/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;

public class DateTime {
    static final Calendar calendar = Calendar.getInstance();
    static final int thisYear;
    int year;
    int month;
    int day;
    int dayOfWeek;
    int hour;
    int minute;
    long timestamp;
    static final long MILLIS_PER_DAY = 86400000L;

    static final String formatNumber(int n) {
        return n < 10 ? "0" + (char)(n + 48) : Integer.toString(n);
    }

    public boolean isSameDay(DateTime dateTime) {
        return dateTime != null && this.day == dateTime.day && this.month == dateTime.month && this.year == dateTime.year;
    }

    public long getWeekStart() {
        return this.timestamp - 86400000L * (long)this.dayOfWeek - (long)(this.hour * 60 + this.minute) * 60000L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        this.getDate(stringBuffer);
        stringBuffer.append(' ');
        this.getTime(stringBuffer);
    }

    public void getWeekDay(StringBuffer stringBuffer) {
        stringBuffer.append(Locale.current.daysOfWeek[this.dayOfWeek]);
        stringBuffer.append(',');
        stringBuffer.append(DateTime.formatNumber(this.day));
    }

    public String getMonth() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getMonth(stringBuffer);
        return stringBuffer.toString();
    }

    public void getMonth(StringBuffer stringBuffer) {
        stringBuffer.append(Locale.current.months[this.month]);
        if (thisYear != this.year) {
            stringBuffer.append('.');
            stringBuffer.append(this.year);
        }
    }

    public String getDate() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getDate(stringBuffer);
        return stringBuffer.toString();
    }

    public void getDate(StringBuffer stringBuffer) {
        stringBuffer.append(DateTime.formatNumber(this.day));
        stringBuffer.append('.');
        this.getMonth(stringBuffer);
    }

    public String getTime() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getTime(stringBuffer);
        return stringBuffer.toString();
    }

    public void getTime(StringBuffer stringBuffer) {
        stringBuffer.append(DateTime.formatNumber(this.hour));
        stringBuffer.append(':');
        stringBuffer.append(DateTime.formatNumber(this.minute));
    }

    public DateTime(long l) {
        this(new Date(l));
    }

    public DateTime() {
        this(new Date());
    }

    public DateTime(Date date) {
        calendar.setTime(date);
        this.timestamp = date.getTime();
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.dayOfWeek = calendar.get(7) - 1;
        if (Locale.current.weekStartsWithMonday && --this.dayOfWeek < 0) {
            this.dayOfWeek = 6;
        }
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
    }

    static {
        DateTime dateTime = new DateTime();
        thisYear = dateTime.year;
    }
}

