/*
 * Decompiled with CFR 0.152.
 */
package hashbang.rgbtester;

import hashbang.rgbtester.RGBTester;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class RGBScreen
extends Canvas
implements CommandListener,
Runnable {
    final int RED;
    final int GREEN;
    final int BLUE;
    private Display display;
    private Command exitCommand;
    private Command helpCommand;
    private RGBTester midlet;
    private boolean fineGrain = false;
    private boolean changeAll = false;
    int pos = 0;
    int red = 255;
    int green = 255;
    int blue = 255;
    int thirdW = this.getWidth() / 3;
    int thirdH = this.getHeight() / 3;
    int lastKeyCode;
    Thread runner;
    boolean keepRunning;

    public RGBScreen(RGBTester midlet) {
        this.RED = 0;
        this.GREEN = 1;
        this.BLUE = 2;
        this.midlet = midlet;
        this.display = Display.getDisplay((MIDlet)midlet);
        this.exitCommand = new Command("Exit", 1, 2);
        this.helpCommand = new Command("Help", 1, 2);
        this.addCommand(this.exitCommand);
        this.addCommand(this.helpCommand);
        this.setCommandListener(this);
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.red, 0, 0);
        g.fillRect(0, 0, this.thirdW, this.thirdH);
        g.setColor(255, 255, 255);
        g.drawString(Integer.toString(this.red), 0, 0, 20);
        g.setColor(0, this.green, 0);
        g.fillRect(this.thirdW, 0, this.thirdW, this.thirdH);
        if (this.green > 218) {
            g.setColor(0, 0, 0);
        } else {
            g.setColor(255, 255, 255);
        }
        g.drawString(Integer.toString(this.green), this.thirdW, 0, 20);
        g.setColor(0, 0, this.blue);
        g.fillRect(this.thirdW * 2, 0, this.thirdW, this.thirdH);
        g.setColor(255, 255, 255);
        g.drawString(Integer.toString(this.blue), this.thirdW * 2, 0, 20);
        g.setColor(this.red, this.green, this.blue);
        g.fillRect(0, this.getHeight() / 2, this.thirdW * 3, this.getHeight() / 2);
        g.setColor(0, 0, 0);
        if (this.changeAll) {
            g.fillRect(0, this.thirdH, this.getWidth(), 3);
        } else if (this.pos == 0) {
            g.fillRect(0, this.thirdH, this.thirdW, 3);
        } else if (this.pos == 1) {
            g.fillRect(this.thirdW, this.thirdH, this.thirdW, 3);
        } else {
            g.fillRect(this.thirdW * 2, this.thirdH, this.thirdW, 3);
        }
        String mode = "";
        mode = this.fineGrain ? "Fine" : "Coarse";
        if (this.changeAll) {
            mode = mode + " - All";
        }
        g.drawString(mode, 0, this.getHeight() / 2, 68);
        Font font = g.getFont();
        g.setFont(Font.getFont((int)0, (int)4, (int)8));
        g.drawString("hashbang.com.au", this.getWidth() / 2, this.getHeight(), 33);
        g.setFont(font);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            this.midlet.destroyApp(false);
            this.midlet.notifyDestroyed();
        } else if (c == this.helpCommand) {
            Alert alert = new Alert("#!RGBTester");
            alert.setString("By Neville Ridley-Smith\nCopyright 2001 Hashbang Pty Ltd\nLeft and right choose a colour to change. Up and down alter the colour values. Fire sets the mode of alteration.");
            alert.setTimeout(-2);
            this.display.setCurrent((Displayable)alert);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            if (this.fineGrain) {
                this.changeAll = !this.changeAll;
            }
            this.fineGrain = !this.fineGrain;
            this.repaint();
            this.serviceRepaints();
        } else if (!this.hasRepeatEvents()) {
            this.lastKeyCode = keyCode;
            this.runner = new Thread(this);
            this.keepRunning = true;
            this.runner.start();
        } else {
            this.moveIt(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        this.keepRunning = false;
    }

    protected void keyRepeated(int keyCode) {
        this.moveIt(keyCode);
        this.moveIt(keyCode);
    }

    public void moveIt(int keyCode) {
        this.lastKeyCode = keyCode;
        int ga = this.getGameAction(keyCode);
        if (ga == 1 || ga == 6) {
            int amount = 1;
            if (!this.fineGrain) {
                amount = 10;
            }
            if (ga == 6) {
                amount = -amount;
            }
            if (this.changeAll) {
                this.red = this.shiftValue(this.red, amount);
                this.green = this.shiftValue(this.green, amount);
                this.blue = this.shiftValue(this.blue, amount);
            } else if (this.pos == 0) {
                this.red = this.shiftValue(this.red, amount);
            } else if (this.pos == 1) {
                this.green = this.shiftValue(this.green, amount);
            } else {
                this.blue = this.shiftValue(this.blue, amount);
            }
        } else if (ga == 2) {
            this.pos = this.pos == 2 ? 1 : 0;
            this.keepRunning = false;
        } else if (ga == 5) {
            this.pos = this.pos == 0 ? 1 : 2;
            this.keepRunning = false;
        }
        this.repaint();
        this.serviceRepaints();
    }

    private int shiftValue(int i, int amount) {
        if ((i += amount) < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        return i;
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    public void run() {
        while (this.keepRunning) {
            try {
                this.moveIt(this.lastKeyCode);
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

