/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Dictionary
extends MIDlet
implements CommandListener,
Receiver {
    TextBox mainMenu = new TextBox("\u0427\u0442\u043e \u043f\u0435\u0440\u0435\u0432\u0435\u0441\u0442\u0438?", "", 50, 0);
    static Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 2);
    static Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static Command TRANSLATE_CMD = new Command("\u041f\u0435\u0440\u0435\u0432\u043e\u0434", 2, 1);
    static String DICTIONARY_URL = "http://www.garret.ru/~knizhnik/Dictionary/";
    static final int SELECTION_LIMIT = 100;
    static final char SEPARATOR = ':';
    static final int CACHE_SIZE = 1;
    static final int MAX_LENGTH = 50;
    static final int MAX_INDEX_SIZE = 16384;
    Volume[] volumes;
    CacheEntry[] cache;
    int[] cacheIdx;
    int cachePos;
    int nVolumes;
    boolean found;
    String prefix;
    Vector selection;
    int currVolume;

    public Dictionary() {
        this.mainMenu.addCommand(TRANSLATE_CMD);
        this.cache = new CacheEntry[1];
        this.cacheIdx = new int[1];
    }

    protected void destroyApp(boolean bl) {
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    private void buildIndex() {
        int n;
        int n2;
        Object object;
        byte[] byArray = new byte[16384];
        try {
            object = this.getClass().getResourceAsStream("/dictionary.idx");
            n2 = ((InputStream)object).read(byArray);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            throw new Error("Failed to read index");
        }
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            Volume volume = new Volume();
            int n3 = n;
            while (byArray[n3] != 58) {
                ++n3;
            }
            volume.first = new String(byArray, n, n3 - n);
            n = ++n3;
            while (byArray[n] != 10) {
                ++n;
            }
            volume.last = new String(byArray, n3, n - n3);
            ((Vector)object).addElement(volume);
        }
        this.nVolumes = ((Vector)object).size();
        this.volumes = new Volume[this.nVolumes];
        for (n = 0; n < this.nVolumes; ++n) {
            this.volumes[n] = (Volume)((Vector)object).elementAt(n);
        }
    }

    void loadVolume(int n) {
        for (int i = 0; i < this.cache.length; ++i) {
            if (n + 1 != this.cacheIdx[i]) continue;
            this.continueSearch(n, this.cache[i]);
            return;
        }
        this.currVolume = n;
        new InternetConnection(DICTIONARY_URL + "volume." + (n + 1), this);
    }

    public void failure(String string) {
        this.error("\u0421\u0431\u043e\u0439 \u0441\u0432\u044f\u0437\u0438");
    }

    public void received(String string, byte[] byArray, int n) {
        CacheEntry cacheEntry = new CacheEntry(byArray, n);
        int n2 = ++this.cachePos % this.cache.length;
        this.cacheIdx[n2] = this.currVolume + 1;
        this.cache[n2] = cacheEntry;
        this.continueSearch(this.currVolume, cacheEntry);
    }

    void startSearch() {
        if (this.nVolumes == 0) {
            this.buildIndex();
        }
        this.found = false;
        this.selection = new Vector();
        for (int i = 0; i < this.volumes.length; ++i) {
            if (this.volumes[i].last.compareTo(this.prefix) < 0) continue;
            this.currVolume = i;
            this.loadVolume(i);
            return;
        }
        this.error("\u041d\u0435\u0442 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432");
    }

    void error(String string) {
        Alert alert = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
    }

    void continueSearch(int n, CacheEntry cacheEntry) {
        byte[] byArray = cacheEntry.data;
        int n2 = cacheEntry.size;
        String string = this.volumes[n].first;
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            while (byArray[i] != 58) {
                ++i;
            }
            String string2 = byArray[n3] <= 57 ? string.substring(0, byArray[n3] - 48) + new String(byArray, n3 + 1, i - n3 - 1) : new String(byArray, n3, i - n3);
            n3 = ++i;
            while (byArray[i] != 10) {
                ++i;
            }
            if (string2.compareTo(this.prefix) >= 0) {
                if (string2.startsWith(this.prefix)) {
                    this.found = true;
                } else if (this.found) {
                    this.showSelection();
                    return;
                }
                char[] cArray = new char[i - n3];
                for (int j = n3; j < i; ++j) {
                    int n4 = byArray[j];
                    cArray[j - n3] = (char)(n4 < 0 ? (n4 == -88 ? 1025 : (n4 == -72 ? 1105 : 0x400 | (n4 & 0x7F) - 48)) : n4);
                }
                this.selection.addElement(new Translation(string2, new String(cArray)));
                if (this.selection.size() == 100) {
                    this.showSelection();
                    return;
                }
            }
            string = string2;
        }
        if (++n < this.nVolumes && this.volumes[n].first.startsWith(this.prefix)) {
            this.loadVolume(n);
            return;
        }
        this.showSelection();
    }

    void showSelection() {
        this.mainMenu.setTitle("\u0427\u0442\u043e \u043f\u0435\u0440\u0435\u0432\u0435\u0441\u0442\u0438?");
        this.mainMenu.setString(this.prefix);
        if (this.selection.size() == 1) {
            Translation translation = (Translation)this.selection.firstElement();
            if (translation.word.equals(this.prefix)) {
                new TranslationBox(this, (Displayable)this.mainMenu, (Translation)this.selection.firstElement());
                return;
            }
        }
        new PrefixList(this, (Displayable)this.mainMenu, this.selection);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            this.prefix = this.mainMenu.getString().toLowerCase();
            if (this.prefix.length() != 0) {
                this.mainMenu.setTitle("\u041c\u0438\u043d\u0443\u0442\u043e\u0447\u043a\u0443");
                this.mainMenu.setString("\u0418\u0434\u0451\u0442 \u043f\u043e\u0438\u0441\u043a...");
                this.startSearch();
            }
        }
    }

    static class CacheEntry {
        byte[] data;
        int size;

        CacheEntry(byte[] byArray, int n) {
            this.data = byArray;
            this.size = n;
        }
    }

    static class Volume {
        String first;
        String last;

        Volume() {
        }
    }
}

