/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    private XMLElement next;
    private XMLElement prev;
    private String name;
    private Hashtable siblings;
    private Hashtable attributes;
    private Vector siblingsList;
    private Vector attributesList;
    private String value;
    private int counter;

    XMLElement(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    final void addSibling(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (this.siblings == null) {
            this.siblings = new Hashtable();
            this.siblingsList = new Vector();
        }
        if ((xMLElement2 = (XMLElement)this.siblings.get(xMLElement.name)) != null) {
            xMLElement.next = null;
            xMLElement.prev = xMLElement2.prev;
            xMLElement.prev.next = xMLElement;
            xMLElement2.prev = xMLElement;
            ++xMLElement2.counter;
        } else {
            this.siblings.put(xMLElement.name, xMLElement);
            xMLElement.prev = xMLElement;
            xMLElement.counter = 1;
        }
        this.siblingsList.addElement(xMLElement);
    }

    final void addAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = new XMLAttribute(string, string2);
        if (this.attributes == null) {
            this.attributes = new Hashtable();
            this.attributesList = new Vector();
        }
        this.attributesList.addElement(xMLAttribute);
        this.attributes.put(string, xMLAttribute);
    }

    final Vector getSiblings() {
        return this.siblingsList;
    }

    final Vector getAttributes() {
        return this.attributesList;
    }

    final XMLElement getSibling(String string) {
        XMLElement xMLElement;
        if (this.siblings != null && (xMLElement = (XMLElement)this.siblings.get(string)) != null) {
            return xMLElement;
        }
        return null;
    }

    final XMLElement getNextSibling() {
        return this.next;
    }

    final int getCounter() {
        return this.counter;
    }

    final XMLAttribute getAttribute(String string) {
        return this.attributes != null ? (XMLAttribute)this.attributes.get(string) : null;
    }

    final void setValue(String string) {
        this.value = string;
    }

    final String getValue() {
        return this.value;
    }

    final int getIntValue() {
        if (this.value == null) {
            throw new XMLException("Value not set");
        }
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLException("Element value '" + this.value + "' is not an integer constant");
        }
    }

    public Vector search(String string) {
        Vector<XMLElement> vector = new Vector<XMLElement>();
        string = string.toUpperCase();
        if (this.siblingsList != null) {
            int n = this.siblingsList.size();
            while (--n >= 0) {
                XMLElement xMLElement = (XMLElement)this.siblingsList.elementAt(n);
                if (!xMLElement.searchSiblings(string)) continue;
                vector.addElement(xMLElement);
            }
        }
        return vector;
    }

    private boolean searchSiblings(String string) {
        Object object;
        int n;
        if (this.name.toUpperCase().equals(string)) {
            return true;
        }
        if (this.value != null && this.value.toUpperCase().indexOf(string) >= 0) {
            return true;
        }
        if (this.attributesList != null) {
            n = this.attributesList.size();
            while (--n >= 0) {
                object = (XMLAttribute)this.attributesList.elementAt(n);
                if ((((XMLAttribute)object).getName() == null || !((XMLAttribute)object).getName().toUpperCase().equals(string)) && (((XMLAttribute)object).getValue() == null || ((XMLAttribute)object).getValue().toUpperCase().indexOf(string) < 0)) continue;
                return true;
            }
        }
        if (this.siblingsList != null) {
            n = this.siblingsList.size();
            while (--n >= 0) {
                object = (XMLElement)this.siblingsList.elementAt(n);
                if (!super.searchSiblings(string)) continue;
                return true;
            }
        }
        return false;
    }
}

