/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class SettingsForm
extends Form
implements CommandListener {
    BrowserCanvas canvas;
    ChoiceGroup choice;
    ChoiceGroup locale;
    Gauge cacheSize;
    boolean[] selected;

    SettingsForm(BrowserCanvas browserCanvas) {
        super(Locale.current.getResource("Settings"));
        this.canvas = browserCanvas;
        int n = browserCanvas.browser.settings.flags;
        this.choice = new ChoiceGroup(null, 2, new String[]{Locale.current.getResource("Fast Scroll"), Locale.current.getResource("Auto zoom"), Locale.current.getResource("Blinking")}, null);
        this.selected = new boolean[]{(n & 1) != 0, (n & 2) != 0, true};
        this.choice.setSelectedFlags(this.selected);
        this.locale = new ChoiceGroup(Locale.current.getResource("Locale"), 1, Locale.SUPPORTED_LANGUAGES, null);
        for (int i = 0; i < Locale.SUPPORTED_LOCALES.length; ++i) {
            if (!Locale.SUPPORTED_LOCALES[i].equals(Locale.current.getLanguage())) continue;
            this.locale.setSelectedIndex(i, true);
            break;
        }
        this.cacheSize = new Gauge("Cache size", true, 9, browserCanvas.browser.settings.cacheSize - 1);
        this.append((Item)this.choice);
        this.append((Item)this.locale);
        this.append((Item)this.cacheSize);
        this.addCommand(MapBrowser.SAVE_CMD);
        this.addCommand(MapBrowser.BACK_CMD);
        this.setCommandListener(this);
        Display.getDisplay((MIDlet)browserCanvas.browser).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MapBrowser.SAVE_CMD) {
            this.choice.getSelectedFlags(this.selected);
            int n = 0;
            if (this.selected[0]) {
                n |= 1;
            }
            if (this.selected[1]) {
                n |= 2;
            }
            if (this.selected[2]) {
                n |= 4;
            }
            MapBrowser mapBrowser = this.canvas.browser;
            mapBrowser.settings.flags = n;
            String string = Locale.SUPPORTED_LOCALES[this.locale.getSelectedIndex()];
            if (!string.equals(mapBrowser.settings.locale)) {
                mapBrowser.settings.locale = string;
                mapBrowser.setLocale();
                mapBrowser.saveSettings();
                mapBrowser.showMap();
                return;
            }
            mapBrowser.settings.cacheSize = this.cacheSize.getValue() + 1;
            mapBrowser.saveSettings();
        }
        Display.getDisplay((MIDlet)this.canvas.browser).setCurrent((Displayable)this.canvas);
    }
}

