/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class BrowserCanvas
extends Canvas
implements CommandListener,
Receiver {
    static final int BLINK_PERIOD = 1000;
    static final int REPEAT_DELAY = 1000;
    static final int REPEAT_PERIOD = 100;
    static final int BACKGROUND_COLOR = 0xFFFFFF;
    static final int SELECTION_COLOR = 0x800080;
    static final int FOCUS_COLOR = 0;
    static final int EPSILON = 10;
    int x;
    int y;
    int focusX;
    int focusY;
    int focusWidth;
    int focusHeight;
    int focusX0;
    int focusY0;
    int screenWidth;
    int screenHeight;
    int selectionColor = 0x800080;
    MapBrowser browser;
    int level;
    int scale;
    int zoom;
    int imageSize;
    boolean busy;
    int skipImages;
    Image[] imageCache;
    String[] imageUrl;
    int imageCachePtr;
    int stepX;
    int stepY;
    int focusStepX;
    int focusStepY;
    Timer repeatTimer = new Timer();
    Timer blinkTimer = new Timer();
    RepeatTask repeatTask;
    BlinkTask blinkTask;
    int cacheSize;
    Location[] selection;
    Index selectionIndex;
    int currSelection;

    String buildImageUrl(int n, int n2) {
        return this.browser.url + this.level + '/' + this.browser.city + n2 + '_' + n + ".png";
    }

    Image getImage(int n, int n2) {
        String string = this.buildImageUrl(n, n2);
        for (int i = 0; i < this.cacheSize; ++i) {
            if (!string.equals(this.imageUrl[i])) continue;
            return this.imageCache[i];
        }
        return null;
    }

    void startImageLoading(int n, int n2) {
        this.busy = true;
        new InternetConnection(this.buildImageUrl(n, n2), this);
    }

    public void failure(String string) {
        System.out.println("Failed to load image " + string);
        new InternetConnection(string, this);
    }

    public void received(String string, byte[] byArray, int n) {
        Image image;
        this.imageCache[this.imageCachePtr] = image = Image.createImage((byte[])byArray, (int)0, (int)n);
        this.imageUrl[this.imageCachePtr] = string;
        this.imageCachePtr = (this.imageCachePtr + 1) % this.cacheSize;
        this.repaint();
    }

    void setPositions(Index index, Location[] locationArray) {
        this.selection = locationArray;
        this.selectionIndex = index;
        this.currSelection = -1;
        if (locationArray.length == 1) {
            Location location = locationArray[0];
            if ((this.browser.settings.flags & 2) != 0) {
                this.scale = 1;
                this.level = this.browser.levels;
                while ((location.getWidth() > this.screenWidth * this.scale || location.getHeight() > this.screenHeight * this.scale) && this.level > 1) {
                    --this.level;
                    this.scale *= this.zoom;
                }
                if (this.level != 1) {
                    this.removeCommand(MapBrowser.ZOOM_OUT_CMD);
                }
                if (this.level != this.browser.levels) {
                    this.addCommand(MapBrowser.ZOOM_IN_CMD);
                }
                this.setFocus();
            }
            this.x = location.getCenterX() - this.screenWidth * this.scale / 2;
            this.y = location.getCenterY() - this.screenHeight * this.scale / 2;
        }
        if (locationArray.length > 0) {
            if (this.cacheSize >= 4 && (this.browser.settings.flags & 4) != 0) {
                this.startBlinking();
            }
            if (index.type == 1) {
                this.addCommand(MapBrowser.NEXT_CMD);
            }
            this.addCommand(MapBrowser.CLEAN_CMD);
        }
        this.check();
    }

    void startBlinking() {
        this.blinkTask = new BlinkTask();
        this.blinkTimer.schedule((TimerTask)this.blinkTask, 1000L, 1000L);
    }

    void stopBlinking() {
        if (this.blinkTask != null) {
            this.blinkTask.cancel();
            this.blinkTask = null;
        }
    }

    void setFocus() {
        this.focusX0 = this.screenWidth * (this.scale - 1) / 2;
        this.focusY0 = this.screenHeight * (this.scale - 1) / 2;
        this.focusX = this.x + this.focusX0;
        this.focusY = this.y + this.focusY0;
    }

    BrowserCanvas(MapBrowser mapBrowser) {
        this.setFullScreenMode(true);
        this.browser = mapBrowser;
        this.setCommandListener(this);
        this.addCommand(MapBrowser.INDEX_CMD);
        this.addCommand(MapBrowser.SETTINGS_CMD);
        this.addCommand(MapBrowser.HELP_CMD);
        this.addCommand(MapBrowser.ABOUT_CMD);
        this.addCommand(MapBrowser.QUIT_CMD);
        this.cacheSize = mapBrowser.settings.cacheSize;
        this.imageCache = new Image[this.cacheSize];
        this.imageUrl = new String[this.cacheSize];
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.stepX = this.screenWidth / 4;
        this.stepY = this.screenHeight / 4;
        this.zoom = mapBrowser.zoom;
        this.scale = 1;
        this.x = 0;
        this.y = 0;
        this.level = 1;
        this.focusWidth = this.screenWidth / this.zoom;
        this.focusHeight = this.screenHeight / this.zoom;
        this.focusStepX = this.focusWidth / this.zoom;
        this.focusStepY = this.focusHeight / this.zoom;
        int n = mapBrowser.levels;
        while (--n != 0) {
            this.scale *= this.zoom;
        }
        if (mapBrowser.levels > 1) {
            this.addCommand(MapBrowser.ZOOM_IN_CMD);
        }
        this.imageSize = mapBrowser.cell;
        this.setFocus();
        this.check();
        Display.getDisplay((MIDlet)mapBrowser).setCurrent((Displayable)this);
    }

    protected void paint(Graphics graphics) {
        int n;
        if (this.skipImages == 0 && this.level == 1) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        }
        int n2 = this.x / this.scale + graphics.getClipX();
        int n3 = this.y / this.scale + graphics.getClipY();
        int n4 = n2 + graphics.getClipWidth() - 1;
        int n5 = n3 + graphics.getClipHeight() - 1;
        if (n4 >= this.browser.width / this.scale) {
            n4 = this.browser.width / this.scale - 1;
        }
        if (n5 >= this.browser.width / this.scale) {
            n5 = this.browser.width / this.scale - 1;
        }
        int n6 = 0;
        for (n = n2 / this.imageSize; n <= n4 / this.imageSize; ++n) {
            for (int i = n3 / this.imageSize; i <= n5 / this.imageSize; ++i) {
                if (++n6 < this.skipImages) continue;
                Image image = this.getImage(n, i);
                if (image != null) {
                    graphics.drawImage(image, n * this.imageSize - this.x / this.scale, i * this.imageSize - this.y / this.scale, 20);
                    continue;
                }
                if (n6 > this.skipImages) {
                    this.skipImages = n6;
                    this.startImageLoading(n, i);
                }
                return;
            }
        }
        this.busy = false;
        this.skipImages = 0;
        if (this.level != this.browser.levels) {
            graphics.setColor(0);
            graphics.setStrokeStyle(1);
            graphics.drawRect((this.focusX - this.x) / this.scale, (this.focusY - this.y) / this.scale, this.focusWidth, this.focusHeight);
        }
        if (this.selection != null) {
            graphics.setStrokeStyle(1);
            graphics.setColor(this.selectionColor);
            block7: for (n = 0; n < this.selection.length; ++n) {
                Location location = this.selection[n];
                switch (this.selectionIndex.type) {
                    case 1: {
                        graphics.drawLine((location.points[0] - this.x) / this.scale - 10, (location.points[1] - this.y) / this.scale, (location.points[0] - this.x) / this.scale + 10, (location.points[1] - this.y) / this.scale);
                        graphics.drawLine((location.points[0] - this.x) / this.scale, (location.points[1] - this.y) / this.scale - 10, (location.points[0] - this.x) / this.scale, (location.points[1] - this.y) / this.scale + 10);
                        if (n != this.currSelection) continue block7;
                        graphics.drawArc((location.points[0] - this.x) / this.scale - 10, (location.points[1] - this.y) / this.scale - 10, 20, 20, 0, 360);
                        continue block7;
                    }
                    case 2: {
                        graphics.drawRect((location.points[0] - this.x) / this.scale, (location.points[1] - this.y) / this.scale, (location.points[2] - location.points[0]) / this.scale + 1, (location.points[3] - location.points[1]) / this.scale + 1);
                        continue block7;
                    }
                    case 3: {
                        for (int i = 2; i < location.points.length; i += 2) {
                            graphics.drawLine((location.points[i - 2] - this.x) / this.scale, (location.points[i - 1] - this.y) / this.scale, (location.points[i] - this.x) / this.scale, (location.points[i + 1] - this.y) / this.scale);
                        }
                        continue block7;
                    }
                }
            }
        }
    }

    boolean zoomIn() {
        if (this.scale == 1) {
            return false;
        }
        ++this.level;
        this.scale /= this.zoom;
        this.x = this.focusX;
        this.y = this.focusY;
        this.addCommand(MapBrowser.ZOOM_OUT_CMD);
        if (this.scale == 1) {
            this.removeCommand(MapBrowser.ZOOM_IN_CMD);
        } else {
            this.setFocus();
            this.check();
        }
        return true;
    }

    boolean zoomOut() {
        if (this.level == 1) {
            return false;
        }
        this.scale *= this.zoom;
        --this.level;
        this.focusX = this.x;
        this.focusY = this.y;
        this.focusX0 = this.screenWidth * (this.scale - 1) / 2;
        this.focusY0 = this.screenHeight * (this.scale - 1) / 2;
        this.x -= this.focusX0;
        this.y -= this.focusY0;
        this.addCommand(MapBrowser.ZOOM_IN_CMD);
        if (this.level == 1) {
            this.removeCommand(MapBrowser.ZOOM_OUT_CMD);
        }
        return true;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MapBrowser.QUIT_CMD) {
            this.browser.quit();
        } else if (command == MapBrowser.ABOUT_CMD) {
            new HelpForm(this.browser, Locale.current.getResource("About"), Locale.current.getResource("AboutText"), (Displayable)this);
        } else if (command == MapBrowser.HELP_CMD) {
            new HelpForm(this.browser, Locale.current.getResource("Help"), Locale.current.getResource("HelpText"), (Displayable)this);
        } else if (command == MapBrowser.ZOOM_IN_CMD) {
            this.zoomIn();
            this.check();
        } else if (command == MapBrowser.ZOOM_OUT_CMD) {
            this.zoomOut();
            this.check();
        } else if (command == MapBrowser.INDEX_CMD) {
            new GroupList(this);
        } else if (command == MapBrowser.NEXT_CMD) {
            this.nextPoint();
            this.repaint();
        } else if (command == MapBrowser.INFO_CMD) {
            this.pointInfo();
        } else if (command == MapBrowser.CLEAN_CMD) {
            this.selection = null;
            this.stopBlinking();
            this.removeCommand(MapBrowser.CLEAN_CMD);
            this.removeCommand(MapBrowser.NEXT_CMD);
            this.removeCommand(MapBrowser.INFO_CMD);
        } else if (command == MapBrowser.SETTINGS_CMD) {
            new SettingsForm(this);
        }
    }

    public void pointerPressed(int n, int n2) {
        this.focusX = this.x + n * this.scale;
        this.focusY = this.y + n2 * this.scale;
        this.repaint();
    }

    public void pointerReleased(int n, int n2) {
        this.focusX = this.x + n * this.scale;
        this.focusY = this.y + n2 * this.scale;
        this.repaint();
    }

    public void pointerDragged(int n, int n2) {
        this.x = this.focusX - n * this.scale;
        this.y = this.focusY - n2 * this.scale;
        this.check();
        this.repaint();
    }

    public void keyPressed(int n) {
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
        }
        if (!this.busy) {
            this.repeatTask = new RepeatTask(n);
            this.repeatTimer.schedule((TimerTask)this.repeatTask, 1000L, 100L);
        }
    }

    public void keyReleased(int n) {
        if (!this.busy) {
            this.keyAction(n);
        }
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
            this.repeatTask = null;
        }
    }

    private boolean pointInfo() {
        if (this.selection != null && this.currSelection >= 0) {
            Location location = this.selection[this.currSelection];
            new InfoForm(this, this.selectionIndex, this.selection[this.currSelection], (Displayable)this);
            return true;
        }
        return false;
    }

    private boolean nextPoint() {
        if (this.selection != null && this.selectionIndex.type == 1) {
            for (int i = 0; i < this.selection.length; ++i) {
                if (++this.currSelection == this.selection.length) {
                    this.currSelection = 0;
                }
                Location location = this.selection[this.currSelection];
                if (location.points[0] < this.x || location.points[0] - this.x >= this.screenWidth * this.scale || location.points[1] < this.y || location.points[1] - this.y >= this.screenHeight * this.scale) continue;
                this.addCommand(MapBrowser.INFO_CMD);
                return true;
            }
            this.currSelection = -1;
        }
        return false;
    }

    private void keyAction(int n) {
        int n2 = 0;
        int n3 = 0;
        block0 : switch (n) {
            case 48: {
                if (!this.pointInfo()) {
                    this.browser.error(Locale.current.getResource("No current point"), (Displayable)this);
                }
                return;
            }
            case 49: {
                n2 = -1;
                n3 = -1;
                break;
            }
            case 50: {
                n3 = -1;
                break;
            }
            case 51: {
                n2 = 1;
                n3 = -1;
                break;
            }
            case 52: {
                n2 = -1;
                break;
            }
            case 53: {
                if (!this.nextPoint()) {
                    this.browser.error(Locale.current.getResource("No points selected"), (Displayable)this);
                }
                this.repaint();
                return;
            }
            case 54: {
                n2 = 1;
                break;
            }
            case 55: {
                n2 = -1;
                n3 = 1;
                break;
            }
            case 56: {
                n3 = 1;
                break;
            }
            case 57: {
                n2 = 1;
                n3 = 1;
                break;
            }
            case 42: {
                if (this.zoomIn()) {
                    this.check();
                }
                return;
            }
            case 35: {
                if (this.zoomOut()) {
                    this.check();
                }
                return;
            }
            default: {
                if ((this.browser.settings.flags & 1) != 0) {
                    n2 = this.stepX * this.scale;
                    n3 = this.stepY * this.scale;
                    switch (this.getGameAction(n)) {
                        case 2: {
                            this.x -= n2;
                            break;
                        }
                        case 5: {
                            this.x += n2;
                            break;
                        }
                        case 1: {
                            this.y -= n3;
                            break;
                        }
                        case 6: {
                            this.y += n3;
                            break;
                        }
                        case 8: {
                            if (!this.pointInfo()) {
                                this.browser.error(Locale.current.getResource("No current point"), (Displayable)this);
                            }
                            return;
                        }
                        case 9: {
                            if (this.zoomIn()) {
                                this.check();
                            }
                            return;
                        }
                        case 10: {
                            if (this.zoomOut()) {
                                this.check();
                            }
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                    this.check();
                    return;
                }
                switch (this.getGameAction(n)) {
                    case 1: {
                        n3 = -1;
                        break block0;
                    }
                    case 2: {
                        n2 = -1;
                        break block0;
                    }
                    case 8: {
                        if (!this.pointInfo()) {
                            this.browser.error(Locale.current.getResource("No current point"), (Displayable)this);
                        }
                        return;
                    }
                    case 5: {
                        n2 = 1;
                        break block0;
                    }
                    case 6: {
                        n3 = 1;
                    }
                }
            }
        }
        if (this.scale != 1) {
            boolean bl = false;
            this.focusX += n2 * this.focusWidth * this.scale / this.zoom;
            this.focusY += n3 * this.focusHeight * this.scale / this.zoom;
            if (this.focusX < this.x) {
                bl = true;
                this.x -= this.stepX * this.scale;
                this.focusX += this.stepX * this.scale;
                if (this.x < 0) {
                    this.focusX += this.x;
                    this.x = 0;
                    if (this.focusX < 0) {
                        this.focusX = 0;
                    }
                }
            }
            if (this.focusX - this.x > (this.screenWidth - this.focusWidth) * this.scale) {
                bl = true;
                this.x += this.stepX * this.scale;
                this.focusX -= this.stepX * this.scale;
                if (this.x + this.screenWidth * this.scale > this.browser.width) {
                    this.focusX += this.x + this.screenWidth * this.scale - this.browser.width;
                    this.x = this.browser.width - this.screenWidth * this.scale;
                    if (this.focusX + this.focusWidth * this.scale > this.browser.width) {
                        this.focusX = this.browser.width - this.focusWidth * this.scale;
                    }
                }
            }
            if (this.focusY < this.y) {
                bl = true;
                this.y -= this.stepY * this.scale;
                this.focusY += this.stepY * this.scale;
                if (this.y < 0) {
                    this.focusY += this.y;
                    this.y = 0;
                    if (this.focusY < 0) {
                        this.focusY = 0;
                    }
                }
            }
            if (this.focusY - this.y > (this.screenHeight - this.focusHeight) * this.scale) {
                bl = true;
                this.y += this.stepY * this.scale;
                this.focusY -= this.stepY * this.scale;
                if (this.y + this.screenHeight * this.scale > this.browser.height) {
                    this.focusY += this.y + this.screenHeight * this.scale - this.browser.height;
                    this.y = this.browser.height - this.screenHeight * this.scale;
                    if (this.focusY + this.focusHeight * this.scale > this.browser.height) {
                        this.focusY = this.browser.height - this.focusHeight * this.scale;
                    }
                }
            }
            if (bl) {
                this.repaint();
            } else {
                this.repaint(((n2 <= 0 ? this.focusX : this.focusX - this.focusWidth * this.scale / this.zoom) - this.x) / this.scale, ((n3 <= 0 ? this.focusY : this.focusY - this.focusHeight * this.scale / this.zoom) - this.y) / this.scale, this.focusWidth + this.focusWidth / this.zoom + 2, this.focusHeight + this.focusHeight / this.zoom + 2);
            }
        } else {
            this.x += n2 * this.stepX;
            this.y += n3 * this.stepY;
            this.check();
        }
    }

    private void check() {
        if (this.x + this.screenWidth * this.scale > this.browser.width) {
            this.x = this.browser.width - this.screenWidth * this.scale;
        }
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y + this.screenHeight * this.scale > this.browser.height) {
            this.y = this.browser.height - this.screenHeight * this.scale;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.scale != 1) {
            if (this.focusX < this.x || this.focusX - this.x > (this.screenWidth - this.focusWidth) * this.scale || this.focusY < this.y || this.focusY - this.y > (this.screenHeight - this.focusHeight) * this.scale) {
                this.focusX = this.x + this.focusX0;
                this.focusY = this.y + this.focusY0;
            }
            if (this.focusX + this.focusWidth * this.scale > this.browser.width) {
                this.focusX = this.browser.width - this.focusWidth * this.scale;
            }
            if (this.focusY + this.focusHeight * this.scale > this.browser.height) {
                this.focusY = this.browser.height - this.focusHeight * this.scale;
            }
        }
        this.repaint();
    }

    class BlinkTask
    extends TimerTask {
        BlinkTask() {
        }

        public void run() {
            if (!BrowserCanvas.this.busy) {
                BrowserCanvas.this.selectionColor ^= 0xFFFFFF;
                BrowserCanvas.this.repaint();
            }
        }
    }

    class RepeatTask
    extends TimerTask {
        int keyCode;

        RepeatTask(int n) {
            this.keyCode = n;
        }

        public void run() {
            if (!BrowserCanvas.this.busy) {
                BrowserCanvas.this.keyAction(this.keyCode);
            }
        }
    }
}

