/*
 * Decompiled with CFR 0.152.
 */
package net.landspurg.map.tools;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.landspurg.map.MapCanvas;
import net.landspurg.map.Track;
import net.landspurg.map.oneGPSPos;
import net.landspurg.map.tools.GPSReader;
import net.landspurg.util.UtilMidp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GPSDisplay
extends MapCanvas
implements Runnable {
    public int c;
    public int d;
    public static final int MODE_EARTH = 0;
    public static final int MODE_COMPASS = 1;
    public static final int MODE_SAT = 2;
    public int m_mode = 1;
    public Canvas a;
    public double a;
    public double b;
    public double c;
    public double d = 0.0;
    public double e = 0.0;
    public long c = -1L;
    public boolean b = true;
    public GPSReader a = 0.0;
    public int lastStatusInfo = -1;
    public String lastStatusInfoStr = null;

    public void setMode(int n) {
        int n2 = 3;
        if (!UtilMidp.m_bluetoothEnabled) {
            n2 = 2;
        }
        this.m_mode = (n2 + n) % n2;
        this.repaint();
    }

    public void setGPSReader(GPSReader gPSReader) {
        this.a = gPSReader;
    }

    public void paint(Graphics graphics) {
        if (UtilMidp.DEBUG) {
            System.out.println("GPS Display..paint");
        }
        switch (this.m_mode) {
            case 1: {
                this.paintCompass(graphics);
                break;
            }
            case 0: {
                super.paint(graphics);
                break;
            }
            case 2: {
                this.paintSat(graphics);
            }
        }
    }

    public void paintCompass(Graphics graphics) {
        int n;
        int n2;
        float f;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.c = this.getWidth();
        this.d = this.getHeight();
        Font font = Font.getFont((int)64, (int)1, (int)16);
        int n9 = font.getHeight() + 5;
        Font font2 = Font.getFont((int)64, (int)0, (int)0);
        Font font3 = Font.getFont((int)64, (int)1, (int)8);
        Font font4 = font;
        boolean bl = true;
        int n10 = font.getHeight() * 2 + 10;
        int n11 = this.c / 2;
        if (this.d - n10 < this.c - 100) {
            bl = false;
        }
        int n12 = 4;
        if (this.wayPoint != null) {
            n10 += n9;
            ++n12;
        }
        if (bl) {
            n8 = this.c / 2;
            n7 = (this.d - n10) / 2 + n10;
            int n13 = n6 = this.c < this.d - n10 ? this.c : this.d - n10;
            if (font.charsWidth("Sp:000m".toCharArray(), 0, 7) > n11) {
                font4 = font2;
            }
        } else {
            n11 = this.c - this.d;
            if (n11 < 100) {
                n11 = 100;
            }
            n8 = n11 + (this.c - n11) / 2;
            n7 = this.d / 2;
            n6 = this.c < this.d - n10 ? this.c : this.d - n10;
        }
        graphics.setColor(0xA0A0FF);
        graphics.fillRect(0, 0, this.c, this.d);
        int n14 = 0;
        int n15 = 0;
        for (n5 = 0; n5 < n12; ++n5) {
            n4 = n11;
            int n16 = n9;
            if (n5 == 4) {
                if (bl) {
                    n4 = this.c;
                } else {
                    n16 *= 2;
                }
            }
            graphics.setColor(0);
            graphics.drawRect(n14 * n11 + 1, n15 * n9 + 1, n4 - 2, n16 - 2);
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(n14 * n11, n15 * n9, n4, n16);
            graphics.setColor(0);
            int n17 = 4 + n14 * n11;
            int n18 = 2 + n15 * n9;
            switch (n5) {
                case 0: {
                    graphics.setFont(font4);
                    graphics.drawString("Alt:" + (int)this.e + "m", n17, n18, 20);
                    break;
                }
                case 2: {
                    graphics.setFont(font4);
                    graphics.drawString("Sp:" + (int)this.b + "." + (int)this.b * 10 % 10 + "km", n17, n18, 20);
                    break;
                }
                case 1: {
                    graphics.setFont(font2);
                    this.a(graphics, n17, n18, true, this.c, true);
                    break;
                }
                case 3: {
                    graphics.setFont(font2);
                    this.a(graphics, n17, n18, false, this.d, true);
                    break;
                }
                case 4: {
                    int n19 = this.getDist();
                    String string = "Dist:" + this.convertDisToString(n19);
                    graphics.drawString(string, n17, n18, 20);
                    if (!bl) {
                        n18 += n9;
                    }
                    graphics.drawString(this.wayPoint.name, n4 - 2, n18, 24);
                }
            }
            if (bl) {
                if (++n14 != 2) continue;
                n14 = 0;
                ++n15;
                continue;
            }
            ++n15;
        }
        graphics.setColor(0);
        n5 = (n6 -= 5) - 5;
        graphics.fillArc(n8 - n5 / 2, n7 - n5 / 2, n5, n5, 0, 360);
        graphics.setColor(0xFFFFFF);
        graphics.fillArc(n8 - (n5 -= 6) / 2, n7 - n5 / 2, n5, n5, 0, 360);
        graphics.setColor(0);
        graphics.setFont(font4);
        n4 = 32;
        double d = -this.a;
        double d2 = (float)this.getCourseToTarget();
        if (!Double.isNaN(d2)) {
            // empty if block
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n20 = n3 * 360 / n4;
            n5 = (n6 - 5) / 2;
            f = (float)Math.toRadians((double)n20 + d);
            n2 = (int)(Math.sin(f) * (double)n5);
            n = -((int)(Math.cos(f) * (double)n5));
            int n21 = 8;
            if (n3 % 4 == 0) {
                n21 = 6;
            }
            graphics.drawLine(n8 + n2, n7 + n, n8 + n2 - n2 / n21, n7 + n - n / n21);
            if (n3 % (n4 / 4) != 0) continue;
            graphics.setFont(font);
            int n22 = n3 * 4 / n4;
            String string = new String("NESW");
            char c = string.charAt(n22);
            graphics.drawChar(c, n8 + n2 * 8 / 10, n7 + n * 8 / 10 - font.getHeight() / 2, 17);
            if (n3 == 0) {
                graphics.fillTriangle(n8 + n / 6, n7 - n2 / 6, n8 - n / 6, n7 + n2 / 6, n8 + n2 / 2, n7 + n / 2);
                continue;
            }
            graphics.drawLine(n8 + n / 6, n7 - n2 / 6, n8 + n2 / 2, n7 + n / 2);
            graphics.drawLine(n8 - n / 6, n7 + n2 / 6, n8 + n2 / 2, n7 + n / 2);
        }
        n3 = n6 / 2 - 30;
        if (this.a != Double.NaN) {
            if (!Double.isNaN(d2)) {
                float f2 = (float)Math.toRadians(d2 + d);
                n2 = (int)(Math.sin(f2) * (double)(n3 + 40));
                n = -((int)(Math.cos(f2) * (double)(n3 + 40)));
                graphics.setColor(255);
                graphics.fillTriangle(n8 + n2 / 2, n7 + n / 2, n8 + n2 * 21 / 20 - n / 10, n7 + n * 21 / 20 + n2 / 10, n8 + n2 * 21 / 20 + n / 10, n7 + n * 21 / 20 - n2 / 10);
            }
            int n23 = (int)(this.a + d);
            float f3 = (float)Math.toRadians(this.a + d);
            n2 = (int)(Math.sin(f3) * (double)n3);
            n = -((int)(Math.cos(f3) * (double)n3));
            f = (float)Math.toRadians(this.a + 135.0 + d);
            int n24 = (int)(Math.sin(f) * (double)n3);
            int n25 = -((int)(Math.cos(f) * (double)n3));
            graphics.setColor(0xFF0000);
            graphics.fillTriangle(n8 + n2, n7 + n, n8 + n2 * 5 / 10 - n / 3, n7 + n * 5 / 10 + n2 / 3, n8 + n2 * 6 / 10, n7 + n * 6 / 10);
            graphics.fillTriangle(n8 + n2, n7 + n, n8 + n2 * 5 / 10 + n / 3, n7 + n * 5 / 10 - n2 / 3, n8 + n2 * 6 / 10, n7 + n * 6 / 10);
            graphics.fillTriangle(n8 + n2, n7 + n, n8 - n2 - n / 4, n7 - n + n2 / 4, n8 - n2 * 8 / 10, n7 - n * 8 / 10);
            graphics.fillTriangle(n8 + n2, n7 + n, n8 - n2 + n / 4, n7 - n - n2 / 4, n8 - n2 * 8 / 10, n7 - n * 8 / 10);
        }
        graphics.setColor(0);
        n5 = 5;
        graphics.drawArc(n8 - n5 / 2, n7 - n5 / 2, n5, n5, 0, 360);
        String string = "--:--:--";
        String string2 = "--/--/--";
        if (this.c != -1L) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(this.c));
            string = this.a(calendar.get(11), 2) + ":" + this.a(calendar.get(12), 2) + ":" + this.a(calendar.get(13), 2);
            string2 = this.a(calendar.get(5), 2) + "/" + this.a(calendar.get(2) + 1, 2) + "/" + this.a(calendar.get(1), 2);
        }
        graphics.setFont(font2);
        if (bl) {
            graphics.drawString(string, 0, n10, 20);
            graphics.drawString(string2, this.getWidth(), n10, 24);
        } else {
            graphics.drawString(string, n11 + 4, 0, 20);
            graphics.drawString(string2, this.getWidth(), 0, 24);
        }
        this.drawBottomIndicators(graphics, this.getHeight() - font.getHeight());
        this.a(graphics, ((MapCanvas)this).a);
    }

    public String a(int n, int n2) {
        String string = n + "";
        while (string.length() < n2) {
            string = "0" + string;
        }
        if (string.length() > n2) {
            string = string.substring(string.length() - n2);
        }
        return string;
    }

    public void a(Graphics graphics, int n, int n2, boolean bl, double d, boolean bl2) {
        String string = MapCanvas.getCoordAsString(bl, (float)d, bl2);
        graphics.drawString(string.toString(), n, n2, 20);
    }

    public void displayTrack(Track track, boolean bl) {
        this.setMode(0);
        super.displayTrack(track, bl);
    }

    public void a(Graphics graphics, String string, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        graphics.drawString(string, n - n3 / 2, n2, 20);
    }

    public void paintSat(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(0);
        graphics.drawRoundRect(0, 0, n, n2, 10, 10);
        if (this.a != null) {
            int n3 = 16;
            int n4 = (n2 - 50) / 2;
            int n5 = n / 2;
            Font font = Font.getFont((int)64, (int)1, (int)16);
            Font font2 = Font.getFont((int)64, (int)0, (int)8);
            graphics.setColor(0);
            int n6 = n / 5;
            graphics.setFont(font2);
            graphics.drawArc(n5 - n6, n4 - n6, 2 * n6, 2 * n6, 0, 360);
            n6 = n / 3;
            graphics.drawArc(n5 - n6, n4 - n6, 2 * n6, 2 * n6, 0, 360);
            n6 = n / 2;
            for (int i = 0; i < this.a.a; ++i) {
                GPSReader.oneSat oneSat2 = this.a.a[i];
                graphics.setColor(0x80FF80);
                graphics.fillRoundRect(i * n3 + 1, n2 - 12 - oneSat2.d - 2, n3 - 2, oneSat2.d, 4, 4);
                graphics.setColor(0);
                graphics.drawRoundRect(i * n3 + 1, n2 - 12 - oneSat2.d - 2, n3 - 2, oneSat2.d, 4, 4);
                String string = Integer.toString(oneSat2.a);
                int n7 = graphics.getFont().stringWidth(string);
                graphics.drawString(string, i * n3 + 4, n2, 36);
                int n8 = (90 - n6 * oneSat2.b / 90) / 2;
                float f = (float)Math.toRadians(oneSat2.c);
                int n9 = n5 + (int)(Math.sin(f) * (double)n8);
                int n10 = n4 + -((int)(Math.cos(f) * (double)n8));
                graphics.setColor(0x806060);
                graphics.fillRoundRect(n9 - 8, n10 - 8, 16, 16, 4, 4);
                graphics.setColor(0);
                graphics.drawRoundRect(n9 - 8, n10 - 8, 16, 16, 4, 4);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(string, n9 - n7 / 2, n10 - 6, 20);
            }
            graphics.setColor(0);
            if (this.a.a == 0) {
                graphics.drawString("NO SATELLITE", 0, n2 / 2, 36);
            }
        } else if (this.lastStatusInfo != -1) {
            Font font = Font.getFont((int)64, (int)1, (int)16);
            graphics.setFont(font);
            graphics.setColor(1044480);
            this.a(graphics, "Location status is:", n / 2, 0);
            graphics.setColor(0);
            this.a(graphics, this.lastStatusInfoStr, n / 2, n2 / 2 - font.getHeight());
            this.a(graphics, "Code:" + this.lastStatusInfo, n / 2, n2 / 2 + font.getHeight());
        } else {
            graphics.setColor(0);
            graphics.drawString("No GPS used", 0, n2 / 2, 36);
        }
    }

    public void setLoc(oneGPSPos oneGPSPos2) {
        this.b = oneGPSPos2.speed;
        this.c = oneGPSPos2.m_lon;
        this.d = oneGPSPos2.m_lat;
        this.a = oneGPSPos2.m_dir;
        this.e = oneGPSPos2.m_alt;
        this.c = oneGPSPos2.stamp;
        super.setLoc(oneGPSPos2);
    }
}

