/*
 * Decompiled with CFR 0.152.
 */
package net.landspurg.map;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.landspurg.map.MapCanvas;
import net.landspurg.map.OneLocListener;
import net.landspurg.util.UtilMidp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OneLoc
implements Runnable {
    public float m_lon;
    public float m_lat;
    public int px;
    public int py;
    public int e = 90;
    public int f = 80;
    public static int m_defaultWidth = 90;
    public static int m_defaultHeight = 80;
    public int g = 15;
    public int h = 30;
    public String name = "";
    public String description = "";
    public String phoneNum = null;
    public String address = "";
    public String iconName = null;
    public Image iconImage = null;
    public String imageName = null;
    public OneLocListener m_theListener = null;
    public int zoom = 1;
    public String URL = null;
    public boolean isModeSat = false;
    public int ima_offx = 0;
    public int ima_offy = 0;
    public int m_category = 0;
    public static final int ICON_LOC_PIN = 0;
    public static final int ICON_SMALL_PIN = 1;
    public static final int ICON_INVISIBLE = 2;
    public static final int ICON_DIAMOND = 3;
    public static final int ICON_CIRCLE = 4;
    public static final int ICON_IMAGE = 5;
    public static final int ICON_PHOTO = 6;
    public int m_type = 0;
    public int m_col = 0xFF8080;
    public int m_colForeground = 0xFFFFFF;
    private static int a = 0;
    private boolean a;
    public Hashtable a = null;

    public OneLoc() {
    }

    public OneLoc(String string, float f, float f2, int n, boolean bl) {
        this.init(string, f, f2, n, bl);
    }

    public OneLoc(float f, float f2) {
        this.m_lon = f;
        this.m_lat = f2;
        this.validate();
    }

    public void init(String string, float f, float f2, int n, boolean bl) {
        this.name = string;
        this.m_lon = f;
        this.m_lat = f2;
        this.validate();
        this.zoom = n;
        this.isModeSat = bl;
    }

    public int distFrom(int n, int n2, int n3) {
        long l = (this.px - n) / (1 << n3);
        long l2 = (this.py - n2) / (1 << n3);
        float f = l * l + l2 * l2;
        int n4 = (int)Math.sqrt(f);
        return n4;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.m_type == 2) {
            return;
        }
        int n8 = n3 + n5 / 2 + (this.px - n) / (1 << n7);
        int n9 = n4 + n6 / 2 + (this.py - n2) / (1 << n7);
        if (n8 > -this.e && n9 > -this.f && n8 < n5 + n3 && n9 < n6 + n4) {
            if (this.iconImage == null) {
                int n10;
                int n11 = n8 - n5 / 2;
                if (n11 < 0) {
                    n11 = -n11;
                }
                if ((n10 = n9 - n6 / 2) < 0) {
                    n10 = -n10;
                }
                graphics.setColor(this.m_col);
                switch (this.m_type) {
                    default: {
                        graphics.fillRoundRect(n8 + 5, n9 - 25, 12, 12, 9, 9);
                        graphics.setColor(0);
                        graphics.drawRoundRect(n8 + 5, n9 - 25, 12, 12, 9, 9);
                        graphics.setColor(this.m_col);
                        graphics.fillTriangle(n8, n9, n8 + 11, n9 - 13, n8 + 6, n9 - 17);
                        graphics.setColor(0);
                        graphics.drawLine(n8, n9, n8 + 11, n9 - 13);
                        graphics.drawLine(n8, n9, n8 + 6, n9 - 17);
                        break;
                    }
                    case 1: {
                        graphics.fillArc(n8 + 10, n9 - 16, 8, 8, 0, 360);
                        graphics.setColor(0);
                        graphics.drawLine(n8, n9, n8 + 10, n9 - 10);
                        graphics.drawArc(n8 + 10, n9 - 16, 7, 7, 0, 360);
                        break;
                    }
                    case 3: {
                        graphics.fillTriangle(n8 - 5, n9, n8, n9 - 5, n8, n9 + 5);
                        graphics.fillTriangle(n8 + 5, n9, n8, n9 - 5, n8, n9 + 5);
                        graphics.setColor(0);
                        graphics.drawLine(n8 - 5, n9, n8, n9 - 5);
                        graphics.drawLine(n8, n9 - 5, n8 + 5, n9);
                        graphics.drawLine(n8 + 5, n9, n8, n9 + 5);
                        graphics.drawLine(n8, n9 + 5, n8 - 5, n9);
                        break;
                    }
                    case 4: {
                        graphics.fillArc(n8 - 5, n9 - 5, 10, 10, 0, 360);
                        graphics.setColor(0);
                        graphics.drawArc(n8 - 5, n9 - 5, 10, 10, 0, 360);
                        break;
                    }
                }
            } else if (this.m_type != 5) {
                graphics.setColor(this.m_colForeground);
                graphics.fillRoundRect(n8 - this.iconImage.getWidth() / 2 - 2, n9 - 10 - (this.iconImage.getHeight() + 2), this.iconImage.getWidth() + 4, this.iconImage.getHeight() + 4, 6, 6);
                graphics.fillTriangle(n8, n9, n8 + 11, n9 - 13, n8 + 6, n9 - 17);
                graphics.drawImage(this.iconImage, n8 - this.iconImage.getWidth() / 2, n9 - 10, 36);
            } else {
                graphics.drawImage(this.iconImage, n8 + this.ima_offx, n9 + this.ima_offy, 36);
            }
        }
        if (this.iconImage == null && this.iconName != null && !this.a) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void setListener(OneLocListener oneLocListener) {
        this.m_theListener = oneLocListener;
    }

    public void fireLoaded() {
        if (this.m_theListener != null) {
            this.m_theListener.iconDownloaded(this);
        }
    }

    public synchronized int a() {
        return a;
    }

    public synchronized int b() {
        return a++;
    }

    public synchronized int c() {
        return a--;
    }

    public void setIconImage(Image image, int n, int n2) {
        this.m_type = 5;
        this.iconImage = image;
        this.ima_offx = n;
        this.ima_offy = n2;
    }

    public void paintFull(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10 = n3 + n5 / 2 + (this.px - n) / (1 << n7);
        int n11 = n4 + n6 / 2 + (this.py - n2) / (1 << n7);
        int n12 = n10 - n5 / 2;
        if (n12 < 0) {
            n12 = -n12;
        }
        if ((n9 = n11 - n6 / 2) < 0) {
            n9 = -n9;
        }
        graphics.setColor(0xFF8080);
        graphics.setColor(0xFFFFFF);
        int n13 = this.g;
        graphics.setFont(UtilMidp.m_smallFont);
        int n14 = graphics.getFont().getHeight();
        if (this.description.equals("") && this.address.equals("") && this.name.equals("")) {
            if (this.iconImage != null) {
                this.g = this.iconImage.getHeight() - this.ima_offy;
                this.h += this.ima_offx;
                int n15 = this.m_colForeground;
                this.m_colForeground = 0xFF0000;
                this.paint(graphics, n, n2, n3, n4, n5, n6, n7);
                this.m_colForeground = n15;
            } else {
                int n16 = this.m_col;
                this.m_col = 0xFF0000;
                this.paint(graphics, n, n2, n3, n4, n5, n6, n7);
                this.m_col = n16;
            }
            return;
        }
        graphics.fillRoundRect(n10 - this.h, n11 - (this.f + this.g), this.e, this.f, 10, 10);
        graphics.fillTriangle(n10 + 8, n11 - 8, n10 + 10, n11 - this.g, n10 + 15, n11 - this.g);
        graphics.setColor(0);
        graphics.drawRoundRect(n10 - this.h, n11 - (this.f + this.g), this.e, this.f, 10, 10);
        graphics.drawLine(n10 + 8, n11 - 8, n10 + 10, n11 - this.g);
        graphics.drawLine(n10 + 8, n11 - 8, n10 + 15, n11 - this.g);
        int n17 = n10 - this.h + 4;
        int n18 = n11 - (this.g + this.f) + 2;
        int n19 = (this.e - 2) / 5;
        Font font = graphics.getFont();
        this.description = UtilMidp.checkString(this.description);
        this.address = UtilMidp.checkString(this.address);
        String string = this.name + "\n" + this.description + "\n" + this.address;
        do {
            if ((n8 = (string = string.trim()).indexOf(10)) == -1) {
                n8 = string.length();
            }
            if (font.substringWidth(string, 0, n8) > this.e) {
                char c;
                int n20 = 0;
                while (n20 + 1 < string.length() && font.substringWidth(string, 0, n20 + 1) < this.e) {
                    ++n20;
                }
                n8 = n20 - 1;
                while ((c = string.charAt(n20--)) != '\n' && c != ' ' && c != '-' && c != '.' && n20 > 0) {
                }
                if (n20 != 0) {
                    n8 = n20 + 1;
                }
            }
            graphics.drawString(string.substring(0, n8), n17, n18, 20);
        } while ((string = string.substring(n8)).length() > 0 && (n18 += n14) + n14 < n11 - this.g);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(n10 + 10, n11 - this.g, n10 + 15, n11 - this.g);
        this.g = n13;
    }

    public void run() {
        this.a = true;
        try {
            if (this.iconName != null && this.iconImage == null) {
                while (this.a() > 2) {
                    Thread.sleep(500L);
                }
                this.b();
                HttpConnection httpConnection = (HttpConnection)Connector.open((String)this.iconName);
                int n = httpConnection.getResponseCode();
                if (n != 200) {
                    this.iconName = null;
                } else {
                    InputStream inputStream = httpConnection.openInputStream();
                    this.iconImage = UtilMidp.ImagecreateImage(inputStream);
                    if (this.iconImage.getWidth() > 40) {
                        this.iconImage = UtilMidp.getThumbnail(null, 0, 0, this.iconImage, 40);
                    }
                    if (this.m_theListener != null) {
                        this.m_theListener.iconDownloaded(this);
                    }
                }
                this.c();
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.c();
            this.iconName = null;
        }
        this.a = false;
    }

    public boolean validate() {
        this.px = MapCanvas.xFromLon(this.m_lon);
        this.py = MapCanvas.yFromLat(this.m_lat);
        this.e = m_defaultWidth;
        this.f = m_defaultHeight;
        return true;
    }

    public void setLonLat(float f, float f2) {
        this.m_lon = f;
        this.m_lat = f2;
        this.validate();
    }

    public void setPxPy(int n, int n2) {
        this.px = n;
        this.py = n2;
        this.m_lon = MapCanvas.convLon(this.px);
        this.m_lat = MapCanvas.convLat(this.py);
    }

    public static OneLoc createFromString(String string) {
        int n = 0;
        OneLoc oneLoc = new OneLoc(0.0f, 0.0f);
        while (true) {
            int n2;
            int n3;
            if ((n3 = string.indexOf(33, n + 1)) == -1) {
                n3 = string.length();
            }
            if ((n2 = string.indexOf(58, n + 1)) == -1) break;
            String string2 = string.substring(n, n2);
            String string3 = string.substring(n2 + 1, n3);
            if (string2.equals("name")) {
                oneLoc.name = string3;
            } else if (string2.equals("lon")) {
                oneLoc.m_lon = Float.parseFloat(string3);
            } else if (string2.equals("lat")) {
                oneLoc.m_lat = Float.parseFloat(string3);
            } else if (string2.equals("phone")) {
                oneLoc.phoneNum = string3;
            } else if (string2.equals("desc")) {
                oneLoc.description = string3;
            } else if (string2.equals("adr")) {
                oneLoc.address = string3;
            } else if (string2.equals("zoom")) {
                oneLoc.zoom = Integer.parseInt(string3);
            } else if (string2.equals("sat")) {
                oneLoc.isModeSat = string3.equals("true");
            }
            n = n3 + 1;
        }
        if (!oneLoc.validate()) {
            return null;
        }
        return oneLoc;
    }

    public void setValue(String string, Object object) {
        if (this.a == null) {
            this.a = new Hashtable();
        }
        this.a.put(string, object);
    }

    public Object getValue(String string) {
        if (this.a == null) {
            return null;
        }
        return this.a.get(string);
    }

    public String saveToString() {
        String string = "name:" + this.name + "!lon:" + this.m_lon + "!lat:" + this.m_lat + "!desc:" + this.description + "!adr:" + this.address + "!phone:" + this.phoneNum + "!zoom:" + this.zoom + "!sat:" + this.isModeSat;
        return string;
    }

    public OneLoc clone(float f, float f2) {
        OneLoc oneLoc = new OneLoc(f, f2);
        oneLoc.m_col = this.m_col;
        oneLoc.m_colForeground = this.m_colForeground;
        oneLoc.m_type = this.m_type;
        oneLoc.h = this.h;
        oneLoc.g = this.g;
        oneLoc.iconImage = this.iconImage;
        oneLoc.imageName = this.imageName;
        oneLoc.iconName = this.iconName;
        oneLoc.ima_offx = this.ima_offx;
        oneLoc.ima_offy = this.ima_offy;
        oneLoc.e = this.e;
        oneLoc.f = this.f;
        return oneLoc;
    }
}

