/*
 * Decompiled with CFR 0.152.
 */
package net.landspurg.map;

import henson.midp.Float11;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import net.landspurg.map.BufferImage;
import net.landspurg.map.BufferImageListener;
import net.landspurg.map.MapCanvasListener;
import net.landspurg.map.MapCustomOverlay;
import net.landspurg.map.OneLoc;
import net.landspurg.map.OneLocListener;
import net.landspurg.map.Track;
import net.landspurg.map.oneGPSPos;
import net.landspurg.util.UtilMidp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MapCanvas
extends GameCanvas
implements Runnable,
OneLocListener,
BufferImageListener {
    public int a;
    public int b;
    public int c;
    public int d;
    public Image a;
    public String a;
    public MapCanvasListener a;
    public static Float a = new Float(180.0f);
    public static Float b = new Float(1.0f);
    public int[] a;
    public int[] b;
    public int[] c;
    public int[] m_segments = null;
    public int[] m_gpsSegments = null;
    public int e = 0;
    public long a;
    public OneLoc currentSel = null;
    public Vector listPlaces = new Vector();
    public Vector m_listMyPlaces = new Vector();
    public int f = 0x800000;
    public int g = 0x800000;
    public static int h = 128;
    public static int i = 128;
    public int j = 17;
    public boolean m_modeSat = false;
    public boolean m_drawLon = false;
    public boolean m_displayCenterArrow = false;
    public boolean m_displaySize = true;
    public boolean m_useUSMetrics = false;
    public static int k = 0;
    private String b;
    private final double a;
    private String c;
    public oneGPSPos m_lastLocation = null;
    public boolean m_autoPositionningEnabeld;
    private int s = 0;
    private boolean b;
    private int t;
    private int u;
    public boolean m_useResampledImages = true;
    private long c;
    public OneLoc wayPoint = null;
    public boolean m_modeShortkey = false;
    public boolean m_autoTrack = true;
    public boolean m_record = false;
    public boolean m_pause = false;
    private static Font a = null;
    private static Font b = null;
    private static int v;
    private boolean c = true;
    public static final int ST_NORMAL = 0;
    public static final int ST_ZOOM = 1;
    public static final int ST_MOVE_PIN = 2;
    private Track b;
    public static int m_state;
    public Track a;
    public String[] a;
    public String m_moreInfo = null;
    private static String[] b;
    public boolean m_drawConsumption = true;
    public int id = -1;
    private MapCustomOverlay a;
    public boolean a;
    public static int l;
    public static int m;
    public int n = 0;
    public int o = 0;
    public int[][] a = new int[5][2];
    public int p = -1;
    public int q = -1;
    public int r = 0;
    public long b = 0L;

    public MapCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.c = this.getWidth();
        this.d = this.getHeight();
        this.f = 16994944;
        this.g = 11543168;
        a = Font.getFont((int)64, (int)0, (int)16);
        b = Font.getFont((int)64, (int)1, (int)16);
        OneLoc.m_defaultWidth = this.c / 2;
        OneLoc.m_defaultHeight = this.d / 3;
    }

    public void init() {
        BufferImage.setImageListener(this);
        BufferImage.initBuffer();
        Thread thread = new Thread(this);
        thread.start();
    }

    public int getLonPx() {
        return this.f;
    }

    public int getLatPy() {
        return this.g;
    }

    public void setClipRect(int n, int n2, int n3, int n4) {
        this.a = n;
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public int getZoom() {
        return this.j;
    }

    public void setZoom(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 17) {
            n = 17;
        }
        if (n != this.j) {
            this.j = n;
            this.b = "Zoom:" + (17 - this.j);
            BufferImage.cleanBuffer();
            if (n > this.j) {
                this.c = System.currentTimeMillis();
            }
            this.s = this.j;
        }
    }

    public int getBufferSize() {
        return BufferImage.c;
    }

    public void setTileSize(int n) {
        h = n;
        this.setModeProxy(true);
    }

    public void setModeProxy(boolean bl) {
        BufferImage.m_useProxy = bl;
        if (bl) {
            i = h;
            BufferImage.m_modePacked = true;
        } else {
            i = 256;
            BufferImage.m_modePacked = false;
        }
        this.setBufferSize(BufferImage.c);
    }

    public boolean getModeProxy() {
        return BufferImage.m_useProxy;
    }

    public void setBufferSize(int n) {
        int n2 = (this.c / i + 2) * (this.d / i + 2) * 2;
        System.out.println("Set buffer size:" + n + " Nb Vis:" + n2);
        if (n2 > n) {
            n = n2;
        }
        BufferImage.setBufferSize(n);
        if (!BufferImage.m_useRMS) {
            BufferImage.setVisibleSize(n);
        } else {
            BufferImage.setVisibleSize(n2);
        }
    }

    public void setOverlay(MapCustomOverlay mapCustomOverlay) {
        this.a = mapCustomOverlay;
    }

    public void run() {
        this.a = true;
        while (this.a) {
            try {
                Thread.sleep(1000L);
                if (this.c != 0L && System.currentTimeMillis() - this.c > 1000L) {
                    this.c = 0L;
                    this.repaint();
                }
                this.a();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stop() {
        BufferImage.stop();
        this.a = false;
    }

    public void clear() {
        this.listPlaces = new Vector();
        this.m_segments = null;
        this.m_gpsSegments = null;
        this.wayPoint = null;
        this.m_moreInfo = null;
    }

    public OneLoc getSelectedItem(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        OneLoc oneLoc;
        int n6;
        OneLoc oneLoc2 = null;
        if (this.currentSel != null && (n6 = this.currentSel.distFrom(n, n2, n3)) < n4) {
            oneLoc2 = this.currentSel;
            n4 = n6;
        }
        Enumeration enumeration = this.listPlaces.elements();
        while (enumeration.hasMoreElements()) {
            oneLoc = (OneLoc)enumeration.nextElement();
            if (oneLoc.m_theListener == null) {
                oneLoc.setListener(this);
            }
            if (graphics != null) {
                oneLoc.paint(graphics, this.f, this.g, this.a, this.b, this.c, this.d, n3);
            }
            if (bl || (n5 = oneLoc.distFrom(n, n2, n3)) >= n4) continue;
            n4 = n5;
            oneLoc2 = oneLoc;
        }
        enumeration = this.m_listMyPlaces.elements();
        while (enumeration.hasMoreElements()) {
            oneLoc = (OneLoc)enumeration.nextElement();
            if (oneLoc.m_theListener == null) {
                oneLoc.setListener(this);
            }
            if (graphics != null) {
                oneLoc.paint(graphics, this.f, this.g, this.a, this.b, this.c, this.d, n3);
            }
            if (bl || (n5 = oneLoc.distFrom(n, n2, n3)) >= n4) continue;
            n4 = n5;
            oneLoc2 = oneLoc;
        }
        if (bl) {
            oneLoc2 = this.currentSel;
        }
        return oneLoc2;
    }

    public void sizeChanged(int n, int n2) {
        this.c = n;
        this.d = n2;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.setClip(this.a, this.b, this.c, this.d);
        if (this.j == 17) {
            graphics.setColor(0);
            graphics.fillRect(this.a, this.b, this.c, this.d);
        }
        v = graphics.getFont().getHeight();
        int n10 = this.d - v - v - 10;
        int n11 = 1 << this.j;
        int n12 = this.f / n11 - this.c / 2;
        int n13 = this.g / n11 - this.d / 2;
        int n14 = this.b - n13 % i;
        int n15 = n13;
        do {
            n5 = this.a - n12 % i;
            n4 = n12;
            do {
                int n16 = k;
                BufferImage.m_customOverlay = this.a;
                if (this.a == null || this.a.isTransparent()) {
                    this.a(graphics, n5, n14, n4, n15, this.j, false);
                }
                if (this.a != null) {
                    k = 4;
                    this.a(graphics, n5, n14, n4, n15, this.j, true);
                }
                k = n16;
                n4 += i;
            } while ((n5 += i) < this.c);
            n15 += i;
        } while ((n14 += i) < this.d);
        n5 = 20;
        if (this.m_displayCenterArrow) {
            graphics.setColor(0xFF0000);
            graphics.drawRect(this.a + this.c / 2 - n5 / 2, this.b + this.d / 2 - n5 / 2, n5, n5);
        }
        if (!BufferImage.m_doNotUseNetwork) {
            n4 = BufferImage.getPending();
            if (n4 > 0) {
                String string = " To load:" + n4;
                this.drawString(graphics, string, 10 + this.a, 1 + this.b);
            }
        } else {
            this.drawString(graphics, "Network disabled", 10 + this.a, 1 + this.b);
        }
        n4 = this.b + 1 + v + 2;
        this.drawString(graphics, this.b, 10 + this.a, n4);
        n4 += v + 1;
        if (this.m_drawLon) {
            this.drawString(graphics, "Lon:" + MapCanvas.getCoordAsString(true, this.getLon(), true), this.a, n4);
            this.drawString(graphics, "Lat:" + MapCanvas.getCoordAsString(false, this.getLat(), true), this.b, n4 += v + 1);
            n4 += v + 1;
        }
        if (this.m_segments != null) {
            this.drawSegment(graphics, this.m_segments, n12, n13, n11, 255);
        }
        if (this.m_gpsSegments != null) {
            this.drawSegment(graphics, this.m_gpsSegments, n12, n13, n11, 65280);
        }
        this.drawDirectiontoWayPoint(graphics);
        OneLoc oneLoc = this.getSelectedItem(graphics, this.f, this.g, this.j, n5, this.hasPointerEvents());
        if (oneLoc != null) {
            oneLoc.paint(graphics, this.f, this.g, this.a, this.b, this.c, this.d, this.j);
            oneLoc.paintFull(graphics, this.f, this.g, this.a, this.b, this.c, this.d, this.j);
            this.a(oneLoc);
        } else {
            this.a(null);
        }
        this.drawBottomIndicators(graphics, n10);
        this.drawString(graphics, b[k], 1, n10);
        n10 -= v;
        if (this.m_displaySize) {
            n2 = n3 = this.getSize(this.c);
            n = 1;
            while (n2 / n > 10) {
                n *= 10;
            }
            int n17 = n2 / n;
            if (n17 > 4) {
                n *= 2;
            } else if (n17 == 1) {
                n /= 2;
            }
            int n18 = n * this.c / n2;
            String string = "";
            if (n < 1000) {
                string = " m";
            } else {
                string = " km";
                n /= 1000;
            }
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, n10 + v - 4, n18 + 2, 5);
            graphics.setColor(0xFF0000);
            graphics.fillRect(1, n10 + v - 3, n18, 3);
            this.drawString(graphics, n + string, 1, n10 - 4);
            n10 -= v;
        }
        if (this.m_moreInfo != null) {
            this.drawString(graphics, this.m_moreInfo, 1, n10);
            n10 -= v;
        }
        if (this.m_lastLocation != null) {
            this.paintGPSPos(graphics, this.m_lastLocation, this.f, this.g, this.c, this.d, this.j);
        }
        if (this.b) {
            n3 = this.j > this.s ? 1 << this.j - this.s : 1 << -this.j + this.s;
            graphics.setColor(0);
            n2 = this.c / n3;
            n = this.d / n3;
            graphics.drawRect(this.a + this.t - 1 - n2 / 2, this.b + this.u - 1 - n / 2, n2, n);
            graphics.setColor(1048575);
            graphics.drawRect(this.a + this.t - n2 / 2, this.b + this.u - n / 2, n2, n);
        }
        if (this.c != null) {
            this.a(graphics, this.c, 10, this.d - 50, 0, 0xFFFFFF);
            this.c = null;
        }
        if (UtilMidp.DEBUG) {
            this.drawString(graphics, "Mem:" + Runtime.getRuntime().freeMemory(), 0, 90);
        }
        this.a(graphics, this.a);
        if (this.hasPointerEvents()) {
            this.paintIcons(graphics);
        }
        if (this.m_drawConsumption) {
            n3 = BufferImage.m_dataDownloadCounter / 1024;
            String string = n3 > 900 ? n3 / 1024 + "." + n3 * 100 / 1024 % 100 + " Mb" : n3 + " Kb";
            this.drawString(graphics, string, 10, n4);
            n4 += v + 1;
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    public void setMode(int n) {
    }

    public void drawBottomIndicators(Graphics graphics, int n) {
        int n2 = this.getWidth() - 10;
        if (this.m_autoPositionningEnabeld) {
            this.drawString(graphics, "GPS", n2 -= graphics.getFont().stringWidth("GPS"), n);
            if (this.m_autoTrack) {
                this.drawString(graphics, "TRACK/", n2 -= graphics.getFont().stringWidth("TRACK/"), n);
                n2 -= 4;
            }
            if (this.m_record) {
                graphics.setColor(0xFF0000);
                graphics.drawString(Integer.toString(Track.currRecord), n2 - v - 6, n, 24);
                if (this.m_pause) {
                    graphics.fillRoundRect(n2 - v - 4, n, v, v, 5, 5);
                    graphics.setColor(0);
                    graphics.drawRoundRect(n2 - v - 4, n, v, v, 5, 5);
                } else {
                    graphics.fillTriangle(n2 - v - 4, this.d - v - 4, n2 - v - 4, this.d - 4, n2 - 4, this.d - v / 2 - 4);
                    graphics.drawLine(n2 - v - 4, n, n2 - v - 4, n + v);
                    graphics.drawLine(n2 - v - 4, n + v, n2 - 4, n + v / 2);
                    graphics.drawLine(n2 - v - 4, n, n2 - 4, n + v / 2);
                }
            }
        }
    }

    public int getSize(int n) {
        double d = 1.194302913224441;
        double d2 = d * Math.cos(Math.toRadians(MapCanvas.convLat(this.g + this.j * (this.d / 2))));
        int n2 = (int)(d2 * (double)((1 << this.j) * n));
        return n2;
    }

    public int a(int n, int n2) {
        long l = 0L;
        long l2 = 179L;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        long l3 = (n > n2 ? n : n2) << 8;
        long l4 = (long)(n + n2) * l2;
        l = l3 < l4 ? l3 : l4;
        l = l * (256L + 65536L / (1024L - 2L * l2)) / 512L;
        return (int)l;
    }

    public void drawSegment(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        graphics.setColor(n4);
        for (int i = 0; i < nArray.length && nArray[i] != -1; i += 2) {
            int n7 = nArray[i + 1] / n3 - n;
            int n8 = nArray[i] / n3 - n2;
            if (i > 0) {
                int n9 = this.a(n5 - n7, n6 - n8);
                if (n9 == 0) {
                    n9 = 256;
                }
                if (n9 < 65536) {
                    int n10 = (n8 - n6) * 2 * 256 / n9;
                    int n11 = -(n7 - n5) * 2 * 256 / n9;
                    graphics.fillTriangle(n5 - n10, n6 - n11, n7 - n10, n8 - n11, n7 + n10, n8 + n11);
                    graphics.fillTriangle(n5 - n10, n6 - n11, n5 + n10, n6 + n11, n7 + n10, n8 + n11);
                }
            }
            n5 = n7;
            n6 = n8;
        }
    }

    public void a(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = graphics.getFont().stringWidth(string);
        int n6 = graphics.getFont().getHeight();
        n = (this.getWidth() - n5) / 2;
        graphics.setColor(n4);
        graphics.fillRoundRect(n - 2, n2 - 2, n5 + 4, n6 + 4, 5, 5);
        graphics.setColor(n3);
        graphics.drawRoundRect(n - 2, n2 - 2, n5 + 4, n6 + 4, 5, 5);
        graphics.drawString(string, n, n2, 20);
    }

    public void a(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (UtilMidp.DEBUG) {
            System.out.println("size:" + n3 + " " + n4 + " " + n5);
        }
        if (this.a == null || this.a.length != n5) {
            this.a = new int[n5];
        }
        if (this.b == null || this.b.length != n6) {
            this.b = new int[n6];
        }
        if (this.c == null || this.c.length != n6) {
            this.c = new int[n6];
        }
        for (n7 = 0; n7 < n6; ++n7) {
            this.c[n7] = n7 * n5 / n6 % n5;
        }
        n7 = -1;
        for (int i = 0; i < n6; ++i) {
            if (n2 + i < 0 || n2 + i >= this.d) continue;
            int n8 = n4 + i * n5 / n6;
            if (n8 != n7) {
                image.getRGB(this.a, 0, n5, n3, n8, n5, 1);
                n7 = n8;
                for (int j = 0; j < n6; ++j) {
                    this.b[j] = this.a[this.c[j]];
                }
            }
            try {
                if (n < 0) {
                    graphics.drawRGB(this.b, -n, n6, 0, n2 + i, n6 + n, 1, false);
                    continue;
                }
                graphics.drawRGB(this.b, 0, n6, n, n2 + i, n6, 1, false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        BufferImage bufferImage;
        n3 -= n3 % i;
        n4 -= n4 % i;
        int n6 = (!this.m_modeSat ? 0 : 1) + k * 2;
        BufferImage bufferImage2 = bufferImage = BufferImage.getImage(n3, n4, n5, n6, i);
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        int n10 = n3;
        int n11 = n4;
        if (this.m_useResampledImages && System.currentTimeMillis() - this.c > 1000L) {
            int n12;
            for (n12 = i; (bufferImage == null || bufferImage.ima == null) && n9 < 17 && n12 > 1; n12 = (int)((short)(n12 / 2))) {
                BufferImage bufferImage3;
                n7 = n7 / 2 + (n10 /= 2) % i;
                n8 = n8 / 2 + (n11 /= 2) % i;
                if ((bufferImage3 = BufferImage.getImage(n10 = n10 / i * i, n11 = n11 / i * i, ++n9, n6, i, false)) == null) continue;
                bufferImage = bufferImage3;
            }
            if (bufferImage2.ima == null && bufferImage != null && bufferImage.ima != null) {
                this.a(graphics, bufferImage.ima, n, n2, n7, n8, n12, i);
                bufferImage.state = 1;
                return;
            }
        }
        if (bufferImage != null && bufferImage.ima != null) {
            graphics.drawImage(bufferImage.ima, n, n2, 20);
            if (UtilMidp.DEBUG) {
                this.drawString(graphics, "" + BufferImage.b, n, n2);
            }
            if (bufferImage.state == 4) {
                graphics.setColor(0x800000);
                graphics.fillRect(n, n2, i, i);
                this.drawString(graphics, "NOT AVAILABLE", n + 50, n2 + i / 2);
            }
            if (UtilMidp.DEBUG && bufferImage.debugString != null) {
                graphics.setColor(0xFF0000);
                graphics.drawString(bufferImage.debugString, n, n2 + 10, 20);
                graphics.drawString("id:" + bufferImage.a + " " + bufferImage.state, n, n2 + 20, 20);
            }
        } else if (!bl) {
            if (this.m_modeSat) {
                graphics.setColor(0, 0, 0);
            } else {
                graphics.setColor(255, 255, 255);
            }
            if (bufferImage != null && bufferImage.state == 2) {
                graphics.setColor(0x808080);
            }
            graphics.fillRect(n, n2, i, i);
            graphics.setColor(255, 0, 0);
            graphics.drawLine(n, n2, n + i, n2 + i);
            graphics.drawLine(n, n2 + i, n + i, n2);
            graphics.drawLine(n, n2, n + i, n2);
            graphics.drawLine(n, n2, n, n2 + i);
            if (bufferImage != null && bufferImage.state == 2) {
                this.drawString(graphics, "Loading...", n + 50, n2 + i / 2);
            }
        }
    }

    public static String getCoordAsString(boolean bl, float f, boolean bl2) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(f > 0.0f ? (char)'E' : 'W');
        } else {
            stringBuffer.append(f > 0.0f ? (char)'N' : 'S');
        }
        if (f < 0.0f) {
            f = -f;
        }
        stringBuffer.append(' ');
        stringBuffer.append(Integer.toString((int)f));
        stringBuffer.append('\u00b0');
        int n3 = (int)f;
        int n4 = 0;
        f -= (float)n3;
        if (bl2) {
            float f2 = f * 60.0f;
            n2 = (int)Math.floor(f2);
            n = (int)((f2 - (float)n2) * 60.0f);
            n4 = (int)((f2 - (float)n2) * 60.0f * 100.0f) % 100;
        } else {
            n2 = (int)(f * 100.0f);
            n = (int)(f * 100000.0f) % 1000;
        }
        String string = Integer.toString(n4);
        stringBuffer.append(n2 + "'" + n);
        while (string.length() < 2) {
            string = '0' + string;
        }
        if (bl2) {
            stringBuffer.append("." + string);
        }
        return stringBuffer.toString();
    }

    public int getDist() {
        return this.getDist(true);
    }

    public int getDist(boolean bl) {
        long l = -1L;
        if (this.wayPoint != null) {
            int n = this.f;
            int n2 = this.g;
            if (this.m_lastLocation != null) {
                n = this.m_lastLocation.a;
                n2 = this.m_lastLocation.b;
            }
            int n3 = this.wayPoint.px - n;
            int n4 = this.wayPoint.py - n2;
            if (n3 != 0 || n4 != 0) {
                double d = n3;
                double d2 = n4;
                l = (int)Math.sqrt(d * d2 + d2 * d2);
                if (bl) {
                    l = this.getSize((int)l / (1 << this.j));
                }
            }
        } else {
            l = -1L;
        }
        return (int)l;
    }

    public double getCourseToTarget() {
        double d = Double.NaN;
        if (this.wayPoint != null) {
            float f;
            float f2;
            double d2;
            int n = this.f;
            int n2 = this.g;
            if (this.m_lastLocation != null) {
                n = this.m_lastLocation.a;
                n2 = this.m_lastLocation.b;
            }
            if ((d2 = Math.sqrt((f2 = -((float)(this.wayPoint.px - n))) * f2 + (f = -((float)(this.wayPoint.py - n2))) * f)) != 0.0) {
                d = -Float11.asin((double)f2 / d2);
                if (f < 0.0f) {
                    d = Math.PI - d;
                }
                d = Math.toDegrees(d);
            }
        }
        return d;
    }

    public String convertDisToString(int n) {
        String string = null;
        string = n > 1999 ? (n > 200000 ? n / 1000 + " km" : n / 1000 + "." + 2 + " km") : n + " m";
        return string;
    }

    public void drawDirectiontoWayPoint(Graphics graphics) {
        if (this.wayPoint != null) {
            int n;
            int n2 = this.wayPoint.px - this.f;
            int n3 = this.wayPoint.py - this.g;
            if (this.m_lastLocation != null) {
                n2 = this.wayPoint.px - this.m_lastLocation.a;
                n3 = this.wayPoint.py - this.m_lastLocation.b;
            }
            if ((n2 /= 1 << this.j) == 0 && (n3 /= 1 << this.j) == 0) {
                graphics.setColor(255);
                graphics.drawArc(this.a + this.c / 2 - 20, this.b + this.d / 2 - 20, 40, 40, 0, 360);
                graphics.drawArc(this.b + this.c / 2 - 19, this.b + this.d / 2 - 19, 38, 38, 0, 360);
            } else {
                int n4 = (int)Math.sqrt(n2 * n2 + n3 * n3);
                n = this.getSize(n4);
                String string = null;
                string = n > 1999 ? (n > 200000 ? "Dist:" + n / 1000 + " km" : "Dist:" + n / 1000 + "." + n / 100 % 10 + " km") : "Dist:" + n + " m";
                graphics.setColor(0);
                graphics.drawString(string, this.a + this.c / 2 + 1, this.b + 40 + 1, 17);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(string, this.a + this.c / 2, this.b + 40, 17);
                n2 = n2 * 20 / n4;
                n3 = n3 * 20 / n4;
                graphics.setColor(255);
                int n5 = this.a + (this.c / 2 + n2);
                int n6 = this.b + (this.d / 2 + n3);
                int n7 = n4;
                if (n7 == 0) {
                    n7 = 1;
                }
                if (n7 < 60) {
                    n5 += n2 * n7 / 20 - 3 * n2;
                    n6 += n3 * n7 / 20 - 3 * n3;
                }
                int n8 = n2 / 4;
                int n9 = n3 / 4;
                graphics.fillTriangle(n5 - n9, n6 + n8, n5 + n2 - n9, n6 + n3 + n8, n5 + n2 + n9, n6 + n3 - n8);
                graphics.fillTriangle(n5 - n9, n6 + n8, n5 + n2 + n9, n6 + n3 - n8, n5 + n9, n6 - n8);
                graphics.fillTriangle((n5 += n2) + n2, (n6 += n3) + n3, n5 - n3 / 2, n6 + n2 / 2, n5 + n3 / 2, n6 - n2 / 2);
                graphics.setColor(0);
                graphics.drawLine((n5 -= n2) - n9, (n6 -= n3) + n8, n5 + n2 - n9, n6 + n3 + n8);
                graphics.drawLine(n5 + n2 - n9, n6 + n3 + n8, n5 + n2 - n3 / 2, n6 + n3 + n2 / 2);
                graphics.drawLine(n5 + 2 * n2, n6 + 2 * n3, n5 + n2 - n3 / 2, n6 + n3 + n2 / 2);
                graphics.drawLine(n5 + 2 * n2, n6 + 2 * n3, n5 + n2 + n3 / 2, n6 + n3 - n2 / 2);
                graphics.drawLine(n5 + n2 + n9, n6 + n3 - n8, n5 + n2 + n3 / 2, n6 + n3 - n2 / 2);
                graphics.drawLine(n5 + n9, n6 - n8, n5 + n2 + n9, n6 + n3 - n8);
                graphics.drawLine(n5 + n9, n6 - n8, n5 - n9, n6 + n8);
            }
            this.wayPoint.paint(graphics, this.f, this.g, this.a, this.b, this.c, this.d, this.j);
            float f = (float)this.getCourseToTarget();
            n2 = (int)(Math.sin(f) * 50.0);
            n3 = -((int)(Math.cos(f) * 50.0));
            graphics.setColor(0xFFFF00);
            n = this.c / 2;
            int n10 = this.d / 2;
        }
    }

    public void a(Graphics graphics, String[] stringArray) {
        if (this.m_modeShortkey) {
            int n;
            int n2;
            int n3 = stringArray.length;
            int n4 = 0;
            Font font = graphics.getFont();
            for (n2 = 0; n2 < n3; ++n2) {
                n = font.stringWidth(stringArray[n2]);
                if (n <= n4) continue;
                n4 = n;
            }
            n2 = n4 + 4;
            n = font.getHeight() * n3 + 4;
            graphics.setColor(0xFFFFFF);
            graphics.fillRoundRect(0, this.d - n, n2, n, 6, 6);
            graphics.setColor(0);
            graphics.drawRoundRect(0, this.d - n, n2, n, 6, 6);
            for (int i = 0; i < n3; ++i) {
                graphics.drawString(stringArray[i], 2, this.d - n + 2 + i * font.getHeight(), 20);
            }
        }
    }

    public void recenterMapAroundSel() {
        this.recenterMapAroundSel(100);
    }

    public void recenterMapAroundSel(int n) {
        int n2 = 0x2000000;
        int n3 = 0x2000000;
        int n4 = -33554432;
        int n5 = -33554432;
        if (this.listPlaces.size() == 0) {
            if (this.m_segments == null) {
                return;
            }
            for (int i = 0; i < this.m_segments.length; i += 2) {
                if (this.m_segments[i + 1] > n5) {
                    n5 = this.m_segments[i + 1];
                }
                if (this.m_segments[i + 1] < n3) {
                    n3 = this.m_segments[i + 1];
                }
                if (this.m_segments[i] > n4) {
                    n4 = this.m_segments[i];
                }
                if (this.m_segments[i] >= n2) continue;
                n2 = this.m_segments[i];
            }
        }
        Enumeration enumeration = this.listPlaces.elements();
        while (enumeration.hasMoreElements()) {
            OneLoc oneLoc = (OneLoc)enumeration.nextElement();
            if (oneLoc.px > n5) {
                n5 = oneLoc.px;
            }
            if (oneLoc.py > n4) {
                n4 = oneLoc.py;
            }
            if (oneLoc.px < n3) {
                n3 = oneLoc.px;
            }
            if (oneLoc.py >= n2) continue;
            n2 = oneLoc.py;
        }
        this.f = (n5 + n3) / 2;
        this.g = (n4 + n2) / 2;
        int n6 = (int)((long)(n5 - n3) * 1000L / (long)(this.c * n));
        int n7 = (int)((long)(n4 - n2) * 1000L / (long)(this.d * n));
        int n8 = n6;
        if (n7 > n6) {
            n8 = n7;
        }
        n8 = (n8 + 5) / 10;
        int n9 = 0;
        while (1 << n9 < n8) {
            ++n9;
        }
        if (n9 > 16) {
            n9 = 16;
        }
        this.setZoom(n9);
        if (UtilMidp.DEBUG) {
            System.out.println("zoomx:" + n6 + " zoomy:" + n7 + " rz:" + n9);
        }
    }

    public void drawString(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(0, 0, 0);
        graphics.drawString(string, n + 1, n2 + 1, 20);
        graphics.setColor(255, 255, 255);
        graphics.drawString(string, n, n2, 20);
    }

    public void goTo(String string) {
        int n = string.indexOf(32);
        float f = Float.parseFloat(string.substring(0, n));
        int n2 = string.indexOf(32, n + 1);
        float f2 = Float.parseFloat(string.substring(n + 1, n2));
        n = string.indexOf(32, n2 + 1);
        int n3 = Integer.parseInt(string.substring(n2 + 1, n));
        boolean bl = string.substring(n + 1).startsWith("true");
        this.gotoLonLat(f, f2, n3, bl);
    }

    public void goTo(OneLoc oneLoc) {
        this.gotoLonLat(oneLoc.m_lon, oneLoc.m_lat, oneLoc.zoom, oneLoc.isModeSat);
    }

    public static int xFromLon(float f) {
        float f2 = 1.6777216E7f * (f + 180.0f) / 180.0f;
        return (int)f2;
    }

    public static int yFromLat(float f) {
        if (f < -89.0f) {
            f = -89.0f;
        }
        if (f > 89.0f) {
            f = 89.0f;
        }
        double d = Math.sin(Math.toRadians(f));
        double d2 = -Float11.log((1.0 + d) / (1.0 - d)) / (Math.PI * 2);
        double d3 = (1.0 + d2) * 1.6777216E7;
        return (int)d3;
    }

    public void gotoLonLat(Float f, Float f2, int n, boolean bl) {
        float f3 = Float.parseFloat(f.toString());
        float f4 = Float.parseFloat(f2.toString());
        this.gotoLonLat(f3, f4, n, bl);
    }

    public void gotoLonLat(float f, float f2, int n, boolean bl) {
        if (UtilMidp.DEBUG) {
            System.out.println("Goto  lon:" + f + " lat:" + f2);
        }
        int n2 = this.f;
        int n3 = this.g;
        int n4 = 1 << n;
        this.f = MapCanvas.xFromLon(f);
        this.g = MapCanvas.yFromLat(f2);
        this.setZoom(n);
        this.m_modeSat = bl;
        if (Math.abs((n2 - this.f) / n4) > this.getWidth() || Math.abs((n3 - this.g) / n4) > this.d) {
            BufferImage.cleanBuffer();
        }
    }

    public float getLon() {
        return MapCanvas.convLon(this.f);
    }

    public static float convLon(int n) {
        double d = (float)n * 180.0f / 1.6777216E7f - 180.0f;
        return (float)d;
    }

    public float getLat() {
        return MapCanvas.convLat(this.g);
    }

    public static float convLat(int n) {
        double d = -5340353.715440872;
        double d2 = Float11.exp((double)((float)n - 1.6777216E7f) / d);
        d2 = Math.toDegrees(Float11.atan(d2) * 2.0 - 1.5707963267948966);
        return (float)d2;
    }

    public boolean selNext(int n) {
        if (this.listPlaces.size() != 0) {
            int n2 = 0;
            if (this.currentSel != null) {
                n2 = this.listPlaces.indexOf(this.currentSel) + n;
            }
            if (n2 >= this.listPlaces.size()) {
                n2 = 0;
            }
            if (n2 < 0) {
                n2 = this.listPlaces.size() - 1;
            }
            this.a((OneLoc)this.listPlaces.elementAt(n2));
            if (UtilMidp.DEBUG) {
                System.out.println("new pos:" + n2);
            }
            this.gotoLonLat(this.currentSel.m_lon, this.currentSel.m_lat, this.j, this.m_modeSat);
            this.wayPoint = this.currentSel;
            if (this.m_autoPositionningEnabeld) {
                this.m_autoTrack = false;
            }
            this.repaint();
            return true;
        }
        return false;
    }

    public void setInfoOnScreen(String string) {
        this.c = string;
        this.a(this.getGraphics(), this.c, 10 + this.a, this.d - 50, 0, 0xFFFFFF);
    }

    public int a(Graphics graphics, int n, String string, int n2, int n3) {
        int n4 = graphics.getFont().stringWidth(string) + 8;
        graphics.setColor(0);
        graphics.fillRoundRect(n2 -= n4 - 2, n3, n4, l, 6, 6);
        graphics.setColor(0xFFFFFF);
        graphics.drawRoundRect(n2, n3, n4, l, 6, 6);
        graphics.drawString(string, n2 + n4 / 2, n3, 17);
        this.a[n][0] = n2;
        this.a[n][1] = n4;
        return n4;
    }

    public void paintIcons(Graphics graphics) {
        int n;
        l = n = graphics.getFont().getHeight();
        int n2 = m = this.a + this.c - 4;
        int n3 = 4 + this.b;
        n2 -= this.a(graphics, 0, "X", n2, n3) + 4;
        n2 -= this.a(graphics, 1, "+", n2, n3) + 4;
        n2 -= this.a(graphics, 2, "-", n2, n3) + 4;
        n2 -= this.a(graphics, 3, this.m_modeSat ? "Map" : "Sat", n2, n3) + 4;
        n2 -= this.a(graphics, 4, ">", n2, n3) + 4;
    }

    public int b(int n, int n2) {
        if (n2 >= 4 && n2 <= 4 + l) {
            for (int i = 0; i < this.a.length; ++i) {
                if (n < this.a[i][0] || n > this.a[0][0] + this.a[0][1]) continue;
                return i;
            }
        }
        return -1;
    }

    public void pointerPressed(int n, int n2) {
        int n3 = this.b(n, n2);
        switch (n3) {
            case 0: {
                this.c = !this.c;
                this.setFullScreenMode(this.c);
                if (this.c) {
                    this.setInfoOnScreen("FullScreen");
                    break;
                }
                this.setInfoOnScreen("Normal");
                break;
            }
            case 1: {
                this.setInfoOnScreen("Zoom +");
                this.setZoom(this.j - 1);
                break;
            }
            case 2: {
                this.setInfoOnScreen("Zoom -");
                this.setZoom(this.j + 1);
                break;
            }
            case 3: {
                this.changeSatMode();
                break;
            }
            case 4: {
                this.keyPressedImpl(48);
            }
        }
        if (n3 == -1) {
            this.n = n;
            this.o = n2;
            OneLoc oneLoc = this.currentSel;
            this.a(this.getSelectedItem(null, this.f + (this.n - this.c / 2) * (1 << this.j), this.g + (this.o - this.d / 2) * (1 << this.j), this.j, 5, false));
            if (oneLoc == this.currentSel && this.a != null && this.currentSel != null) {
                this.a.oneLocationSelected(this, this.currentSel);
            }
        }
        this.repaint();
    }

    public void a() {
        if (this.f == this.p && this.g == this.q && this.r == this.j) {
            if (this.b != 0L && System.currentTimeMillis() - this.b > 3000L) {
                this.b = 0L;
                if (this.b != null && this.b.m_refreshType == 1) {
                    this.b.refreshTrack(this);
                }
            }
        } else {
            this.b = System.currentTimeMillis();
        }
        this.p = this.f;
        this.q = this.g;
        this.r = this.j;
    }

    public void a(OneLoc oneLoc) {
        if (oneLoc != this.currentSel) {
            if (oneLoc != null && this.b != null && this.b.listPlaces.contains(oneLoc)) {
                this.b.fireSelected(oneLoc);
            }
            this.currentSel = oneLoc;
        }
    }

    public void pointerDragged(int n, int n2) {
        if (UtilMidp.DEBUG) {
            System.out.println("dragged:" + n + " " + n2);
        }
        int n3 = n - this.n;
        int n4 = n2 - this.o;
        this.f -= n3 * (1 << this.j);
        this.g -= n4 * (1 << this.j);
        this.n = n;
        this.o = n2;
        this.repaint();
    }

    public void keyRepeated(int n) {
    }

    public void keyPressed(int n) {
        if (this.a == null || this.a.mapKeyPressed(this, n)) {
            this.keyPressedImpl(n);
        }
        super.keyPressed(n);
    }

    public void keyPressedImpl(int n) {
        int n2 = this.getGameAction(n);
        if (UtilMidp.DEBUG) {
            System.out.println("code :" + n + "(" + (char)n + ") action:" + n2);
        }
        int n3 = 1 << this.j;
        boolean bl = false;
        if (this.m_modeShortkey) {
            switch (n) {
                case 49: {
                    boolean bl2 = this.m_drawLon = !this.m_drawLon;
                    if (this.m_drawLon) {
                        this.setInfoOnScreen("Display Lat/Lon");
                    } else {
                        this.setInfoOnScreen("Hide Lat/Lon");
                    }
                    if (UtilMidp.DEBUG) {
                        BufferImage.dumpState();
                    }
                    bl = true;
                    break;
                }
                case 50: {
                    boolean bl3 = this.m_displaySize = !this.m_displaySize;
                    if (this.m_displaySize) {
                        this.setInfoOnScreen("Show scale bar");
                    } else {
                        this.setInfoOnScreen("Remove scale bar");
                    }
                    bl = true;
                    break;
                }
                case 51: {
                    this.m_autoTrack = !this.m_autoTrack;
                    break;
                }
                case 52: {
                    boolean bl4 = this.m_record = !this.m_record;
                    if (!this.m_record) {
                        this.saveRecords();
                        break;
                    }
                    this.a = Track.getTrack(null, "");
                    break;
                }
                case 53: {
                    if (!this.m_record) break;
                    this.m_pause = !this.m_pause;
                    break;
                }
                case 54: {
                    boolean bl5 = BufferImage.m_doNotUseNetwork = !BufferImage.m_doNotUseNetwork;
                    if (BufferImage.m_doNotUseNetwork) {
                        this.setInfoOnScreen("Network disabeld");
                        break;
                    }
                    this.setInfoOnScreen("Network enabeld");
                    break;
                }
                case 55: {
                    BufferImage.dumpState();
                }
            }
            this.m_modeShortkey = false;
            this.repaint();
            return;
        }
        switch (n) {
            case 48: 
            case 100: {
                this.setCurSat(this.getCurSat() + 1);
                switch (this.getCurSat()) {
                    case 0: {
                        this.setInfoOnScreen("Using Google data");
                        break;
                    }
                    case 1: {
                        this.setInfoOnScreen("Using VirtualEarth data");
                        break;
                    }
                    case 2: {
                        this.setInfoOnScreen("Using Ask.com data");
                        break;
                    }
                    case 3: {
                        this.setInfoOnScreen("Using Yahoo.com data");
                    }
                }
                this.b = false;
                bl = true;
                break;
            }
            case 45: 
            case 49: 
            case 117: {
                if (this.j < 17) {
                    if (this.b) {
                        ++this.s;
                        if (this.s == this.j) {
                            this.b = false;
                        }
                    } else {
                        this.setZoom(this.j + 1);
                    }
                    this.setInfoOnScreen("Zoom out...");
                }
                bl = true;
                break;
            }
            case 43: 
            case 51: 
            case 105: {
                if (this.j > -2) {
                    if (!this.b) {
                        this.t = this.c / 2;
                        this.u = this.d / 2;
                        this.s = this.j;
                    }
                    if (this.s > -2) {
                        --this.s;
                    }
                    this.b = true;
                    this.setInfoOnScreen("Zoom in...");
                }
                bl = true;
                break;
            }
            case 55: 
            case 111: {
                if (this.selNext(-1)) {
                    this.setInfoOnScreen("Sel previous element...");
                } else {
                    this.setInfoOnScreen("No element to select.");
                }
                bl = true;
                break;
            }
            case 57: 
            case 112: {
                if (this.selNext(1)) {
                    this.setInfoOnScreen("Sel next element...");
                } else {
                    this.setInfoOnScreen("No element to select.");
                }
                bl = true;
                break;
            }
            case 35: 
            case 113: {
                boolean bl6 = this.m_displaySize = !this.m_displaySize;
                if (this.m_displaySize) {
                    this.setInfoOnScreen("Show scale bar");
                } else {
                    this.setInfoOnScreen("Remove scale bar");
                }
                BufferImage.dumpState();
                bl = true;
                break;
            }
            case 42: 
            case 97: 
            case 109: {
                this.m_modeShortkey = !this.m_modeShortkey;
                break;
            }
            case 32: 
            case 53: {
                if (!this.b) {
                    this.changeSatMode();
                } else {
                    this.stopZooming();
                }
                bl = true;
            }
        }
        if (!bl) {
            if (!this.b) {
                switch (n2) {
                    case 2: {
                        this.f -= 20 * n3;
                        break;
                    }
                    case 5: {
                        this.f += 20 * n3;
                        break;
                    }
                    case 1: {
                        this.g -= 20 * n3;
                        break;
                    }
                    case 6: {
                        this.g += 20 * n3;
                        break;
                    }
                    case 8: {
                        if (this.a == null || this.currentSel == null) break;
                        this.a.oneLocationSelected(this, this.currentSel);
                    }
                }
            } else {
                switch (n2) {
                    case 2: {
                        this.t -= 4;
                        break;
                    }
                    case 5: {
                        this.t += 4;
                        break;
                    }
                    case 1: {
                        this.u -= 4;
                        break;
                    }
                    case 6: {
                        this.u += 4;
                        break;
                    }
                    case 8: {
                        this.stopZooming();
                    }
                }
            }
        }
        this.repaint();
    }

    public void stopZooming() {
        this.b = false;
        int n = 1 << this.j;
        this.f += (this.t - this.c / 2) * n;
        this.g += (this.u - this.d / 2) * n;
        this.setZoom(this.s);
    }

    public boolean changeSatMode() {
        this.m_modeSat = !this.m_modeSat;
        BufferImage.cleanBuffer();
        if (this.m_modeSat) {
            this.setInfoOnScreen("Switching to satellite mode");
        } else {
            this.setInfoOnScreen("Switching to map mode");
        }
        return this.m_modeSat;
    }

    public int getCurSat() {
        return k;
    }

    public void setCurSat(int n) {
        if ((n %= 4) != k) {
            k = n;
            BufferImage.cleanBuffer();
        }
    }

    public void setListener(MapCanvasListener mapCanvasListener) {
        this.a = mapCanvasListener;
    }

    public void iconDownloaded(OneLoc oneLoc) {
        this.repaint();
    }

    public void drawArrow(Graphics graphics, oneGPSPos oneGPSPos2, int n, int n2, int n3) {
        graphics.setColor(n3);
        if (oneGPSPos2.m_dir != Double.NaN) {
            graphics.fillTriangle(n, n2, n + oneGPSPos2.e, n2 + oneGPSPos2.f, n + oneGPSPos2.c, n2 + oneGPSPos2.d);
            graphics.fillTriangle(n, n2, n - oneGPSPos2.f, n2 + oneGPSPos2.e, n + oneGPSPos2.c, n2 + oneGPSPos2.d);
            graphics.setColor(0);
            graphics.drawLine(n, n2, n + oneGPSPos2.e, n2 + oneGPSPos2.f);
            graphics.drawLine(n, n2, n - oneGPSPos2.f, n2 + oneGPSPos2.e);
            graphics.drawLine(n + oneGPSPos2.c, n2 + oneGPSPos2.d, n - oneGPSPos2.f, n2 + oneGPSPos2.e);
            graphics.drawLine(n + oneGPSPos2.c, n2 + oneGPSPos2.d, n + oneGPSPos2.e, n2 + oneGPSPos2.f);
        } else {
            graphics.drawArc(n - 20, n2 - 20, 39, 39, 0, 360);
            graphics.drawArc(n - 20, n2 - 20, 40, 40, 0, 360);
        }
    }

    public void paintGPSPos(Graphics graphics, oneGPSPos oneGPSPos2, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 / 2 + (oneGPSPos2.a - n) / (1 << n5);
        int n7 = n4 / 2 + (oneGPSPos2.b - n2) / (1 << n5);
        graphics.setColor(0xFFFFFF);
        this.drawArrow(graphics, oneGPSPos2, n6 - 1, n7 + 2, 0);
        if (oneGPSPos2.isValid) {
            this.drawArrow(graphics, oneGPSPos2, n6, n7, 65280);
        } else {
            this.drawArrow(graphics, oneGPSPos2, n6, n7, 0x808080);
            this.a(graphics, "No valid positionning data", 10, 10, 0xFF0000, 0xFFFFFF);
        }
        if (oneGPSPos2.speed != Double.NaN) {
            String string = Integer.toString((int)oneGPSPos2.speed);
            graphics.setColor(0);
            Font font = graphics.getFont();
            graphics.setFont(b);
            graphics.drawString(string, this.c, this.d / 2, 72);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(a);
            graphics.drawString(string, this.c - 1, this.d / 2 + 1, 72);
            graphics.setFont(font);
        }
    }

    public void setLoc(oneGPSPos oneGPSPos2) {
        this.m_lastLocation = oneGPSPos2;
        if (oneGPSPos2.isValid) {
            if (this.m_gpsSegments == null) {
                this.m_gpsSegments = new int[200];
                this.m_gpsSegments[0] = -1;
                this.e = 0;
            }
            if (this.e >= 100) {
                System.arraycopy(this.m_gpsSegments, 2, this.m_gpsSegments, 0, 198);
                --this.e;
            }
            this.m_gpsSegments[this.e * 2] = oneGPSPos2.b;
            this.m_gpsSegments[this.e * 2 + 1] = oneGPSPos2.a;
            if (this.e + 1 < 100) {
                this.m_gpsSegments[(this.e + 1) * 2] = -1;
            }
            if (this.m_record && !this.m_pause) {
                this.a.addRecord(oneGPSPos2);
            }
        }
        if (oneGPSPos2.stamp - this.a > 1000L) {
            this.a = oneGPSPos2.stamp;
            ++this.e;
        }
        if (this.m_autoTrack) {
            this.gotoLonLat((float)oneGPSPos2.m_lon, (float)oneGPSPos2.m_lat, this.j, this.m_modeSat);
        }
        this.repaint();
    }

    public void saveRecords() {
        this.setInfoOnScreen("Saving " + Track.currRecord + " datas...");
        this.a.saveTrack();
    }

    public void imageLoaded(BufferImage bufferImage) {
        this.repaint();
    }

    public void displayTrack(Track track, boolean bl) {
        this.clear();
        if (this.b != track && track.m_refreshType != 0) {
            track.refreshTrack(this);
        }
        this.m_segments = track.getTrack();
        this.listPlaces = track.getWaypoints();
        this.m_moreInfo = track.m_name;
        this.b = track;
        if (bl) {
            this.recenterMapAroundSel();
        } else {
            this.repaint();
        }
    }

    public boolean isTrackDisplayed(Track track) {
        return this.b == track;
    }

    public void removeTrack(Track track) {
        this.clear();
    }

    public String locateURL(String string) {
        float f;
        string = UtilMidp.strReplace(string, "!lat!", this.getLat());
        string = UtilMidp.strReplace(string, "!lon!", this.getLon());
        int n = this.getLonPx();
        int n2 = this.getLatPy();
        int n3 = this.c * (1 << this.getZoom()) * 9 / 10;
        int n4 = this.d * (1 << this.getZoom()) * 9 / 10;
        float f2 = MapCanvas.convLat(n2 - n4 / 2);
        if (f2 > (f = MapCanvas.convLat(n2 + n4 / 2))) {
            float f3 = f2;
            f2 = f;
            f = f3;
        }
        string = UtilMidp.strReplace(string, "!minlon!", MapCanvas.convLon(n - n3 / 2));
        string = UtilMidp.strReplace(string, "!minlat!", f2);
        string = UtilMidp.strReplace(string, "!maxlon!", MapCanvas.convLon(n + n3 / 2));
        string = UtilMidp.strReplace(string, "!maxlat!", f);
        string = UtilMidp.strReplace(string, "!zoom!", 17 - this.j);
        string = UtilMidp.strReplace(string, "[bboxWest]", MapCanvas.convLon(n - n3 / 2));
        string = UtilMidp.strReplace(string, "[bboxSouth]", f2);
        string = UtilMidp.strReplace(string, "[bboxEast]", MapCanvas.convLon(n + n3 / 2));
        string = UtilMidp.strReplace(string, "[bboxNorth]", f);
        string = UtilMidp.strReplace(string, "[lookatLon]", this.getLon());
        string = UtilMidp.strReplace(string, "[lookatLat]", this.getLat());
        string = UtilMidp.strReplace(string, "[lookatTilt]", "0.0");
        string = UtilMidp.strReplace(string, "[lookatHeading]", "0.0");
        string = UtilMidp.strReplace(string, "[lookatRange]", 2000 * (1 << this.j));
        return string;
    }

    static {
        m_state = 0;
        b = new String[]{"Google", "MSN", "Ask.com", "Yahoo"};
        l = 20;
        m = 30;
    }
}

