/*
 * Decompiled with CFR 0.152.
 */
package trezor;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import trezor.CryptMgr;

public class TwofishCryptMgr
implements CryptMgr {
    BufferedBlockCipher engine;
    KeyParameter key;

    public void initialize(String string) {
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(n + 20);
            ++n;
        }
        byte[] byArray2 = string.getBytes();
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] + byArray2[n3]);
            n2 = (n2 + 1) % 16;
            ++n3;
        }
        this.key = new KeyParameter(byArray);
        this.engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
    }

    public byte[] encrypt(byte[] byArray) {
        this.engine.init(true, this.key);
        return this.doCipher(byArray);
    }

    public byte[] decrypt(byte[] byArray) {
        this.engine.init(false, this.key);
        return this.doCipher(byArray);
    }

    private byte[] doCipher(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getOutputSize(byArray.length)];
        int n = this.engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        try {
            this.engine.doFinal(byArray2, n);
        }
        catch (CryptoException cryptoException) {
            cryptoException.printStackTrace();
            return null;
        }
        return byArray2;
    }
}

