/*
 * Decompiled with CFR 0.152.
 */
package com.anyEase.ScreenSaver;

import com.anyEase.ScreenSaver.Block;
import com.anyEase.ScreenSaver.BounceText;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class TextMain
extends Canvas
implements CommandListener,
Runnable {
    final byte NOSHOW;
    final byte SHOWTEXT;
    final byte SHOWDATE = (byte)2;
    final byte SHOWTIME = (byte)3;
    BounceText text;
    Command cmdExit;
    Command cmdAbout;
    Command cmdHelp;
    Command cmdRestart;
    Command cmdSpeed;
    Command[] cmdEdit;
    Command cmdTZone;
    Command cmdBack;
    int nWidth;
    int nHeight;
    int speed = 50;
    int numBlocks = 3;
    boolean bPause;
    boolean bRun = true;
    Thread thread;
    Image imgBack;
    Graphics graphBack;
    int nType = 0;
    Form form;
    TextField textfield;
    ChoiceGroup choice;
    Gauge gauge;
    long offset;
    int num;
    Block[] block;

    public TextMain(BounceText bounceText) {
        this.NOSHOW = 0;
        this.SHOWTEXT = 1;
        this.text = bounceText;
        this.cmdExit = new Command("Exit", 7, 0);
        this.cmdAbout = new Command("About", 1, 1);
        this.cmdHelp = new Command("Help", 1, 2);
        this.cmdRestart = new Command("Restart", 1, 3);
        this.cmdTZone = new Command("Time Different", 1, 4);
        this.cmdSpeed = new Command("Speed", 1, 5);
        this.cmdBack = new Command("Back", 2, 1);
        this.addCommand(this.cmdExit);
        this.addCommand(this.cmdAbout);
        this.addCommand(this.cmdHelp);
        this.addCommand(this.cmdRestart);
        this.cmdEdit = new Command[3];
        int n = 0;
        while (n < this.cmdEdit.length) {
            this.cmdEdit[n] = new Command("Edit Text " + (n + 1), 1, 3);
            this.addCommand(this.cmdEdit[n]);
            ++n;
        }
        this.addCommand(this.cmdTZone);
        this.addCommand(this.cmdSpeed);
        this.setCommandListener(this);
        this.nWidth = this.getWidth();
        this.nHeight = this.getHeight();
        this.imgBack = Image.createImage((int)this.nWidth, (int)this.nHeight);
        this.graphBack = this.imgBack.getGraphics();
        this.block = new Block[this.numBlocks];
        this.init();
        this.thread = new Thread(this);
        this.thread.start();
        this.getTime((byte)1);
    }

    public String addZeroForSmall(int n) {
        if (n < 10) {
            return "0" + Integer.toString(n);
        }
        return Integer.toString(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable.getClass().isInstance(this.form)) {
            if (command == this.cmdBack) {
                switch (this.nType) {
                    case 4: {
                        this.setTimeDiff(this.textfield.getString());
                        break;
                    }
                    case 5: {
                        this.speed = (11 - this.gauge.getValue()) * 10;
                        if (this.speed > 100) {
                            this.speed = 100;
                        }
                        this.save((byte)8);
                        break;
                    }
                    case 6: {
                        this.block[this.nType - 6].setType((byte)this.choice.getSelectedIndex());
                        this.block[this.nType - 6].setLabel(this.textfield.getString());
                        this.save((byte)1);
                        this.save((byte)2);
                        break;
                    }
                    case 7: {
                        this.block[this.nType - 6].setType((byte)this.choice.getSelectedIndex());
                        this.block[this.nType - 6].setLabel(this.textfield.getString());
                        this.save((byte)3);
                        this.save((byte)4);
                        break;
                    }
                    case 8: {
                        this.block[this.nType - 6].setType((byte)this.choice.getSelectedIndex());
                        this.block[this.nType - 6].setLabel(this.textfield.getString());
                        this.save((byte)5);
                        this.save((byte)6);
                        break;
                    }
                }
                this.form = null;
                this.textfield = null;
                this.choice = null;
                this.gauge = null;
                Display.getDisplay((MIDlet)this.text).setCurrent((Displayable)this);
            }
        } else if (command == this.cmdExit) {
            this.bRun = false;
            this.text.destroyApp(false);
            this.text.notifyDestroyed();
        } else {
            if (command == this.cmdAbout) {
                this.nType = 1;
            } else if (command == this.cmdHelp) {
                this.nType = 2;
            } else if (command == this.cmdRestart) {
                this.nType = 3;
            } else if (command == this.cmdTZone) {
                this.nType = 4;
            } else if (command == this.cmdSpeed) {
                this.nType = 5;
            } else {
                int n = 0;
                while (n < this.cmdEdit.length) {
                    if (command == this.cmdEdit[n]) {
                        this.nType = 6 + n;
                    }
                    ++n;
                }
            }
            this.doSetup(this.nType);
        }
    }

    public void doSetup(int n) {
        if (n < 1 || n > 8) {
            return;
        }
        if (n == 3) {
            this.reset();
            return;
        }
        this.form = new Form("Setup");
        this.form.addCommand(this.cmdBack);
        this.form.setCommandListener((CommandListener)this);
        if (n == 1) {
            this.form.setTitle("About");
            this.form.append("BounceText is a screen savers for java enabled mobile phone.\rIf you have any contents and questions,please contact support@anyease.com.\rWelcome visit www.anyease.com for more information about it and the other software.\rCopyright anyEase 2002.");
        } else if (n == 2) {
            this.form.setTitle("Help");
            this.form.append("You can input different content for each text and decide which text show what content.\r You can set the speed of run and the time different when you show time.");
        } else if (n == 4) {
            this.textfield = new TextField("Time difference:", Long.toString(this.offset / 3600000L), 3, 0);
            this.form.append((Item)this.textfield);
        } else if (n == 5) {
            this.gauge = new Gauge("Speed:", true, 10, 11 - this.speed / 10);
            this.form.append((Item)this.gauge);
        } else if (n == 6 || n == 7 || n == 8) {
            this.textfield = new TextField("Private Content:", this.block[n - 6].getLabel(), 10, 0);
            this.form.append((Item)this.textfield);
            this.choice = new ChoiceGroup("Show setting:", 1);
            this.choice.append("Don't Show", null);
            this.choice.append("Private Content", null);
            this.choice.append("Show Date", null);
            this.choice.append("Show Time", null);
            this.choice.setSelectedIndex((int)this.block[n - 6].getType(), true);
            this.form.append((Item)this.choice);
        }
        Display.getDisplay((MIDlet)this.text).setCurrent((Displayable)this.form);
    }

    public String getTime(byte by) {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        date.setTime(this.offset + date.getTime());
        calendar.setTime(date);
        if (by == 2) {
            string = String.valueOf(this.addZeroForSmall(calendar.get(2))) + "/" + this.addZeroForSmall(calendar.get(5)) + " " + this.getWeekString(calendar.get(7));
        } else if (by == 3) {
            string = String.valueOf(this.addZeroForSmall(calendar.get(11))) + ":" + this.addZeroForSmall(calendar.get(12)) + ":" + this.addZeroForSmall(calendar.get(13));
        }
        return string;
    }

    public String getWeekString(int n) {
        String string = "";
        switch (n) {
            case 2: {
                string = "Mon";
                break;
            }
            case 3: {
                string = "Tue";
                break;
            }
            case 5: {
                string = "Thu";
                break;
            }
            case 4: {
                string = "Wed";
                break;
            }
            case 6: {
                string = "Fri";
                break;
            }
            case 7: {
                string = "Sat";
                break;
            }
            case 1: {
                string = "Sun";
                break;
            }
        }
        return string;
    }

    public void init() {
        Random random = new Random();
        int[] nArray = new int[4];
        int n = 0;
        while (n < this.numBlocks) {
            nArray[0] = Math.abs(random.nextInt() % (this.nWidth / 2));
            nArray[1] = Math.abs(random.nextInt() % (this.nHeight / 2));
            nArray[2] = random.nextInt();
            nArray[3] = random.nextInt();
            this.block[n] = new Block("Text " + (n + 1), this.nWidth, this.nHeight);
            this.block[n].init(nArray[0], nArray[1], nArray[2], nArray[3]);
            ++n;
        }
        this.read();
        nArray = null;
    }

    public void paint(Graphics graphics) {
        this.graphBack.setColor(0);
        this.graphBack.fillRect(0, 0, this.nWidth, this.nHeight);
        int n = 0;
        while (n < this.numBlocks) {
            byte by = this.block[n].getType();
            if (by != 0) {
                if (by == 2 || by == 3) {
                    this.block[n].setLabel(this.getTime(by));
                }
                this.block[n].move();
                this.block[n].paint(this.graphBack);
            }
            ++n;
        }
        if (this.num > 6000) {
            this.graphBack.setColor(0);
            this.graphBack.fillRect(0, 0, this.nWidth, this.nHeight);
            this.graphBack.setColor(255, 255, 255);
            this.graphBack.setFont(Font.getFont((int)0, (int)0, (int)8));
            this.graphBack.drawString("Demo Version", 2, 2, 20);
            this.graphBack.drawString("Play again!", 2, 12, 20);
            this.graphBack.drawString("www.anyEase.com", 2, 22, 20);
            this.graphBack.drawString("Buy it from anyEase", 2, 32, 20);
            this.graphBack.drawString("or from Handango.", 2, 42, 20);
        } else {
            ++this.num;
        }
        graphics.drawImage(this.imgBack, 0, 0, 20);
    }

    public void read() {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)"com.anyEase.ScreenSaver.Text", (boolean)false);
                recordEnumeration = recordStore.enumerateRecords(null, null, false);
                int n = 8;
                while (recordEnumeration.hasNextElement()) {
                    byte[] byArray = recordEnumeration.nextRecord();
                    switch (n) {
                        case 1: {
                            this.block[0].setLabel(new String(byArray));
                            break;
                        }
                        case 2: {
                            this.block[0].setType(Byte.parseByte(new String(byArray)));
                            break;
                        }
                        case 3: {
                            this.block[1].setLabel(new String(byArray));
                            break;
                        }
                        case 4: {
                            this.block[1].setType(Byte.parseByte(new String(byArray)));
                            break;
                        }
                        case 5: {
                            this.block[2].setLabel(new String(byArray));
                            break;
                        }
                        case 6: {
                            this.block[2].setType(Byte.parseByte(new String(byArray)));
                            break;
                        }
                        case 7: {
                            this.offset = Long.parseLong(new String(byArray));
                            break;
                        }
                        case 8: {
                            this.speed = Integer.parseInt(new String(byArray));
                            break;
                        }
                    }
                    --n;
                }
                recordEnumeration.destroy();
                recordStore.closeRecordStore();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                try {
                    recordStore = RecordStore.openRecordStore((String)"com.anyEase.ScreenSaver.Text", (boolean)true);
                    byte[] byArray = null;
                    byArray = this.block[0].getLabel().getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = Integer.toString(this.block[0].getType()).getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = this.block[1].getLabel().getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = Integer.toString(this.block[1].getType()).getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = this.block[2].getLabel().getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = Integer.toString(this.block[2].getType()).getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = Long.toString(this.offset).getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = Integer.toString(this.speed).getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    byArray = null;
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                System.out.println("Other exception in read() : " + exception.getMessage());
            }
        }
        finally {
            recordEnumeration = null;
            recordStore = null;
        }
    }

    public void reset() {
        Random random = new Random();
        int[] nArray = new int[4];
        int n = 0;
        while (n < this.numBlocks) {
            nArray[0] = Math.abs(random.nextInt() % (this.nWidth / 2));
            nArray[1] = Math.abs(random.nextInt() % (this.nHeight / 2));
            nArray[2] = random.nextInt();
            nArray[3] = random.nextInt();
            this.block[n].init(nArray[0], nArray[1], nArray[2], nArray[3]);
            ++n;
        }
        nArray = null;
    }

    public void run() {
        while (this.bRun) {
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            this.repaint();
        }
    }

    public void save(byte by) {
        RecordStore recordStore = null;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)"com.anyEase.ScreenSaver.Text", (boolean)false);
                byte[] byArray = null;
                switch (by) {
                    case 1: {
                        byArray = this.block[0].getLabel().getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 2: {
                        byArray = Integer.toString(this.block[0].getType()).getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 3: {
                        byArray = this.block[1].getLabel().getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 4: {
                        byArray = Integer.toString(this.block[1].getType()).getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 5: {
                        byArray = this.block[2].getLabel().getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 6: {
                        byArray = Integer.toString(this.block[2].getType()).getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 7: {
                        byArray = Long.toString(this.offset).getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                    case 8: {
                        byArray = Integer.toString(this.speed).getBytes();
                        recordStore.setRecord((int)by, byArray, 0, byArray.length);
                        break;
                    }
                }
                recordStore.closeRecordStore();
                byArray = null;
            }
            catch (Exception exception) {}
        }
        finally {
            recordStore = null;
        }
    }

    public void setTimeDiff(String string) {
        try {
            this.offset = Integer.parseInt(string) * 3600000;
            this.save((byte)7);
        }
        catch (Exception exception) {}
    }
}

