/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.Reader;

public class XMLScanner {
    static final int XML_IDENT = 0;
    static final int XML_VALUE = 1;
    static final int XML_LT = 2;
    static final int XML_GT = 3;
    static final int XML_LTS = 4;
    static final int XML_GTS = 5;
    static final int XML_EQ = 6;
    static final int XML_EOF = 7;
    Reader reader;
    int line;
    int column;
    char[] buf;
    int slen;
    String ident;
    boolean inTag;
    char[] inputBuf;
    int inputBufPos;
    int inputBufUsed;
    int pos;

    XMLScanner(Reader reader) {
        this.reader = reader;
        this.buf = new char[1024];
        this.inputBuf = new char[256];
        this.line = 1;
        this.column = 0;
    }

    static final char hexDigit(int n) {
        int n2 = n & 0xF;
        return (char)(n2 <= 9 ? n2 + 48 : n2 - 10 + 65);
    }

    final int get() {
        char c;
        if (this.inputBufPos >= this.inputBufUsed) {
            try {
                while ((this.inputBufUsed = this.reader.read(this.inputBuf, 0, this.inputBuf.length)) == 0) {
                }
                this.pos += this.inputBufUsed;
            }
            catch (IOException iOException) {
                throw new XMLException(this.line, this.column, iOException.getMessage());
            }
            this.inputBufPos = 0;
            if (this.inputBufUsed < 0) {
                return -1;
            }
        }
        if ((c = this.inputBuf[this.inputBufPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            this.column = c == '\t' ? (this.column += this.column + 8 & 0xFFFFFFF8) : ++this.column;
        }
        return c;
    }

    final void unget(int n) {
        if (n >= 0) {
            --this.inputBufPos;
            if (n == 10) {
                --this.line;
            } else {
                --this.column;
            }
        }
    }

    private final boolean isLetterOrDigit(int n) {
        return n >= 48 && n <= 57 || n >= 65;
    }

    private int decodeChar() {
        switch (this.get()) {
            case 97: {
                if (this.get() != 109 || this.get() != 112 || this.get() != 59) {
                    throw new XMLException(this.line, this.column, "Bad XML file format");
                }
                return 38;
            }
            case 108: {
                if (this.get() != 116 || this.get() != 59) {
                    throw new XMLException(this.line, this.column, "Bad XML file format");
                }
                return 60;
            }
            case 103: {
                if (this.get() != 116 || this.get() != 59) {
                    throw new XMLException(this.line, this.column, "Bad XML file format");
                }
                return 62;
            }
            case 113: {
                if (this.get() != 117 || this.get() != 111 || this.get() != 116 || this.get() != 59) {
                    throw new XMLException(this.line, this.column, "Bad XML file format");
                }
                return 34;
            }
        }
        throw new XMLException(this.line, this.column, "Bad XML file format");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int scan() {
        int n;
        int n2 = 0;
        block11: while (true) {
            if ((n = this.get()) < 0) {
                return 7;
            }
            if (n <= 32) continue;
            switch (n) {
                case 60: {
                    n = this.get();
                    if (n == 63) {
                        while ((n = this.get()) != 63) {
                            if (n >= 0) continue;
                            throw new XMLException(this.line, this.column, "'?' expected");
                        }
                        n = this.get();
                        if (n != 62) throw new XMLException(this.line, this.column, "'>' expected");
                        continue block11;
                    }
                    if (this.inTag) {
                        throw new XMLException(this.line, this.column, "Unexpected '<'");
                    }
                    this.inTag = true;
                    if (n == 47) return 4;
                    this.unget(n);
                    return 2;
                }
                case 62: {
                    if (!this.inTag) {
                        throw new XMLException(this.line, this.column, "Unexpected '>'");
                    }
                    this.inTag = false;
                    return 3;
                }
                case 47: {
                    if (!this.inTag) break block11;
                    if (this.get() != 62) {
                        throw new XMLException(this.line, this.column, "'>' expected");
                    }
                    this.inTag = false;
                    return 5;
                }
                case 61: {
                    if (!this.inTag) break block11;
                    return 6;
                }
                case 34: {
                    while (true) {
                        if ((n = this.get()) < 0) {
                            throw new XMLException(this.line, this.column, "Unclosed string");
                        }
                        if (n == 38) {
                            n = this.decodeChar();
                        } else if (n == 34) {
                            this.slen = n2;
                            return 1;
                        }
                        if (n2 == this.buf.length) {
                            char[] cArray = new char[this.buf.length * 2];
                            System.arraycopy(this.buf, 0, cArray, 0, n2);
                            this.buf = cArray;
                        }
                        this.buf[n2++] = (char)n;
                    }
                }
            }
            break;
        }
        if (this.inTag) {
            while (this.isLetterOrDigit(n) || n == 45 || n == 58 || n == 95 || n == 46) {
                if (n2 == this.buf.length) {
                    throw new XMLException(this.line, this.column, "Too long identifier");
                }
                this.buf[n2++] = (char)n;
                n = this.get();
            }
            this.unget(n);
            if (n2 == 0) {
                throw new XMLException(this.line, this.column, "Identifier expected");
            }
            this.slen = n2;
            this.ident = new String(this.buf, 0, n2);
            return 0;
        }
        while (n != 60) {
            switch (n) {
                case 62: {
                    throw new XMLException(this.line, this.column, "Unexpected '>'");
                }
                case 38: {
                    n = this.decodeChar();
                }
            }
            if (n2 == this.buf.length) {
                char[] cArray = new char[this.buf.length * 2];
                System.arraycopy(this.buf, 0, cArray, 0, n2);
                this.buf = cArray;
            }
            this.buf[n2++] = (char)n;
            n = this.get();
        }
        this.unget(n);
        this.slen = n2;
        return 1;
    }

    final String getIdentifier() {
        return this.ident;
    }

    final String getValue() {
        return new String(this.buf, 0, this.slen);
    }

    final int getLine() {
        return this.line;
    }

    final int getColumn() {
        return this.column;
    }
}

