/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class MapBrowser
extends MIDlet
implements Receiver {
    static final String STORE_NAME = "MAPBROWSER";
    static final String INDEX_FILE = "/index";
    static final String ENCODING = "UTF-8";
    static Command QUIT_CMD;
    static Command BACK_CMD;
    static Command SEARCH_CMD;
    static Command SELECT_CMD;
    static Command MAP_CMD;
    static Command INDEX_CMD;
    static Command ZOOM_IN_CMD;
    static Command ZOOM_OUT_CMD;
    static Command SETTINGS_CMD;
    static Command HELP_CMD;
    static Command ABOUT_CMD;
    static Command ALL_CMD;
    static Command NEXT_CMD;
    static Command INFO_CMD;
    static Command CLEAN_CMD;
    static Command SAVE_CMD;
    static Command LOAD_CMD;
    static final String DEFAULT_MAP_LOCATION = "www.garret.ru/~knizhnik/Moscow/";
    String url = "www.garret.ru/~knizhnik/Moscow/";
    String city;
    int width;
    int height;
    int zoom;
    int levels;
    int cell;
    RecordStore store;
    Settings settings;
    BrowserCanvas canvas;
    Form main;
    Vector indices;

    private void openStore() {
        block5: {
            try {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.settings = new Settings();
                try {
                    byte[] byArray = this.store.getRecord(1);
                    if (byArray.length == this.settings.pack().length) {
                        this.settings = new Settings(byArray);
                        break block5;
                    }
                    byArray = this.settings.pack();
                    this.store.setRecord(1, byArray, 0, byArray.length);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    byte[] byArray = this.settings.pack();
                    this.store.addRecord(byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to load settings: " + exception);
                this.settings = new Settings();
            }
        }
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void saveSettings() {
        try {
            byte[] byArray = this.settings.pack();
            this.store.setRecord(1, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setLocale() {
        Locale locale = new Locale(this.settings.locale);
        QUIT_CMD = new Command(locale.getResource("Quit"), 3, 3);
        BACK_CMD = new Command(locale.getResource("Back"), 2, 3);
        SEARCH_CMD = new Command(locale.getResource("Search"), 1, 3);
        SELECT_CMD = new Command(locale.getResource("Select"), 1, 1);
        MAP_CMD = new Command(locale.getResource("Map"), 1, 1);
        INDEX_CMD = new Command(locale.getResource("Index"), 1, 1);
        ZOOM_IN_CMD = new Command(locale.getResource("Zoom In"), 1, 2);
        ZOOM_OUT_CMD = new Command(locale.getResource("Zoom Out"), 1, 2);
        SETTINGS_CMD = new Command(locale.getResource("Settings"), 1, 7);
        HELP_CMD = new Command(locale.getResource("Help"), 5, 8);
        ABOUT_CMD = new Command(locale.getResource("About"), 1, 9);
        ALL_CMD = new Command(locale.getResource("Select All"), 1, 2);
        NEXT_CMD = new Command(locale.getResource("Next"), 1, 4);
        INFO_CMD = new Command(locale.getResource("Info"), 1, 5);
        CLEAN_CMD = new Command(locale.getResource("Clean"), 1, 6);
        SAVE_CMD = new Command(locale.getResource("Save"), 1, 1);
        LOAD_CMD = new Command(locale.getResource("Load"), 1, 1);
    }

    public void failure(String string) {
        this.error(Locale.current.getResource("Connection Failed"), (Displayable)this.main);
    }

    void error(String string, final Displayable displayable) {
        Alert alert = new Alert(Locale.current.getResource("Error"));
        alert.setType(AlertType.ERROR);
        alert.setString(string);
        alert.setTimeout(-2);
        if ("Nokia6600".equals(System.getProperty("microedition.platform"))) {
            Display.getDisplay((MIDlet)this).setCurrent(displayable);
            Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
            alert.setCommandListener(new CommandListener(){

                public void commandAction(Command command, Displayable displayable2) {
                    Display.getDisplay((MIDlet)MapBrowser.this).setCurrent(displayable);
                }
            });
        } else {
            Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
        }
    }

    public void received(String string, byte[] byArray, int n) {
        XMLParser xMLParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
        if ("ru".equals(Locale.current.getLanguage())) {
            xMLParser = new XMLParser(new CyrillicWinReader(byteArrayInputStream));
        } else {
            try {
                xMLParser = new XMLParser(new SafeInputStreamReader(byteArrayInputStream, ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                xMLParser = new XMLParser(new InputStreamReader(byteArrayInputStream));
            }
        }
        this.indices = new Vector();
        xMLParser.parse(new XMLBuilder(){

            public XMLBuilder addElement(String string) {
                if (!string.equals("city")) {
                    throw new XMLException("<city> element expected");
                }
                return new XMLBuilder(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void addAttribute(String string, String string2) {
                        if ("name".equals(string)) {
                            2.access$000(this.this$1).city = string2.toLowerCase();
                        } else if ("cell".equals(string)) {
                            2.access$000(this.this$1).cell = Integer.parseInt(string2);
                        } else if ("width".equals(string)) {
                            2.access$000(this.this$1).width = Integer.parseInt(string2);
                        } else if ("height".equals(string)) {
                            2.access$000(this.this$1).height = Integer.parseInt(string2);
                        } else if ("levels".equals(string)) {
                            2.access$000(this.this$1).levels = Integer.parseInt(string2);
                        } else if ("zoom".equals(string)) {
                            2.access$000(this.this$1).zoom = Integer.parseInt(string2);
                        }
                    }

                    public XMLBuilder addElement(String string) {
                        if (!string.equals("index")) {
                            throw new XMLException("<index> element expected");
                        }
                        Index index = new Index();
                        2.access$000(this.this$1).indices.addElement(index);
                        return new IndexBuilder(index);
                    }
                };
            }

            static /* synthetic */ MapBrowser access$000(2 var0) {
                return var0.MapBrowser.this;
            }
        });
        this.showMap();
    }

    void showMap() {
        this.canvas = new BrowserCanvas(this);
    }

    protected void destroyApp(boolean bl) {
        this.closeStore();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        this.openStore();
        this.setLocale();
        this.main = new UrlForm(this);
    }

    void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }
}

