/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class IndexList
extends List
implements CommandListener {
    BrowserCanvas canvas;
    String prefix;
    Index index;
    Displayable parent;
    static final int MAX_LENGTH = 32;

    IndexList(BrowserCanvas browserCanvas, Index index, String string, Displayable displayable) {
        super(index.name, 3);
        this.canvas = browserCanvas;
        this.index = index;
        this.prefix = string;
        this.parent = displayable;
        for (int i = 0; i < index.objects.length; ++i) {
            if (!index.objects[i].name.toLowerCase().startsWith(string)) continue;
            this.append(index.objects[i].name, null);
        }
        if (this.size() == 0) {
            browserCanvas.browser.error(Locale.current.getResource("No items"), displayable);
        } else {
            this.addCommand(MapBrowser.SEARCH_CMD);
            this.addCommand(MapBrowser.SELECT_CMD);
            this.addCommand(MapBrowser.BACK_CMD);
            if (index.type == 1) {
                this.addCommand(MapBrowser.ALL_CMD);
            }
            this.setCommandListener(this);
            Display.getDisplay((MIDlet)browserCanvas.browser).setCurrent((Displayable)this);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MapBrowser.SEARCH_CMD) {
            new SearchForm(this.canvas, this.index, (Displayable)this);
        } else if (command == MapBrowser.ALL_CMD) {
            Location[] locationArray = new Location[this.size()];
            int n = 0;
            for (int i = 0; i < this.index.objects.length; ++i) {
                if (!this.index.objects[i].name.toLowerCase().startsWith(this.prefix)) continue;
                locationArray[n++] = this.index.objects[i];
            }
            this.canvas.setPositions(this.index, locationArray);
            Display.getDisplay((MIDlet)this.canvas.browser).setCurrent((Displayable)this.canvas);
        } else if (command != MapBrowser.BACK_CMD) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                int n2 = 0;
                while (!this.index.objects[n2].name.toLowerCase().startsWith(this.prefix) || --n >= 0) {
                    ++n2;
                }
                if (this.index.type == 0) {
                    new IndexList(this.canvas, (Index)this.index.objects[n2], "", (Displayable)this);
                } else if (this.index.objects[n2].info != null || this.index.objects[n2].image != null) {
                    new InfoForm(this.canvas, this.index, this.index.objects[n2], (Displayable)this);
                } else {
                    this.canvas.setPositions(this.index, new Location[]{this.index.objects[n2]});
                    Display.getDisplay((MIDlet)this.canvas.browser).setCurrent((Displayable)this.canvas);
                }
            }
        } else {
            Display.getDisplay((MIDlet)this.canvas.browser).setCurrent(this.parent);
        }
    }
}

