/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Econometer
extends MIDlet
implements CommandListener {
    public Vector purchases;
    public Vector shops;
    private List mainMenu;
    private RecordStore purchaseStore;
    private RecordStore shopStore;
    private Hashtable shopHash;
    static Command BACK_CMD;
    static Command ADD_CMD;
    static Command ENTER_CMD;
    static Command DELETE_CMD;
    static Command EDIT_CMD;
    static Command GRAPH_CMD;
    static Command SEARCH_CMD;
    static Command SELECT_CMD;
    static Command QUIT_CMD;
    static final int FRACTION = 100;
    static final int SETTINGS_RECORD_ID = 1;
    static final String PURCHASE_STORE_NAME = "Econometer.P004";
    static final String SHOP_STORE_NAME = "Econometer.S004";

    public Econometer() {
        String string = this.getAppProperty("Econometer.Locale");
        if (string == null) {
            string = System.getProperty("microedition.locale");
        }
        new Locale(string);
        BACK_CMD = new Command(Locale.current.back, 2, 1);
        SELECT_CMD = new Command(Locale.current.select, 8, 1);
        ENTER_CMD = new Command(Locale.current.enter, 4, 1);
        ADD_CMD = new Command(Locale.current.add, 4, 1);
        DELETE_CMD = new Command(Locale.current.delete, 8, 1);
        EDIT_CMD = new Command(Locale.current.update, 8, 1);
        GRAPH_CMD = new Command(Locale.current.graph, 1, 1);
        SEARCH_CMD = new Command(Locale.current.search, 1, 1);
        QUIT_CMD = new Command(Locale.current.quit, 2, 1);
        this.mainMenu = new List(Locale.current.title, 3, Locale.current.mainMenuItems, null);
        this.mainMenu.addCommand(SELECT_CMD);
        this.mainMenu.addCommand(QUIT_CMD);
    }

    protected void destroyApp(boolean bl) {
        this.closeStore();
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        if (this.purchaseStore == null) {
            this.openStore();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    private void openStore() {
        try {
            try {
                this.shopStore = RecordStore.openRecordStore((String)SHOP_STORE_NAME, (boolean)false);
                this.loadShopData();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.shopStore = RecordStore.openRecordStore((String)SHOP_STORE_NAME, (boolean)true);
                this.initializeShopData();
            }
        }
        catch (Exception exception) {
            this.criticalException(exception);
            return;
        }
        try {
            this.purchaseStore = RecordStore.openRecordStore((String)PURCHASE_STORE_NAME, (boolean)true);
        }
        catch (Exception exception) {
            this.criticalException(exception);
            return;
        }
        this.loadPurchaseData();
    }

    private void closeStore() {
        if (this.purchaseStore != null) {
            try {
                this.purchaseStore.closeRecordStore();
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
        if (this.shopStore != null) {
            try {
                this.shopStore.closeRecordStore();
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
    }

    private void initializeShopData() {
        Settings settings = new Settings(Locale.current.defaultCurrency, 0);
        byte[] byArray = settings.pack();
        try {
            this.shopStore.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
            return;
        }
        this.shops = new Vector();
        for (int i = 0; i < Locale.current.shopNames.length; ++i) {
            Shop shop = new Shop(Locale.current.shopNames[i]);
            this.storeShop(shop);
        }
    }

    private void loadShopData() {
        this.shops = new Vector();
        this.shopHash = new Hashtable();
        try {
            byte[] byArray = this.shopStore.getRecord(1);
            new Settings(byArray);
            int n = this.shopStore.getNextRecordID();
            for (int i = 2; i < n; ++i) {
                byArray = null;
                try {
                    byArray = this.shopStore.getRecord(i);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (byArray == null) continue;
                Shop shop = new Shop(i, byArray);
                this.shopHash.put(new Integer(i), shop);
                this.shops.addElement(shop);
            }
        }
        catch (Exception exception) {
            try {
                this.shopStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)SHOP_STORE_NAME);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.criticalException(exception);
        }
    }

    private void loadPurchaseData() {
        this.purchases = new Vector();
        try {
            int n = this.purchaseStore.getNextRecordID();
            for (int i = 1; i < n; ++i) {
                byte[] byArray = null;
                try {
                    byArray = this.purchaseStore.getRecord(i);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (byArray == null) continue;
                int n2 = Converter.unpackInt(byArray, 0);
                Shop shop = (Shop)this.shopHash.get(new Integer(n2));
                if (shop == null) {
                    this.criticalError("Shop not found");
                }
                this.purchases.addElement(new Purchase(i, byArray, shop));
            }
        }
        catch (Exception exception) {
            try {
                this.purchaseStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)PURCHASE_STORE_NAME);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.criticalException(exception);
        }
        this.shopHash = null;
        if (this.purchases.size() == 0 && "True".equals(this.getAppProperty("Econometer.TestData"))) {
            Calendar calendar = DateTime.calendar;
            Random random = new Random(2003L);
            int n = 1;
            int n3 = 0;
            int n4 = 1;
            while (true) {
                Purchase purchase = new Purchase("Purchase " + n4, ((random.nextInt() & 0xFFF) + 1) * 100, (Shop)this.shops.elementAt(random.nextInt() & 3));
                calendar.setTime(new Date(purchase.timestamp));
                if (calendar.get(2) == n3 && n > calendar.get(5) || calendar.get(2) < n3) break;
                calendar.set(2, n3);
                calendar.set(5, n);
                if ((n += random.nextInt() & 3) > 29) {
                    n %= 29;
                    ++n3;
                }
                purchase.timestamp = calendar.getTime().getTime();
                this.storePurchase(purchase);
                ++n4;
            }
        }
    }

    void saveSettings() {
        try {
            byte[] byArray = Settings.instance.pack();
            this.shopStore.setRecord(1, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    void storePurchase(Purchase purchase) {
        try {
            byte[] byArray = purchase.pack();
            purchase.recordId = this.purchaseStore.addRecord(byArray, 0, byArray.length);
            this.purchases.addElement(purchase);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    void storeShop(Shop shop) {
        try {
            byte[] byArray = shop.pack();
            shop.recordId = this.shopStore.addRecord(byArray, 0, byArray.length);
            this.shops.addElement(shop);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    void removePurchase(Purchase purchase, int n) {
        if (purchase.shop != null) {
            --purchase.shop.nPurchases;
        }
        try {
            this.purchaseStore.deleteRecord(purchase.recordId);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        this.purchases.removeElementAt(n);
    }

    void removeShop(Shop shop, int n) {
        try {
            this.shopStore.deleteRecord(shop.recordId);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        this.shops.removeElementAt(n);
    }

    void updatePurchase(Purchase purchase) {
        try {
            byte[] byArray = purchase.pack();
            this.purchaseStore.setRecord(purchase.recordId, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    void updateShop(Shop shop) {
        try {
            byte[] byArray = shop.pack();
            this.shopStore.setRecord(shop.recordId, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    void truncate(Date date) {
        long l = date.getTime();
        int n = this.purchases.size();
        while (--n >= 0) {
            Purchase purchase = (Purchase)this.purchases.elementAt(0);
            if (purchase.timestamp >= l) continue;
            this.removePurchase(purchase, 0);
        }
    }

    private void criticalException(Exception exception) {
        exception.printStackTrace();
        this.criticalError(exception.toString());
    }

    private void criticalError(String string) {
        System.err.println(string);
        this.showAlert(AlertType.ERROR, Locale.current.error, string, null);
    }

    void showAlert(AlertType alertType, String string, String string2, Displayable displayable) {
        Alert alert = new Alert(string);
        alert.setType(alertType);
        alert.setString(string2);
        alert.setTimeout(-2);
        if (displayable != null) {
            Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
        } else {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        }
    }

    String analyze(Shop shop) {
        Purchase purchase;
        long l = 0L;
        long l2 = 0L;
        int n = this.purchases.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Purchase purchase2 = (Purchase)this.purchases.elementAt(i);
            if (shop != null && shop != purchase2.shop) continue;
            if (purchase2.price > l2) {
                l2 = purchase2.price;
            }
            l += purchase2.price;
            ++n2;
        }
        long l3 = System.currentTimeMillis();
        DateTime dateTime = new DateTime(l3);
        long l4 = 0L;
        long l5 = 0L;
        int n3 = n;
        while (--n3 >= 0) {
            Purchase purchase3 = (Purchase)this.purchases.elementAt(n3);
            DateTime dateTime2 = purchase3.getDateTime();
            if (dateTime2.month != dateTime.month || dateTime2.year != dateTime.year) break;
            if (shop != null && shop != purchase3.shop) continue;
            l5 += purchase3.price;
        }
        long l6 = dateTime.getWeekStart();
        int n4 = n;
        while (--n4 >= 0) {
            purchase = (Purchase)this.purchases.elementAt(n4);
            if (purchase.timestamp < l6) break;
            if (shop != null && shop != purchase.shop) continue;
            l4 += purchase.price;
        }
        Purchase purchase4 = (Purchase)this.purchases.elementAt(0);
        purchase = (Purchase)this.purchases.elementAt(this.purchases.size() - 1);
        long l7 = (purchase.timestamp - purchase4.timestamp) / 86400000L + 1L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Locale.current.totalExpenses);
        purchase4.getDateTime().getDate(stringBuffer);
        stringBuffer.append('-');
        purchase.getDateTime().getDate(stringBuffer);
        stringBuffer.append(": ");
        Purchase.printPriceWithCurrency(l, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.averageMonthExpenses);
        Purchase.printPriceWithCurrency(l * 30L / l7, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.averageWeekExpenses);
        Purchase.printPriceWithCurrency(l * 7L / l7, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.lastMonthExpenses);
        Purchase.printPriceWithCurrency(l5, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.lastWeekExpenses);
        Purchase.printPriceWithCurrency(l4, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.mostExpensivePurchase);
        Purchase.printPriceWithCurrency(l2, stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append(Locale.current.everagePurchase);
        Purchase.printPriceWithCurrency(l / (long)n2, stringBuffer);
        return stringBuffer.toString();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            switch (this.mainMenu.getSelectedIndex()) {
                case 0: {
                    new ShopList(this, (Displayable)this.mainMenu);
                    break;
                }
                case 1: {
                    new WeekList(this, (Displayable)this.mainMenu, null);
                    break;
                }
                case 2: {
                    new MonthList(this, (Displayable)this.mainMenu, null);
                    break;
                }
                case 3: {
                    if (this.purchases.size() == 0) {
                        this.showAlert(AlertType.WARNING, Locale.current.error, Locale.current.noData, (Displayable)this.mainMenu);
                        break;
                    }
                    this.showAlert(AlertType.INFO, Locale.current.analysis, this.analyze(null), (Displayable)this.mainMenu);
                    break;
                }
                case 4: {
                    new SearchBox(this, (Displayable)this.mainMenu, null);
                    break;
                }
                case 5: {
                    new SettingsForm(this, (Displayable)this.mainMenu);
                }
            }
        }
    }
}

