/*
 * Decompiled with CFR 0.152.
 */
package Notepad;

import Notepad.NoteInfo;
import Notepad.SVC;
import javax.microedition.rms.RecordStore;

class Note {
    NoteInfo model = new NoteInfo();

    public void setFromBytes(byte[] parentID, byte[] name, byte[] content, byte[] created, byte[] modified) {
        if (content == null) {
            String s = " ";
            content = s.getBytes();
        }
        this.set(new String(parentID), new String(name), new String(content), new String(created), new String(modified));
    }

    public void set(String parentID, String name, String content, String created, String modified) {
        this.model.ParentID = parentID;
        this.model.Name = name;
        this.model.Content = content;
        this.model.CreatedDate = created;
        this.model.ModifiedDate = modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNoteData(String rsName) {
        RecordStore myRec = null;
        try {
            myRec = RecordStore.openRecordStore((String)rsName, (boolean)false);
            this.setFromBytes(myRec.getRecord(SVC.INDEX_PARENT_ID), myRec.getRecord(SVC.INDEX_RECORD_NAME), myRec.getRecord(SVC.INDEX_CONTENT), myRec.getRecord(SVC.INDEX_CREATED), myRec.getRecord(SVC.INDEX_MODIFIED));
        }
        catch (Exception exception) {
        }
        finally {
            SVC.sReleaseRS(myRec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String AddNew(NoteInfo model) {
        RecordStore myRecChild = null;
        byte[] arrBytes = null;
        boolean res = false;
        String newNoteID = null;
        try {
            newNoteID = new Character(SVC.PREFIX_NOTE).toString() + model.Name + SVC.sGetANewID();
            String currentTime = SVC.sGetCurrentDateTimeString();
            myRecChild = RecordStore.openRecordStore((String)newNoteID, (boolean)true);
            arrBytes = model.ParentID.getBytes();
            myRecChild.addRecord(arrBytes, 0, arrBytes.length);
            arrBytes = model.Name.getBytes();
            myRecChild.addRecord(arrBytes, 0, arrBytes.length);
            if (model.Content == "" || model.Content == null) {
                model.Content = ".";
            }
            arrBytes = model.Content.getBytes();
            myRecChild.addRecord(arrBytes, 0, arrBytes.length);
            arrBytes = currentTime.getBytes();
            myRecChild.addRecord(arrBytes, 0, arrBytes.length);
            arrBytes = currentTime.getBytes();
            myRecChild.addRecord(arrBytes, 0, arrBytes.length);
        }
        catch (Exception ex) {
            SVC.sReleaseRS(myRecChild);
            return newNoteID;
            catch (Throwable throwable) {
                SVC.sReleaseRS(myRecChild);
                return newNoteID;
            }
        }
        SVC.sReleaseRS(myRecChild);
        return newNoteID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void UpdateBy(String noteID, NoteInfo model) {
        RecordStore myRecChild = null;
        byte[] arrBytes = null;
        boolean res = false;
        try {
            String currentTime = SVC.sGetCurrentDateTimeString();
            myRecChild = RecordStore.openRecordStore((String)noteID, (boolean)true);
            if (model.ParentID != "") {
                arrBytes = model.ParentID.getBytes();
                myRecChild.setRecord(SVC.INDEX_PARENT_ID, arrBytes, 0, arrBytes.length);
            }
            if (model.Name != "") {
                arrBytes = model.Name.getBytes();
                myRecChild.setRecord(SVC.INDEX_RECORD_NAME, arrBytes, 0, arrBytes.length);
            }
            if (model.Content != "") {
                arrBytes = model.Content.getBytes();
                myRecChild.setRecord(SVC.INDEX_CONTENT, arrBytes, 0, arrBytes.length);
            }
            arrBytes = currentTime.getBytes();
            myRecChild.setRecord(SVC.INDEX_MODIFIED, arrBytes, 0, arrBytes.length);
        }
        catch (Exception ex) {
            SVC.sReleaseRS(myRecChild);
            catch (Throwable throwable) {
                SVC.sReleaseRS(myRecChild);
                throw throwable;
            }
        }
        SVC.sReleaseRS(myRecChild);
    }

    public boolean DeleteBy(String noteID) {
        return SVC.sDeleteRecordStore(noteID);
    }
}

