/*
 * Decompiled with CFR 0.152.
 */
package trezor;

import java.util.Enumeration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import trezor.ChangeEntryForm;
import trezor.CreateEntryForm;
import trezor.DeleteEntryForm;
import trezor.Entry;
import trezor.EntryMgr;
import trezor.ShowEntryDetailForm;
import trezor.trezor;

public class EntryList
extends List
implements CommandListener {
    private EntryMgr entryMgr;
    private trezor app;
    Command showCommand = new Command("Zobrazit", 1, 1);
    Command createCommand = new Command("Nov\u00fd Z\u00e1znam", 1, 1);
    Command changeCommand = new Command("Zm\u011bnit Z\u00e1znam", 1, 1);
    Command deleteCommand = new Command("Odstranit Z\u00e1znam", 1, 1);

    public EntryList(trezor trezor2) {
        super("Z\u00e1znamy", 3);
        this.entryMgr = trezor2.entryMgr;
        this.app = trezor2;
        this.addCommand(trezor2.exitCommand);
        this.addCommand(this.createCommand);
        this.addCommand(this.changeCommand);
        this.addCommand(this.deleteCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.createCommand) {
            CreateEntryForm createEntryForm = new CreateEntryForm(this.app);
            this.app.getDisplay().setCurrent((Displayable)createEntryForm);
        } else if (command == this.changeCommand) {
            Entry entry = this.getSelectedEntry();
            if (entry == null) {
                return;
            }
            ChangeEntryForm changeEntryForm = new ChangeEntryForm(this.app, entry);
            this.app.getDisplay().setCurrent((Displayable)changeEntryForm);
        } else if (command == this.deleteCommand) {
            Entry entry = this.getSelectedEntry();
            if (entry == null) {
                return;
            }
            DeleteEntryForm deleteEntryForm = new DeleteEntryForm(this.app, entry);
            this.app.getDisplay().setCurrent((Displayable)deleteEntryForm);
        } else if (command == this.showCommand || command == List.SELECT_COMMAND) {
            Entry entry = this.getSelectedEntry();
            if (entry == null) {
                return;
            }
            ShowEntryDetailForm showEntryDetailForm = new ShowEntryDetailForm(this.app, entry);
            this.app.getDisplay().setCurrent((Displayable)showEntryDetailForm);
        } else {
            this.app.commandAction(command, displayable);
        }
    }

    public void initialize() {
        Enumeration enumeration = this.entryMgr.getEntries().elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            super.append(entry.getLabel(), null);
        }
    }

    public void deleteAll() {
        this.entryMgr.deleteAll();
        while (super.size() > 0) {
            super.delete(0);
        }
    }

    public void createEntry(String string, String string2) {
        this.entryMgr.createEntry(string, string2);
        this.append(string, null);
    }

    public void deleteEntry(Entry entry) {
        int n = this.entryMgr.getEntries().indexOf(entry);
        this.delete(n);
        this.entryMgr.deleteEntry(entry);
    }

    public void changeEntry(Entry entry) {
        int n = this.entryMgr.getEntries().indexOf(entry);
        this.set(n, entry.getLabel(), null);
        this.entryMgr.changeEntry(entry);
    }

    private Entry getSelectedEntry() {
        int n = super.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (Entry)this.entryMgr.getEntries().elementAt(n);
    }
}

