/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class WeekList
extends UpdatableList {
    Econometer econometer;
    Displayable parent;
    int nWeeks;
    Shop shop;

    WeekList(Econometer econometer, Displayable displayable, Shop shop) {
        super(Locale.current.weekList, 3);
        this.econometer = econometer;
        this.parent = displayable;
        this.shop = shop;
        long l = 0L;
        int n = econometer.purchases.size();
        while (--n >= 0) {
            Purchase purchase = (Purchase)econometer.purchases.elementAt(n);
            if (shop != null && purchase.shop != shop) continue;
            DateTime dateTime = purchase.getDateTime();
            StringBuffer stringBuffer = new StringBuffer();
            long l2 = dateTime.getWeekStart();
            if (l != 0L) {
                while (l2 != l) {
                    l -= 604800000L;
                    ++this.nWeeks;
                }
            } else {
                l = l2;
                this.nWeeks = 1;
            }
            DateTime dateTime2 = new DateTime(l2);
            dateTime2.getDate(stringBuffer);
            stringBuffer.append(" - ");
            long l3 = purchase.price;
            while (--n >= 0) {
                purchase = (Purchase)econometer.purchases.elementAt(n);
                if (shop != null && purchase.shop != shop) continue;
                if (purchase.timestamp < l2) break;
                l3 += purchase.price;
            }
            ++n;
            Purchase.printPriceWithCurrency(l3, stringBuffer);
            this.append(stringBuffer.toString(), null);
        }
        this.setCommandListener(this);
        this.addCommand(Econometer.SELECT_CMD);
        this.addCommand(Econometer.BACK_CMD);
        this.addCommand(Econometer.GRAPH_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void update(int n, long l, long l2, boolean bl) {
        if (l == 0L) {
            this.delete(n);
        } else {
            String string = this.getString(n);
            int n2 = string.indexOf(45);
            this.set(n, string.substring(0, n2 + 2) + Purchase.printPriceWithCurrency(l), null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.BACK_CMD) {
            Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
        } else if (command == Econometer.GRAPH_CMD) {
            if (this.nWeeks != 0) {
                long[] lArray = new long[this.nWeeks];
                long l = 0L;
                int n = 0;
                int n2 = this.econometer.purchases.size();
                for (int i = 0; i < n2; ++i) {
                    Purchase purchase = (Purchase)this.econometer.purchases.elementAt(i);
                    if (this.shop != null && purchase.shop != this.shop) continue;
                    DateTime dateTime = purchase.getDateTime();
                    long l2 = dateTime.getWeekStart();
                    if (l != 0L) {
                        while (l2 != l) {
                            l += 604800000L;
                            ++n;
                        }
                    } else {
                        l = l2;
                        n = 1;
                    }
                    int n3 = n - 1;
                    lArray[n3] = lArray[n3] + purchase.price;
                }
                if (n >= 2) {
                    new Diagram(this.econometer, (Displayable)this, lArray, n);
                    return;
                }
            }
            this.econometer.showAlert(AlertType.WARNING, Locale.current.error, Locale.current.noData, (Displayable)this);
        } else {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                long l = 0L;
                int n4 = this.econometer.purchases.size();
                int n5 = n;
                while (--n4 >= 0) {
                    DateTime dateTime;
                    long l3;
                    Purchase purchase = (Purchase)this.econometer.purchases.elementAt(n4);
                    if (this.shop != null && purchase.shop != this.shop || (l3 = (dateTime = purchase.getDateTime()).getWeekStart()) == l) continue;
                    if (--n5 < 0) {
                        new WeekDayList(this.econometer, this, n, n4, this.shop);
                        break;
                    }
                    l = l3;
                }
            }
        }
    }
}

