/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class SettingsForm
extends Form
implements CommandListener {
    Econometer econometer;
    Displayable parent;
    TextField currencyField;
    ChoiceGroup precisionField;
    DateField truncateDate;

    SettingsForm(Econometer econometer, Displayable displayable) {
        super(Locale.current.newPurchase);
        this.econometer = econometer;
        this.parent = displayable;
        this.currencyField = new TextField(Locale.current.currency, Settings.instance.currency, 8, 0);
        this.precisionField = new ChoiceGroup(Locale.current.precision, 1, Locale.current.precisionTypes, null);
        this.truncateDate = new DateField(Locale.current.truncateDate, 1);
        this.precisionField.setSelectedIndex(Settings.instance.precision, true);
        this.append((Item)this.currencyField);
        this.append((Item)this.precisionField);
        this.append((Item)this.truncateDate);
        this.setCommandListener(this);
        this.addCommand(Econometer.BACK_CMD);
        this.addCommand(Econometer.ENTER_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.ENTER_CMD) {
            Settings.instance.currency = this.currencyField.getString();
            Settings.instance.precision = this.precisionField.getSelectedIndex();
            Date date = this.truncateDate.getDate();
            this.econometer.saveSettings();
            if (date != null) {
                this.econometer.truncate(date);
            }
        } else if (command != Econometer.BACK_CMD) {
            return;
        }
        Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
    }
}

