/*
 * Decompiled with CFR 0.152.
 */
public class Purchase {
    DateTime dt;
    long timestamp;
    long price;
    Shop shop;
    String description;
    int recordId;

    DateTime getDateTime() {
        if (this.dt == null) {
            this.dt = new DateTime(this.timestamp);
        }
        return this.dt;
    }

    Purchase(String string, long l, Shop shop) {
        this.description = string;
        this.price = l;
        this.shop = shop;
        ++shop.nPurchases;
        this.timestamp = System.currentTimeMillis();
    }

    Purchase(int n, byte[] byArray, Shop shop) {
        this.recordId = n;
        this.shop = shop;
        if (shop != null) {
            ++shop.nPurchases;
        }
        this.unpack(byArray);
    }

    boolean search(String string) {
        return this.description.toLowerCase().indexOf(string) >= 0;
    }

    static String printPrice(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Purchase.printPrice(l, stringBuffer);
        return stringBuffer.toString();
    }

    static void printPrice(long l, StringBuffer stringBuffer) {
        long l2 = l / 100L;
        int n = (int)(l % 100L);
        stringBuffer.append(l2);
        if (n != 0) {
            stringBuffer.append(Locale.current.fractionSeparatorChar);
            int n2 = 100;
            while (n2 != 1) {
                stringBuffer.append(n / (n2 /= 10) % 10);
            }
        }
    }

    static String printPriceWithCurrency(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Purchase.printPriceWithCurrency(l, stringBuffer);
        return stringBuffer.toString();
    }

    static void printPriceWithCurrency(long l, StringBuffer stringBuffer) {
        if (Locale.current.placeCurrencyInFront) {
            stringBuffer.append(Settings.instance.currency);
            Purchase.printPrice(l, stringBuffer);
        } else {
            Purchase.printPrice(l, stringBuffer);
            stringBuffer.append(Settings.instance.currency);
        }
    }

    static long parsePrice(String string) throws NumberFormatException {
        long l;
        int n = string.indexOf(Locale.current.fractionSeparatorChar);
        if (n >= 0) {
            l = Long.parseLong(string.substring(0, n)) * 100L;
            int n2 = 100;
            int n3 = string.length();
            while (++n < n3) {
                n2 /= 10;
                char c = string.charAt(n);
                if (c < '0' || c > '9') {
                    return 0L;
                }
                l += (long)(n2 * (c - 48));
            }
        } else {
            l = Long.parseLong(string) * 100L;
        }
        return l;
    }

    void unpack(byte[] byArray) {
        this.timestamp = Converter.unpackLong(byArray, 4);
        this.price = Converter.unpackLong(byArray, 12);
        this.description = Converter.unpackString(byArray, 20, byArray.length - 20);
    }

    byte[] pack() {
        byte[] byArray = Converter.packString(this.description);
        byte[] byArray2 = new byte[20 + byArray.length];
        if (this.shop != null) {
            Converter.packInt(byArray2, 0, this.shop.recordId);
        }
        Converter.packLong(byArray2, 4, this.timestamp);
        Converter.packLong(byArray2, 12, this.price);
        System.arraycopy(byArray, 0, byArray2, 20, byArray.length);
        return byArray2;
    }
}

