/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class CostManager
extends MIDlet
implements CommandListener,
ItemStateListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form openingForm;
    private Form helpForm;
    private Form resetForm;
    private Form reportsForm;
    private Form textualReportForm;
    private Form graphicReportForm;
    private Form addCostForm;
    private Form addTypeForm;
    private Form delTypeForm;
    private Image img;
    private ImageItem imgItem;
    private ImageItem graphImgItem;
    private List mainList;
    private StringItem resetSI;
    private StringItem openingSI;
    private StringItem helpSI;
    private TextField nameTF;
    private TextField costTF;
    private DateField fromDF;
    private DateField toDF;
    private Calendar calendar;
    private Canvas graphicReportCanvas;
    private Command helpCommand;
    private Command nextCommand;
    private Command backCommand;
    private Command saveCommand;
    private Command delCommand;
    private Command addCommand;
    private Command okCommand;
    private Command mainCommand;
    private String[] types;
    private CostManagerEngine costManagerEngine = new CostManagerEngine();
    private ChoiceGroup typesCG;
    private ChoiceGroup typesCGCopy;
    private ChoiceGroup reportsCG;
    private Alert alertMessage;

    public CostManager() throws Exception {
        this.calendar = Calendar.getInstance();
        this.alertMessage = new Alert("System Message");
        this.nextCommand = new Command("Next", 4, 1);
        this.helpCommand = new Command("Help", 4, 1);
        this.backCommand = new Command("Back", 4, 1);
        this.delCommand = new Command("Del", 4, 1);
        this.addCommand = new Command("Add", 4, 1);
        this.saveCommand = new Command("Save", 4, 1);
        this.okCommand = new Command("Ok", 4, 1);
        this.mainCommand = new Command("Main", 4, 1);
        this.openingForm = new Form("");
        try {
            this.img = Image.createImage((String)"/costManager.png");
            this.imgItem = new ImageItem("", this.img, 0, "[CostManager]");
            this.openingForm.append((Item)this.imgItem);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.openingSI = new StringItem("Cost Manager v1.1Beta\nwas developed by", "\nJACADO\nwww.jacado.com\nThis software is provided \"AS IS\", without warranty of any kind. In no event, shell we be liable for any claim, damages or other liability. Copyright(c)2001 Haim Michael, JACADO & ZINDELL Ltd. All rights reserved.");
        this.openingForm.append((Item)this.openingSI);
        this.openingForm.addCommand(this.nextCommand);
        this.openingForm.addCommand(this.helpCommand);
        this.openingForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.openingForm);
        System.out.println("openingForm was created");
        this.helpForm = new Form("Help");
        String str = "\nThis midlet allows you to manage your daily costs. You can add new types of costs as well as creating reports (textual & graphic) for specifc period of time. This midlet was not written for a specific currency. Therefore, remember to stick to the currency you chose in the begining. ";
        this.helpSI = new StringItem("Instructions", str);
        this.helpForm.append((Item)this.helpSI);
        this.helpForm.addCommand(this.backCommand);
        this.helpForm.setCommandListener((CommandListener)this);
        System.out.println("helpForm was created");
        this.mainList = new List("Main Menu", 3, new String[]{"Add Cost", "Reports", "Reset", "Add Type", "Del Type", "Exit"}, null);
        this.mainList.addCommand(this.nextCommand);
        this.mainList.addCommand(this.backCommand);
        this.mainList.setCommandListener((CommandListener)this);
        System.out.println("mainList was created");
        this.addCostForm = new Form("Add Cost");
        this.typesCG = new ChoiceGroup("", 1, this.types, null);
        this.costTF = new TextField("Sum", "", 10, 2);
        this.addCostForm.append((Item)this.typesCG);
        this.addCostForm.append((Item)this.costTF);
        this.addCostForm.addCommand(this.addCommand);
        this.addCostForm.addCommand(this.backCommand);
        this.addCostForm.setCommandListener((CommandListener)this);
        System.out.println("addCostForm was created");
        this.resetForm = new Form("Reset");
        this.resetSI = new StringItem("The result of this action", " All the cost data shell be deleted");
        this.resetForm.append((Item)this.resetSI);
        this.resetForm.addCommand(this.delCommand);
        this.resetForm.addCommand(this.backCommand);
        this.resetForm.setCommandListener((CommandListener)this);
        System.out.println("resetForm was created");
        this.addTypeForm = new Form("Add Type");
        this.nameTF = new TextField("Type name", "", 14, 0);
        this.addTypeForm.append((Item)this.nameTF);
        this.addTypeForm.addCommand(this.addCommand);
        this.addTypeForm.addCommand(this.backCommand);
        this.addTypeForm.setCommandListener((CommandListener)this);
        System.out.println("addTypeForm was created");
        this.reportsForm = new Form("Reports");
        this.fromDF = new DateField("From", 1);
        this.toDF = new DateField("To", 1);
        Date toDate = this.calendar.getTime();
        System.out.println("toDate.getTime()=" + toDate.getTime());
        this.toDF.setDate(toDate);
        Date fromDate = null;
        long subtractFrom = (long)(this.calendar.get(5) - 1) * 24L * 60L * 60L * 1000L;
        System.out.println("subtractFrom=" + subtractFrom);
        long sendToDateConstructor = toDate.getTime() - subtractFrom;
        System.out.println("sendToDateConstructor=" + sendToDateConstructor);
        fromDate = new Date(sendToDateConstructor);
        System.out.println("fromDate.getTime()=" + fromDate.getTime());
        this.fromDF.setDate(fromDate);
        this.reportsCG = new ChoiceGroup("Reports Types", 1, new String[]{"Textual", "Graphics"}, null);
        this.reportsForm.append((Item)this.fromDF);
        this.reportsForm.append((Item)this.toDF);
        this.reportsForm.append((Item)this.reportsCG);
        this.reportsForm.addCommand(this.nextCommand);
        this.reportsForm.addCommand(this.backCommand);
        this.reportsForm.setCommandListener((CommandListener)this);
        System.out.println("reportsForm was created");
        this.textualReportForm = new Form("Textual Report");
        this.textualReportForm.addCommand(this.mainCommand);
        this.textualReportForm.addCommand(this.backCommand);
        this.textualReportForm.setCommandListener((CommandListener)this);
        System.out.println("textualReportForm was created");
        this.graphicReportForm = new Form("Graphics Report");
        this.graphicReportForm.addCommand(this.mainCommand);
        this.graphicReportForm.addCommand(this.backCommand);
        this.graphicReportForm.setCommandListener((CommandListener)this);
        System.out.println("graphicReportForm was created");
        this.delTypeForm = new Form("Del Type");
        this.typesCGCopy = new ChoiceGroup("", 1, this.types, null);
        this.delTypeForm.append((Item)this.typesCGCopy);
        this.delTypeForm.addCommand(this.delCommand);
        this.delTypeForm.addCommand(this.backCommand);
        this.delTypeForm.setCommandListener((CommandListener)this);
        System.out.println("delTypeForm was created");
    }

    public void itemStateChanged(Item item) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commandAction(Command c, Displayable d) {
        if (d == this.openingForm) {
            if (c == this.nextCommand) {
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            if (c != this.helpCommand) return;
            this.display.setCurrent((Displayable)this.helpForm);
            return;
        }
        if (d == this.helpForm) {
            if (c != this.backCommand) return;
            this.display.setCurrent((Displayable)this.openingForm);
            return;
        }
        if (d == this.mainList) {
            if (c != this.nextCommand) {
                if (c != this.backCommand) return;
                this.display.setCurrent((Displayable)this.openingForm);
                return;
            }
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Add Cost") && this.typesCG.size() > 0) {
                this.costTF.setString("");
                this.display.setCurrent((Displayable)this.addCostForm);
                return;
            }
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Reports")) {
                this.display.setCurrent((Displayable)this.reportsForm);
                return;
            }
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Reset")) {
                this.display.setCurrent((Displayable)this.resetForm);
                return;
            }
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Del Type")) {
                this.display.setCurrent((Displayable)this.delTypeForm);
                return;
            }
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Add Type")) {
                this.display.setCurrent((Displayable)this.addTypeForm);
                return;
            }
            if (!this.mainList.getString(this.mainList.getSelectedIndex()).equals("Exit")) return;
            this.exit();
            return;
        }
        if (d == this.resetForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            if (c != this.delCommand) return;
            try {
                this.costManagerEngine.delAllCosts();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.display.setCurrent((Displayable)this.mainList);
            return;
        }
        if (d == this.addCostForm) {
            if (c != this.addCommand) {
                if (c != this.backCommand) return;
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            try {
                long time = new Date().getTime();
                String typeName = this.typesCG.getString(this.typesCG.getSelectedIndex());
                int sum = Integer.parseInt(this.costTF.getString());
                Cost newCost = new Cost(time, typeName, sum);
                this.costManagerEngine.addCost(newCost);
                this.costTF.setString("");
                this.alertMessage.setString("cost adding succeeded");
                this.alertMessage.setTimeout(2000);
                this.alertMessage.setType(AlertType.INFO);
                this.display.setCurrent((Displayable)this.alertMessage);
            }
            catch (Exception e) {
                this.alertMessage.setString("cost adding failed");
                this.alertMessage.setTimeout(2000);
                this.alertMessage.setType(AlertType.ERROR);
                this.display.setCurrent((Displayable)this.alertMessage);
                e.printStackTrace();
                return;
            }
            this.display.setCurrent((Displayable)this.mainList);
            return;
        }
        if (d == this.delTypeForm) {
            if (c == this.delCommand) {
                System.out.println("Del was pressed");
                int temp = this.typesCGCopy.getSelectedIndex();
                System.out.println("The index of the type that was selected is " + temp);
                System.out.println("In typesCG the type to be deleted is " + this.typesCG.getString(temp));
                System.out.println("In typesCGCopy the type to be deleted is " + this.typesCGCopy.getString(temp));
                this.typesCG.delete(temp);
                this.typesCGCopy.delete(temp);
                this.costManagerEngine.removeTypeByName(this.typesCG.getString(temp));
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            if (c != this.backCommand) return;
            this.display.setCurrent((Displayable)this.mainList);
            return;
        }
        if (d == this.addTypeForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            if (c != this.addCommand) return;
            try {
                this.costManagerEngine.addType(new Type(this.nameTF.getString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.display.setCurrent((Displayable)this.mainList);
            this.nameTF.setString("");
            return;
        }
        if (d == this.reportsForm) {
            if (c != this.nextCommand) {
                if (c != this.backCommand) return;
                this.display.setCurrent((Displayable)this.mainList);
                return;
            }
            if (this.reportsCG.getString(this.reportsCG.getSelectedIndex()).equals("Textual")) {
                this.initTextualReportForm();
                this.display.setCurrent((Displayable)this.textualReportForm);
                return;
            }
            if (!this.reportsCG.getString(this.reportsCG.getSelectedIndex()).equals("Graphics")) return;
            this.initGraphicReportForm();
            this.display.setCurrent((Displayable)this.graphicReportForm);
            return;
        }
        if (d == this.textualReportForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.reportsForm);
                return;
            }
            if (c != this.mainCommand) return;
            this.display.setCurrent((Displayable)this.mainList);
            return;
        }
        if (d != this.graphicReportForm) return;
        if (c == this.backCommand) {
            this.display.setCurrent((Displayable)this.reportsForm);
            return;
        }
        if (c != this.mainCommand) return;
        this.display.setCurrent((Displayable)this.mainList);
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        System.out.println("in startApp()");
    }

    public void pauseApp() {
        System.out.println("in pause()");
    }

    public void destroyApp(boolean cond) {
        this.display = null;
        this.openingForm = null;
        this.helpForm = null;
        this.openingForm = null;
        this.helpForm = null;
        this.resetForm = null;
        this.reportsForm = null;
        this.textualReportForm = null;
        this.graphicReportForm = null;
        this.addCostForm = null;
        this.addTypeForm = null;
        this.delTypeForm = null;
        this.img = null;
        this.imgItem = null;
        this.graphImgItem = null;
        this.mainList = null;
        this.resetSI = null;
        this.openingSI = null;
        this.helpSI = null;
        this.nameTF = null;
        this.costTF = null;
        this.fromDF = null;
        this.toDF = null;
        this.calendar = null;
        this.graphicReportCanvas = null;
        this.helpCommand = null;
        this.nextCommand = null;
        this.backCommand = null;
        this.saveCommand = null;
        this.delCommand = null;
        this.addCommand = null;
        this.okCommand = null;
        this.mainCommand = null;
        this.types = null;
        this.costManagerEngine = null;
        this.typesCG = null;
        this.typesCGCopy = null;
        this.reportsCG = null;
        this.alertMessage = null;
    }

    public void initTextualReportForm() {
        Hashtable map = this.costManagerEngine.getCosts();
        int numOfItemsToRemove = this.textualReportForm.size();
        int i = 0;
        while (i < numOfItemsToRemove) {
            this.textualReportForm.delete(i);
            ++i;
        }
        String typeName = null;
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            typeName = (String)e.nextElement();
            this.textualReportForm.append((Item)new StringItem(typeName + " ", String.valueOf(map.get(typeName))));
        }
    }

    public void initGraphicReportForm() {
        Hashtable map = this.costManagerEngine.getCosts();
        int numOfItemsToRemove = this.graphicReportForm.size();
        int i = 0;
        while (i < numOfItemsToRemove) {
            this.graphicReportForm.delete(i);
            ++i;
        }
        int numOfTypes = map.size();
        if (numOfTypes < 8) {
            Image temp = Image.createImage((int)60, (int)(57 + numOfTypes * 15));
            Graphics g = temp.getGraphics();
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, 60, 62 + numOfTypes * 15);
            int[] typeSums = new int[numOfTypes];
            String[] typeNames = new String[numOfTypes];
            int i2 = 0;
            Enumeration e = map.keys();
            System.out.println("About to start the enumeration process");
            while (e.hasMoreElements()) {
                typeNames[i2] = (String)e.nextElement();
                System.out.println("typeNames[" + i2 + "] is : " + typeNames[i2]);
                typeSums[i2] = (Integer)map.get(typeNames[i2]);
                System.out.println("typeSums[" + i2 + "] is : " + typeSums[i2]);
                ++i2;
            }
            int totalSum = 0;
            i2 = 0;
            while (i2 < typeSums.length) {
                totalSum += typeSums[i2];
                ++i2;
            }
            System.out.println("The total sum is : " + totalSum);
            int startArc = 0;
            int endArc = 0;
            int[] colors = new int[]{223, 191, 159, 127, 95, 63, 31};
            System.out.println("numOfTypes-1=" + (numOfTypes - 1));
            i2 = 0;
            while (i2 < numOfTypes - 1) {
                System.out.println("startArc=" + startArc + " endArc=" + endArc);
                endArc = 360 * typeSums[i2] / totalSum + endArc;
                System.out.println("g.setGrayScale(colors[" + i2 + "])");
                g.setGrayScale(colors[i2]);
                System.out.println("g.fillArc(2,2,50,50," + startArc + "," + (endArc - startArc) + ")");
                g.fillArc(2, 2, 50, 50, startArc, endArc - startArc);
                System.out.println("g.fillRect(2," + (70 + i2 * 15) + ",5,5)");
                g.fillRect(2, 62 + i2 * 15, 8, 8);
                g.setGrayScale(0);
                System.out.println("g.drawString(typeNames[" + i2 + "], 2, " + (75 + i2 * 15) + ", Graphics.LEFT | Graphics.BASELINE)");
                g.drawString(typeNames[i2], 12, 60 + i2 * 15 + 10, 68);
                startArc = endArc;
                ++i2;
            }
            System.out.println("end of loop. i=" + i2);
            endArc = 360;
            g.setGrayScale(colors[i2]);
            g.fillArc(2, 2, 50, 50, startArc, endArc - startArc);
            g.fillRect(2, 62 + i2 * 15, 8, 8);
            g.setGrayScale(0);
            g.drawString(typeNames[i2], 12, 60 + i2 * 15 + 10, 68);
            System.out.println("about to create the imageitem");
            this.graphImgItem = new ImageItem("", Image.createImage((Image)temp), 1, "[Graph]");
            this.graphicReportForm.append((Item)this.graphImgItem);
        }
    }

    static /* synthetic */ String[] access$202(CostManager x0, String[] x1) {
        x0.types = x1;
        return x1;
    }

    class CostManagerEngine {
        private RecordStore typesRS = RecordStore.openRecordStore((String)"typesRS", (boolean)true);
        private RecordStore costsRS = RecordStore.openRecordStore((String)"costsRS", (boolean)true);
        private Vector typesVec = new Vector();

        CostManagerEngine() throws Exception {
            this.initTypesVec();
            this.updateTypesArray();
        }

        Hashtable getCosts() {
            Hashtable<String, Integer> mapy = new Hashtable<String, Integer>();
            RecordEnumeration recordEnumeration = null;
            Cost tempCost = null;
            String typeName = null;
            boolean typeIndex = false;
            boolean typeTotalSum = false;
            try {
                recordEnumeration = this.costsRS.enumerateRecords(null, null, false);
                int tempId = 0;
                int tempSum = 0;
                long tempTime = 0L;
                long min = CostManager.this.fromDF.getDate().getTime();
                long max = CostManager.this.toDF.getDate().getTime() + 86400000L;
                while (recordEnumeration.hasNextElement()) {
                    tempId = recordEnumeration.nextRecordId();
                    byte[] data = this.costsRS.getRecord(tempId);
                    tempCost = new Cost(data);
                    tempSum = tempCost.getSum();
                    typeName = tempCost.getType();
                    tempTime = tempCost.getTime();
                    if (tempTime < min || tempTime > max) {
                        System.out.println("not pass the time condition");
                        continue;
                    }
                    if (mapy.containsKey(typeName)) {
                        System.out.println("add to report : " + tempCost);
                        mapy.put(typeName, new Integer((Integer)mapy.get(typeName) + tempSum));
                        continue;
                    }
                    System.out.println("(first)add to report : " + tempCost);
                    mapy.put(typeName, new Integer(tempCost.getSum()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return mapy;
        }

        void delAllCosts() throws Exception {
            System.out.println("within delAllCosts()");
            this.costsRS.closeRecordStore();
            RecordStore.deleteRecordStore((String)"costsRS");
            this.costsRS = RecordStore.openRecordStore((String)"costsRS", (boolean)true);
        }

        void addCost(Cost newCost) throws Exception {
            byte[] vec = newCost.toBytes();
            this.costsRS.addRecord(vec, 0, vec.length);
        }

        void updateTypesArray() {
            String[] vec = new String[this.typesVec.size()];
            int i = 0;
            while (i < vec.length) {
                vec[i] = ((Type)this.typesVec.elementAt(i)).getName();
                ++i;
            }
            CostManager.access$202(CostManager.this, vec);
        }

        void initTypesVec() {
            RecordEnumeration recordEnumeration = null;
            try {
                recordEnumeration = this.typesRS.enumerateRecords(null, null, false);
                int tempId = 0;
                while (recordEnumeration.hasNextElement()) {
                    tempId = recordEnumeration.nextRecordId();
                    byte[] data = this.typesRS.getRecord(tempId);
                    this.typesVec.addElement(new Type(data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void addType(Type type) throws Exception {
            byte[] temp = type.toBytes();
            int idTemp = this.typesRS.addRecord(temp, 0, temp.length);
            type.setId(idTemp);
            this.typesVec.addElement(type);
            CostManager.this.typesCG.append(type.getName(), null);
            CostManager.this.typesCGCopy.append(type.getName(), null);
        }

        void removeTypeByName(String str) {
            int recordId = 0;
            int i = 0;
            while (i < this.typesVec.size()) {
                System.out.println("i=" + i);
                if (((Type)this.typesVec.elementAt(i)).getName().equals(str)) {
                    recordId = i;
                }
                ++i;
            }
            try {
                this.typesRS.deleteRecord(recordId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

