/*
 * Decompiled with CFR 0.152.
 */
package compass;

import compass.Astrometric;
import compass.EarthHeading;
import compass.EarthPosition;
import compass.EclipticPosition;
import compass.EquitorialPosition;
import compass.HorizontalPosition;
import compass.Preferences;
import compass.UTCDate;
import henson.midp.Float;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SunMoonPosition {
    private static final EarthPosition[] a = new EarthPosition[]{new EarthPosition(32, 55, 35, 4), new EarthPosition(31, 46, 35, 14), new EarthPosition(21, 25, 39, 49)};
    private UTCDate a;
    private HorizontalPosition a;
    private HorizontalPosition b;
    private Float a;
    private EarthHeading a;

    public SunMoonPosition(Preferences preferences) {
        this.a = new UTCDate(preferences.TimeOffset);
        EarthPosition earthPosition = new EarthPosition(preferences.LatMinutes, preferences.LongMinutes);
        Float float_ = this.a.getMJD();
        EclipticPosition eclipticPosition = Astrometric.sunPosition(float_);
        EquitorialPosition equitorialPosition = eclipticPosition.toEquitorialPosition();
        this.a = equitorialPosition.toHorizontalPosition(earthPosition, float_);
        EclipticPosition eclipticPosition2 = Astrometric.moonPosition(float_);
        EquitorialPosition equitorialPosition2 = eclipticPosition2.toEquitorialPosition();
        this.b = equitorialPosition2.toHorizontalPosition(earthPosition, float_);
        Float float_2 = eclipticPosition.getLongitude().Sub(eclipticPosition2.getLongitude());
        this.a = Float.cos(Float.PI.Sub(float_2)).Add(new Float(1L)).Div(new Float(2L));
        this.a = preferences.PrayerFocus == 0 ? null : earthPosition.toEarthHeading(a[preferences.PrayerFocus - 1]);
    }

    public UTCDate getUTCDate() {
        return this.a;
    }

    public HorizontalPosition getSunPosition() {
        return this.a;
    }

    public HorizontalPosition getMoonPosition() {
        return this.b;
    }

    public Float getMoonPhase() {
        return this.a;
    }

    public EarthHeading getPrayerHeading() {
        return this.a;
    }
}

