/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ChessGoClockCanvas
extends Canvas {
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int STOPPED = 3;
    private int state = 3;
    private UpperTimer leftTimer;
    private UpperTimer rightTimer;
    protected ChessGoClockMIDlet chessGoClockMIDlet;
    private Timer timer = new Timer();
    private TimerTask timerTask = new TimerTask(){

        public void run() {
            try {
                if (ChessGoClockCanvas.this.state == 1) {
                    ChessGoClockCanvas.this.leftTimer.reduce();
                    ChessGoClockCanvas.this.repaint();
                } else if (ChessGoClockCanvas.this.state == 2) {
                    ChessGoClockCanvas.this.rightTimer.reduce();
                    ChessGoClockCanvas.this.repaint();
                }
            }
            catch (ChessTimer.TimeOverException timeOverException) {
                ChessGoClockCanvas.this.chessGoClockMIDlet.timeOver();
            }
        }
    };

    public ChessGoClockCanvas(UpperTimer upperTimer, UpperTimer upperTimer2, ChessGoClockMIDlet chessGoClockMIDlet) {
        this.leftTimer = upperTimer;
        this.rightTimer = upperTimer2;
        this.chessGoClockMIDlet = chessGoClockMIDlet;
    }

    public void start() {
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, 200L);
    }

    public void hardStop() {
        this.timer.cancel();
    }

    public void softStop() {
        this.state = 3;
    }

    protected void paint(Graphics graphics) {
        int n = graphics.getClipWidth();
        int n2 = graphics.getClipHeight();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(0);
        graphics.setFont(Font.getFont((int)graphics.getFont().getFace(), (int)graphics.getFont().getStyle(), (int)16));
        graphics.drawString(this.leftTimer.getLowerString() + this.leftSharp(), 0, n2 / 2, 20);
        graphics.drawString(this.rightSharp() + this.rightTimer.getLowerString(), n, n2 / 2, 40);
        int n3 = graphics.getFont().getHeight();
        graphics.setFont(Font.getFont((int)graphics.getFont().getFace(), (int)graphics.getFont().getStyle(), (int)0));
        graphics.drawString(this.leftTimer.getString(), 0, n2 / 2 + n3, 20);
        graphics.drawString(this.rightTimer.getString(), n, n2 / 2 - n3, 40);
    }

    public synchronized void keyPressed(int n) {
        if (n == 49) {
            if (this.state == 1) {
                this.leftTimer.moved();
            }
            this.state = 2;
        } else if (n == 51) {
            if (this.state == 2) {
                this.rightTimer.moved();
            }
            this.state = 1;
        } else if (n == 53) {
            this.state = 3;
        }
    }

    private String leftSharp() {
        if (this.state == 1) {
            return "#";
        }
        return "";
    }

    private String rightSharp() {
        if (this.state == 2) {
            return "#";
        }
        return "";
    }
}

