/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VictoriaPuzzleCanvas
extends FullCanvas {
    final boolean COLOR_SCREEN;
    static final int MIN_MEMORY = 70000;
    int chunkX;
    int chunkY;
    int resultWidth;
    int resultHeight;
    int playedNum;
    int playedCol;
    int playedRow;
    int screenWidth;
    int screenHeight;
    int cellWidth;
    int cellHeight;
    int eg;
    int eg2;
    private int[][] matrix;
    private int[][] check;
    protected Image victoria;
    protected Image graphics;
    protected Image menuImg;
    protected Image star;
    protected Image bigStar;
    int col;
    int row;
    byte level;
    int end;
    private Display display;
    private VictoriaPuzzle puzzle;
    boolean sound;
    boolean bRemoveStars;
    boolean chunked;
    Font myFont;
    int moveRight;
    int moveDown;

    VictoriaPuzzleCanvas(VictoriaPuzzle victoriaPuzzle) {
        this.COLOR_SCREEN = false;
        System.out.println("vpc1");
        this.puzzle = victoriaPuzzle;
        this.display = victoriaPuzzle.display;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        try {
            this.graphics = Image.createImage((String)"/graphics.png");
            this.menuImg = Image.createImage((String)"/VictoriaPuzzleMenu.png");
            if (victoriaPuzzle.APP_STARS != null) {
                this.star = Image.createImage((String)"/star.png");
                this.bigStar = Image.createImage((String)"/bigStar.png");
            }
        }
        catch (IOException iOException) {}
    }

    public void init(byte by, boolean bl) {
        this.level = by;
        this.chunked = bl;
        this.victoria = null;
        if (Runtime.getRuntime().freeMemory() < 70000L) {
            System.gc();
        }
        this.createImages();
        this.prepare(this.victoria);
        this.end = 0;
    }

    private void createImages() {
        Graphics graphics = null;
        Image image = null;
        try {
            image = Image.createImage((String)("/victoria" + (this.level - 1) + ".png"));
            this.victoria = Image.createImage((int)image.getWidth(), (int)image.getHeight());
            graphics = this.victoria.getGraphics();
            graphics.drawImage(image, 0, 0, 20);
            if (this.puzzle.APP_STARS != null) {
                switch (this.level) {
                    case 5: {
                        graphics.drawImage(this.star, 46, 112, 3);
                        graphics.drawImage(this.star, 102, 107, 3);
                        graphics.drawImage(this.star, 110, 177, 3);
                        break;
                    }
                    case 4: {
                        graphics.drawImage(this.star, 68, 100, 3);
                        graphics.drawImage(this.star, 115, 115, 3);
                        graphics.drawImage(this.bigStar, 62, 177, 3);
                        break;
                    }
                    case 3: {
                        graphics.drawImage(this.star, 47, 107, 3);
                        graphics.drawImage(this.star, 104, 107, 3);
                        graphics.drawImage(this.star, 60, 208, 3);
                        break;
                    }
                    case 2: {
                        graphics.drawImage(this.star, 69, 123, 3);
                        graphics.drawImage(this.star, 125, 124, 3);
                        graphics.drawImage(this.star, 90, 208, 3);
                        break;
                    }
                }
            }
            graphics = null;
            image = null;
            System.gc();
        }
        catch (IOException iOException) {}
    }

    public void prepare(Image image) {
        if (this.level < 3) {
            this.chunkY = 3;
            this.chunkX = 3;
        } else if (this.level < 5) {
            this.chunkY = 4;
            this.chunkX = 4;
        } else {
            this.chunkY = 5;
            this.chunkX = 5;
        }
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.moveDown = 2;
        this.moveRight = 2;
        this.cellWidth = (this.victoria.getWidth() - this.moveRight * 2 - (this.chunkX - 1) * 3) / this.chunkX;
        this.cellHeight = (this.victoria.getHeight() - this.moveDown * 2 - (this.chunkY - 1) * 3) / this.chunkY;
        if (this.moveRight * 2 + (this.chunkX - 1) * 3 + this.cellWidth * this.chunkX >= this.screenWidth) {
            --this.cellWidth;
        }
        if (this.moveDown * 2 + (this.chunkY - 1) * 3 + this.cellHeight * this.chunkY >= this.screenHeight) {
            --this.cellHeight;
        }
        this.myFont = Font.getFont((int)0, (int)1, (int)0);
        this.check = Shuffle.fill(this.chunkX, this.chunkY);
        this.matrix = Shuffle.mix(this.chunkX, this.chunkY, 0);
        this.playedRow = 0;
        this.playedCol = 0;
        this.playedNum = 0;
    }

    protected void paint(Graphics graphics) {
        if (Runtime.getRuntime().freeMemory() < 70000L) {
            System.gc();
        }
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (!this.chunked) {
            graphics.drawImage(this.victoria, this.screenWidth / 2, this.screenHeight / 2, 3);
        } else {
            this.drawBoard(graphics);
        }
    }

    private void drawBoard(Graphics graphics) {
        System.out.println(this.end);
        graphics.setColor(255, 0, 0);
        graphics.drawRect(0, 0, this.moveRight * 2 + (this.chunkX - 1) * 3 + this.cellWidth * this.chunkX, this.moveDown * 2 + (this.chunkY - 1) * 3 + this.cellHeight * this.chunkY);
        this.row = 0;
        while (this.row < this.chunkX) {
            this.col = 0;
            while (this.col < this.chunkY) {
                if (this.matrix[this.row][this.col] != this.playedNum || this.end >= 2) {
                    if (this.end == 3) {
                        this.matrix = this.check;
                    }
                    graphics.setClip(this.moveRight + this.col * (this.cellWidth + 3), this.moveDown + this.row * (this.cellHeight + 3), this.cellWidth, this.cellHeight);
                    graphics.drawImage(this.victoria, this.moveRight + (this.col - this.matrix[this.row][this.col] % this.chunkX) * (this.cellWidth + 3), this.moveDown + (this.row - this.matrix[this.row][this.col] / this.chunkX) * (this.cellHeight + 3), 20);
                    graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
                    graphics.drawRect(this.moveRight + this.col * (this.cellWidth + 3), this.moveDown + this.row * (this.cellHeight + 3), this.cellWidth, this.cellHeight);
                }
                ++this.col;
            }
            ++this.row;
        }
    }

    private boolean isGameOver() {
        int n = 0;
        while (n < this.chunkX) {
            int n2 = 0;
            while (n2 < this.chunkY) {
                if (this.matrix[n][n2] != this.check[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    protected void keyPressed(int n) {
        if (n == -6 || n == -7 || this.level >= 6) {
            this.puzzle.mainCanvas.selected = 1;
            this.display.setCurrent((Displayable)this.puzzle.mainCanvas);
            this.puzzle.saveResults();
            return;
        }
        if (this.end == 0) {
            int n2 = 0;
            while (n2 < this.chunkX) {
                int n3 = 0;
                while (n3 < this.chunkY) {
                    if (this.matrix[n2][n3] == this.playedNum) {
                        this.playedRow = n2;
                        this.playedCol = n3;
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
            try {
                switch (this.getGameAction(n)) {
                    case 5: {
                        this.matrix[this.playedRow][this.playedCol] = this.matrix[this.playedRow][--this.playedCol];
                        break;
                    }
                    case 2: {
                        this.matrix[this.playedRow][this.playedCol] = this.matrix[this.playedRow][++this.playedCol];
                        break;
                    }
                    case 1: {
                        this.matrix[this.playedRow][this.playedCol] = this.matrix[++this.playedRow][this.playedCol];
                        break;
                    }
                    case 6: {
                        this.matrix[this.playedRow][this.playedCol] = this.matrix[--this.playedRow][this.playedCol];
                    }
                }
                this.matrix[this.playedRow][this.playedCol] = this.playedNum;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (this.isGameOver()) {
                Thread thread = new Thread(){

                    public void run() {
                        int n = 15;
                        try {
                            while (n-- > 0) {
                                VictoriaPuzzleCanvas.this.end = n % 2 << 1;
                                VictoriaPuzzleCanvas.this.repaint();
                                VictoriaPuzzleCanvas.this.serviceRepaints();
                                Thread.sleep(200L);
                            }
                            VictoriaPuzzleCanvas.this.end = 1;
                            byte by = VictoriaPuzzleCanvas.this.level;
                            if (((VictoriaPuzzleCanvas)VictoriaPuzzleCanvas.this).puzzle.maxLevel < (by = (byte)(by + 1))) {
                                ((VictoriaPuzzleCanvas)VictoriaPuzzleCanvas.this).puzzle.maxLevel = by;
                            }
                            VictoriaPuzzleCanvas.this.chunked = false;
                            VictoriaPuzzleCanvas.this.repaint();
                            VictoriaPuzzleCanvas.this.serviceRepaints();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                };
                thread.start();
                AlertType.INFO.playSound(this.display);
            }
            if (n == 35) {
                ++this.eg;
                if (this.eg % 5 == 0) {
                    this.matrix = this.check;
                }
            }
            this.repaint();
            this.serviceRepaints();
            if (n == 42) {
                ++this.eg2;
                if (this.eg2 % 5 == 0) {
                    this.puzzle.APP_STARS = null;
                    this.init(this.level, this.chunked);
                }
            }
            this.repaint();
            this.serviceRepaints();
        }
    }
}

