/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class VictoriaPuzzle
extends MIDlet
implements CommandListener {
    static final boolean REAL_DEVICE = false;
    static final boolean DEBUG = true;
    String ms = "";
    byte maxLevel = 1;
    byte level = 1;
    String[] menuText = new String[]{"Continue", "New game", "Exit", "Help", "About", "Level 1", "Level 2", "Level 3", "Level 4", "Level 5", "Play again", "View"};
    Display display;
    Displayable currentDisplayable;
    Displayable previousDisplayable;
    private Form loadingForm;
    private Form helpForm;
    private Form aboutForm;
    private SplashCanvas splashCanvas;
    MainCanvas mainCanvas;
    private VictoriaPuzzleCanvas victoriaPuzzleCanvas;
    private Thread thread;
    static Gauge gauge;
    private boolean firstTime;
    private Command exitCommand;
    Command backCommand;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_NAME = this.getAppProperty("MIDlet-Name");
    final String APP_SPLASH;
    final String APP_MENU;
    final String MAIN_STR = this.getAppProperty("MIDlet-Description");
    String APP_STARS = this.getAppProperty("APP-STARS");
    private Font boldFont = Font.getFont((int)0, (int)1, (int)8);
    private Font selFont = Font.getFont((int)0, (int)5, (int)8);
    final String ABOUT_STR = "Victoria Puzzle, version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Midlex.com & PlanetVictoria.com. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + ", images of Victoria Zdrok provided by PlanetVictoria.com. \nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR;

    public VictoriaPuzzle() {
        this.APP_SPLASH = "/VictoriaPuzzleSplash.png";
        this.APP_MENU = "/VictoriaPuzzleMenu.png";
        this.HELP_STR = "Try to arrange the tiles to complete Victoria Zdrok image. Use the Navigation Keys to move the tiles in order to complete the image. Once you complete a level you can start playing the next level.";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.currentDisplayable = this.mainCanvas;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.thread = new Thread(){

                public void run() {
                    try {
                        VictoriaPuzzle.this.display = Display.getDisplay((MIDlet)VictoriaPuzzle.this);
                        VictoriaPuzzle.this.loadingForm = new Form("Loading...");
                        VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.loadingForm;
                        gauge = new Gauge("Please wait:", false, 14, 0);
                        VictoriaPuzzle.this.loadingForm.append((Item)gauge);
                        gauge.setValue(0);
                        VictoriaPuzzle.this.display.setCurrent((Displayable)VictoriaPuzzle.this.loadingForm);
                        VictoriaPuzzle.this.exitCommand = new Command("Exit", 7, 2);
                        VictoriaPuzzle.this.backCommand = new Command("Back", 2, 2);
                        VictoriaPuzzle.this.firstTime = true;
                        gauge.setValue(1);
                        VictoriaPuzzle.this.loadHighScore();
                        VictoriaPuzzle.this.level = VictoriaPuzzle.this.maxLevel < 6 ? VictoriaPuzzle.this.maxLevel : (byte)5;
                        gauge.setValue(2);
                        VictoriaPuzzle.this.victoriaPuzzleCanvas = new VictoriaPuzzleCanvas(VictoriaPuzzle.this);
                        gauge.setValue(10);
                        gauge.setValue(11);
                        VictoriaPuzzle.this.mainCanvas = new MainCanvas();
                        gauge.setValue(12);
                        VictoriaPuzzle.this.aboutForm = new Form("About");
                        VictoriaPuzzle.this.aboutForm.append(VictoriaPuzzle.this.ABOUT_STR);
                        VictoriaPuzzle.this.aboutForm.addCommand(VictoriaPuzzle.this.backCommand);
                        VictoriaPuzzle.this.aboutForm.setCommandListener((CommandListener)VictoriaPuzzle.this);
                        gauge.setValue(13);
                        VictoriaPuzzle.this.helpForm = new Form("Help");
                        VictoriaPuzzle.this.helpForm.append("Try to arrange the tiles to complete Victoria Zdrok image. Use the Navigation Keys to move the tiles in order to complete the image. Once you complete a level you can start playing the next level.");
                        VictoriaPuzzle.this.helpForm.addCommand(VictoriaPuzzle.this.backCommand);
                        VictoriaPuzzle.this.helpForm.setCommandListener((CommandListener)VictoriaPuzzle.this);
                        gauge.setValue(14);
                        VictoriaPuzzle.this.splashCanvas = new SplashCanvas();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainCanvas) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.mainCanvas = null;
        this.loadingForm = null;
        gauge = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.victoriaPuzzleCanvas = null;
        this.splashCanvas = null;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHighScore() {
        System.out.println("loadHighScore");
        RecordStore recordStore = null;
        byte[] byArray = new byte[]{1};
        try {
            recordStore = RecordStore.openRecordStore((String)"VictoriaPuzzleScores", (boolean)true);
            if (recordStore.getNumRecords() == 1) {
                byArray = recordStore.getRecord(1);
                this.maxLevel = byArray[0];
            } else {
                if (recordStore.getNumRecords() > 0) {
                    this.deleteScoresDatabase();
                }
                recordStore = RecordStore.openRecordStore((String)"VictoriaPuzzleScores", (boolean)true);
                recordStore.addRecord(byArray, 0, 1);
                this.maxLevel = 1;
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.deleteScoresDatabase();
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    private void deleteScoresDatabase() {
        try {
            RecordStore.deleteRecordStore((String)"VictoriaPuzzleScores");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResults() {
        RecordStore recordStore = null;
        byte[] byArray = new byte[]{1};
        try {
            recordStore = RecordStore.openRecordStore((String)"VictoriaPuzzleScores", (boolean)false);
            byArray[0] = this.maxLevel;
            recordStore.setRecord(1, byArray, 0, 1);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    protected class MainCanvas
    extends FullCanvas {
        int selected = 1;
        int h1 = 0;
        int h2 = 0;
        int[] picX = new int[]{129, 12, 129, 12, 129, 70, 70};
        int[] picY = new int[]{50, 75, 100, 125, 150, 125, 125};
        private boolean bug = false;
        private boolean bAlert = false;

        private MainCanvas() {
        }

        protected void keyPressed(int n) {
            block27: {
                try {
                    if (n == -6 || n == -7) {
                        if (this.selected < 5) {
                            this.bug = true;
                        } else {
                            this.selected = this.selected > 9 ? VictoriaPuzzle.this.level + 4 : 1;
                        }
                    } else if (n == -2) {
                        if (this.selected != 4 && this.selected != 9 && this.selected != 11) {
                            ++this.selected;
                        }
                    } else if (n == -1) {
                        if (this.selected != 5 && this.selected != 10 && this.selected != 0) {
                            --this.selected;
                        }
                    } else if (n == -5 || this.getGameAction(n) == 8) {
                        switch (this.selected) {
                            case 0: {
                                if (((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.victoria != null) {
                                    VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.victoriaPuzzleCanvas;
                                    VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                                    break;
                                }
                                this.selected = 5;
                                break;
                            }
                            case 1: {
                                this.selected = 5;
                                break;
                            }
                            case 2: {
                                this.bug = true;
                                break;
                            }
                            case 3: {
                                VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.helpForm;
                                VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                                break;
                            }
                            case 4: {
                                VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.aboutForm;
                                VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                if (VictoriaPuzzle.this.maxLevel >= this.selected - 4) {
                                    VictoriaPuzzle.this.level = (byte)(this.selected - 4);
                                    if (VictoriaPuzzle.this.maxLevel > VictoriaPuzzle.this.level) {
                                        this.selected = 10;
                                        break;
                                    }
                                    VictoriaPuzzle.this.victoriaPuzzleCanvas.init(VictoriaPuzzle.this.level, true);
                                    VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.victoriaPuzzleCanvas;
                                    VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                                    break;
                                }
                                Alert alert = new Alert("Sorry!", "You need to solve previous levels first.", null, AlertType.INFO);
                                alert.setTimeout(-2);
                                VictoriaPuzzle.this.display.setCurrent(alert, (Displayable)this);
                                break;
                            }
                            case 10: {
                                VictoriaPuzzle.this.victoriaPuzzleCanvas.init(VictoriaPuzzle.this.level, true);
                                VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.victoriaPuzzleCanvas;
                                VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                                break;
                            }
                            case 11: {
                                VictoriaPuzzle.this.victoriaPuzzleCanvas.init(VictoriaPuzzle.this.level, false);
                                VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.victoriaPuzzleCanvas;
                                VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
                            }
                        }
                    }
                    if (this.bug) {
                        VictoriaPuzzle.this.exit();
                        break block27;
                    }
                    this.repaint();
                    this.serviceRepaints();
                }
                catch (Exception exception) {
                    VictoriaPuzzle.this.ms = exception.getMessage();
                }
            }
        }

        protected void paint(Graphics graphics) {
            if (Runtime.getRuntime().freeMemory() < 70000L) {
                System.gc();
            }
            graphics.drawImage(((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.menuImg, 0, 0, 20);
            graphics.setFont(VictoriaPuzzle.this.boldFont);
            if (this.selected < 5) {
                this.h1 = 0;
                this.h2 = 5;
            } else if (this.selected < 10) {
                this.h1 = 5;
                this.h2 = 10;
            } else {
                this.h1 = 10;
                this.h2 = 12;
            }
            int n = this.h1;
            while (n < this.h2) {
                if (n == this.selected) {
                    graphics.setColor(255, 154, 0);
                    graphics.setFont(VictoriaPuzzle.this.selFont);
                } else {
                    graphics.setColor(204, 204, 204);
                    graphics.setFont(VictoriaPuzzle.this.boldFont);
                }
                graphics.drawString(VictoriaPuzzle.this.menuText[n], ((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.screenWidth / 2, 64 + (n - this.h1) * 25, 17);
                ++n;
            }
            if (this.selected > 4) {
                graphics.setClip(this.picX[this.selected - 5], this.picY[this.selected - 5], 37, 43);
                if (this.selected < 10) {
                    if (VictoriaPuzzle.this.maxLevel <= this.selected - 4) {
                        if (VictoriaPuzzle.this.maxLevel == this.selected - 4) {
                            graphics.setColor(0, 255, 0);
                        } else {
                            graphics.setColor(255, 0, 0);
                        }
                        graphics.drawImage(((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.graphics, this.picX[this.selected - 5] + 1 + (5 - this.selected) * 35, this.picY[this.selected - 5] + 1, 20);
                    } else {
                        graphics.drawImage(((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.graphics, this.picX[this.selected - 5] + 1 + (5 - this.selected) * 35, this.picY[this.selected - 5] + 1, 20);
                        graphics.setColor(0, 255, 0);
                    }
                } else {
                    graphics.drawImage(((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.graphics, this.picX[this.selected - 5] + 1 + (1 - VictoriaPuzzle.this.level) * 35, this.picY[this.selected - 5] + 1, 20);
                    graphics.setColor(0, 255, 0);
                }
                graphics.setClip(0, 0, ((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.screenWidth, ((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.screenHeight);
                graphics.drawRect(this.picX[this.selected - 5], this.picY[this.selected - 5], 36, 42);
                graphics.drawString(VictoriaPuzzle.this.ms, 5, 5, 20);
            }
        }

        protected void hideNotify() {
            if (this.bug) {
                return;
            }
        }

        protected void showNotify() {
        }
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;
        private int startPos = 55;
        private boolean bAdultConfirmation = false;
        private boolean bFlag = true;
        private String[] as = new String[]{"To continue, you must read", "and agree to the following", "terms and conditions:", "1. That you are an adult of", "legal age (and at least 18", "years old) in your State or", "Country;", "2. That you are not", "offended by photographs", "depicting nudity and sexual", "situations;", "3. That it is legal to receive", "and view adult images in the", "locale and country in which", "you reside;", "4. That you will never make", "any of the materials in this", "software available", "to minors;", "5. That you recognize that", "all materials contained in", "this software are", "copyrighted;", "and", "6. That you will not publish,", "use or distribute any of the", "contents of this software in", "any media."};

        private SplashCanvas() {
            try {
                this.splashImg = Image.createImage((String)"/VictoriaPuzzleSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            VictoriaPuzzle.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
        }

        protected void keyPressed(int n) {
            block14: {
                try {
                    if (this.bAdultConfirmation) {
                        this.dismiss();
                        break block14;
                    }
                    if (n == -6 || n == -7) {
                        VictoriaPuzzle.this.exit();
                        return;
                    }
                    switch (this.getGameAction(n)) {
                        case 5: {
                            this.bFlag = false;
                            this.repaint();
                            this.serviceRepaints();
                            break;
                        }
                        case 2: {
                            this.bFlag = true;
                            this.repaint();
                            this.serviceRepaints();
                            break;
                        }
                        case 1: {
                            if (this.startPos < 50) {
                                this.startPos += 12;
                            }
                            this.repaint();
                            this.serviceRepaints();
                            break;
                        }
                        case 6: {
                            if (this.startPos >= 50 - (this.as.length - 6) * 12) {
                                this.startPos -= 12;
                            }
                            this.repaint();
                            this.serviceRepaints();
                            break;
                        }
                        case 8: {
                            this.bAdultConfirmation = this.bFlag;
                            if (!this.bFlag) {
                                VictoriaPuzzle.this.exit();
                                break;
                            }
                            this.timer.schedule((TimerTask)new CountDown(), 5000L);
                            this.repaint();
                            this.serviceRepaints();
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(((VictoriaPuzzle)VictoriaPuzzle.this).victoriaPuzzleCanvas.menuImg, 0, 0, 20);
            if (this.bAdultConfirmation) {
                graphics.drawImage(this.splashImg, 0, 0, 20);
                if (VictoriaPuzzle.this.APP_STARS != null) {
                    try {
                        Image image = Image.createImage((String)"/star.png");
                        graphics.drawImage(image, 50, 162, 3);
                        graphics.drawImage(image, 108, 158, 3);
                        image = null;
                    }
                    catch (IOException iOException) {}
                }
            } else {
                graphics.setFont(VictoriaPuzzle.this.boldFont);
                graphics.setColor(204, 204, 204);
                int n = 0;
                while (n < this.as.length) {
                    if (this.startPos + n * 12 > 50) {
                        graphics.drawString(this.as[n], 5, this.startPos + n * 12, 20);
                    }
                    System.out.println(this.as[n] + VictoriaPuzzle.this.boldFont.stringWidth(this.as[n]));
                    ++n;
                }
                if (this.bFlag) {
                    graphics.setColor(255, 204, 0);
                    graphics.setFont(VictoriaPuzzle.this.selFont);
                    graphics.drawString("ACCEPT", 5, 36, 20);
                    graphics.setFont(VictoriaPuzzle.this.boldFont);
                    graphics.setColor(0, 0, 0);
                    graphics.drawString("DECLINE", 173, 38, 24);
                    graphics.setColor(204, 204, 204);
                    graphics.drawString("DECLINE", 171, 36, 24);
                } else {
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(VictoriaPuzzle.this.boldFont);
                    graphics.drawString("ACCEPT", 7, 38, 20);
                    graphics.setColor(204, 204, 204);
                    graphics.drawString("ACCEPT", 5, 36, 20);
                    graphics.setColor(255, 204, 0);
                    graphics.setFont(VictoriaPuzzle.this.selFont);
                    graphics.drawString("DECLINE", 171, 36, 24);
                }
            }
        }

        private void dismiss() {
            this.timer.cancel();
            this.splashImg = null;
            VictoriaPuzzle.this.currentDisplayable = VictoriaPuzzle.this.mainCanvas;
            VictoriaPuzzle.this.display.setCurrent(VictoriaPuzzle.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

