/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.Sprite;
import arcadia.game.jetski.AnimObject;
import arcadia.game.jetski.JSObject;

public class Ramp
extends AnimObject
implements JSObject {
    static final byte NORMAL = 0;
    protected boolean passThrough = false;

    public Ramp(int n, int n2) {
        super(n, n2);
    }

    public Ramp(Ramp ramp) {
        super(ramp);
        this.passThrough = ramp.passThrough;
    }

    public void initialize() {
        super.initialize();
        this.passThrough = false;
    }

    public int checkCollision(Sprite sprite) {
        int n = sprite.getX();
        int n2 = sprite.getX() + sprite.getWidth();
        int n3 = this.x + this.bBoxLeft;
        int n4 = this.x + this.width - this.bBoxRight;
        boolean bl = n < n3 && n2 > n3 || n < n4 && n2 > n4;
        boolean bl2 = sprite.getX() + sprite.getWidth() > n3 && n4 > sprite.getX();
        boolean bl3 = sprite.getY() + sprite.getHeight() - this.bBoxUp > this.y && this.y + this.height - this.bBoxDown > sprite.getY();
        this.collided = bl2 && bl3;
        boolean bl4 = this.passThrough = !bl && bl3;
        if (this.collided) {
            return this.type;
        }
        return 0;
    }

    public boolean isPassThought() {
        return this.passThrough;
    }

    static {
        NORMAL = 0;
    }
}

