/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.AnimSprite;
import arcadia.game.TileWorld;
import arcadia.game.jetski.Bonus;
import arcadia.game.jetski.FXManager;
import arcadia.game.jetski.Game;
import arcadia.game.jetski.JSObject;
import arcadia.game.jetski.JetSkiMIDlet;
import arcadia.game.jetski.Ramp;

public class Player
extends AnimSprite {
    private Game _$147;
    private TileWorld _$4633;
    private FXManager _$520;
    int state = 0;
    static final byte STRAIGHT = 0;
    static final byte RIGHT = 1;
    static final byte LEFT = 2;
    static final byte BOOST = 3;
    static final byte JUMP = 4;
    static final byte RAMPJUMP = 5;
    static final byte DIVE = 6;
    static final byte WRECK = 7;
    protected int speedY;
    protected int speedX;
    protected int xCenterMap;
    protected int yCenterMap;
    static final int SPEEDX = 4;
    static final int SPEEDY = 2;
    protected int boostSpeed;
    private static final int _$3084 = 6;
    private static final int _$3085 = 4;
    static final int LIVES = 3;
    private static final int _$3086 = 2000;
    protected int lives = 3;
    protected int score;
    protected int tempScore;
    protected int bonusPoints;
    protected int multiplier = 1;
    protected int bonusSpeedTimer;
    private static final int _$3087 = 3000;
    protected int timerDive;
    boolean diveUp = false;
    boolean jumpDown = false;
    boolean bonusSpeed = false;
    static final int WINSIZE = 3;
    protected JSObject[][] objectsMap;
    private int _$889;
    private JSObject _$3088;
    protected final int TILEBOUNDLEFT;
    protected final int TILEBOUNDRIGHT;
    protected final int TILEBOUNDUP;
    protected final int TILEBOUNDDOWN;

    public Player(Game game, int n, int n2, int n3) {
        super(n, n2, n3);
        this.TILEBOUNDLEFT = 8;
        this.TILEBOUNDRIGHT = 8;
        this.TILEBOUNDUP = 16;
        this.TILEBOUNDDOWN = 7;
        this._$147 = game;
        this._$4633 = game.getTileWorld();
        this.objectsMap = game.getObjectsMap();
        this._$520 = JetSkiMIDlet.getFXManager();
        this.speedY = 4 * Game.getSpeedFactor();
        this.speedX = 2 * Game.getSpeedFactor();
    }

    public void initialize() {
        this.bonusPoints = 0;
        this.tempScore = 0;
        this.score = 0;
        this.lives = 3;
        this.reset();
    }

    public void initLevelData() {
        this._$4633 = this._$147.getTileWorld();
        this.objectsMap = this._$147.getObjectsMap();
        this.bonusPoints = 0;
        this.multiplier = 1;
    }

    public void reset() {
        this.speedY = 0;
        this.speedX = 0;
        this.boostSpeed = 4;
        this.multiplier = 1;
        this.setState(0);
        this.setXY(88 - this.getWidth() / 2, 185 - this.getHeight() / 2);
        this.setMapXY(640, 2537);
    }

    void update() {
        this.checkCollision();
        if (this.state <= 3) {
            this.updateSkiing();
        } else if (this.state == 4 || this.state == 5) {
            this.updateJumping();
        } else if (this.state == 6) {
            this.updateDiving();
        }
        this.updateAnimation();
    }

    void updateSkiing() {
        if (this._$889 >= 1 && this._$889 <= 11) {
            Bonus bonus = (Bonus)this._$3088;
            if (!bonus.isCaught()) {
                this.catchBonus(bonus, this._$889);
                bonus.caught();
            }
        } else if (this._$889 == 19) {
            Ramp ramp = (Ramp)this._$3088;
            if (ramp.isPassThought()) {
                if (this.state == 0 || this.state == 3) {
                    this.setSpeedXY(0, 2);
                    this.setState(5);
                    this._$520.play(31);
                }
            } else {
                this.wreck();
            }
        } else if (this._$889 != 0) {
            if (this._$889 == 13) {
                this._$520.play(30);
            }
            this.wreck();
        }
        if (this.state == 0 || this.state == 3) {
            this.yCenterMap -= this.speedY;
            if (this.bonusSpeed) {
                if (this.bonusSpeedTimer < 2000) {
                    this.bonusSpeedTimer += this._$147.getUpdateTime();
                } else {
                    this.boostSpeed = 4;
                    this.bonusSpeed = false;
                    if (this.state == 3) {
                        this.setSpeedXY(4, this.boostSpeed);
                    } else {
                        this.setSpeedXY(4, 2);
                    }
                }
            }
        } else {
            this.yCenterMap -= this.speedY;
            if (this.state == 1) {
                this.xCenterMap += this.speedX;
            } else if (this.state == 2) {
                this.xCenterMap -= this.speedX;
            }
        }
    }

    void updateJumping() {
        if (this._$889 != 0) {
            this.wreck();
        }
        this.yCenterMap -= this.speedY;
        if (!this.jumpDown) {
            this.timerDive += this._$147.getUpdateTime();
            if (this.timerDive > 3000) {
                this.setMode(3);
                this.jumpDown = true;
                this.timerDive = 0;
            }
        } else if (this.isEnd()) {
            this.setSpeedXY(4, 2);
            this.setState(0);
            this.jumpDown = false;
        }
    }

    void updateDiving() {
        if (this._$889 != 0) {
            this.wreck();
        }
        this.yCenterMap -= this.speedY;
        if (!this.diveUp) {
            if (this.isEnd()) {
                this.setMode(3);
                this.diveUp = true;
            }
        } else if (this.isEnd()) {
            this.setState(0);
            this.diveUp = false;
        }
    }

    int checkCollision() {
        int n = this.xCenterMap >> 13;
        int n2 = this.yCenterMap >> 13;
        int n3 = Math.max(n - 2, 0);
        int n4 = Math.max(n2 - 2, 0);
        int n5 = Math.min(n + 2, 40);
        int n6 = Math.min(n2 + 2, 80);
        this._$3088 = null;
        this._$889 = 0;
        for (int i = n4; i < n6; ++i) {
            for (int j = n3; j < n5; ++j) {
                JSObject jSObject = this.objectsMap[i][j];
                if (jSObject != null && this._$889 == 0) {
                    int n7;
                    if (this.state <= 3) {
                        this._$3088 = jSObject;
                        this._$889 = jSObject.checkCollision(this);
                    } else if (this.state == 4) {
                        n7 = jSObject.getType();
                        if (n7 >= 15 && n7 <= 17) {
                            this._$3088 = jSObject;
                            this._$889 = jSObject.checkCollision(this);
                        }
                    } else if (this.state == 6 && (n7 = jSObject.getType()) >= 16 && n7 <= 21) {
                        this._$3088 = jSObject;
                        this._$889 = jSObject.checkCollision(this);
                    }
                }
                if (this._$889 != 0 || this.state == 5) continue;
                this._$889 = this.tileCollision(i, j);
            }
        }
        return this._$889;
    }

    public int tileCollision(int n, int n2) {
        int n3 = n2 << 5;
        int n4 = n << 5;
        int n5 = this.getXMap() - this.width / 2;
        int n6 = this.getYMap() - this.getHeight() / 2;
        byte by = this._$4633.getTileIndex(n, n2);
        if (by < 14 && n5 + this.width - 8 > n3 && n3 + 32 - 8 > n5 && n6 + this.getHeight() - 16 > n4 && n4 + 32 - 7 > n6) {
            return 17;
        }
        return 0;
    }

    public void KEYPRESSED(int n, int n2) {
        if (this.state == 0) {
            if (n == -3 || n == 52 || n == 53 || n == 42) {
                this.setState(2);
            } else if (n == -4 || n == 54 || n == 55 || n == 35) {
                this.setState(1);
            } else if (n2 == 8 || n == 50 || n == 57) {
                this.setSpeedXY(0, this.boostSpeed);
                this.setState(3);
            } else if (n2 == 1 || n == 49 || n == 48) {
                this.setState(4);
            } else if (n2 == 6 || n == 51 || n == 56) {
                this.setState(6);
            }
        }
    }

    public void KEYRELEASED(int n, int n2) {
        if (this.state == 3) {
            this.setSpeedXY(4, 2);
        } else if (this.state == 4) {
            this.setMode(3);
            this.jumpDown = true;
        }
        if (this.state != 4 && this.state != 6 && this.state != 7 && this.state != 5) {
            this.setState(0);
        }
    }

    void setState(int n) {
        if (n == 4) {
            this._$520.play(31);
            this.setMode(1);
            this.setFpsRatio(2);
            this.timerDive = 0;
        } else if (n == 6) {
            this._$520.play(32);
            this.setMode(1);
            this.setFpsRatio(3);
        } else if (n == 0) {
            this.setMode(0);
            this.setFpsRatio(3);
        } else if (n == 5) {
            this.setMode(1);
            this.setFpsRatio(6);
        } else if (n == 7) {
            this._$520.stopSound();
            this._$520.play(33);
            this.setMode(1);
            this.setFpsRatio(4);
        }
        this.selectAnimation(n);
        this.setXY(88 - this.getWidth() / 2, 185 - this.getHeight() / 2);
        this.state = n;
    }

    int getState() {
        return this.state;
    }

    void setMapXY(int n, int n2) {
        this.xCenterMap = n << 8;
        this.yCenterMap = n2 << 8;
    }

    int getXMap() {
        return this.xCenterMap >> 8;
    }

    int getYMap() {
        return this.yCenterMap >> 8;
    }

    int getScore() {
        return this.score;
    }

    int getTempScore() {
        return this.tempScore;
    }

    int getBonusPoint() {
        return this.bonusPoints;
    }

    int getMultiplier() {
        return this.multiplier;
    }

    int getLives() {
        return this.lives;
    }

    void setSpeedXY(int n, int n2) {
        this.speedX = n * Game.getSpeedFactor();
        this.speedY = n2 * Game.getSpeedFactor();
    }

    boolean isCollidable() {
        return this.state <= 3;
    }

    boolean isDive() {
        return this.state == 6;
    }

    void catchBonus(Bonus bonus, int n) {
        if (n == 1) {
            this.bonusPoints += 100;
            this.tempScore += 100;
            this._$520.play(20);
        } else if (n == 2) {
            this.bonusPoints += 200;
            this.tempScore += 200;
            this._$520.play(20);
        } else if (n == 3) {
            this.bonusPoints += 500;
            this.tempScore += 500;
            this._$520.play(20);
        } else if (n == 4) {
            this.bonusPoints += 1000;
            this.tempScore += 1000;
            this._$520.play(20);
        } else if (n == 5) {
            this._$147.increaseFuel(6000);
            this._$520.play(21);
        } else if (n == 6) {
            ++this.lives;
            this._$520.play(22);
        } else if (n == 7) {
            this.setSpeedXY(6, 4);
            this.boostSpeed = (this.speedY >> 8) + 2;
            this.bonusSpeed = true;
            this.bonusSpeedTimer = 0;
            this._$520.play(23);
        } else if (n == 9) {
            this.multiplier = 2;
            this._$520.play(24);
        } else if (n == 10) {
            this.multiplier = 3;
            this._$520.play(24);
        } else if (n == 11) {
            this.multiplier = 4;
            this._$520.play(24);
        }
        bonus.selectAnimation(1);
    }

    void wreck() {
        --this.lives;
        this.setSpeedXY(0, 0);
        this.setState(7);
        this._$147.raceStop();
    }

    void endGas() {
        --this.lives;
        this.setSpeedXY(0, 0);
        this.setState(0);
    }

    void computeScore(int n) {
        this.tempScore = this.score = n * this.multiplier / 6 + this.tempScore;
    }

    static {
        STRAIGHT = 0;
        RIGHT = 1;
        LEFT = (byte)2;
        BOOST = (byte)3;
        JUMP = (byte)4;
        RAMPJUMP = (byte)5;
        DIVE = (byte)6;
        WRECK = (byte)7;
        SPEEDX = 4;
        SPEEDY = 2;
        _$3084 = 6;
        _$3085 = 4;
        LIVES = 3;
        _$3086 = 2000;
        _$3087 = 3000;
        WINSIZE = 3;
    }
}

