/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.GameScreen;
import arcadia.game.NokiaGameCanvas;
import arcadia.game.jetski.Game;
import arcadia.game.jetski.HelpScr;
import arcadia.game.jetski.HighScoresScr;
import arcadia.game.jetski.JetSkiMIDlet;
import arcadia.game.jetski.MenuScr;
import arcadia.game.jetski.PlayIntroScr;
import arcadia.game.jetski.ResourceManager;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JSCanvas
extends NokiaGameCanvas {
    protected JetSkiMIDlet midlet;
    private ResourceManager _$4793;
    private Game _$147;
    private MenuScr _$4983;
    protected GameScreen currentScreen;
    private int _$4984;
    public static final byte MENU_SCR = 0;
    public static final byte PLAYGAME_SCR = 1;
    public static final byte HIGHSCORES_SCR = 3;
    public static final byte HELP_SCR = 4;
    public static final byte CREDITS_SCR = 5;
    public static final byte PLAYINTRO_SCR = 6;
    public static final int WIDTH = 176;
    public static final int HEIGHT = 208;
    public static final byte KEY_SCRLEFT = -6;
    public static final byte KEY_SCRRIGHT = -7;
    public static final byte KEY_CANC = -8;
    public static final byte KEY_PENCIL = -50;
    static final byte[] BGPATTERN1;
    static final byte[] BGPATTERN2;
    static final byte[] BGPATTERN3;
    static final byte[] BGPATTERN4;
    static final byte[] BGPATTERN5;
    static final byte LABELSNUM = 5;

    public JSCanvas(JetSkiMIDlet jetSkiMIDlet, ResourceManager resourceManager) {
        this.midlet = jetSkiMIDlet;
        this._$4793 = resourceManager;
        this.setFps(15);
        this._$147 = new Game(this);
        this.currentScreen = new MenuScr(this, 0);
    }

    public JSCanvas(JetSkiMIDlet jetSkiMIDlet) {
        this.midlet = jetSkiMIDlet;
        this.currentScreen = new MenuScr(this, 3);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width, this.height);
        this.currentScreen.paint(graphics);
    }

    protected void KEYPRESSED(int n) {
        int n2 = this.getGameAction(n);
        this.currentScreen.KEYPRESSED(n, n2);
        this.midlet.checkErrors();
    }

    protected void KEYRELEASED(int n) {
        int n2 = this.getGameAction(n);
        this.currentScreen.KEYRELEASED(n, n2);
    }

    public static void fillAlphaRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{n, n, n + n3, n + n3};
        int[] nArray2 = new int[]{n2, n2 + n4, n2 + n4, n2};
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics(graphics);
        directGraphics.fillPolygon(nArray, 0, nArray2, 0, 4, n5);
    }

    public static void drawShadowText(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, Graphics graphics) {
        graphics.setColor(n5);
        graphics.drawString(string, n + n3, n2 + n4, n7);
        graphics.setColor(n6);
        graphics.drawString(string, n, n2, n7);
    }

    public static void drawBackground(Image image, int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = image.getWidth();
        int n6 = image.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                graphics.drawImage(image, n + i * n5, n2 + j * n6, 20);
            }
        }
    }

    public static void drawTilePattern(Image image, int n, int n2, int n3, byte[] byArray, Graphics graphics) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < byArray.length; ++j) {
                byte by = byArray[j];
                int n4 = by % 6;
                int n5 = by / 6;
                int n6 = i * 32 - n;
                int n7 = j * 32 - n2;
                graphics.setClip(n6, n7, 32, 32);
                graphics.drawImage(image, n6 - n4 * 32, n7 - n5 * 32, 20);
            }
        }
        graphics.setClip(0, 0, 176, 208);
    }

    static void drawSetting(boolean bl, int n, int n2, int n3, Graphics graphics) {
        if (bl) {
            JSCanvas.drawShadowText(ResourceManager.STR_ON, n, n2, 1, 1, 0, n3, 20, graphics);
        } else {
            JSCanvas.drawShadowText(ResourceManager.STR_OFF, n, n2, 1, 1, 0, n3, 20, graphics);
        }
    }

    public Game getGame() {
        return this._$147;
    }

    public JetSkiMIDlet getMidlet() {
        return this.midlet;
    }

    public void selectScreen(int n) {
        switch (n) {
            case 0: {
                this.currentScreen = new MenuScr(this, 1);
                break;
            }
            case 3: {
                this.currentScreen = new HighScoresScr(this);
                break;
            }
            case 4: {
                this.currentScreen = new HelpScr(this);
                break;
            }
            case 1: {
                this._$147.initialize();
                this.currentScreen = this._$147;
                break;
            }
            case 5: {
                this.currentScreen = new MenuScr(this, 2);
                break;
            }
            case 6: {
                this.currentScreen = new PlayIntroScr(this);
            }
        }
        this._$4984 = n;
    }

    protected void hideNotify() {
        this.pauseGame();
    }

    public void pauseGame() {
        if (this._$4984 == 1) {
            ((Game)this.currentScreen).setMenu(true);
        }
    }

    static {
        MENU_SCR = 0;
        PLAYGAME_SCR = 1;
        HIGHSCORES_SCR = (byte)3;
        HELP_SCR = (byte)4;
        CREDITS_SCR = (byte)5;
        PLAYINTRO_SCR = (byte)6;
        WIDTH = 176;
        HEIGHT = 208;
        KEY_SCRLEFT = (byte)-6;
        KEY_SCRRIGHT = (byte)-7;
        KEY_CANC = (byte)-8;
        KEY_PENCIL = (byte)-50;
        BGPATTERN1 = new byte[]{17, 16, 15, 14, 25, 24, 23};
        BGPATTERN2 = new byte[]{21, 20, 15, 14, 21, 20, 15};
        BGPATTERN3 = new byte[]{15, 14, 25, 25, 21, 20, 19};
        BGPATTERN4 = new byte[]{15, 20, 15, 20, 15, 20, 19};
        BGPATTERN5 = new byte[]{25, 24, 23, 25, 24, 23, 22};
        LABELSNUM = (byte)5;
    }
}

