/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.AnimSprite;
import arcadia.game.Sprite;
import arcadia.game.jetski.JSObject;

public class AnimObject
extends AnimSprite
implements JSObject {
    protected int startX;
    protected int startY;
    protected int xMap;
    protected int yMap;
    protected int bBoxLeft = 7;
    protected int bBoxRight = 7;
    protected int bBoxUp = 7;
    protected int bBoxDown = 7;
    protected boolean collided = false;
    protected int type;
    protected JSObject[][] objectsMap;
    protected int mapRow;
    protected int mapColumn;

    public AnimObject(int n, int n2) {
        super(n, 0, 0);
        this.type = n2;
    }

    public AnimObject(AnimObject animObject) {
        super(animObject);
        this.xMap = animObject.xMap;
        this.yMap = animObject.yMap;
        this.bBoxLeft = animObject.bBoxLeft;
        this.bBoxRight = animObject.bBoxRight;
        this.bBoxUp = animObject.bBoxUp;
        this.bBoxDown = animObject.bBoxDown;
        this.type = animObject.type;
        this.collided = animObject.collided;
    }

    public void initialize() {
        this.collided = false;
        this.selectAnimation(0);
        this.randomize();
    }

    public void initGridPosition(JSObject[][] jSObjectArray, int n, int n2) {
        this.objectsMap = jSObjectArray;
        this.mapRow = n;
        this.mapColumn = n2;
    }

    public void setMapXY(int n, int n2) {
        this.xMap = n << 8;
        this.yMap = n2 << 8;
        this.startX = this.xMap;
        this.startY = this.yMap;
    }

    public int getXMap() {
        return this.xMap >> 8;
    }

    public int getYMap() {
        return this.yMap >> 8;
    }

    public int getType() {
        return this.type;
    }

    public void setBoundingBox(int n, int n2, int n3, int n4) {
        this.bBoxLeft = n;
        this.bBoxRight = n2;
        this.bBoxUp = n3;
        this.bBoxDown = n4;
    }

    public void update() {
        this.updateAnimation();
    }

    public int checkCollision(Sprite sprite) {
        boolean bl = this.collided = sprite.getX() + sprite.getWidth() - this.bBoxLeft > this.x && this.x + this.width - this.bBoxRight > sprite.getX() && sprite.getY() + sprite.getHeight() - this.bBoxUp > this.y && this.y + this.height - this.bBoxDown > sprite.getY();
        if (this.collided) {
            return this.type;
        }
        return 0;
    }

    public void updatePosition() {
        int n = this.getXMap() >> 5;
        int n2 = this.getYMap() >> 5;
        if (n != this.mapColumn || n2 != this.mapRow) {
            this.objectsMap[this.mapRow][this.mapColumn] = null;
            this.objectsMap[n2][n] = this;
            this.mapRow = n2;
            this.mapColumn = n;
        }
    }
}

