/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.jetski.AnimObject;
import arcadia.game.jetski.Game;
import arcadia.game.jetski.JSObject;

public class Shark
extends AnimObject
implements JSObject {
    static final byte UPRIGHT = 0;
    static final byte UPLEFT = 1;
    static final byte DOWNLEFT = 2;
    static final byte DOWNRIGHT = 3;
    protected static byte[] steps;
    protected int pathX;
    protected int currentPath;
    protected int stepX;
    protected int stepY;
    protected static final int PATHSIZEX = 15360;
    protected static final int STEPX = 3;
    protected static final int STEPY = 1;

    public Shark(int n, int n2) {
        super(n, n2);
        this.stepX = 3 * Game.getSpeedFactor();
        this.stepY = 1 * Game.getSpeedFactor();
    }

    public Shark(Shark shark) {
        super(shark);
        this.stepX = shark.stepX;
        this.stepY = shark.stepY;
    }

    public void initialize() {
        super.initialize();
        this.stepX = 3 * Game.getSpeedFactor();
        this.stepY = 1 * Game.getSpeedFactor();
        this.pathX = 0;
        this.currentPath = Math.abs(this.hashCode()) % (steps.length / 3) * 3;
        this.selectAnimation(steps[this.currentPath]);
        this.xMap = this.startX + 15360 * (steps.length / 2 - Math.abs(steps.length / 2 - this.currentPath)) / 3;
        this.yMap = this.startY - 15360 * (this.currentPath % 2);
    }

    public void update() {
        if (this.collided) {
            this.stepY = 0;
            this.stepX = 0;
        } else if (this.pathX < 15360) {
            this.pathX += this.stepX;
            this.xMap += this.stepX * steps[this.currentPath + 1];
            this.yMap += this.stepY * steps[this.currentPath + 2];
            this.updatePosition();
        } else {
            this.currentPath = (this.currentPath + 3) % steps.length;
            this.selectAnimation(steps[this.currentPath]);
            this.pathX = 0;
        }
        this.updateAnimation();
    }

    static {
        UPRIGHT = 0;
        UPLEFT = 1;
        DOWNLEFT = (byte)2;
        DOWNRIGHT = (byte)3;
        steps = new byte[]{0, 1, -1, 3, 1, 1, 0, 1, -1, 3, 1, 1, 0, 1, -1, 3, 1, 1, 1, -1, -1, 2, -1, 1, 1, -1, -1, 2, -1, 1, 1, -1, -1, 2, -1, 1};
        PATHSIZEX = 15360;
        STEPX = 3;
        STEPY = 1;
    }
}

