/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.jetski.AnimObject;
import arcadia.game.jetski.Game;
import arcadia.game.jetski.JSObject;

public class Mine
extends AnimObject
implements JSObject {
    static final byte NORMAL = 0;
    static final byte BLAST = 1;
    static final byte DEBRIS = 2;
    protected int nextSpot;
    protected int stepX;
    protected int xVersus;
    protected static final byte STEPX = 1;
    protected static final int PATHSIZEX = 90112;
    protected static int[] spots;

    public Mine(int n, int n2) {
        super(n, n2);
        this.stepX = 1 * Game.getSpeedFactor();
    }

    public Mine(Mine mine) {
        super(mine);
        this.stepX = mine.stepX;
    }

    public void initialize() {
        super.initialize();
        this.selectAnimation(0);
        this.setMode(0);
        int n = Math.abs(this.hashCode());
        this.nextSpot = n % spots.length;
        this.xMap = this.startX + n % 90112;
        this.xVersus = (this.startX + spots[this.nextSpot] - this.xMap) / Math.abs(this.startX + spots[this.nextSpot] - this.xMap);
        this.stepX = 1 * Game.getSpeedFactor() * this.xVersus;
    }

    public void update() {
        if (this.collided) {
            if (this.currentAnim == 0) {
                this.stepX = 0;
                this.setMode(1);
                this.selectAnimation(1);
            } else if (this.currentAnim == 1 && this.isEnd()) {
                this.setMode(0);
                this.selectAnimation(2);
            }
        } else {
            int n = (this.xMap - (spots[this.nextSpot] + this.startX)) * this.xVersus;
            if (n < 0) {
                this.xMap += this.stepX;
                this.updatePosition();
            } else {
                this.nextSpot = (this.nextSpot + 1) % spots.length;
                this.xVersus = (this.startX + spots[this.nextSpot] - this.xMap) / Math.abs(this.startX + spots[this.nextSpot] - this.xMap);
                this.stepX = 1 * Game.getSpeedFactor() * this.xVersus;
            }
        }
        this.updateAnimation();
    }

    static {
        NORMAL = 0;
        BLAST = 1;
        DEBRIS = (byte)2;
        STEPX = 1;
        PATHSIZEX = 90112;
        spots = new int[]{0, 90112};
    }
}

