/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.GameScreen;
import arcadia.game.Sprite;
import arcadia.game.TileWorld;
import arcadia.game.jetski.AnimObject;
import arcadia.game.jetski.Bonus;
import arcadia.game.jetski.DebugScreen;
import arcadia.game.jetski.FXManager;
import arcadia.game.jetski.Foe;
import arcadia.game.jetski.JSCanvas;
import arcadia.game.jetski.JSObject;
import arcadia.game.jetski.JetSkiMIDlet;
import arcadia.game.jetski.Mine;
import arcadia.game.jetski.Obstacle;
import arcadia.game.jetski.Player;
import arcadia.game.jetski.Ramp;
import arcadia.game.jetski.ResourceManager;
import arcadia.game.jetski.Shark;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
extends GameScreen {
    private JSCanvas _$428;
    private ResourceManager _$519;
    private FXManager _$520;
    private boolean _$521 = false;
    private boolean _$522 = false;
    private boolean _$523 = false;
    private boolean _$524 = false;
    private TileWorld _$4633;
    static final int TILESNUMCRASH = 14;
    static final int TILESCOLUMNS = 6;
    static final int TILEROWS = 5;
    static final int WORLDROWS = 80;
    static final int WORLDCOLUMNS = 40;
    static final int TILEBITS = 5;
    static final int TILESIZE = 32;
    static final int WORLDWIDTH = 1280;
    static final int WORLDHEIGHT = 2560;
    static final int SPEEDOV = 6;
    private int _$532;
    private int _$533;
    static final int BARHEIGHT = 40;
    static final int PLAYHEIGHT = 168;
    static final int PLAYERY = 145;
    static final int MENUCOLUMNS = 8;
    static final int MENUROWS = 5;
    private int _$539;
    static final byte CHOICEMUSIC = 2;
    static final byte CHOICESOUND = 3;
    private Image _$543;
    private Image _$4638;
    int labelX = 0;
    private byte _$545;
    private Player _$547;
    int state = 0;
    static final byte IDLE = 0;
    static final byte START = 1;
    static final byte RUNNING = 2;
    static final byte FINISH = 3;
    static final byte SCORES = 4;
    static final byte RACESTOP = 5;
    static final byte ENDTIME = 6;
    static final byte GAMEOVER = 7;
    static final byte ENDGAME = 8;
    static final byte OVERVIEW = 9;
    static final byte TESTING = 127;
    public static final byte FP_SHIFT = 8;
    public static final int STEPUNIT = 256;
    static final int RACEFUEL = 60000;
    private static final int _$561 = 12000;
    private static final int _$562 = 4000;
    private static final int _$563 = 2500;
    private static final int _$564 = 2800;
    private static final int _$565 = 3000;
    private static final int _$566 = 3000;
    private static final int _$567 = 400;
    private static int _$568;
    private int _$569;
    private int _$570 = 60000;
    private int _$571;
    static final int FINISHLINEY = 32;
    public static final byte NUMLEVELS = 10;
    private int _$574;
    private int _$575;
    private boolean _$576 = false;
    static final byte OBJ_NONE = 0;
    static final byte OBJ_BONUSP1 = 1;
    static final byte OBJ_BONUSP2 = 2;
    static final byte OBJ_BONUSP3 = 3;
    static final byte OBJ_BONUSP4 = 4;
    static final byte OBJ_BONUSTIME = 5;
    static final byte OBJ_BONUSLIFE = 6;
    static final byte OBJ_BONUSSPEED = 7;
    static final byte OBJ_BONUSINV = 8;
    static final byte OBJ_BONUSMULTI1 = 9;
    static final byte OBJ_BONUSMULTI2 = 10;
    static final byte OBJ_BONUSMULTI3 = 11;
    static final byte OBJ_MINE = 13;
    static final byte OBJ_BUOYSMALL = 14;
    static final byte OBJ_BUOY = 15;
    static final byte OBJ_STAKE = 16;
    static final byte OBJ_ROCKMEDIUM = 17;
    static final byte OBJ_ROCKSMALL = 18;
    static final byte OBJ_RAMP = 19;
    static final byte OBJ_OCTOPUS = 20;
    static final byte OBJ_SHARK = 21;
    private static final int _$599 = 48;
    private static final int _$600 = 48;
    private int _$601;
    private int _$602;
    private int _$603;
    private int _$604;
    JSObject[][] objectsMap;
    private int _$607;
    private JSObject[] _$608;
    private boolean _$874;
    private boolean _$875;
    private boolean _$876;
    private boolean _$877;
    private int _$878 = 12;
    private int _$879 = 12;
    private long _$880;

    public Game(JSCanvas jSCanvas) {
        this._$428 = jSCanvas;
        this._$519 = JetSkiMIDlet.getResourceManager();
        this._$520 = JetSkiMIDlet.getFXManager();
        this._$569 = _$568 = jSCanvas.getFrameTime();
        this._$4638 = ResourceManager.IMG_ALPHAGRID;
        this._$547 = new Player(this, 8, 0, 0);
        this._$547.setAnimation(ResourceManager.IMG_PLYRSTRAIGHT, 2, 0);
        this._$547.setAnimation(ResourceManager.IMG_PLYRBOOST, 2, 3);
        this._$547.setAnimation(ResourceManager.IMG_PLYRLEFT, 2, 2);
        this._$547.setAnimation(ResourceManager.IMG_PLYRRIGHT, 2, 1);
        this._$547.setAnimation(ResourceManager.IMG_PLYRJUMP, 4, 4);
        this._$547.setAnimation(ResourceManager.IMG_PLYRJUMP, 4, 5);
        this._$547.setAnimation(ResourceManager.IMG_PLYRWRECK, 5, 7);
        this._$547.setAnimation(ResourceManager.IMG_PLYRDIVE, 5, 6);
        this._$547.selectAnimation(0);
        this._$547.setFpsRatio(4);
    }

    public void initialize() {
        this._$571 = 0;
        this._$571 = 0;
        this._$570 = 60000;
        this._$547.initialize();
        this._$630();
        this._$631();
    }

    public void initLevel(int n) {
        this._$574 = n;
        this._$4633 = null;
        this.objectsMap = null;
        this._$608 = null;
        this._$547.initLevelData();
        System.gc();
        byte[][] byArray = this._$4641();
        this._$4633 = new TileWorld(byArray, ResourceManager.IMG_TILES, 6, 5, 0, 40, 176, 168);
        this._$4633.setWinXY(0, 0);
        this.objectsMap = new JSObject[80][40];
        this._$641();
        this._$547.initLevelData();
        this._$570 = 60000;
        System.gc();
    }

    public void initAllObject() {
        for (int i = 0; i < 80; ++i) {
            for (int j = 0; j < 40; ++j) {
                JSObject jSObject = this.objectsMap[i][j];
                if (jSObject == null) continue;
                jSObject.initialize();
            }
        }
    }

    private byte[][] _$4641() {
        byte[][] byArray = new byte[80][40];
        boolean bl = false;
        InputStream inputStream = this._$519.loadStream("map.dat", this._$574);
        try {
            for (int i = 0; i < 80; ++i) {
                for (int j = 0; j < 40; ++j) {
                    byArray[i][j] = (byte)inputStream.read();
                }
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            DebugScreen.log("Unable to load tiles map");
        }
        return byArray;
    }

    private void _$641() {
        int n = 3200;
        byte[] byArray = new byte[n];
        InputStream inputStream = this._$519.loadStream("objectsmap.dat", this._$574);
        try {
            inputStream.read(byArray, 0, n);
            inputStream.close();
        }
        catch (Exception exception) {
            DebugScreen.log("Unable to load objects map");
        }
        Obstacle obstacle = new Obstacle(1, 17);
        obstacle.setAnimation(ResourceManager.IMG_ROCKMID, 1, 0);
        obstacle.setBoundingBox(8, 8, 9, 5);
        Obstacle obstacle2 = new Obstacle(1, 18);
        obstacle2.setAnimation(ResourceManager.IMG_ROCKSMALL, 1, 0);
        obstacle2.setBoundingBox(6, 7, 9, 1);
        Obstacle obstacle3 = new Obstacle(1, 15);
        obstacle3.setAnimation(ResourceManager.IMG_BUOY, 2, 0);
        obstacle3.selectAnimation(0);
        obstacle3.setFpsRatio(10);
        obstacle3.setBoundingBox(9, 11, 27, 5);
        Obstacle obstacle4 = new Obstacle(1, 14);
        obstacle4.setAnimation(ResourceManager.IMG_BUOYSMALL, 2, 0);
        obstacle4.selectAnimation(0);
        obstacle4.setFpsRatio(16);
        obstacle4.setBoundingBox(7, 6, 12, 4);
        Obstacle obstacle5 = new Obstacle(1, 16);
        obstacle5.setAnimation(ResourceManager.IMG_STAKE, 2, 0);
        obstacle5.selectAnimation(0);
        obstacle5.setFpsRatio(10);
        obstacle5.setBoundingBox(13, 15, 20, 7);
        Ramp ramp = new Ramp(1, 19);
        ramp.setAnimation(ResourceManager.IMG_RAMP, 2, 0);
        ramp.selectAnimation(0);
        ramp.setFpsRatio(10);
        ramp.setBoundingBox(11, 8, 11, 6);
        Mine mine = new Mine(3, 13);
        mine.setAnimation(ResourceManager.IMG_MINE, 2, 0);
        mine.setAnimation(ResourceManager.IMG_MINEBLAST, 4, 1);
        mine.setAnimation(ResourceManager.IMG_MINEDEBRIS, 2, 2);
        mine.selectAnimation(0);
        mine.setFpsRatio(10);
        mine.setBoundingBox(7, 10, 12, 6);
        Shark shark = new Shark(4, 21);
        shark.setAnimation(ResourceManager.IMG_SHARKUR, 2, 0);
        shark.setAnimation(ResourceManager.IMG_SHARKUL, 2, 1);
        shark.setAnimation(ResourceManager.IMG_SHARKDR, 2, 3);
        shark.setAnimation(ResourceManager.IMG_SHARKDL, 2, 2);
        shark.selectAnimation(0);
        shark.setFpsRatio(4);
        shark.setBoundingBox(7, 7, 11, 7);
        Foe foe = new Foe(3, 20);
        foe.setAnimation(ResourceManager.IMG_OCTLEFT, 5, 0);
        foe.setAnimation(ResourceManager.IMG_OCTRIGHT, 5, 1);
        foe.setAnimation(ResourceManager.IMG_OCTWATER, 2, 2);
        foe.selectAnimation(2);
        foe.setFpsRatio(4);
        foe.setBoundingBox(7, 7, 17, 3);
        Bonus bonus = new Bonus(2, 1);
        bonus.setAnimation(ResourceManager.IMG_BNSP1, 2, 0);
        bonus.setAnimation(ResourceManager.IMG_BNSP1C, 1, 1);
        bonus.selectAnimation(0);
        bonus.setFpsRatio(10);
        Bonus bonus2 = new Bonus(2, 2);
        bonus2.setAnimation(ResourceManager.IMG_BNSP2, 2, 0);
        bonus2.setAnimation(ResourceManager.IMG_BNSP2C, 1, 1);
        bonus2.selectAnimation(0);
        bonus2.setFpsRatio(10);
        Bonus bonus3 = new Bonus(2, 3);
        bonus3.setAnimation(ResourceManager.IMG_BNSP3, 2, 0);
        bonus3.setAnimation(ResourceManager.IMG_BNSP3C, 1, 1);
        bonus3.selectAnimation(0);
        bonus3.setFpsRatio(10);
        Bonus bonus4 = new Bonus(2, 4);
        bonus4.setAnimation(ResourceManager.IMG_BNSP4, 2, 0);
        bonus4.setAnimation(ResourceManager.IMG_BNSP4C, 1, 1);
        bonus4.selectAnimation(0);
        bonus4.setFpsRatio(10);
        Bonus bonus5 = new Bonus(2, 5);
        bonus5.setAnimation(ResourceManager.IMG_BNSFUEL, 2, 0);
        bonus5.setAnimation(ResourceManager.IMG_BNSFUELC, 1, 1);
        bonus5.selectAnimation(0);
        bonus5.setFpsRatio(10);
        Bonus bonus6 = new Bonus(2, 6);
        bonus6.setAnimation(ResourceManager.IMG_BNSLIFE, 2, 0);
        bonus6.setAnimation(ResourceManager.IMG_BNSLIFEC, 1, 1);
        bonus6.selectAnimation(0);
        bonus6.setFpsRatio(10);
        Bonus bonus7 = new Bonus(2, 7);
        bonus7.setAnimation(ResourceManager.IMG_BNSSPEED, 3, 0);
        bonus7.setAnimation(ResourceManager.IMG_BNSSPEEDC, 1, 1);
        bonus7.selectAnimation(0);
        bonus7.setFpsRatio(2);
        Bonus bonus8 = new Bonus(2, 9);
        bonus8.setAnimation(ResourceManager.IMG_BNSMULTI, 2, 0);
        bonus8.setAnimation(ResourceManager.IMG_BNSMULTIC1, 1, 1);
        bonus8.selectAnimation(0);
        bonus8.setFpsRatio(10);
        Bonus bonus9 = new Bonus(2, 10);
        bonus9.setAnimation(ResourceManager.IMG_BNSMULTI, 2, 0);
        bonus9.setAnimation(ResourceManager.IMG_BNSMULTIC2, 1, 1);
        bonus9.selectAnimation(0);
        bonus9.setFpsRatio(10);
        Bonus bonus10 = new Bonus(2, 11);
        bonus10.setAnimation(ResourceManager.IMG_BNSMULTI, 2, 0);
        bonus10.setAnimation(ResourceManager.IMG_BNSMULTIC3, 1, 1);
        bonus10.selectAnimation(0);
        bonus10.setFpsRatio(10);
        int n2 = 0;
        for (int i = 0; i < 80; ++i) {
            for (int j = 0; j < 40; ++j) {
                int n3 = j + i * 40;
                byte by = byArray[n3];
                if (by == 0) continue;
                AnimObject animObject = null;
                switch (by) {
                    case 17: {
                        animObject = new Obstacle(obstacle);
                        break;
                    }
                    case 18: {
                        animObject = new Obstacle(obstacle2);
                        break;
                    }
                    case 13: {
                        Mine mine2 = new Mine(mine);
                        mine2.initGridPosition(this.objectsMap, i, j);
                        animObject = mine2;
                        break;
                    }
                    case 15: {
                        animObject = new Obstacle(obstacle3);
                        break;
                    }
                    case 14: {
                        animObject = new Obstacle(obstacle4);
                        break;
                    }
                    case 16: {
                        animObject = new Obstacle(obstacle5);
                        break;
                    }
                    case 19: {
                        animObject = new Ramp(ramp);
                        break;
                    }
                    case 21: {
                        Shark shark2 = new Shark(shark);
                        shark2.initGridPosition(this.objectsMap, i, j);
                        animObject = shark2;
                        break;
                    }
                    case 20: {
                        Foe foe2 = new Foe(foe);
                        foe2.initGridPosition(this.objectsMap, i, j);
                        animObject = foe2;
                        break;
                    }
                    case 1: {
                        animObject = new Bonus(bonus);
                        break;
                    }
                    case 2: {
                        animObject = new Bonus(bonus2);
                        break;
                    }
                    case 3: {
                        animObject = new Bonus(bonus3);
                        break;
                    }
                    case 4: {
                        animObject = new Bonus(bonus4);
                        break;
                    }
                    case 5: {
                        animObject = new Bonus(bonus5);
                        break;
                    }
                    case 6: {
                        animObject = new Bonus(bonus6);
                        break;
                    }
                    case 7: {
                        animObject = new Bonus(bonus7);
                        break;
                    }
                    case 9: {
                        animObject = new Bonus(bonus8);
                        break;
                    }
                    case 10: {
                        animObject = new Bonus(bonus9);
                        break;
                    }
                    case 11: {
                        animObject = new Bonus(bonus10);
                    }
                }
                if (animObject != null) {
                    int n4 = ((Sprite)animObject).getWidth();
                    int n5 = ((Sprite)animObject).getHeight();
                    animObject.setMapXY(j * 32 + 16 - n4 / 2, i * 32 + 16 - n5 / 2);
                    this.objectsMap[i][j] = animObject;
                }
                ++n2;
            }
        }
        this._$608 = new JSObject[n2];
    }

    public void update() {
        block1: {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                block2: {
                                    block0: {
                                        if (this.state != 2) break block0;
                                        this._$707();
                                        break block1;
                                    }
                                    if (this.state != 5) break block2;
                                    this._$708();
                                    break block1;
                                }
                                if (this.state != 6) break block3;
                                this._$709();
                                break block1;
                            }
                            if (this.state != 1) break block4;
                            this._$710();
                            break block1;
                        }
                        if (this.state != 7) break block5;
                        this._$711();
                        break block1;
                    }
                    if (this.state != 3) break block6;
                    this._$712();
                    break block1;
                }
                if (this.state != 4) break block7;
                this._$713();
                break block1;
            }
            if (this.state != 9) break block1;
            this._$714();
        }
    }

    private void _$707() {
        this._$716();
        this._$631();
        this._$547.update();
        this._$570 -= this._$569;
        if (this._$570 < this._$569) {
            this._$717();
        } else if (this._$533 < 32) {
            this._$718();
        }
    }

    private void _$708() {
        this._$716();
        this._$631();
        this._$547.update();
        this._$571 += _$568;
        if (this._$571 > 4000) {
            if (this._$547.getLives() <= 0) {
                this._$720();
            } else {
                if (this._$570 < 12000) {
                    this._$570 = 12000;
                }
                this._$721();
            }
        }
    }

    private void _$709() {
        this._$716();
        this._$631();
        this._$547.update();
        this._$571 += _$568;
        if (this._$571 > 3000) {
            if (this._$547.getLives() <= 0) {
                this._$720();
            } else {
                this._$570 = 60000;
                this._$721();
            }
        }
    }

    private void _$714() {
        if (this._$533 > 2386) {
            this._$721();
        } else {
            this._$547.setXY(88 - this._$547.getWidth() / 2, this._$547.getYMap() + this._$547.getHeight() / 2 - this._$533);
            this._$533 += 6;
            this._$4633.setWinXY(this._$532, this._$533);
            this._$631();
        }
    }

    private void _$710() {
        this._$716();
        this._$631();
        this._$547.update();
        this._$571 += _$568;
        if (this._$571 > 2500) {
            this._$725();
        }
    }

    private void _$711() {
        this._$716();
        this._$631();
        this._$571 += _$568;
        if (this._$571 > 3000) {
            if (this._$576) {
                this._$428.selectScreen(0);
            } else {
                this._$428.selectScreen(3);
            }
        }
    }

    private void _$712() {
        this._$716();
        this._$631();
        this._$547.update();
        this._$571 += _$568;
        if (this._$571 > 2800) {
            this._$729();
        }
    }

    private void _$713() {
        this._$631();
        this._$571 += _$568;
    }

    private void _$716() {
        this._$532 = this._$547.getXMap() - 88;
        this._$533 = this._$547.getYMap() - 145;
        this._$4633.setWinXY(this._$532, this._$533);
    }

    private void _$631() {
        int n = this._$547.getXMap() >> 5;
        this._$601 = Math.max(0, n - 14);
        this._$602 = Math.min(n + 13, 40);
        this._$603 = this._$533 < 48 ? 0 : this._$533 - 48 >> 5;
        this._$604 = this._$533 + 168 + 32 > 2560 ? 80 : (this._$533 + 168 >> 5) + 1;
        this._$607 = 0;
        for (int i = this._$603; i < this._$604; ++i) {
            for (int j = this._$601; j < this._$602; ++j) {
                JSObject jSObject = this.objectsMap[i][j];
                if (jSObject == null) continue;
                jSObject.update();
                int n2 = jSObject.getXMap() - this._$532;
                int n3 = jSObject.getYMap() - this._$533 + 40;
                jSObject.setXY(n2, n3);
                this._$608[this._$607] = jSObject;
                ++this._$607;
            }
        }
    }

    public void refreshFrame(Graphics graphics) {
        if (!this._$521) {
            this.update();
        }
        this._$739(graphics);
        if (this._$522) {
            this._$740(graphics);
        }
    }

    private void _$739(Graphics graphics) {
        block1: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block3: {
                                    block2: {
                                        block0: {
                                            if (this.state != 2) break block0;
                                            this._$741(graphics);
                                            break block1;
                                        }
                                        if (this.state != 5) break block2;
                                        this._$742(graphics);
                                        break block1;
                                    }
                                    if (this.state != 6) break block3;
                                    this._$743(graphics);
                                    break block1;
                                }
                                if (this.state != 1) break block4;
                                this._$744(graphics);
                                break block1;
                            }
                            if (this.state != 7) break block5;
                            this._$745(graphics);
                            break block1;
                        }
                        if (this.state != 3) break block6;
                        this._$746(graphics);
                        break block1;
                    }
                    if (this.state != 4) break block7;
                    this._$747(graphics);
                    break block1;
                }
                if (this.state != 8) break block8;
                this._$748(graphics);
                break block1;
            }
            if (this.state != 9) break block1;
            this._$749(graphics);
        }
    }

    private void _$749(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$547.drawSprite(graphics);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(String.valueOf(String.valueOf(ResourceManager.STR_OVRLEVEL)).concat(String.valueOf(String.valueOf(this._$574))), 88, 124, 1, 1, 0, 16753223, 65, graphics);
        Game.drawMenuLabel(graphics);
    }

    private void _$744(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$547.drawSprite(graphics);
        this._$770(this._$571, 2500);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(ResourceManager.STR_GETREADY, this.labelX, 124, 1, 1, 0, 0xFFFF00, 65, graphics);
        Game.drawMenuLabel(graphics);
    }

    private void _$743(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$770(this._$571, 3000);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(ResourceManager.STR_OUTGAS, this.labelX, 124, 1, 1, 0, 65280, 65, graphics);
        Game.drawMenuLabel(graphics);
    }

    private void _$745(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$770(this._$571, 3000);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(ResourceManager.STR_GAMEOVER, this.labelX, 124, 1, 1, 0, 0xFF0000, 65, graphics);
        Game.drawMenuLabel(graphics);
    }

    private void _$746(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$770(this._$571, 2800);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(ResourceManager.STR_ENDLEVEL, this.labelX, 124, 1, 1, 0, 0xFF9797, 65, graphics);
        Game.drawMenuLabel(graphics);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _$747(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block12: {
            this._$4633.drawTiles(graphics);
            this._$752(graphics);
            this._$753(graphics);
            int n6 = 88 - this._$4638.getWidth() * 9 / 2;
            n5 = 124 - this._$4638.getHeight() * 6 / 2;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (this._$523) {
                if (this._$571 < 400) {
                    n = n6 - 176 * this._$571 / 400;
                    n3 = n2 = n + 10;
                    n4 = n2;
                    break block12;
                } else {
                    if (this._$576) {
                        this._$576 = false;
                        this._$428.selectScreen(0);
                        return;
                    }
                    if (this._$574 < 10) {
                        this.loadNextLevel();
                        return;
                    }
                    this._$785();
                    return;
                }
            }
            n = n6;
            if (this._$571 < 400) {
                n4 = n6 + 10 + (176 - 176 * this._$571 / 400);
                n3 = 176;
                n2 = 176;
            } else if (this._$571 < 800) {
                n4 = n6 + 10;
                n3 = n6 + 10 + (176 - 176 * (this._$571 - 400) / 400);
                n2 = 176;
            } else if (this._$571 < 1200) {
                n4 = n6 + 10;
                n3 = n6 + 10;
                n2 = n6 + 10 + (176 - 176 * (this._$571 - 800) / 400);
            } else {
                n3 = n2 = n6 + 10;
                n4 = n2;
            }
        }
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        if (this._$576) {
            this._$786(graphics);
        }
        n5 = 90;
        JSCanvas.drawBackground(this._$4638, n, n5, 9, 5, graphics);
        JSCanvas.drawShadowText(String.valueOf(String.valueOf(ResourceManager.STR_SCOREFUEL)).concat(String.valueOf(String.valueOf(this._$547.getMultiplier()))), n4, n5 + 10, 1, 1, 0, 0xFFFF00, 20, graphics);
        JSCanvas.drawShadowText(ResourceManager.STR_SCOREPTS, n3, n5 + 30, 1, 1, 0, 0xFFFF00, 20, graphics);
        int n7 = this._$547.getMultiplier();
        int n8 = this._$570 / 6 * n7;
        JSCanvas.drawShadowText(String.valueOf(n8), n4 + 125, n5 + 10, 1, 1, 0, 0xA0FFA0, 24, graphics);
        JSCanvas.drawShadowText(String.valueOf(this._$547.getBonusPoint()), n3 + 125, n5 + 30, 1, 1, 0, 0xA0FFA0, 24, graphics);
        JSCanvas.drawShadowText(String.valueOf(n8 + this._$547.getBonusPoint()), n2 + 125, n5 + 62, 1, 1, 0, 0x70FF70, 24, graphics);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(n + 5, n5 + 51, n + 135, n5 + 51);
        graphics.drawLine(n + 5, n5 + 52, n + 135, n5 + 52);
        JSCanvas.drawShadowText(ResourceManager.STR_SCORELEVEL, n2, n5 + 62, 1, 1, 0, 16759859, 20, graphics);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        this._$797(ResourceManager.STR_CMDNEXT, 175, 207, 72, graphics);
        Game.drawMenuLabel(graphics);
    }

    private void _$748(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        if (this._$799(this._$571, 400)) {
            this._$428.selectScreen(3);
        }
        graphics.drawImage(ResourceManager.IMG_ENDGAME, this.labelX, 96, 3);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        JSCanvas.drawShadowText(ResourceManager.STR_ENDGAME1, this.labelX, 153, 1, 1, 0, 0xFFA0FF, 65, graphics);
        JSCanvas.drawShadowText(ResourceManager.STR_ENDGAME2, this.labelX, 179, 1, 1, 0, 65280, 65, graphics);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        this._$797(ResourceManager.STR_CMDNEXT, 175, 207, 72, graphics);
        Game.drawMenuLabel(graphics);
        this._$571 += _$568;
    }

    private void _$741(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$753(graphics);
        if (this._$547.isDive()) {
            graphics.setClip(0, 0, 176, 208);
            this._$547.drawSprite(graphics);
            this._$752(graphics);
        } else {
            this._$752(graphics);
            this._$547.drawSprite(graphics);
        }
        Game.drawMenuLabel(graphics);
    }

    private void _$742(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        this._$547.drawSprite(graphics);
        if (this._$571 > 1333) {
            graphics.setFont(Font.getFont((int)64, (int)1, (int)0));
            graphics.setColor(0xFF8000);
            if (this._$571 > 1333 && this._$571 < 1333 + _$568) {
                this._$520.play(10);
            }
            this._$770(this._$571 - 1333, 2666);
            graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
            JSCanvas.drawShadowText(ResourceManager.STR_WRECK, this.labelX, 124, 1, 1, 0, 0xFFFF00, 65, graphics);
        }
        Game.drawMenuLabel(graphics);
    }

    private void _$740(Graphics graphics) {
        this._$4633.drawTiles(graphics);
        this._$752(graphics);
        this._$753(graphics);
        int n = 88 - this._$4638.getWidth() * 8 / 2;
        int n2 = 124 - this._$4638.getHeight() * 5 / 2;
        JSCanvas.drawBackground(this._$4638, n, n2, 8, 5, graphics);
        int n3 = 0;
        while (true) {
            int n4;
            if (n3 >= ResourceManager.STR_INGAMEMENU.length) break;
            if (this._$539 == n3) {
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                n4 = 0xFFFF00;
            } else {
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                n4 = 0xFFFFFF;
            }
            JSCanvas.drawShadowText(ResourceManager.STR_INGAMEMENU[n3], n + 20, n2 + 10 + 17 * n3, 1, 1, 0, n4, 20, graphics);
            if (n3 == 2) {
                int n5 = this._$520.getMidiVolume();
                if (n5 != 0) {
                    JSCanvas.drawShadowText(String.valueOf(n5), n + 80, n2 + 10 + 17 * n3, 1, 1, 0, n4, 20, graphics);
                } else {
                    JSCanvas.drawShadowText(ResourceManager.STR_OFF, n + 80, n2 + 10 + 17 * n3, 1, 1, 0, n4, 20, graphics);
                }
            } else if (n3 == 3) {
                JSCanvas.drawSetting(this._$520.isSettingOn(1), n + 80, n2 + 10 + 17 * n3, n4, graphics);
            }
            ++n3;
        }
    }

    static void drawMenuLabel(Graphics graphics) {
        graphics.setColor(0xFFFF00);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        graphics.drawString(ResourceManager.STR_CMDMENU, 1, 207, 68);
    }

    private void _$797(String string, int n, int n2, int n3, Graphics graphics) {
        this._$545 = (byte)(this._$545 + 16);
        int n4 = Math.abs(this._$545) + 127;
        int n5 = 0xFF0000 + (n4 << 8) + n4;
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    private void _$786(Graphics graphics) {
        int[] nArray = this._$519.getTrnScores();
        JSCanvas.drawShadowText(ResourceManager.STR_TRNHISCORE, 88, 53, 1, 1, 0, 65280, 17, graphics);
        JSCanvas.drawShadowText(String.valueOf(nArray[this._$574 - 1]), 88, 68, 1, 1, 0, 0xFFFFFF, 17, graphics);
    }

    private void _$753(Graphics graphics) {
        graphics.drawImage(ResourceManager.IMG_GAMEBAR, 0, 0, 20);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        graphics.setColor(23708);
        graphics.drawString(String.valueOf(this._$547.getTempScore()), 51, 35, 72);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        graphics.setColor(0xC0FFC0);
        graphics.drawString(String.valueOf(this._$574), 108, 9, 17);
        graphics.setColor(0xFFFFC0);
        graphics.drawString(String.valueOf(this._$547.getLives()), 106, 36, 72);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        if (this._$570 > 12000) {
            graphics.setColor(29184);
        } else {
            graphics.setColor(0xFF0000);
        }
        graphics.drawString(String.valueOf(this._$570 / 6), 174, 35, 72);
    }

    private void _$752(Graphics graphics) {
        graphics.setClip(0, 40, 176, 168);
        for (int i = 0; i < this._$607; ++i) {
            this._$608[i].drawSprite(graphics);
        }
        graphics.setClip(0, 0, 176, 208);
    }

    private void _$770(int n, int n2) {
        this.labelX = n < n2 / 5 ? 88 + (176 - 176 * n / (n2 / 5)) : (n < n2 * 4 / 5 ? 88 : 88 - 176 * (n - n2 * 4 / 5) / (n2 / 5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _$799(int n, int n2) {
        if (this._$523) {
            if (n >= n2) return true;
            this.labelX = 88 - 176 * n / n2;
            return false;
        } else {
            this.labelX = n < 400 ? 88 + (176 - 176 * n / n2) : 88;
        }
        return false;
    }

    public int getUpdateTime() {
        return _$568;
    }

    public void setMenu(boolean bl) {
        this._$521 = this._$522 = bl;
    }

    public Player getPlayer() {
        return this._$547;
    }

    public JSObject[][] getObjectsMap() {
        return this.objectsMap;
    }

    public void increaseFuel(int n) {
        this._$570 += n;
    }

    public int getState() {
        return this.state;
    }

    public TileWorld getTileWorld() {
        return this._$4633;
    }

    public static int getSpeedFactor() {
        return 6400 * _$568 / 1000;
    }

    public void setTraining(boolean bl) {
        this._$576 = bl;
    }

    public void KEYPRESSED(int n, int n2) {
        block2: {
            block3: {
                block1: {
                    if (!this._$522) break block1;
                    this.KEYPRESSEDOnMenu(n, n2);
                    break block2;
                }
                if (!(n != -6 && n != -8 && n != -50 || this._$522)) {
                    this.setMenu(true);
                }
                if (this.state != 2) break block3;
                this._$547.KEYPRESSED(n, n2);
                break block2;
            }
            if (this.state != 8 && this.state != 3 && this.state != 4 || n != -7) break block2;
            this._$571 = 0;
            this._$523 = true;
        }
    }

    public void KEYRELEASED(int n, int n2) {
        block0: {
            if (this.state != 2) break block0;
            this._$547.KEYRELEASED(n, n2);
        }
    }

    public void KEYPRESSEDOnMenu(int n, int n2) {
        if (n2 == 6) {
            this._$539 = (this._$539 + 1) % ResourceManager.STR_INGAMEMENU.length;
        } else if (n2 == 1) {
            this._$539 = (this._$539 - 1 + ResourceManager.STR_INGAMEMENU.length) % ResourceManager.STR_INGAMEMENU.length;
        } else if (n == -6 || n == -8 || n == -50) {
            this.setMenu(false);
        } else if (n2 == 8 || n == -7) {
            this._$868(this._$539);
        }
        if (this._$539 == 2) {
            if (n2 == 2) {
                this._$520.changeMidiVolume(-10);
            } else if (n2 == 5) {
                this._$520.changeMidiVolume(10);
            }
            if (this.state == 2 && this._$520.getMidiVolume() > 0) {
                this._$520.play(70);
            }
            this._$519.saveSettings();
        }
    }

    private void _$868(int n) {
        switch (n) {
            case 0: {
                this.setMenu(false);
                break;
            }
            case 1: {
                this.idle();
                this._$520.stopSound();
                this._$428.selectScreen(0);
                break;
            }
            case 3: {
                this._$520.invertSetting(1);
                this._$519.saveSettings();
            }
        }
    }

    private void _$715() {
    }

    private void _$864(int n, int n2) {
    }

    public void KEYRELEASEDOnTesting(int n, int n2) {
    }

    private void _$750(Graphics graphics) {
    }

    private void _$895() {
    }

    private void _$630() {
        this.initAllObject();
        this._$532 = 552;
        this._$533 = 2048;
        this._$547.reset();
        this._$631();
        this._$547.update();
        this._$520.play(2);
        this.state = 9;
    }

    private void _$721() {
        this._$547.reset();
        this._$716();
        this._$631();
        this._$547.update();
        this.initAllObject();
        this._$520.play(9);
        this._$571 = 0;
        this.state = 1;
    }

    private void _$725() {
        this._$547.setSpeedXY(4, 2);
        this._$571 = 0;
        this._$520.play(70);
        this.state = 2;
    }

    private void _$717() {
        this._$547.endGas();
        this._$571 = 0;
        this._$570 = 0;
        this._$520.stopSound();
        this._$520.play(8);
        this.state = 6;
    }

    private void _$720() {
        this._$547.setSpeedXY(0, 0);
        this._$547.setState(0);
        this._$547.computeScore(0);
        this._$571 = 0;
        this._$520.play(4);
        this.state = 7;
    }

    public void raceStop() {
        this._$547.setSpeedXY(0, 0);
        this.state = 5;
    }

    private void _$718() {
        this._$547.setSpeedXY(0, 0);
        this._$547.setState(0);
        this._$571 = 0;
        this._$523 = false;
        this._$520.stopSound();
        this._$520.play(3);
        this.state = 3;
    }

    private void _$729() {
        this._$547.computeScore(this._$570);
        if (this._$576) {
            int[] nArray = this._$519.getTrnScores();
            int n = this._$547.getScore();
            if (n > nArray[this._$574 - 1]) {
                nArray[this._$574 - 1] = n;
                this._$519.saveTrnHiScores();
            }
        }
        this._$571 = 0;
        this._$523 = false;
        this.state = 4;
    }

    private void _$785() {
        this._$571 = 0;
        this._$523 = false;
        this._$520.play(11);
        this.state = 8;
    }

    void idle() {
        this.setMenu(false);
        this.state = 0;
    }

    void loadNextLevel() {
        if (this._$574 >= this._$519.getUnlockedLevel() && this._$574 < 10) {
            this._$519.saveUnlockedLevel(this._$574 + 1);
        }
        this.initLevel(this._$574 + 1);
        this._$630();
    }

    static {
        TILESNUMCRASH = 14;
        TILESCOLUMNS = 6;
        TILEROWS = 5;
        WORLDROWS = 80;
        WORLDCOLUMNS = 40;
        TILEBITS = 5;
        TILESIZE = 32;
        WORLDWIDTH = 1280;
        WORLDHEIGHT = 2560;
        SPEEDOV = 6;
        BARHEIGHT = 40;
        PLAYHEIGHT = 168;
        PLAYERY = 145;
        MENUCOLUMNS = 8;
        MENUROWS = 5;
        CHOICEMUSIC = (byte)2;
        CHOICESOUND = (byte)3;
        IDLE = 0;
        START = 1;
        RUNNING = (byte)2;
        FINISH = (byte)3;
        SCORES = (byte)4;
        RACESTOP = (byte)5;
        ENDTIME = (byte)6;
        GAMEOVER = (byte)7;
        ENDGAME = (byte)8;
        OVERVIEW = (byte)9;
        TESTING = (byte)127;
        FP_SHIFT = (byte)8;
        STEPUNIT = 256;
        RACEFUEL = 60000;
        _$561 = 12000;
        _$562 = 4000;
        _$563 = 2500;
        _$564 = 2800;
        _$565 = 3000;
        _$566 = 3000;
        _$567 = 400;
        _$568 = 0;
        FINISHLINEY = 32;
        NUMLEVELS = (byte)10;
        OBJ_NONE = 0;
        OBJ_BONUSP1 = 1;
        OBJ_BONUSP2 = (byte)2;
        OBJ_BONUSP3 = (byte)3;
        OBJ_BONUSP4 = (byte)4;
        OBJ_BONUSTIME = (byte)5;
        OBJ_BONUSLIFE = (byte)6;
        OBJ_BONUSSPEED = (byte)7;
        OBJ_BONUSINV = (byte)8;
        OBJ_BONUSMULTI1 = (byte)9;
        OBJ_BONUSMULTI2 = (byte)10;
        OBJ_BONUSMULTI3 = (byte)11;
        OBJ_MINE = (byte)13;
        OBJ_BUOYSMALL = (byte)14;
        OBJ_BUOY = (byte)15;
        OBJ_STAKE = (byte)16;
        OBJ_ROCKMEDIUM = (byte)17;
        OBJ_ROCKSMALL = (byte)18;
        OBJ_RAMP = (byte)19;
        OBJ_OCTOPUS = (byte)20;
        OBJ_SHARK = (byte)21;
        _$599 = 48;
        _$600 = 48;
    }
}

