/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game.jetski;

import arcadia.game.Sprite;
import arcadia.game.jetski.AnimObject;
import arcadia.game.jetski.Game;
import arcadia.game.jetski.JSObject;

public class Foe
extends AnimObject
implements JSObject {
    static final byte LEFT = 0;
    static final byte RIGHT = 1;
    static final byte UNDERWATER = 2;
    protected static byte[] steps;
    protected int pathX;
    protected int currentPath;
    protected int stepX;
    protected static final byte STEPX = 2;
    protected static final short PATHSIZEX = 24576;

    public Foe(int n, int n2) {
        super(n, n2);
        this.stepX = 2 * Game.getSpeedFactor();
    }

    public Foe(Foe foe) {
        super(foe);
        this.stepX = foe.stepX;
    }

    public void initialize() {
        super.initialize();
        this.stepX = 2 * Game.getSpeedFactor();
        this.pathX = 0;
        this.currentPath = Math.abs(this.hashCode()) % (steps.length / 2) * 2;
        this.selectAnimation(steps[this.currentPath]);
        this.xMap = this.startX + 24576 * (steps.length / 2 - Math.abs(steps.length / 2 - this.currentPath)) / 2;
    }

    public void update() {
        if (this.collided) {
            this.stepX = 0;
        } else if (this.pathX >= 24576 || this.currentAnim != 2 && this.isEnd()) {
            this.currentPath = (this.currentPath + 2) % steps.length;
            byte by = steps[this.currentPath];
            if (by != 2) {
                this.setMode(1);
            } else {
                this.setMode(0);
            }
            this.selectAnimation(by);
            this.pathX = 0;
        } else {
            this.pathX += this.stepX;
            this.xMap += this.stepX * steps[this.currentPath + 1];
            this.updatePosition();
        }
        this.updateAnimation();
    }

    public int checkCollision(Sprite sprite) {
        if (steps[this.currentPath] == 2) {
            return 0;
        }
        return super.checkCollision(sprite);
    }

    static {
        LEFT = 0;
        RIGHT = 1;
        UNDERWATER = (byte)2;
        steps = new byte[]{2, 1, 1, 1, 2, 1, 1, 1, 2, -1, 0, -1, 2, -1, 0, -1};
        STEPX = (byte)2;
        PATHSIZEX = (short)24576;
    }
}

