/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TileWorld {
    private int width;
    private int height;
    private int worldRows;
    private int worldColumns;
    private byte[][] world;
    private int tileSizeX;
    private int tileSizeY;
    private int tileColumns;
    private int tileRows;
    private Image tiles;
    private int winBaseRow;
    private int winBaseColumn;
    private int winRows;
    private int winColumns;
    private int winRowBound;
    private int winColumnBound;
    private int windowX;
    private int windowY;
    private int clipWidth;
    private int clipHeight;
    private int clipX;
    private int clipY;
    int oldClipX;
    int oldClipY;
    int oldClipWidth;
    int oldClipHeight;
    int tileIndex;
    int tileX;
    int tileY;

    public TileWorld(byte[][] byArray, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        this.world = byArray;
        this.tiles = image;
        this.worldRows = byArray.length;
        this.worldColumns = byArray[0].length;
        this.tileColumns = n;
        this.tileRows = n2;
        this.tileSizeX = image.getWidth() / n;
        this.tileSizeY = image.getHeight() / n2;
        this.clipWidth = n5;
        this.clipHeight = n6;
        this.clipX = n3;
        this.clipY = n4;
        this.winColumns = n5 / this.tileSizeX + (n5 % this.tileSizeX == 0 ? 1 : 2);
        this.winRows = n6 / this.tileSizeY + (n6 % this.tileSizeY == 0 ? 1 : 2);
        if (this.winColumns > this.worldColumns) {
            this.winColumns = this.worldColumns;
        }
        this.winColumnBound = this.worldColumns - this.winColumns;
        if (this.winRows > this.worldRows) {
            this.winRows = this.worldRows;
        }
        this.winRowBound = this.worldRows - this.winRows;
    }

    public void drawTiles(Graphics graphics) {
        this.oldClipX = graphics.getClipX();
        this.oldClipY = graphics.getClipY();
        this.oldClipWidth = graphics.getClipWidth();
        this.oldClipHeight = graphics.getClipHeight();
        for (int i = this.winBaseRow; i < this.winRows + this.winBaseRow; ++i) {
            for (int j = this.winBaseColumn; j < this.winColumns + this.winBaseColumn; ++j) {
                this.tileIndex = this.world[i][j];
                int n = this.tileIndex % this.tileColumns;
                int n2 = this.tileIndex / this.tileColumns;
                this.tileX = j * this.tileSizeX - this.windowX;
                this.tileY = i * this.tileSizeY - this.windowY;
                graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
                graphics.clipRect(this.tileX + this.clipX, this.tileY + this.clipY, this.tileSizeX, this.tileSizeY);
                graphics.drawImage(this.tiles, this.tileX + this.clipX - n * this.tileSizeX, this.tileY + this.clipY - n2 * this.tileSizeX, 20);
            }
        }
        graphics.setClip(this.oldClipX, this.oldClipY, this.oldClipWidth, this.oldClipHeight);
    }

    public void moveWin(int n, int n2) {
        int n3 = this.windowX + n;
        int n4 = this.windowY + n2;
        this.setWinXY(n3, n4);
    }

    public void setWinXY(int n, int n2) {
        this.windowX = n;
        this.windowY = n2;
        this.winBaseColumn = this.windowX / this.tileSizeX;
        if (this.winBaseColumn > this.winColumnBound) {
            this.winBaseColumn = this.winColumnBound;
        }
        if (this.winBaseColumn < 0) {
            this.winBaseColumn = 0;
        }
        this.winBaseRow = this.windowY / this.tileSizeY;
        if (this.winBaseRow > this.winRowBound) {
            this.winBaseRow = this.winRowBound;
        }
        if (this.winBaseRow < 0) {
            this.winBaseRow = 0;
        }
    }

    public int getWinX() {
        return this.windowX;
    }

    public int getWinY() {
        return this.windowY;
    }

    public byte getTileIndex(int n, int n2) {
        return this.world[n][n2];
    }

    public boolean isBoundLeft() {
        return this.windowX <= 0;
    }

    public boolean isBoundRight() {
        return this.windowX >= this.worldColumns * this.tileSizeX - this.clipWidth;
    }

    public boolean isBoundUp() {
        return this.windowY <= 0;
    }

    public boolean isBoundDown() {
        return this.windowY >= this.worldRows * this.tileSizeY - this.clipHeight;
    }
}

