/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game;

import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;

public abstract class NokiaGameCanvas
extends FullCanvas
implements Runnable {
    public static final byte STANDARDFPS = 25;
    protected int fps = 25;
    protected int frame;
    protected int frameTime;
    protected volatile Thread animator;
    protected int width = this.getWidth();
    protected int height = this.getHeight();

    public final synchronized void start() {
        this.frame = 0;
        this.frameTime = 1000 / this.fps;
        this.animator = new Thread(this);
        this.animator.start();
    }

    public final synchronized void stop() {
        this.animator = null;
    }

    public final void run() {
        try {
            while (Thread.currentThread() == this.animator) {
                long l = System.currentTimeMillis();
                this.repaint(0, 0, this.width, this.height);
                this.serviceRepaints();
                long l2 = System.currentTimeMillis() - l;
                if (l2 < (long)this.frameTime) {
                    NokiaGameCanvas nokiaGameCanvas = this;
                    synchronized (nokiaGameCanvas) {
                        this.wait((long)this.frameTime - l2);
                    }
                }
                ++this.frame;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
    }

    public final int getFps() {
        return this.fps;
    }

    public synchronized void setFps(int n) {
        if (n > 0) {
            this.fps = n;
            this.frameTime = 1000 / n;
        }
    }

    public int getFrameTime() {
        return this.frameTime;
    }

    static {
        STANDARDFPS = (byte)25;
    }
}

