/*
 * Decompiled with CFR 0.152.
 */
package arcadia.game;

import arcadia.game.Sprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimSprite
extends Sprite {
    private Image[] animationSet;
    private Image spriteImage;
    protected int currentAnim;
    private int index;
    private int[] numImages;
    private int frames;
    private int fpsRatio = 1;
    private byte mode = 0;
    public static final byte FORWARD_LOOP = 0;
    public static final byte FORWARD_ONCE = 1;
    public static final byte BACKWARD_LOOP = 2;
    public static final byte BACKWARD_ONCE = 3;

    public AnimSprite(int n, int n2, int n3) {
        this.x = n2;
        this.y = n3;
        this.numImages = new int[n];
        this.animationSet = new Image[n];
    }

    public AnimSprite(AnimSprite animSprite) {
        this.x = animSprite.x;
        this.y = animSprite.y;
        this.spriteImage = animSprite.spriteImage;
        this.width = animSprite.width;
        this.height = animSprite.height;
        this.numImages = animSprite.numImages;
        this.animationSet = animSprite.animationSet;
        this.currentAnim = animSprite.currentAnim;
        this.fpsRatio = animSprite.fpsRatio;
        this.mode = animSprite.mode;
    }

    public final void setFpsRatio(int n) {
        this.frames = 0;
        this.fpsRatio = n;
    }

    public final void updateAnimation() {
        int n = (this.frames++ % this.fpsRatio + 1) / this.fpsRatio;
        if (this.mode == 0) {
            this.index = (this.index + n) % this.numImages[this.currentAnim];
        } else if (this.mode == 1) {
            if (this.index < this.numImages[this.currentAnim] - 1) {
                this.index += n;
            }
        } else if (this.mode == 2) {
            int n2 = this.numImages[this.currentAnim];
            this.index = (this.index - n + n2) % n2;
        } else if (this.mode == 3 && this.index > 0) {
            this.index -= n;
        }
    }

    public final void setMode(int n) {
        this.mode = (byte)n;
    }

    public final int getMode() {
        return this.mode;
    }

    public final boolean isEnd() {
        if (this.mode == 1) {
            return this.index >= this.numImages[this.currentAnim] - 1 && this.frames >= this.fpsRatio * this.numImages[this.currentAnim];
        }
        if (this.mode == 3) {
            return this.index <= 0 && this.frames >= this.fpsRatio * this.numImages[this.currentAnim];
        }
        return false;
    }

    public final void setAnimation(Image image, int n, int n2) {
        this.numImages[n2] = n;
        this.animationSet[n2] = image;
        this.width = image.getWidth() / n;
        this.height = image.getHeight();
    }

    public final void selectAnimation(int n) {
        if (this.animationSet != null) {
            this.currentAnim = n;
            this.spriteImage = this.animationSet[n];
            this.width = this.spriteImage.getWidth() / this.numImages[n];
            this.height = this.spriteImage.getHeight();
            this.index = this.mode == 0 || this.mode == 1 ? 0 : this.numImages[n] - 1;
            this.frames = 0;
        }
    }

    public void drawSprite(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(this.x, this.y, this.width, this.height);
        graphics.drawImage(this.spriteImage, this.x - this.index * this.width, this.y, 20);
        graphics.setClip(n, n2, n3, n4);
    }

    public void randomize() {
        this.frames = Math.abs(this.hashCode()) % this.fpsRatio;
    }

    static {
        FORWARD_LOOP = 0;
        FORWARD_ONCE = 1;
        BACKWARD_LOOP = (byte)2;
        BACKWARD_ONCE = (byte)3;
    }
}

