/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class Player
extends Missile {
    static final int SHOT = 0;
    static final int MOVE = 1;
    int HP;
    int damage;
    int angle;
    int power;
    int actionType;
    static final int[] strTypesID = new int[]{60, 61};
    int idName;
    int hits;
    int shots;
    int aiLevel;
    int wins;
    boolean turnFinished;
    static final int[][] color = new int[][]{{0x800000, 0x500000}, {0x808000, 0x505000}, {32768, 20480}};
    int w = -1;

    public void drawGradientLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n3; ++i) {
            int n6 = 0;
            for (int j = 0; j < 3; ++j) {
                n6 |= (n5 >> j * 8 & 0xFF) * i / n3 << j * 8;
            }
            graphics.setColor(n4 + n6);
            graphics.fillRect(n + i, n2, 1, 1);
        }
    }

    public void draw(Graphics graphics) {
        if (this.HP > 0) {
            int n = Form.getFrameInfo(this.imgID, 0);
            this.frameID = Form.normalizeAngle(this.angle + 90 + 180 / n) * n / 360 + (this.idName == 58 ? n : 0);
            Form.drawImageFrame(graphics, this.imgID, this.frameID, this.x, this.y, 3);
            int n2 = this.y + this.size / 2 + 1;
            int n3 = Math.max(1, Form.getFrameHeight(9) / 7);
            if (n2 + n3 > GameLogic.gameHeight) {
                n2 = this.y - this.size / 2 - n3;
            }
            int n4 = Math.min(this.HP / 33, color.length - 1);
            for (int i = 0; i < n3; ++i) {
                this.drawGradientLine(graphics, this.x - this.size / 2, n2 + i, 1 + this.size * this.HP / 100, color[n4][0], color[n4][1]);
            }
        }
    }

    public void drawStat(Graphics graphics) {
        Font font = graphics.getFont();
        if (this.w < 0) {
            this.w = font.stringWidth(App.getString(59, "360", String.valueOf(100)));
        }
        String string = App.getString(59, String.valueOf(this.angle), String.valueOf(this.power));
        int n = font.getHeight() * 2;
        int n2 = this.x - this.w / 2;
        int n3 = this.y;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > GameLogic.gameWidth - this.w) {
            n2 = GameLogic.gameWidth - this.w;
        }
        n3 = n3 > GameLogic.gameHeight / 2 ? (n3 -= n + this.size / 2) : (n3 += this.size / 2);
        graphics.setColor(-1);
        graphics.drawString(string, n2 + this.w / 2, n3, 17);
        graphics.drawString(App.getString(strTypesID[this.actionType]), n2 + this.w / 2, n3 + font.getHeight(), 17);
    }

    public Missile getMissile() {
        Missile missile = this;
        int n = Form.fixedSin(this.angle);
        int n2 = Form.fixedCos(this.angle);
        if (this.actionType == 0) {
            missile = new Missile(0);
            missile.fixedX = this.fixedX + (this.size + 2) * n2 / 2;
            missile.fixedY = this.fixedY + (this.size + 2) * n / 2;
            missile.fixedToReal();
            missile.shipFrom = this;
            missile.step = 500;
        } else {
            this.step = 60;
        }
        missile.fixedVX = 230 * this.power * n2 / 100 / 100;
        missile.fixedVY = 230 * this.power * n / 100 / 100;
        return missile;
    }

    void reinit() {
        this.turnFinished = false;
        this.angle = 0;
        this.power = 50;
        this.HP = 0;
        this.hits = 0;
        this.shots = 0;
        this.actionType = 0;
    }

    void setMaxSpeed() {
        if (this.fixedVX > 65536) {
            this.fixedVX = 65536;
        } else if (this.fixedVX < -65536) {
            this.fixedVX = -65536;
        }
        if (this.fixedVY > 65536) {
            this.fixedVY = 65536;
        } else if (this.fixedVY < -65536) {
            this.fixedVY = -65536;
        }
    }

    public Player() {
        super(1);
        this.imgID = 9;
        this.reinit();
    }

    public Player(Player player) {
        this();
        this.fixedX = player.fixedX;
        this.fixedY = player.fixedY;
        this.power = player.power;
        this.angle = player.angle;
        this.actionType = player.actionType;
    }
}

