/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TBoard {
    private int fSizeX = 0;
    private int fSizeY = 0;
    private int fWordBuffSize;
    private byte[] fCharBuff;
    private int[] fCharState;
    private byte[] fWords;
    private byte[] fName;
    public static final int bsNone = 0;
    public static final int bsEmpty = 1;
    public static final int bsSelected = 2;
    public static final int bsSolvedOk = 3;
    public static final int bsSolvedError = 4;

    public TBoard(String fileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                return;
            }
            DataInputStream file = new DataInputStream(is);
            short k = file.readByte();
            this.fSizeX = file.readByte();
            this.fSizeY = file.readByte();
            this.fWordBuffSize = file.readShort();
            this.fName = new byte[32];
            int i = 0;
            while (i < 32) {
                this.fName[i] = file.readByte();
                ++i;
            }
            int sz = this.fSizeX * this.fSizeY;
            this.fCharState = new int[sz];
            this.fCharBuff = new byte[sz];
            i = 0;
            while (i < sz) {
                this.fCharBuff[i] = file.readByte();
                this.fCharState[i] = file.readShort() | 1;
                ++i;
            }
            this.fWords = new byte[this.fWordBuffSize];
            i = 0;
            while (i < this.fWordBuffSize) {
                this.fWords[i] = file.readByte();
                ++i;
            }
            file.close();
            System.err.println("board " + fileName);
        }
        catch (IOException e) {
            System.out.println("io error " + e.getMessage());
        }
    }

    public boolean loaded() {
        return this.fSizeX > 0 && this.fSizeY > 0;
    }

    public int getWidth() {
        return this.fSizeX;
    }

    public int getHeight() {
        return this.fSizeY;
    }

    public int getChar(int x, int y) {
        if (x >= 0 && x < this.fSizeX && y >= 0 && y < this.fSizeY) {
            return this.fCharBuff[y * this.fSizeX + x] & 0xFF;
        }
        return 0;
    }

    public int getState(int x, int y) {
        if (x >= 0 && x < this.fSizeX && y >= 0 && y < this.fSizeY) {
            return this.fCharState[y * this.fSizeX + x];
        }
        return 0;
    }

    public byte[] getWord(int x, int y) {
        if (x >= 0 && x < this.fSizeX && y >= 0 && y < this.fSizeY) {
            int k = this.fCharState[y * this.fSizeX + x] >> 3;
            int sz = this.fWords[k];
            byte[] buff = new byte[sz];
            int i = 0;
            while (i < sz) {
                buff[i] = this.fWords[k + i + 1];
                ++i;
            }
            return buff;
        }
        return null;
    }

    public void setState(int x, int y, int state) {
        if (x >= 0 && x < this.fSizeX && y >= 0 && y < this.fSizeY) {
            int k = y * this.fSizeX + x;
            int n = this.fCharState[k] & 0xFFFFFFF8;
            int m = this.fCharState[k] & 7;
            if (state == 2) {
                this.fCharState[k] = m == 2 ? n | 1 : n | 2;
            }
        }
    }

    public synchronized void checkSolution() {
        int n;
        int x;
        int wsel = 0;
        int k = 0;
        boolean tg = true;
        int y = 0;
        while (y < this.fSizeY) {
            x = 0;
            while (x < this.fSizeX) {
                n = this.fCharState[k++];
                switch (n & 7) {
                    case 2: {
                        if (wsel == 0) {
                            wsel = n >> 3;
                            break;
                        }
                        if (wsel == n >> 3) break;
                        tg = false;
                        break;
                    }
                    case 1: {
                        if (wsel != n >> 3) break;
                        tg = false;
                    }
                }
                ++x;
            }
            ++y;
        }
        if (wsel != 0 && tg) {
            k = 0;
            wsel <<= 3;
            y = 0;
            while (y < this.fSizeY) {
                x = 0;
                while (x < this.fSizeX) {
                    n = this.fCharState[k] & 0xFFFFFFF8;
                    if (n == wsel) {
                        this.fCharState[k] = n | 3;
                    }
                    ++k;
                    ++x;
                }
                ++y;
            }
        }
    }

    public void restart() {
        int sz = this.fSizeX * this.fSizeY;
        int i = 0;
        while (i < sz) {
            ++i;
        }
        this.fCharState[i] = this.fCharState[i] & 0xFFFFFFF8 | 1;
    }
}

