/*
 * Decompiled with CFR 0.152.
 */
package com.sprintpcs.media;

public class DualTone {
    private static final byte TEMPO = 60;
    private static final byte RESOLUTION = 96;
    byte[] toneSequence;
    int vibration;
    int priority;

    public DualTone(int[] freqAs, int[] freqBs, int[] durations, int priority, int vibration) {
        int i2;
        int dur = 0;
        if (vibration < 0) {
            throw new IllegalArgumentException("DualTone constructor: negative vibration");
        }
        for (i2 = 0; i2 < freqAs.length; ++i2) {
            if (freqAs[i2] >= 0) continue;
            throw new IllegalArgumentException("DualTone constructor: negative arguments");
        }
        for (i2 = 0; i2 < freqBs.length; ++i2) {
            if (freqBs[i2] >= 0) continue;
            throw new IllegalArgumentException("DualTone constructor: negative arguments");
        }
        for (i2 = 0; i2 < durations.length; ++i2) {
            if (durations[i2] >= 0) continue;
            throw new IllegalArgumentException("DualTone constructor: negative arguments");
        }
        int length = Math.max(freqAs.length, freqBs.length);
        this.vibration = vibration;
        this.priority = priority;
        this.toneSequence = new byte[6 + freqAs.length * 2 + freqBs.length * 2];
        this.toneSequence[0] = -2;
        this.toneSequence[1] = 1;
        this.toneSequence[2] = -3;
        this.toneSequence[3] = 60;
        this.toneSequence[4] = -4;
        this.toneSequence[5] = 96;
        int index = 6;
        for (i2 = 0; i2 < length; ++i2) {
            int noteA = freqAs.length > i2 ? (int)DualTone.convertToMIDINote(freqAs[i2]) : -1;
            int noteB = freqBs.length > i2 ? (int)DualTone.convertToMIDINote(freqBs[i2]) : -1;
            if (durations.length > i2) {
                dur = durations[i2] * 96 * 60 / 240000;
            }
            if (dur > 255) {
                dur = 255;
            }
            if (noteA != -1) {
                this.toneSequence[index++] = (byte)noteA;
                this.toneSequence[index++] = (byte)dur;
            }
            if (noteB == -1) continue;
            this.toneSequence[index++] = (byte)noteB;
            this.toneSequence[index++] = (byte)dur;
        }
    }

    public DualTone(int freqA, int freqB, int duration, int priority, int vibration) {
        if (vibration < 0 || freqA < 0 || freqB < 0 || duration < 0) {
            throw new IllegalArgumentException("DualTone constructor: negative vibration");
        }
        this.vibration = vibration;
        this.priority = priority;
        this.toneSequence = new byte[10];
        this.toneSequence[0] = -2;
        this.toneSequence[1] = 1;
        this.toneSequence[2] = -3;
        this.toneSequence[3] = 60;
        this.toneSequence[4] = -4;
        this.toneSequence[5] = 96;
        int dur = duration * 96 * 60 / 240000;
        if (dur > 255) {
            dur = 255;
        }
        this.toneSequence[6] = DualTone.convertToMIDINote(freqA);
        this.toneSequence[7] = (byte)dur;
        this.toneSequence[8] = DualTone.convertToMIDINote(freqB);
        this.toneSequence[9] = (byte)dur;
    }

    private static byte convertToMIDINote(int freq) {
        if (freq < 0) {
            return -1;
        }
        if (freq > 0 && freq <= 9) {
            return 2;
        }
        if (freq == 10) {
            return 3;
        }
        if (freq == 11) {
            return 5;
        }
        if (freq == 12) {
            return 7;
        }
        if (freq == 13) {
            return 8;
        }
        if (freq == 14) {
            return 9;
        }
        if (freq == 15) {
            return 11;
        }
        if (freq == 16) {
            return 12;
        }
        if (freq == 17) {
            return 13;
        }
        if (freq == 18) {
            return 14;
        }
        if (freq == 19) {
            return 15;
        }
        if (freq == 20 || freq == 21) {
            return 16;
        }
        if (freq == 22) {
            return 17;
        }
        if (freq == 23) {
            return 18;
        }
        if (freq == 24 || freq == 25) {
            return 19;
        }
        if (freq == 26) {
            return 20;
        }
        if (freq == 27 || freq == 28) {
            return 21;
        }
        if (freq == 29) {
            return 22;
        }
        if (freq == 30 || freq == 31) {
            return 23;
        }
        if (freq == 32 || freq == 33) {
            return 24;
        }
        if (freq == 34 || freq == 35) {
            return 25;
        }
        if (freq == 36 || freq == 37) {
            return 26;
        }
        if (freq == 38 || freq == 39) {
            return 27;
        }
        if (freq >= 40 && freq <= 42) {
            return 28;
        }
        if (freq >= 43 && freq <= 44) {
            return 29;
        }
        if (freq >= 45 && freq <= 47) {
            return 30;
        }
        if (freq >= 48 && freq <= 50) {
            return 31;
        }
        if (freq >= 51 && freq <= 53) {
            return 32;
        }
        if (freq >= 54 && freq <= 56) {
            return 33;
        }
        if (freq >= 57 && freq <= 59) {
            return 34;
        }
        if (freq >= 60 && freq <= 63) {
            return 35;
        }
        if (freq >= 64 && freq <= 67) {
            return 36;
        }
        if (freq >= 68 && freq <= 71) {
            return 37;
        }
        if (freq >= 72 && freq <= 75) {
            return 38;
        }
        if (freq >= 76 && freq <= 79) {
            return 39;
        }
        if (freq >= 80 && freq <= 84) {
            return 40;
        }
        if (freq >= 85 && freq <= 89) {
            return 41;
        }
        if (freq >= 90 && freq <= 95) {
            return 42;
        }
        if (freq >= 96 && freq <= 100) {
            return 43;
        }
        if (freq >= 101 && freq <= 106) {
            return 44;
        }
        if (freq >= 107 && freq <= 113) {
            return 45;
        }
        if (freq >= 114 && freq <= 119) {
            return 46;
        }
        if (freq >= 120 && freq <= 126) {
            return 47;
        }
        if (freq >= 127 && freq <= 134) {
            return 48;
        }
        if (freq >= 135 && freq <= 142) {
            return 49;
        }
        if (freq >= 143 && freq <= 150) {
            return 50;
        }
        if (freq >= 151 && freq <= 159) {
            return 51;
        }
        if (freq >= 160 && freq <= 169) {
            return 52;
        }
        if (freq >= 170 && freq <= 179) {
            return 53;
        }
        if (freq >= 180 && freq <= 190) {
            return 54;
        }
        if (freq >= 191 && freq <= 201) {
            return 55;
        }
        if (freq >= 202 && freq <= 213) {
            return 56;
        }
        if (freq >= 214 && freq <= 226) {
            return 57;
        }
        if (freq >= 227 && freq <= 239) {
            return 58;
        }
        if (freq >= 240 && freq <= 253) {
            return 59;
        }
        if (freq >= 254 && freq <= 269) {
            return 60;
        }
        if (freq >= 270 && freq <= 284) {
            return 61;
        }
        if (freq >= 285 && freq <= 301) {
            return 62;
        }
        if (freq >= 302 && freq <= 319) {
            return 63;
        }
        if (freq >= 320 && freq <= 338) {
            return 64;
        }
        if (freq >= 339 && freq <= 359) {
            return 65;
        }
        if (freq >= 360 && freq <= 380) {
            return 66;
        }
        if (freq >= 381 && freq <= 403) {
            return 67;
        }
        if (freq >= 404 && freq <= 427) {
            return 68;
        }
        if (freq >= 428 && freq <= 452) {
            return 69;
        }
        if (freq >= 453 && freq <= 479) {
            return 70;
        }
        if (freq >= 480 && freq <= 507) {
            return 71;
        }
        if (freq >= 508 && freq <= 538) {
            return 72;
        }
        if (freq >= 539 && freq <= 569) {
            return 73;
        }
        if (freq >= 570 && freq <= 603) {
            return 74;
        }
        if (freq >= 604 && freq <= 639) {
            return 75;
        }
        if (freq >= 639 && freq <= 677) {
            return 76;
        }
        if (freq >= 678 && freq <= 718) {
            return 77;
        }
        if (freq >= 719 && freq <= 760) {
            return 78;
        }
        if (freq >= 761 && freq <= 806) {
            return 79;
        }
        if (freq >= 807 && freq <= 854) {
            return 80;
        }
        if (freq >= 855 && freq <= 904) {
            return 81;
        }
        if (freq >= 905 && freq <= 958) {
            return 82;
        }
        if (freq >= 959 && freq <= 1015) {
            return 83;
        }
        if (freq >= 1016 && freq <= 1076) {
            return 84;
        }
        if (freq >= 1077 && freq <= 1139) {
            return 85;
        }
        if (freq >= 1140 && freq <= 1207) {
            return 86;
        }
        if (freq >= 1208 && freq <= 1279) {
            return 87;
        }
        if (freq >= 1280 && freq <= 1355) {
            return 88;
        }
        if (freq >= 1356 && freq <= 1436) {
            return 89;
        }
        if (freq >= 1437 && freq <= 1521) {
            return 90;
        }
        if (freq >= 1522 && freq <= 1612) {
            return 91;
        }
        if (freq >= 1613 && freq <= 1709) {
            return 92;
        }
        if (freq >= 1710 && freq <= 1809) {
            return 93;
        }
        if (freq >= 1810 && freq <= 1917) {
            return 94;
        }
        if (freq >= 1918 && freq <= 2031) {
            return 95;
        }
        if (freq >= 2032 && freq <= 2152) {
            return 96;
        }
        if (freq >= 2153 && freq <= 2279) {
            return 97;
        }
        if (freq >= 2280 && freq <= 2415) {
            return 98;
        }
        if (freq >= 2416 && freq <= 2559) {
            return 99;
        }
        if (freq >= 2560 && freq <= 2711) {
            return 100;
        }
        if (freq >= 2712 && freq <= 2872) {
            return 101;
        }
        if (freq >= 2873 && freq <= 3043) {
            return 102;
        }
        if (freq >= 3044 && freq <= 3224) {
            return 103;
        }
        if (freq >= 3225 && freq <= 3416) {
            return 104;
        }
        if (freq >= 3417 && freq <= 3619) {
            return 105;
        }
        if (freq >= 3620 && freq <= 3834) {
            return 106;
        }
        if (freq >= 3835 && freq <= 4062) {
            return 107;
        }
        if (freq >= 4063 && freq <= 4304) {
            return 108;
        }
        if (freq >= 4305 && freq <= 4559) {
            return 109;
        }
        if (freq >= 4560 && freq <= 4831) {
            return 110;
        }
        if (freq >= 4832 && freq <= 5118) {
            return 111;
        }
        if (freq >= 5119 && freq <= 5422) {
            return 112;
        }
        if (freq >= 5423 && freq <= 5745) {
            return 113;
        }
        if (freq >= 5746 && freq <= 6086) {
            return 114;
        }
        if (freq >= 6087 && freq <= 6448) {
            return 115;
        }
        if (freq >= 6449 && freq <= 6832) {
            return 116;
        }
        if (freq >= 6833 && freq <= 7238) {
            return 117;
        }
        if (freq >= 7239 && freq <= 7668) {
            return 118;
        }
        if (freq >= 7669 && freq <= 8124) {
            return 119;
        }
        if (freq >= 8125 && freq <= 8608) {
            return 120;
        }
        if (freq >= 8609 && freq <= 9119) {
            return 121;
        }
        if (freq >= 9120 && freq <= 9662) {
            return 122;
        }
        if (freq >= 9663 && freq <= 10236) {
            return 123;
        }
        if (freq >= 10237 && freq <= 10846) {
            return 124;
        }
        if (freq >= 10847 && freq <= 11490) {
            return 125;
        }
        if (freq >= 11490 && freq <= 12173) {
            return 126;
        }
        if (freq >= 12174 && freq <= 20000) {
            return 127;
        }
        return 2;
    }
}

