/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

class DDLUtility {
    private static MIDlet m_Parent;
    private static long randseed;
    private static byte[] m_atanTab;
    public static int[] m_sintab;
    public static int m_vibrateOn;
    static int G_traceDepth;

    public DDLUtility(MIDlet mIDlet) {
        m_Parent = mIDlet;
    }

    private static void ReadBytes(InputStream inputStream, byte[] byArray, int n, int n2) {
        try {
            int n3;
            while (n2 > 0 && (n3 = inputStream.read(byArray, n, n2)) >= 0) {
                n += n3;
                n2 -= n3;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static byte[] ReadByteArray(String object, int n) {
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream((String)object);
            object = new byte[n];
            DDLUtility.ReadBytes(inputStream, (byte[])object, 0, n);
            inputStream.close();
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public static short[] ReadShortArray(String string, int n) {
        short[] sArray = null;
        byte[] byArray = new byte[]{0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            sArray = new short[n >> 1];
            for (int i = 0; i < n >> 1; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[i] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            sArray = null;
        }
        return sArray;
    }

    public static int[] ReadIntArray(String string, int n) {
        int[] nArray = null;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            nArray = new int[n >> 2];
            for (int i = 0; i < n >> 2; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 4);
                nArray[i] = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            nArray = null;
        }
        return nArray;
    }

    public static byte[] ReadCATByteArray(int n) {
        byte[] byArray;
        byte[] byArray2 = new byte[]{0, 0};
        try {
            int n2;
            String string = "/files.bin";
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
            DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
            int n3 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
                if (n2 > n) continue;
                n5 += n4;
                n4 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8;
            }
            for (n3 = n5; n3 > 0 && (n2 = (int)inputStream.skip(n3)) >= 0; n3 -= n2) {
            }
            byArray = new byte[n4];
            DDLUtility.ReadBytes(inputStream, byArray, 0, n4);
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static Image ReadCATImage(int n) {
        Object object = DDLUtility.ReadCATByteArray(n);
        object = Image.createImage((byte[])object, (int)0, (int)((byte[])object).length);
        System.gc();
        return object;
    }

    public static short[] ReadCATShortArray(int n) {
        short[] sArray;
        byte[] byArray = new byte[]{0, 0};
        try {
            int n2;
            String string = "/files.bin";
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
            DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
            int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                if (n2 > n) continue;
                n5 += n4;
                n4 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            }
            for (n3 = n5; n3 > 0 && (n2 = (int)inputStream.skip(n3)) >= 0; n3 -= n2) {
            }
            sArray = new short[n4 >> 1];
            for (n2 = 0; n2 < n4 >> 1; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[n2] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            sArray = null;
        }
        return sArray;
    }

    public static void ReadShortArrayInto(String string, int n, short[] sArray) {
        byte[] byArray = new byte[]{0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            for (int i = 0; i < n >> 1; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[i] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void initRandom() {
        randseed = -739132197L;
        for (int i = (int)System.currentTimeMillis() & 0xFF; i > 0; --i) {
            DDLUtility.getRandom();
        }
    }

    public static int getRandom() {
        randseed = 1103515245L * randseed + 12345L;
        return (int)(randseed >> 16);
    }

    public static int sqrtRout(int n) {
        int n2;
        if (n <= 0) {
            return 1;
        }
        int n3 = n;
        while ((n3 = (n2 = n3) + n / n2 >> 1) < n2 && n3 > 0) {
        }
        return n3;
    }

    public static void DoBuildAtanTab() {
        m_atanTab = new byte[520];
        byte[] byArray = DDLUtility.ReadByteArray("/atan.bin", 32);
        System.arraycopy(byArray, 24, m_atanTab, 512, 8);
        int n = 0;
        int n2 = 0;
        while (n < 16) {
            DDLUtility.BuildAtanTab(byArray, byArray[n], n2, byArray[n + 1]);
            n += 2;
            n2 += 64;
        }
        System.gc();
    }

    private static void BuildAtanTab(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = 16;
        int n6 = 7;
        for (n = 0; n < 64; ++n) {
            DDLUtility.m_atanTab[n + n2] = (byte)n4;
            if ((byArray[n5] & 1 << n6) != 0) {
                n4 += n3;
            }
            if (--n6 >= 0) continue;
            n6 = 7;
            ++n5;
        }
    }

    public static int atanRout(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = 0;
            if (n < 0) {
                n4 = 256;
                n = -n;
            }
            if (n2 < 0) {
                n4 |= 0x80;
                n2 = -n2;
            }
            if (n == n2) {
                n3 = m_atanTab[512 + (n4 >> 6)] & 0xFF;
            } else {
                if (n2 < n) {
                    n4 |= 0x40;
                    int n5 = n;
                    n = n2;
                    n2 = n5;
                }
                n3 = n2 == 0 ? m_atanTab[n4] & 0xFF : m_atanTab[(n << 6) / n2 + n4] & 0xFF;
            }
        }
        catch (Exception exception) {}
        return n3;
    }

    private static int[] ReadSinTab() {
        m_sintab = new int[256];
        byte[] byArray = DDLUtility.ReadByteArray("/sintab.bin", 128);
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = 2;
            int n3 = 0;
            int n4 = 0;
            while (n3 < 128) {
                int n5;
                if (n3 == 64) {
                    n5 = 65536;
                    n2 = -n2;
                } else {
                    n5 = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8;
                }
                if (i == 1) {
                    n5 = -n5;
                }
                DDLUtility.m_sintab[n] = n5;
                ++n;
                ++n3;
                n4 += n2;
            }
        }
        System.gc();
        return m_sintab;
    }

    public static boolean intersection(int[][] nArray, int[] nArray2) {
        int n = (nArray[3][0] - nArray[2][0]) * (nArray[0][1] - nArray[2][1]) - (nArray[3][1] - nArray[2][1]) * (nArray[0][0] - nArray[2][0]);
        int n2 = (nArray[3][1] - nArray[2][1]) * (nArray[1][0] - nArray[0][0]) - (nArray[3][0] - nArray[2][0]) * (nArray[1][1] - nArray[0][1]);
        if (n2 == 0) {
            return false;
        }
        n = (n << 8) / n2;
        nArray2[0] = nArray[0][0] + (n * (nArray[1][0] - nArray[0][0]) >> 8);
        nArray2[1] = nArray[0][1] + (n * (nArray[1][1] - nArray[0][1]) >> 8);
        return true;
    }

    public static boolean intersectRects(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (n <= n5 && n + n3 >= n5 || n <= n5 + n7 && n + n3 >= n5 + n7 || n5 < n && n5 + n7 > n + n3) && (n2 <= n6 && n2 + n4 >= n6 || n2 <= n6 + n8 && n2 + n4 >= n6 + n8 || n6 < n2 && n6 + n8 > n2 + n4);
    }

    public static int PNG_CalcCRC(byte[] byArray, int n, int n2) {
        n2 -= (n -= 4);
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            int n4 = (n3 ^ (byte)byArray[i + n]) & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((n4 & 1) != 0) {
                    n4 = 0xEDB88320 ^ n4 >>> 1;
                    continue;
                }
                n4 >>>= 1;
            }
            n3 = n4 ^ n3 >>> 8;
        }
        return ~n3;
    }

    public static Image PNG_SetPlayerPalette(byte[] byArray, int n, int[][] nArray) {
        int n2;
        byte by;
        int n3 = -1;
        do {
            by = (byte)(n3 + 1);
            n3 = by;
        } while ((byArray[by] != 80 || byArray[n3 + 1] != 76 || byArray[n3 + 2] != 84 || byArray[n3 + 3] != 69) && n3 + 3 < byArray.length);
        n3 = (byte)(n3 - 4);
        int n4 = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
        n3 += 8;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (int i = 0; i < 3; ++i) {
                byArray[n3 + (nArray[n2][0] * 3 + i)] = (byte)nArray[n2][i + 1];
            }
        }
        n2 = DDLUtility.PNG_CalcCRC(byArray, n3, n3 + n4);
        byArray[n3 + n4] = (byte)(n2 >>> 24);
        byArray[n3 + n4 + 1] = (byte)(n2 >> 16);
        byArray[n3 + n4 + 2] = (byte)(n2 >> 8);
        byArray[n3 + n4 + 3] = (byte)n2;
        try {
            return Image.createImage((byte[])byArray, (int)0, (int)n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image PNG_SwitchPalette(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = byArray2[4] & 0xFF | (byArray2[5] & 0xFF) << 8;
        System.arraycopy(byArray2, 8 + n3 * n2, byArray, byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8, n3);
        return Image.createImage((byte[])byArray, (int)0, (int)n);
    }

    public static void SwitchNokiaPal(short[] sArray, byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = 0;
        n3 = n3 * n2 << 1;
        for (n4 = 0; n4 < n; ++n4) {
            n2 = byArray[n4] << 1;
            sArray[n4] = (short)(byArray2[n3 + n2] & 0xFF | (byArray2[n3 + n2 + 1] & 0xFF) << 8);
        }
    }

    public static void InsertionSort(int n, int[] nArray, int[] nArray2) {
        for (int i = 2; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            for (int j = i - 1; j > 0 && nArray[j] > n2; --j) {
                nArray[j + 1] = nArray[j];
                nArray2[j + 1] = nArray2[j];
            }
            nArray[j + 1] = n2;
            nArray2[j + 1] = n3;
        }
    }

    public static Image loadImage(String string, int n) {
        try {
            return Image.createImage((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void DrawPNGProSprite(Graphics graphics, Image image, byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        n *= n4;
        if (n4 == 6) {
            n2 -= byArray[n + 4] & 0xFF;
            n3 -= byArray[n + 5] & 0xFF;
        }
        graphics.setClip(n2, n3, byArray[n] & 0xFF, byArray[n + 1] & 0xFF);
        graphics.drawImage(image, n2 - (byArray[n + 2] & 0xFF), n3 - (byArray[n + 3] & 0xFF), 20);
        graphics.setClip(n5, n6, n7, n8);
    }

    public static void DrawPNGProSprite(Graphics graphics, Image image, short[] sArray, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        n *= n4;
        if (n4 == 6) {
            n2 -= sArray[n + 4];
            n3 -= sArray[n + 5];
        }
        graphics.setClip(n2, n3, (int)sArray[n], (int)sArray[n + 1]);
        graphics.drawImage(image, n2 - sArray[n + 2], n3 - sArray[n + 3], 20);
        graphics.setClip(n5, n6, n7, n8);
    }

    public static void drawRegularSprite(Graphics graphics, Image image, int n, int n2, int n3) {
        graphics.setClip(0, 0, 176, 208);
        graphics.drawImage(image, n, n2, n3);
    }

    public static void drawTileSprite(Graphics graphics, Image image, int n, int n2, boolean bl, int n3, int n4) {
        graphics.setClip(n, n2, 1 << n3, 1 << n3);
        graphics.drawImage(image, n, n2 - (1 << n3) * n4, 20);
    }

    public static void DrawMultiBoxFrame(Graphics graphics, Image[] imageArray, byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (byArray[0] == 6) {
            DDLUtility.DrawMultiBoxFrame2(graphics, imageArray, byArray, n, n2, n3, bl);
            return;
        }
        int n4 = 4 + n * 3;
        int n5 = byArray[n4];
        n4 = (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
        for (int i = 0; i < n5; ++i) {
            n = byArray[n4 + 1] & 0xFF;
            int n6 = byArray[n4 + 2] & 0xFF;
            int n7 = byArray[n4 + 3] & 0xFF;
            int n8 = byArray[n4 + 4] & 0xFF;
            byte by = byArray[n4 + 5];
            byte by2 = byArray[n4 + 6];
            byte by3 = byArray[n4];
            graphics.setClip(n2 + by, n3 + by2, n7, n8);
            graphics.drawImage(imageArray[by3], n2 - n + by, n3 - n6 + by2, 0);
            n4 += 7;
        }
    }

    public static byte[] LoadAndUnpackMultiboxFile(String string, int n) {
        byte[] byArray;
        byte[] byArray2 = byArray = DDLUtility.ReadByteArray(string, n);
        n = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
        int n2 = n << 1;
        int n3 = n2 + 4;
        for (n2 = 0; n2 < n; ++n2) {
            if ((byArray[n3 + 0] & 0x80) != 0) {
                byArray2[4 + (n2 << 1)] = (byte)n3;
                byArray2[4 + (n2 << 1) + 1] = (byte)(n3 >> 8);
                n3 += 4;
                continue;
            }
            byArray2[4 + (n2 << 1)] = (byte)n3;
            byArray2[4 + (n2 << 1) + 1] = (byte)(n3 >> 8);
            n3 += 2 + (byArray[n3 + 0] & 0x3F) * 6;
        }
        return byArray2;
    }

    public static void DrawMultiBoxFrame2(Graphics graphics, Image[] imageArray, byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        if (bl) {
            n4 = graphics.getClipX();
            n5 = graphics.getClipY();
            n6 = graphics.getClipWidth();
            n7 = graphics.getClipHeight();
        }
        int n8 = 4 + (n << 1);
        n8 = (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8] & 0xFF;
        byte by = byArray[n8];
        boolean bl2 = false;
        byte by2 = byArray[n8 + 1];
        if ((by & 0x80) != 0) {
            if ((by & 0x40) != 0) {
                bl2 = true;
            }
            n8 = (byArray[n8 + 3] & 0xFF) << 8 | byArray[n8 + 2] & 0xFF;
            by = byArray[n8];
        }
        n8 += 2;
        for (int i = 0; i < (by & 0x3F); ++i) {
            n = byArray[n8] & 0xFF;
            int n9 = byArray[n8 + 1] & 0xFF;
            int n10 = byArray[n8 + 2] & 0x7F;
            int n11 = byArray[n8 + 3] & 0x7F;
            byte by3 = byArray[n8 + 4];
            byte by4 = byArray[n8 + 5];
            int n12 = (byArray[n8 + 2] & 0x80) >> 6;
            n12 |= (byArray[n8 + 3] & 0x80) >> 7;
            if (bl2) {
                if (bl) {
                    graphics.setClip(n4, n5, n6, n7);
                } else {
                    graphics.setClip(0, 0, 176, 208);
                }
                graphics.drawRegion(imageArray[n12], n, n9, n10, n11, 2, n2 - n10 - by3 + by2, n3 + by4, 20);
            } else {
                if (bl) {
                    graphics.setClip(n4, n5, n6, n7);
                    graphics.clipRect(n2 + by3 - by2, n3 + by4, n10, n11);
                } else {
                    graphics.setClip(n2 + by3 - by2, n3 + by4, n10, n11);
                }
                graphics.drawImage(imageArray[n12], n2 - n + by3 - by2, n3 - n9 + by4, 20);
            }
            n8 += 6;
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    static void trace_in(String string, String string2, int n) {
        String string3 = "TRACE: +";
        ++G_traceDepth;
        for (int i = 0; i < G_traceDepth; ++i) {
            string3 = string3 + "-";
        }
        string3 = string3 + "> " + string;
        System.out.println(string3);
    }

    static void trace_out(String string, String string2, int n) {
        String string3 = "TRACE: +";
        for (int i = 0; i < G_traceDepth; ++i) {
            string3 = string3 + "-";
        }
        --G_traceDepth;
        string3 = string3 + "< " + string;
        System.out.println(string3);
    }

    public static void init() {
        DDLUtility.DoBuildAtanTab();
        DDLUtility.ReadSinTab();
        DDLUtility.initRandom();
    }

    public static void playVibrate(int n) {
        if (m_vibrateOn == 0) {
            return;
        }
        try {
            Display.getDisplay((MIDlet)m_Parent).vibrate(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static byte[] getStringBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static int getFreeMemory() {
        int n;
        int n2 = 65536;
        int n3 = 0;
        byte[][] byArrayArray = new byte[512][];
        System.gc();
        for (n = 0; n < 512; ++n) {
            try {
                byArrayArray[n] = new byte[n2];
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n3 = n * n2;
                break;
            }
        }
        while (n >= 0) {
            byArrayArray[n--] = null;
        }
        System.gc();
        return n3;
    }

    public static void printFreeHolesOnConsole() {
        int[] nArray = new int[10];
        DDLUtility.getFreeMemoryHoles(10, nArray);
        System.gc();
        System.gc();
    }

    public static int getFreeMemoryHoles(int n, int[] nArray) {
        int n2 = 0x400000;
        int n3 = 0;
        byte[][] byArrayArray = new byte[n][];
        System.gc();
        while (n3 < n) {
            try {
                System.gc();
                byte[] byArray = new byte[n2];
                nArray[n3] = n2;
                byArrayArray[n3] = byArray;
                ++n3;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if ((n2 -= 8192) > 65536) continue;
                nArray[n3++] = -65536;
                break;
            }
        }
        n = n3;
        while (n > 0) {
            byArrayArray[--n] = null;
        }
        System.gc();
        return n3;
    }

    static {
        G_traceDepth = 0;
    }
}

