/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;

public final class vTextEntry
extends vWindow {
    private vLabel m_textLabel;
    public String m_szText = new String();
    private Font m_font;
    private int m_kFgColor;
    private int m_kLineColor;
    private int m_iLabelStyle;
    private int m_iCursorPeriod;
    private int m_iLastKeyTime;
    private int m_iKeyCount;
    private int m_iLastKey;
    private int m_iFontFile;
    public int m_iTextLength;
    private int m_iMaxLength;
    private int m_iCursorPos;
    private int m_iCursorX;
    private int m_iEntryStyle;
    private int m_iWideCharWidth;
    private boolean m_bShowCursor;
    private boolean m_bOldShowCursor;
    private boolean m_bCursorOn;
    private boolean m_bNumeric;
    private boolean m_bAllowSpace;
    private boolean m_bAllowSymbols;
    private vRect m_tempRect = new vRect();

    public vTextEntry(vBaseCanvas canvas) {
        super(canvas, 0);
        this.m_textLabel = new vLabel(canvas);
        this.m_bAllowSpace = true;
        this.m_iLastKeyTime = -1;
        this.m_iClassID = 8;
        this.m_bShowCursor = true;
    }

    private int calcCursorX() {
        return this.m_app.m_font.measureString(this.m_szText.substring(0, this.m_iCursorPos)) + 2;
    }

    public final void setText(String szText) throws IOException {
        this.m_iCursorPos = 0;
        this.m_iCursorX = 2;
        this.m_iLastKey = 65535;
        this.m_szText = szText;
        this.m_iTextLength = szText.length();
        this.m_textLabel.setText(this.m_szText, true);
        if (this.m_iEntryStyle == 0) {
            this.sizeToChildren();
            this.setInnerDimensions(this.getInnerWidth() + 1 + 2, this.getInnerHeight());
            this.m_textLabel.setPosition(this.m_textLabel.getOuterX() + 2, this.m_textLabel.getOuterY());
        }
        this.repaint();
    }

    public final void onIdle(int iTime) throws IOException {
        this.repaint((vRect)null);
        boolean bOldCursorOn = this.m_bCursorOn;
        int iOldCursorPos = this.m_iCursorPos;
        boolean bl = this.m_bCursorOn = (iTime / (this.m_iCursorPeriod >> 1) & 1) > 0;
        if (iTime - this.m_iLastKeyTime > 1000 && this.m_iLastKey != 65535) {
            if (this.m_iCursorPos < this.m_iMaxLength && this.m_iCursorPos < this.m_iTextLength) {
                ++this.m_iCursorPos;
            }
            this.m_iLastKey = 65535;
            this.m_iCursorX = this.m_szText != null ? this.calcCursorX() : 2;
            if (this.m_iEntryStyle == 1) {
                int sXPos = this.m_textLabel.getOuterX() + this.m_iCursorX;
                if (sXPos < 2) {
                    this.m_textLabel.setPosition(2 - this.m_iCursorX, this.m_textLabel.getOuterY());
                }
                if (sXPos > this.getInnerWidth() - this.m_iWideCharWidth - 4 && this.m_font.stringWidth(this.m_szText.substring(0, this.m_iTextLength)) + 4 > this.getInnerWidth()) {
                    this.m_textLabel.setPosition(2 - this.m_iCursorX + (this.getInnerWidth() - 4 - this.m_iWideCharWidth) - 2, this.m_textLabel.getOuterY());
                }
            }
        }
        if (iOldCursorPos != this.m_iCursorPos) {
            this.repaint((vRect)null);
        }
        if (this.m_bOldShowCursor != this.m_bShowCursor || this.m_bCursorOn != bOldCursorOn) {
            if (this.m_bShowCursor || this.m_bOldShowCursor) {
                this.repaint((vRect)null);
            }
            this.m_bOldShowCursor = this.m_bShowCursor;
        }
    }

    public final boolean onKey(int iKey, int iAction) throws IOException {
        String[] acKeyChars = new String[]{"0", "1.@?!-_,&:'", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9", " "};
        this.repaint();
        this.m_iLastKeyTime = vBaseCanvas.getAppTime();
        switch (iAction) {
            case 0x10000000: {
                this.m_iLastKey = 65535;
                if (this.m_iTextLength <= 0) break;
                if (this.m_iCursorPos > 0) {
                    this.m_szText = this.m_szText.substring(0, this.m_iCursorPos - 1) + this.m_szText.substring(this.m_iCursorPos, this.m_szText.length());
                    --this.m_iCursorPos;
                    this.m_iCursorX = this.calcCursorX();
                } else {
                    this.m_szText = this.m_szText.substring(1, this.m_szText.length());
                }
                --this.m_iTextLength;
                this.m_textLabel.setText(this.m_szText, true);
                if (this.m_iEntryStyle != 0) break;
                this.sizeToChildren();
                this.setInnerDimensions(this.getInnerWidth() + 1 + 2, this.getInnerHeight());
                this.m_textLabel.setPosition(this.m_textLabel.getOuterX() + 2, this.m_textLabel.getOuterY());
                break;
            }
            default: {
                int iArrayIndex = 0;
                switch (iKey) {
                    case 1: {
                        iArrayIndex = 0;
                        break;
                    }
                    case 2: {
                        iArrayIndex = 1;
                        break;
                    }
                    case 4: {
                        iArrayIndex = 2;
                        break;
                    }
                    case 8: {
                        iArrayIndex = 3;
                        break;
                    }
                    case 16: {
                        iArrayIndex = 4;
                        break;
                    }
                    case 32: {
                        iArrayIndex = 5;
                        break;
                    }
                    case 64: {
                        iArrayIndex = 6;
                        break;
                    }
                    case 128: {
                        iArrayIndex = 7;
                        break;
                    }
                    case 256: {
                        iArrayIndex = 8;
                        break;
                    }
                    case 512: {
                        iArrayIndex = 9;
                        break;
                    }
                    case 2048: {
                        if (this.m_bNumeric || !this.m_bAllowSpace) {
                            iArrayIndex = -1;
                            break;
                        }
                        iArrayIndex = 10;
                        break;
                    }
                    default: {
                        iArrayIndex = -1;
                    }
                }
                if (iArrayIndex == -1) {
                    switch (iAction) {
                        case 32768: {
                            this.m_iLastKey = 65535;
                            if (this.m_iCursorPos <= 0) break;
                            --this.m_iCursorPos;
                            this.m_iCursorX = this.calcCursorX();
                            break;
                        }
                        case 65536: {
                            this.m_iLastKey = 65535;
                            if (this.m_iCursorPos >= this.m_iTextLength) break;
                            ++this.m_iCursorPos;
                            this.m_iCursorX = this.calcCursorX();
                        }
                    }
                    break;
                }
                if (this.m_iCursorPos >= this.m_iMaxLength) break;
                if (!this.m_bNumeric) {
                    if (this.m_iCursorPos == this.m_iMaxLength - 1 || this.m_iLastKey == 65535 || this.m_iLastKey == iKey) {
                        this.m_iKeyCount = iKey != this.m_iLastKey ? 0 : ++this.m_iKeyCount;
                    } else {
                        ++this.m_iCursorPos;
                        this.m_iKeyCount = 0;
                    }
                }
                if (this.m_bNumeric) {
                    String szTemp = "";
                    if (this.m_szText.length() > 0 && this.m_iCursorPos <= this.m_szText.length()) {
                        szTemp = new String(this.m_szText.substring(0, this.m_iCursorPos));
                    }
                    szTemp = szTemp + Integer.toString(iArrayIndex);
                    if (this.m_szText.length() > 0 && this.m_iCursorPos + 1 <= this.m_szText.length()) {
                        szTemp = szTemp + new String(this.m_szText.substring(this.m_iCursorPos + 1, this.m_szText.length()));
                    }
                    this.m_szText = new String(szTemp);
                    this.m_iTextLength = this.m_szText.length();
                    if (this.m_iCursorPos < this.m_iMaxLength - 1) {
                        ++this.m_iCursorPos;
                        this.m_iKeyCount = 0;
                    }
                } else {
                    int r = this.m_iKeyCount % acKeyChars[iArrayIndex].length();
                    if (iKey == 2 && !this.m_bAllowSymbols) {
                        r = 0;
                    }
                    String szTemp = "";
                    if (this.m_szText.length() > 0 && this.m_iCursorPos <= this.m_szText.length()) {
                        szTemp = new String(this.m_szText.substring(0, this.m_iCursorPos));
                    }
                    szTemp = szTemp + acKeyChars[iArrayIndex].charAt(r);
                    if (this.m_szText.length() > 0 && this.m_iCursorPos + 1 <= this.m_szText.length()) {
                        szTemp = szTemp + new String(this.m_szText.substring(this.m_iCursorPos + 1, this.m_szText.length()));
                    }
                    this.m_szText = new String(szTemp);
                    this.m_iTextLength = this.m_szText.length();
                }
                this.m_iLastKey = iKey;
                this.m_textLabel.setText(this.m_szText, true);
                if (this.m_iEntryStyle == 0) {
                    this.sizeToChildren();
                    this.setInnerDimensions(this.getInnerWidth() + 1 + 2, this.getInnerHeight());
                    this.m_textLabel.setPosition(this.m_textLabel.getOuterX() + 2, this.m_textLabel.getOuterY());
                }
                this.m_iCursorX = this.calcCursorX();
            }
        }
        if (this.m_iEntryStyle == 1) {
            int sXPos = this.m_textLabel.getOuterX() + this.m_iCursorX;
            if (sXPos < 2) {
                this.m_textLabel.setPosition(2 - this.m_iCursorX, this.m_textLabel.getOuterY());
            }
            if (sXPos > this.getInnerWidth() - this.m_iWideCharWidth - 4 && this.m_app.m_font.measureString(this.m_szText.substring(0, this.m_iTextLength)) + 4 > this.getInnerWidth()) {
                this.m_textLabel.setPosition(2 - this.m_iCursorX + (this.getInnerWidth() - 4 - this.m_iWideCharWidth) - 2, this.m_textLabel.getOuterY());
            }
        }
        this.repaint();
        return true;
    }

    public final void paint(vGraphics graphics) {
        int m_iNewX = this.m_iCursorX;
        if (this.m_iEntryStyle == 1) {
            m_iNewX += this.m_textLabel.getOuterX();
        }
        super.paint(graphics);
        if (this.m_bShowCursor && this.m_bCursorOn) {
            graphics.translate(this.getOuterX(), this.getOuterY());
            graphics.translate(this.getInnerX(), this.getInnerY());
            if ((this.m_iLabelStyle & 2) != 0) {
                this.m_tempRect.set(m_iNewX, 1, 3, this.m_textLabel.getOuterHeight() - 2);
                graphics.fillOutlinedRect(this.m_tempRect, this.m_kLineColor, this.m_kFgColor);
            } else if ((this.m_iLabelStyle & 1) != 0) {
                graphics.drawLine(m_iNewX, 1, m_iNewX, this.m_textLabel.getOuterHeight() - 3, this.m_kFgColor);
                graphics.drawLine(m_iNewX + 1, 2, m_iNewX + 1, this.m_textLabel.getOuterHeight() - 2, this.m_kLineColor);
            } else {
                graphics.drawLine(m_iNewX, 1, m_iNewX, this.m_textLabel.getOuterHeight() - 2, this.m_kFgColor);
            }
            graphics.translate(-this.getInnerX(), -this.getInnerY());
            graphics.translate(-this.getOuterX(), -this.getOuterY());
        }
    }

    protected final void readElement(DataInputStream dis) throws IOException {
        this.readParams(dis);
        this.m_iType = 0;
        this.m_kFgColor = dis.readInt();
        this.m_kLineColor = dis.readInt();
        this.m_iLabelStyle = dis.readInt();
        this.m_iFontFile = dis.readShort();
        this.m_iMaxLength = dis.readShort();
        this.m_iCursorPeriod = dis.readInt();
        this.m_bShowCursor = dis.readBoolean();
        this.m_bNumeric = dis.readBoolean();
        this.m_bAllowSpace = dis.readBoolean();
        this.m_bAllowSymbols = dis.readBoolean();
        this.m_iEntryStyle = dis.readShort();
        this.m_bOldShowCursor = !this.m_bShowCursor;
        int[] nArray = vBaseCanvas.getSharedLabelConstructionInfo();
        int[] labelInfo = nArray;
        nArray[0] = this.m_kFgColor;
        labelInfo[1] = this.m_kLineColor;
        labelInfo[2] = this.m_iLabelStyle;
        labelInfo[3] = 1;
        labelInfo[4] = -1;
        labelInfo[5] = this.m_iFontFile;
        labelInfo[6] = 1;
        this.m_textLabel = new vLabel(this.m_app, labelInfo);
        this.addToBack(this.m_textLabel);
    }

    protected final void initElement() throws IOException {
        super.initElement();
        this.m_textLabel.setText("", true);
        this.m_szText = "";
        this.m_iCursorPos = 0;
        this.m_iCursorX = 2;
        this.m_iKeyCount = 0;
        this.m_iLastKeyTime = -1;
        this.m_iLastKey = 65535;
        this.m_iTextLength = 0;
        this.m_iWideCharWidth = this.m_app.m_font.measureString("W");
        if (this.m_iEntryStyle == 0) {
            this.sizeToChildren();
            this.setInnerDimensions(this.getInnerWidth() + 1 + 2, this.getInnerHeight());
        } else {
            this.setInnerDimensions(this.getInnerWidth() + 2 + 2, this.m_textLabel.getInnerHeight());
        }
        this.m_textLabel.setPosition(2, this.m_textLabel.getOuterY());
    }

    protected final void freeElement() {
    }
}

