/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class vTextControl
extends vWindow {
    private vRect m_scrollBarRect = new vRect();
    private vRect m_scrollBarThumbRect = new vRect();
    private int m_iTextStyle;
    private int m_iControlStyle;
    private String m_szText;
    private int[] m_aiLineOffsets = new int[200];
    private int m_kFgColor;
    private int m_kScrollFg;
    private int m_kScrollBg;
    private int m_kLineColor;
    private int m_iCurrentLine;
    private int m_iNumLines;
    private int m_iLinesPerPage;
    private int m_iLineHeight;
    private int m_iTextWidth;
    private int m_iTextLength;
    private int m_iRenderLength;
    private int m_iStringID;
    private int m_iLineSpacing;
    private int m_iJustify;

    public vTextControl(vBaseCanvas canvas) {
        super(canvas, 0);
        this.m_iClassID = 4;
    }

    public final void readElement(DataInputStream dis) throws IOException {
        this.readParams(dis);
        this.m_iType = 0;
        dis.readShort();
        this.m_iTextStyle = dis.readInt();
        this.m_iControlStyle = dis.readInt();
        this.m_iJustify = dis.readShort();
        this.m_kFgColor = dis.readInt();
        this.m_kLineColor = dis.readInt();
        this.m_kScrollFg = dis.readInt();
        this.m_kScrollBg = dis.readInt();
        this.m_iStringID = dis.readShort();
        this.m_iLineSpacing = dis.readShort();
    }

    public final void initElement() throws IOException {
        int iNewHeight;
        int iMaxWidth;
        super.initElement();
        this.m_iCurrentLine = 0;
        this.m_iNumLines = 0;
        this.m_iTextWidth = this.getInnerWidth() - 6;
        if (this.m_iStringID != -1) {
            this.setText(this.m_iStringID);
        }
        this.m_iLineHeight = this.m_app.m_font.getHeight() + this.m_iLineSpacing;
        this.m_iLinesPerPage = (this.getInnerHeight() + this.m_iLineSpacing - 6) / this.m_iLineHeight;
        if (this.m_szText == null) {
            return;
        }
        if (this.hasStyle(8)) {
            this.m_iTextWidth -= 5;
            iMaxWidth = this.splitText(this.m_szText);
        } else {
            iMaxWidth = this.splitText(this.m_szText);
            if (this.m_iNumLines > this.m_iLinesPerPage && !this.hasStyle(4)) {
                this.m_iTextWidth -= 5;
                iMaxWidth = this.splitText(this.m_szText);
            }
        }
        if (this.hasStyle(2) && (iNewHeight = this.m_iLineHeight * this.m_iNumLines + 6 - this.m_iLineSpacing) < this.getInnerHeight()) {
            this.m_iLinesPerPage = this.m_iNumLines;
            this.setInnerDimensions(this.getInnerWidth(), iNewHeight);
        }
        if (this.hasStyle(1)) {
            this.m_iTextWidth = iMaxWidth;
            int iNewWidth = iMaxWidth + 6;
            if (this.isScrollable() && !this.hasStyle(4)) {
                iNewWidth += 5;
            }
            if (iNewWidth < this.getInnerWidth()) {
                this.setInnerDimensions(iNewWidth, this.getInnerHeight());
            }
        }
        this.m_iRenderLength = this.m_iTextLength;
    }

    public final void freeElement() throws IOException {
    }

    public final void paint(vGraphics graphics) {
        super.paint(graphics);
        graphics.translate(this.m_windowRect.x, this.m_windowRect.y);
        graphics.translate(this.m_clientRect.x, this.m_clientRect.y);
        int iY = 3;
        int iEnd = this.m_iCurrentLine + this.m_iLinesPerPage;
        if (iEnd > this.m_iNumLines) {
            iEnd = this.m_iNumLines;
        }
        int iCharactersRendered = 0;
        for (int i = this.m_iCurrentLine; i < iEnd && this.m_szText.length() != this.m_aiLineOffsets[i]; ++i) {
            char src = this.m_szText.charAt(this.m_aiLineOffsets[i]);
            if (src != '$') {
                int iDelta;
                int iLineStart = this.m_aiLineOffsets[i];
                int iLineEnd = this.m_aiLineOffsets[i + 1];
                if (iLineEnd == 0) break;
                int iLength = iLineEnd - iLineStart;
                if (iLength <= 0) {
                    System.out.println("VASSERT failed ::iLength > 0");
                }
                while (this.m_szText.charAt(this.m_aiLineOffsets[i] + iLength - 1) == '$') {
                    --iLength;
                }
                if ((iCharactersRendered += iLength) > this.m_iRenderLength && (iLength -= (iDelta = iCharactersRendered - this.m_iRenderLength)) <= 0) break;
                this.renderText(graphics, 3, iY, this.m_aiLineOffsets[i], iLength);
            }
            iY += this.m_iLineHeight;
        }
        if (!this.hasStyle(4) && this.isScrollable()) {
            int barHeight = this.getInnerHeight() - 6;
            this.m_scrollBarRect.set(this.getInnerWidth() - 5, 3, 3, barHeight);
            this.m_scrollBarThumbRect.set(this.m_scrollBarRect);
            this.m_scrollBarThumbRect.dy = this.m_iLinesPerPage * barHeight / this.m_iNumLines;
            this.m_scrollBarThumbRect.dy = Math.max(this.m_scrollBarThumbRect.dy, 1);
            this.m_scrollBarThumbRect.y = this.m_iCurrentLine + this.m_iLinesPerPage == this.m_iNumLines ? this.m_scrollBarRect.y + this.m_scrollBarRect.dy - this.m_scrollBarThumbRect.dy : barHeight * this.m_iCurrentLine / this.m_iNumLines + 3;
            graphics.fillRect(this.m_scrollBarRect, this.m_kScrollBg);
            graphics.fillRect(this.m_scrollBarThumbRect, this.m_kScrollFg);
        }
        graphics.translate(-this.m_clientRect.x, -this.m_clientRect.y);
        graphics.translate(-this.m_windowRect.x, -this.m_windowRect.y);
    }

    private void setLine(int iLine) {
        int iLastLine = Math.max(0, this.m_iNumLines - this.m_iLinesPerPage);
        int iOld = this.m_iCurrentLine;
        this.m_iCurrentLine = vBaseCanvas.clamp(iLine, 0, iLastLine);
        if (iOld != this.m_iCurrentLine) {
            this.repaint();
        }
    }

    public final void nextPage() {
        this.setLine(this.m_iCurrentLine + this.m_iLinesPerPage - 1);
    }

    public final void prevPage() {
        this.setLine(this.m_iCurrentLine - this.m_iLinesPerPage + 1);
    }

    public final void setText(String szText) {
        this.m_iStringID = -1;
        int i = szText.indexOf("%version");
        this.m_szText = i >= 0 ? szText.substring(0, i) + this.m_app.m_midlet.getAppProperty("MIDlet-Version") + szText.substring(i + 8) : szText;
        if (this.m_szText != null) {
            this.m_iTextLength = this.m_szText.length();
            return;
        }
        this.m_iTextLength = 0;
    }

    public final void setText(int iStringID) {
        this.m_iStringID = iStringID;
        this.setText(vBaseCanvas.getString(this.m_iStringID));
    }

    private boolean hasStyle(int iStyle) {
        return (this.m_iControlStyle & iStyle) > 0;
    }

    private boolean isScrollable() {
        return this.m_iNumLines > this.m_iLinesPerPage;
    }

    private int splitText(String szText) {
        for (int i = 0; i < 200; ++i) {
            this.m_aiLineOffsets[i] = 0;
        }
        int iLengthPad = 0;
        int iWidestLine = 0;
        int iTotalCharactersPerLine = 0;
        int iNumSplitDollarLines = 1;
        int iFragmentLength = 0;
        int iCurFragmentLength = 0;
        if ((this.m_iTextStyle & 1) != 0) {
            ++iLengthPad;
        }
        if ((this.m_iTextStyle & 2) != 0) {
            iLengthPad += 2;
        }
        int i = 1;
        for (int iIter = 0; iIter < szText.length(); ++iIter) {
            if (szText.charAt(iIter) != '$') continue;
            this.m_aiLineOffsets[i] = iIter + 1;
            ++i;
            ++iNumSplitDollarLines;
        }
        int[] aiSplitDollarLines = new int[iNumSplitDollarLines + 1];
        for (i = 0; i < iNumSplitDollarLines; ++i) {
            aiSplitDollarLines[i] = this.m_aiLineOffsets[i];
        }
        aiSplitDollarLines[++iNumSplitDollarLines - 1] = szText.length();
        this.m_iNumLines = 0;
        int iEndIndex = 0;
        for (int i2 = 0; i2 < iNumSplitDollarLines - 1; ++i2) {
            this.m_aiLineOffsets[this.m_iNumLines] = aiSplitDollarLines[i2];
            ++this.m_iNumLines;
            int iBeginIndex = aiSplitDollarLines[i2];
            iEndIndex = Math.min(iBeginIndex + iTotalCharactersPerLine, aiSplitDollarLines[i2 + 1] - 1);
            iEndIndex = this.getIndex(iBeginIndex, iEndIndex, szText, iLengthPad);
            while (iBeginIndex < aiSplitDollarLines[i2 + 1]) {
                iCurFragmentLength = 0;
                int iOffsetIndex = 0;
                int iIndexOffset = iBeginIndex;
                while (iEndIndex < aiSplitDollarLines[i2 + 1] && iCurFragmentLength < this.m_iTextWidth) {
                    if ((++iEndIndex >= szText.length() || szText.charAt(iEndIndex) != ' ') && iEndIndex != aiSplitDollarLines[i2 + 1] - 1 || (iCurFragmentLength += this.m_app.m_font.measureString(szText.substring(iIndexOffset = iEndIndex, iEndIndex)) + iLengthPad) >= this.m_iTextWidth) continue;
                    iFragmentLength = iCurFragmentLength;
                    iOffsetIndex = iEndIndex;
                }
                if (iOffsetIndex != 0 && iEndIndex < aiSplitDollarLines[i2 + 1]) {
                    this.m_aiLineOffsets[this.m_iNumLines] = iOffsetIndex + 1;
                    if (iFragmentLength > iWidestLine) {
                        iWidestLine = iFragmentLength;
                        iTotalCharactersPerLine = this.m_aiLineOffsets[this.m_iNumLines] - this.m_aiLineOffsets[this.m_iNumLines - 1];
                    }
                    ++this.m_iNumLines;
                    iBeginIndex = iOffsetIndex + 1;
                } else {
                    iIndexOffset = iEndIndex;
                    if (iEndIndex != szText.length()) {
                        --iIndexOffset;
                    }
                    if ((iFragmentLength = this.m_app.m_font.measureString(szText.substring(this.m_aiLineOffsets[this.m_iNumLines - 1], iIndexOffset)) + iLengthPad) > iWidestLine) {
                        iWidestLine = iFragmentLength;
                    }
                    iBeginIndex = iEndIndex + 1;
                }
                iEndIndex = Math.min(iBeginIndex + iTotalCharactersPerLine, aiSplitDollarLines[i2 + 1] - 1);
                iEndIndex = this.getIndex(iBeginIndex, iEndIndex, szText, iLengthPad);
            }
        }
        this.m_aiLineOffsets[this.m_iNumLines] = szText.length();
        return iWidestLine;
    }

    private int getIndex(int iBeginIndex, int iEndIndex, String szText, int iLengthPad) {
        int iFragmentLength = 0;
        int iFinalIndex = -1;
        while (iEndIndex > iBeginIndex) {
            if (szText.charAt(iEndIndex) == ' ') {
                iFragmentLength = iFinalIndex == -1 ? this.m_app.m_font.measureString(szText.substring(iBeginIndex, iEndIndex)) + iLengthPad : (iFragmentLength -= this.m_app.m_font.measureString(szText.substring(iEndIndex, iFinalIndex)) + iLengthPad);
                iFinalIndex = iEndIndex--;
                if (iFragmentLength < this.m_iTextWidth) break;
            }
            --iEndIndex;
        }
        return iEndIndex;
    }

    private void renderText(vGraphics graphics, int iX, int iY, int iOffset, int iLength) {
        int iStringWidth = this.m_app.m_font.measureString(this.m_szText.substring(iOffset, iLength + iOffset));
        if (this.m_szText != null) {
            int x = iX;
            switch (this.m_iJustify) {
                case 1: {
                    x += this.m_iTextWidth - iStringWidth + 1 >> 1;
                    break;
                }
                case 2: {
                    x += this.m_iTextWidth - iStringWidth;
                }
            }
            this.m_app.m_font.drawString(graphics, this.m_szText.substring(iOffset, iLength + iOffset), x - 1, iY + 2);
        }
    }
}

