/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Display;

public final class TC2App
extends vBaseCanvas {
    public GamePref m_gamePref = new GamePref();
    private vWindow m_deferedWindow = null;
    private int m_iDeferedLoadStage = 0;
    private int m_iDeferedOpenWindowID = -1;
    private int m_iDeferedOpenMenuID = -1;
    private boolean m_bDeferedClosePrevious = false;
    private int[] m_iReturnWindowID = new int[16];
    private int[] m_iReturnMenuID = new int[16];
    private int m_iReturnStackSize;
    private boolean m_bDataInitialized = false;
    private Game m_game;
    private int m_iCallbackType;
    public int m_iDeferedSlotIndex;
    public String m_sDeferedSlotName;
    public boolean m_bInMenuFromGame = false;
    public int m_iMapCursorX = Integer.MAX_VALUE;
    public int m_iMapCursorY = Integer.MAX_VALUE;

    TC2App(TC2MIDlet midlet, Display display) {
        super(midlet, display, "/s.v");
        try {
            vSprite whiteFont = this.loadSprite(180, 14, -1, -1, 180, 18);
            this.m_font_white = new vBitmapFont();
            this.m_font_white.m_sprite = whiteFont;
            vSprite redFont = this.loadSprite(180, 16, -1, -1, 180, 18);
            this.m_font_red = new vBitmapFont();
            this.m_font_red.m_sprite = redFont;
            vSprite greenFont = this.loadSprite(180, 15, -1, -1, 180, 18);
            this.m_font_green = new vBitmapFont();
            this.m_font_green.m_sprite = greenFont;
            vSprite blackFont = this.loadSprite(180, 17, -1, -1, 180, 18);
            this.m_font_black = new vBitmapFont();
            this.m_font_black.m_sprite = blackFont;
            this.m_font = this.m_font_white;
        }
        catch (IOException iOException) {
            System.out.println("exception loading font sprite");
        }
        vBaseCanvas.LOADCOLOR_SCREEN_BG = 0;
        vBaseCanvas.LOADCOLOR_BAR_BG = 0x3F3F3F;
        vBaseCanvas.LOADCOLOR_BAR_FILL = 0xFF0000;
        vBaseCanvas.LOADCOLOR_BAR_HILITE = 16128;
        vBaseCanvas.LOADCOLOR_BAR_BORDER = 63;
    }

    protected final void onStart() throws IOException {
        System.out.println("TC2App.onStart");
        this.createKeyLabels(0xFF0000, 0x4E0000, 0, 0, true);
        this.setKeyLabels(-1, -1);
        try {
            Class.forName("TC2App");
            Class.forName("ConversationResponse");
            Class.forName("ConversationSnippet");
            Class.forName("ConversationSnippetCollection");
            Class.forName("Definition");
            Class.forName("Engine");
            Class.forName("Game");
            Class.forName("GameWindow");
            Class.forName("KDTree2D");
            Class.forName("MapWindow");
            Class.forName("MenuWindow");
            Class.forName("PauseWindow");
            Class.forName("PropertyTable");
            Class.forName("Sector");
            Class.forName("vDictionary");
            Class.forName("vLinkedList");
            Class.forName("vNode");
            Class.forName("vVector3");
            Class.forName("vBitmapFont");
            Class.forName("vGraphics");
            Class.forName("vLabel");
            Class.forName("vRect");
            Class.forName("vSprite");
            Class.forName("vSpriteData");
            Class.forName("vTextControl");
            Class.forName("vTextEntry");
            Class.forName("vUIElement");
            Class.forName("vUISprite");
            Class.forName("vWindow");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.m_bInMenuFromGame = false;
        this.openMenu(1, false, 2);
    }

    public final Game createGame() throws IOException {
        this.m_game = new Game();
        this.m_game.init(this);
        return this.m_game;
    }

    protected final void onStop() throws IOException {
        System.out.println("TC2App.onStop");
        this.saveGamePref();
        if (this.m_game != null) {
            this.m_game.shutdown();
            this.m_game = null;
        }
    }

    protected final void onSuspend() throws IOException {
        System.out.println("TC2App.onSuspend");
    }

    protected final void onResume() throws IOException {
        System.out.println("TC2App.onResume");
        this.clearKeyEvents();
    }

    public final void resumeSound() {
    }

    public final int preloadImages(int iStage) throws IOException {
        switch (iStage) {
            case 0: {
                vBaseCanvas.loadPalPixels(183, 2, 183, 3);
                vBaseCanvas.loadPalPixels(183, 5, 183, 6);
                vBaseCanvas.loadImage(183, 0);
                vBaseCanvas.loadImage(183, 8);
                vBaseCanvas.loadImage(183, 9);
                this.loadSpriteData(183, 1);
                this.loadSpriteData(183, 4);
                this.loadSpriteData(183, 7);
                return 10;
            }
            case 1: {
                vBaseCanvas.loadPalPixels(184, 3, 184, 4);
                vBaseCanvas.loadPalPixels(184, 0, 184, 1);
                this.loadSpriteData(184, 5);
                this.loadSpriteData(184, 2);
                return 20;
            }
            case 2: {
                vBaseCanvas.loadPalPixels(185, 0, 185, 1);
                vBaseCanvas.loadPalPixels(185, 3, 185, 4);
                this.loadSpriteData(185, 2);
                this.loadSpriteData(185, 5);
                return 30;
            }
            case 3: {
                vBaseCanvas.loadImage(182, 2);
                vBaseCanvas.loadImage(182, 0);
                this.loadSpriteData(182, 3);
                this.loadSpriteData(182, 1);
                return 60;
            }
            case 4: {
                vBaseCanvas.loadImage(190, 0);
                vBaseCanvas.loadImage(190, 1);
                vBaseCanvas.loadImage(190, 2);
                vBaseCanvas.loadImage(190, 3);
                vBaseCanvas.loadImage(190, 4);
                vBaseCanvas.loadImage(190, 5);
                vBaseCanvas.loadImage(190, 6);
                vBaseCanvas.loadImage(190, 7);
                vBaseCanvas.loadImage(190, 8);
                vBaseCanvas.loadImage(190, 9);
                vBaseCanvas.loadImage(190, 10);
                vBaseCanvas.loadImage(190, 11);
                vBaseCanvas.loadImage(190, 12);
                vBaseCanvas.loadImage(190, 13);
                vBaseCanvas.loadImage(190, 14);
                vBaseCanvas.loadImage(190, 15);
                vBaseCanvas.loadImage(190, 16);
                vBaseCanvas.loadImage(190, 17);
                vBaseCanvas.loadImage(190, 18);
                vBaseCanvas.loadImage(190, 19);
                vBaseCanvas.loadImage(190, 20);
                return 80;
            }
            case 5: {
                vBaseCanvas.loadImage(191, 0);
                vBaseCanvas.loadImage(191, 1);
                vBaseCanvas.loadImage(191, 2);
                vBaseCanvas.loadImage(191, 3);
                vBaseCanvas.loadImage(191, 4);
                vBaseCanvas.loadImage(191, 5);
                vBaseCanvas.loadImage(191, 6);
                vBaseCanvas.loadImage(191, 7);
                vBaseCanvas.loadImage(191, 8);
                vBaseCanvas.loadImage(191, 9);
                vBaseCanvas.loadImage(191, 10);
                vBaseCanvas.loadImage(191, 11);
                vBaseCanvas.loadImage(191, 12);
                vBaseCanvas.loadImage(191, 13);
                vBaseCanvas.loadImage(191, 14);
                vBaseCanvas.loadImage(191, 15);
                vBaseCanvas.loadImage(191, 16);
                vBaseCanvas.loadImage(191, 17);
                vBaseCanvas.loadImage(191, 18);
                vBaseCanvas.loadImage(191, 19);
                vBaseCanvas.loadImage(191, 20);
                vBaseCanvas.loadImage(191, 21);
                vBaseCanvas.loadImage(191, 22);
                vBaseCanvas.loadImage(191, 23);
                vBaseCanvas.loadImage(191, 24);
                vBaseCanvas.loadImage(191, 25);
                vBaseCanvas.loadImage(191, 26);
                vBaseCanvas.loadImage(191, 27);
                vBaseCanvas.loadImage(191, 28);
                vBaseCanvas.loadImage(191, 29);
                vBaseCanvas.loadImage(191, 30);
                vBaseCanvas.loadImage(191, 31);
                vBaseCanvas.loadImage(191, 32);
                vBaseCanvas.loadImage(191, 33);
                vBaseCanvas.loadImage(191, 34);
                vBaseCanvas.loadImage(191, 35);
                vBaseCanvas.loadImage(191, 36);
                vBaseCanvas.loadImage(191, 37);
                vBaseCanvas.loadImage(191, 38);
                vBaseCanvas.loadImage(191, 39);
                vBaseCanvas.loadImage(191, 40);
                vBaseCanvas.loadImage(191, 41);
                vBaseCanvas.loadImage(191, 42);
                vBaseCanvas.loadImage(191, 43);
                vBaseCanvas.loadImage(191, 44);
                vBaseCanvas.loadImage(191, 45);
                vBaseCanvas.loadImage(191, 46);
                vBaseCanvas.loadImage(191, 47);
                vBaseCanvas.loadImage(191, 48);
                vBaseCanvas.loadImage(191, 49);
                vBaseCanvas.loadImage(191, 50);
                vBaseCanvas.loadImage(191, 51);
                vBaseCanvas.loadImage(191, 52);
                vBaseCanvas.loadImage(191, 53);
                vBaseCanvas.loadImage(191, 54);
                vBaseCanvas.loadImage(191, 55);
                vBaseCanvas.loadImage(191, 56);
                return 90;
            }
            case 6: {
                vBaseCanvas.loadImage(180, 20);
                vBaseCanvas.loadImage(180, 10);
                vBaseCanvas.loadImage(180, 12);
                vBaseCanvas.loadImage(180, 3);
                vBaseCanvas.loadImage(180, 0);
                vBaseCanvas.loadImage(180, 19);
                vBaseCanvas.loadImage(180, 4);
                vBaseCanvas.loadImage(180, 14);
                vBaseCanvas.loadImage(180, 15);
                vBaseCanvas.loadImage(180, 16);
                vBaseCanvas.loadImage(180, 17);
                vBaseCanvas.loadImage(180, 2);
                vBaseCanvas.loadImage(180, 5);
                vBaseCanvas.loadImage(180, 6);
                vBaseCanvas.loadImage(180, 7);
                vBaseCanvas.loadImage(180, 8);
                vBaseCanvas.loadImage(180, 9);
                vBaseCanvas.loadImage(180, 1);
                vBaseCanvas.loadImage(180, 21);
                this.loadSpriteData(180, 11);
                this.loadSpriteData(180, 18);
                this.loadSpriteData(180, 13);
                this.loadSpriteData(180, 22);
                return 100;
            }
        }
        return 100;
    }

    protected final void initData() {
        System.out.println("initData");
        this.loadGamePref();
        this.m_bDataInitialized = true;
    }

    private void loadPrefsCallback(DataInputStream ds) throws IOException {
        this.m_gamePref.iVersion = ds.readInt();
        if (this.m_gamePref.iVersion != 4) {
            return;
        }
        this.m_gamePref.iSoundEnabled = ds.readInt();
        this.m_gamePref.iDifficulty = ds.readInt();
    }

    private void savePrefsCallback(DataOutputStream ds) throws IOException {
        if (!this.m_bDataInitialized) {
            return;
        }
        ds.writeInt(this.m_gamePref.iVersion);
        ds.writeInt(this.m_gamePref.iSoundEnabled);
        ds.writeInt(this.m_gamePref.iDifficulty);
    }

    protected final void onReadGameData(DataInputStream ds) throws IOException {
        switch (this.m_iCallbackType) {
            case 0: {
                this.loadPrefsCallback(ds);
                return;
            }
            case 1: {
                this.m_game.loadSlotCallback(ds);
                return;
            }
            case 2: {
                this.m_game.loadAutoCallback(ds);
                return;
            }
        }
        System.out.println("VASSERT failed ::false");
    }

    protected final void onWriteGameData(DataOutputStream ds) throws IOException {
        switch (this.m_iCallbackType) {
            case 0: {
                this.savePrefsCallback(ds);
                return;
            }
            case 1: {
                this.m_game.saveSlotCallback(ds);
                return;
            }
            case 2: {
                this.m_game.saveAutoCallback(ds);
                return;
            }
        }
        System.out.println("VASSERT failed ::false");
    }

    public final vUIElement createObject(int iType) {
        switch (iType) {
            case 0: {
                return new vWindow(this, 0);
            }
            case 1: {
                return new vLabel(this);
            }
            case 2: {
                return new vUISprite(this);
            }
            case 4: {
                return new vTextControl(this);
            }
            case 8: {
                return new vTextEntry(this);
            }
            case 1000: {
                return new MenuWindow(this.m_game, this);
            }
            case 1001: {
                return new GameWindow(this.m_game, this);
            }
            case 1002: {
                return new MapWindow(this.m_game, this);
            }
            case 1003: {
                return new PauseWindow(this.m_game, this);
            }
        }
        System.out.println("VASSERT_MSG failed ::false | TC2App.createObject -- unknown type");
        return null;
    }

    public final void onService(int iServiceType) throws IOException {
        switch (iServiceType) {
            case 2: {
                if (this.m_iDeferedOpenWindowID != -1) {
                    System.out.println("Servicing defered window request..." + this.m_iDeferedOpenWindowID);
                    if (this.m_bDeferedClosePrevious) {
                        vWindow frontWindow = this.m_windowListHead;
                        if (frontWindow != null) {
                            this.closeWindow(frontWindow);
                            frontWindow.destructor();
                        }
                        this.m_bDeferedClosePrevious = false;
                    }
                    int iIndex = 0;
                    int iDeferedOpenWindowID = this.m_iDeferedOpenWindowID;
                    switch (this.m_iDeferedOpenWindowID) {
                        case 1000: {
                            iIndex = 19;
                            break;
                        }
                        case 1001: {
                            iIndex = 20;
                            break;
                        }
                        case 1002: {
                            iIndex = 21;
                            break;
                        }
                        case 1003: {
                            iIndex = 22;
                            break;
                        }
                        default: {
                            System.out.println("VASSERT_MSG failed ::false | TC2App.onService -- unknown window id.");
                            System.out.println("m_iDeferedOpenWindowID == " + this.m_iDeferedOpenWindowID);
                        }
                    }
                    this.m_iDeferedOpenWindowID = -1;
                    vWindow newWindow = this.loadUIFile(181, iIndex);
                    if (newWindow != null) {
                        newWindow.init();
                        this.m_deferedWindow = newWindow;
                        this.m_iDeferedLoadStage = 0;
                        this.setLoadStatusText(vBaseCanvas.getString(173 + (iDeferedOpenWindowID - 1000)));
                    }
                    return;
                }
                if (this.m_deferedWindow == null) break;
                int iComplete = 0;
                if (this.m_iDeferedOpenMenuID != -1 && this.m_iDeferedOpenMenuID < 3) {
                    iComplete = 100;
                    this.updateLoadStatus(100);
                } else {
                    iComplete = this.m_deferedWindow.load(this.m_iDeferedLoadStage++);
                    this.updateLoadStatus(iComplete);
                }
                if (iComplete != 100) break;
                if (this.m_iDeferedOpenMenuID != -1) {
                    ((MenuWindow)this.m_deferedWindow).openMenu(this.m_iDeferedOpenMenuID);
                    this.m_iDeferedOpenMenuID = -1;
                }
                this.openWindow(this.m_deferedWindow);
                this.m_deferedWindow = null;
            }
        }
    }

    public final void openMenu(int iMenu, boolean bClosePrevious, int iStackOp) throws IOException {
        vWindow backWindow = this.m_windowListTail;
        if (iStackOp == 1 && backWindow != null) {
            if (this.m_iReturnStackSize >= 16) {
                System.out.println("VASSERT failed ::m_iReturnStackSize < kReturnStackSize");
            }
            this.m_iReturnWindowID[this.m_iReturnStackSize] = backWindow.m_iUserID;
            if (backWindow.m_iUserID == 1000) {
                this.m_iReturnMenuID[this.m_iReturnStackSize] = ((MenuWindow)backWindow).m_iMenu;
            }
            ++this.m_iReturnStackSize;
        } else if (iStackOp == 2) {
            this.clearReturnStack();
        }
        if (backWindow == null || 1000 != backWindow.m_iUserID) {
            this.requestDeferedOpenMenu(iMenu, bClosePrevious);
            return;
        }
        if (backWindow != null && 1000 == backWindow.m_iUserID) {
            ((MenuWindow)backWindow).openMenu(iMenu);
        }
    }

    public final void openWindow(int iWindowID, boolean bClosePrevious, int iStackOp) {
        vWindow frontWindow = this.m_windowListHead;
        if (iStackOp == 1 && frontWindow != null) {
            if (this.m_iReturnStackSize >= 16) {
                System.out.println("VASSERT failed ::m_iReturnStackSize < kReturnStackSize");
            }
            this.m_iReturnWindowID[this.m_iReturnStackSize] = frontWindow.m_iUserID;
            if (frontWindow.m_iUserID == 1000) {
                this.m_iReturnMenuID[this.m_iReturnStackSize] = ((MenuWindow)frontWindow).m_iMenu;
            }
            ++this.m_iReturnStackSize;
        } else if (iStackOp == 2) {
            this.clearReturnStack();
        }
        this.requestDeferedOpenWindow(iWindowID, bClosePrevious);
    }

    private void requestDeferedOpenMenu(int iMenuID, boolean bClosePrevious) {
        System.out.println("Requested defered open menu..." + iMenuID);
        this.m_iDeferedOpenWindowID = 1000;
        this.m_iDeferedOpenMenuID = iMenuID;
        this.m_bDeferedClosePrevious = bClosePrevious;
    }

    private void requestDeferedOpenWindow(int iWindowID, boolean bClosePrevious) {
        System.out.println("Requested defered open window... " + iWindowID);
        this.m_iDeferedOpenWindowID = iWindowID;
        this.m_iDeferedOpenMenuID = -1;
        this.m_bDeferedClosePrevious = bClosePrevious;
    }

    public final vWindow getUIFile(int iFile, int iIndex) throws IOException {
        return this.loadUIFile(iFile, iIndex);
    }

    private void initGamePref() {
        this.m_gamePref.iVersion = 4;
        this.m_gamePref.iSoundEnabled = 1;
        this.m_gamePref.iDifficulty = 0;
    }

    public final void exit() {
        this.stopAllSounds();
        this.saveGamePref();
        this.quitMainLoop();
    }

    private void loadGamePref() {
        boolean bWorked = this.loadRecordStore("gamePref.dat", 0);
        if (!bWorked || this.m_gamePref.iVersion != 4) {
            this.initGamePref();
        }
        if (!bWorked) {
            this.saveRecordStore("gamePref.dat", true, 0);
        }
    }

    public final void saveGamePref() {
        this.saveRecordStore("gamePref.dat", false, 0);
    }

    public final void returnToPrevious() throws IOException {
        --this.m_iReturnStackSize;
        if (this.m_iReturnWindowID[this.m_iReturnStackSize] == 1000) {
            this.openMenu(this.m_iReturnMenuID[this.m_iReturnStackSize], true, 0);
            return;
        }
        this.openWindow(this.m_iReturnWindowID[this.m_iReturnStackSize], true, 0);
    }

    private void clearReturnStack() {
        this.m_iReturnStackSize = 0;
    }

    public final boolean loadRecordStore(String s, int iCallbackType) {
        this.m_iCallbackType = iCallbackType;
        return vBaseCanvas.loadData(s, true);
    }

    public final boolean saveRecordStore(String s, boolean bCreateNew, int iCallbackType) {
        this.m_iCallbackType = iCallbackType;
        return vBaseCanvas.saveData(s, bCreateNew);
    }
}

