/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class vWindow
extends vUIElement {
    protected vUIElement m_listHead;
    protected vUIElement m_listTail;
    protected int m_iType;
    protected boolean m_bSizeToChildren;
    public int m_iListLength;
    protected int m_iPadding;
    protected vRect m_wndMgrDirtyRect = new vRect();
    protected vRect m_wndMgrLocalWindowRect = new vRect();
    protected vRect m_globalClip = new vRect();
    protected boolean m_bIsOpen;
    private vRect m_masterLocal;

    public vWindow(vBaseCanvas canvas, int iType) {
        super(canvas);
        new vRect();
        new vRect();
        this.m_masterLocal = new vRect();
        this.m_iType = iType;
        this.m_iClassID = 0;
    }

    public void destructor() throws IOException {
        this.free();
        this.destroyChildren();
    }

    public final void setOuterDimensions(int iX, int iY) {
        super.setOuterDimensions(iX, iY);
        vUIElement iter = this.m_listHead;
        while (iter != null) {
            iter.calculateAlignment();
            iter = iter.m_next;
        }
        this.adjustSpacing();
        if (this.m_bIsOpen) {
            this.m_app.windowResized(this);
        }
    }

    public final void setInnerDimensions(int iX, int iY) {
        super.setInnerDimensions(iX, iY);
        vUIElement iter = this.m_listHead;
        while (iter != null) {
            iter.calculateAlignment();
            iter = iter.m_next;
        }
        this.adjustSpacing();
        if (this.m_bIsOpen) {
            this.m_app.windowResized(this);
        }
    }

    public int load(int iLoadStage) throws IOException {
        return 100;
    }

    public boolean onKeyPressed(int iKeyCode, int iGameAction) throws IOException {
        return false;
    }

    public boolean onKeyReleased(int iKeyCode, int iGameAction) throws IOException {
        return false;
    }

    public void onIdle(int iTime) throws IOException {
    }

    public void paint(vGraphics graphics) {
        super.paint(graphics);
        graphics.translate(this.m_windowRect.x, this.m_windowRect.y);
        graphics.translate(this.m_clientRect.x, this.m_clientRect.y);
        if (this.m_iListLength > 0) {
            this.paintChildren(graphics);
        }
        graphics.translate(-this.m_clientRect.x, -this.m_clientRect.y);
        graphics.translate(-this.m_windowRect.x, -this.m_windowRect.y);
    }

    public boolean onWindowEvent$f13b8cb(int iEvent) throws IOException {
        return false;
    }

    public final void setPadding(int iPadding) {
        if (this.m_iPadding != iPadding) {
            this.m_iPadding = iPadding;
            this.adjustSpacing();
        }
    }

    public final void addToFront(vUIElement element) {
        if (element == null) {
            return;
        }
        element.m_next = this.m_listHead;
        element.m_previous = null;
        if (this.m_listHead != null) {
            this.m_listHead.m_previous = element;
        }
        this.m_listHead = element;
        if (this.m_listTail == null) {
            this.m_listTail = element;
        }
        element.m_parent = this;
        ++this.m_iListLength;
        this.adjustSpacing();
    }

    public final void addToBack(vUIElement element) {
        if (element == null) {
            return;
        }
        element.m_previous = this.m_listTail;
        element.m_next = null;
        if (this.m_listTail != null) {
            this.m_listTail.m_next = element;
        }
        this.m_listTail = element;
        if (this.m_listHead == null) {
            this.m_listHead = element;
        }
        element.m_parent = this;
        ++this.m_iListLength;
        this.adjustSpacing();
    }

    public final void remove(vUIElement element) {
        if (element == null) {
            return;
        }
        if (this.m_listHead == element) {
            this.m_listHead = element.m_next;
            if (this.m_listHead != null) {
                this.m_listHead.m_previous = null;
            }
        } else {
            element.m_previous.m_next = element.m_next;
        }
        if (this.m_listTail == element) {
            this.m_listTail = element.m_previous;
            if (this.m_listTail != null) {
                this.m_listTail.m_next = null;
            }
        } else {
            element.m_next.m_previous = element.m_previous;
        }
        element.m_parent = null;
        --this.m_iListLength;
    }

    public final void destroyChildren() {
        while (this.m_listHead != null) {
            vUIElement p = this.m_listHead;
            this.m_listHead = p.m_next;
            p.m_parent = null;
            p.m_next = null;
            p.m_previous = null;
            if (!(p instanceof vWindow)) continue;
            ((vWindow)p).destroyChildren();
        }
        this.m_listTail = null;
        this.m_iListLength = 0;
    }

    public final void adjustSpacing() {
        switch (this.m_iType) {
            case 1: {
                int iCurrent = 0;
                vUIElement iter = this.m_listHead;
                while (iter != null) {
                    iter.setPosition(iter.getOuterX(), iCurrent);
                    iCurrent += iter.getOuterHeight() + this.m_iPadding;
                    iter = iter.m_next;
                }
                return;
            }
            case 2: {
                int iCurrent = 0;
                vUIElement iter = this.m_listHead;
                while (iter != null) {
                    iter.setPosition(iCurrent, iter.getOuterY());
                    iCurrent += iter.getOuterWidth() + this.m_iPadding;
                    iter = iter.m_next;
                }
                break;
            }
        }
    }

    public final void sizeToChildren() {
        int iMinX = 5000;
        int iMinY = 5000;
        vUIElement iter = this.m_listHead;
        while (iter != null) {
            iMinX = Math.min(iMinX, iter.getOuterX());
            iMinY = Math.min(iMinY, iter.getOuterY());
            iter = iter.m_next;
        }
        if (iMinX != 0 || iMinY != 0) {
            iter = this.m_listHead;
            while (iter != null) {
                iter.move(-iMinX, -iMinY);
                iter = iter.m_next;
            }
        }
        int iWidth = 0;
        int iHeight = 0;
        vUIElement iter2 = this.m_listHead;
        while (iter2 != null) {
            int iterWidth = iter2.getOuterX() + iter2.getOuterWidth();
            int iterHeight = iter2.getOuterY() + iter2.getOuterHeight();
            iWidth = Math.max(iWidth, iterWidth);
            iHeight = Math.max(iHeight, iterHeight);
            iter2 = iter2.m_next;
        }
        this.setInnerDimensions(iWidth, iHeight);
        this.calculateAlignment();
        if (this.m_bIsOpen) {
            this.m_app.windowResized(this);
            return;
        }
        this.invalidate(null);
    }

    public final vUIElement getChild(int iChild) {
        vUIElement child = this.m_listHead;
        for (int i = 0; i < iChild && child != null; ++i) {
            child = child.m_next;
        }
        return child;
    }

    public final vUIElement getChildCRC32(int iCRC32) {
        vUIElement child = this.m_listHead;
        while (child != null) {
            if (iCRC32 == child.m_iElementCRC32) {
                return child;
            }
            child = child.m_next;
        }
        child = this.m_listHead;
        while (child != null) {
            vUIElement child2;
            if (child.m_iClassID == 0 && (child2 = ((vWindow)child).getChildCRC32(iCRC32)) != null) {
                return child2;
            }
            child = child.m_next;
        }
        return child;
    }

    public final void localToGlobal(vRect outGlobal, vRect inLocal) {
        outGlobal.x = inLocal.x + this.getOuterX() + this.getInnerX();
        outGlobal.y = inLocal.y + this.getOuterY() + this.getInnerY();
        outGlobal.dx = inLocal.dx;
        outGlobal.dy = inLocal.dy;
    }

    public final void globalToLocal(vRect outLocal, vRect inGlobal) {
        outLocal.x = inGlobal.x - this.getOuterX() - this.getInnerX();
        outLocal.y = inGlobal.y - this.getOuterY() - this.getInnerY();
        outLocal.dx = inGlobal.dx;
        outLocal.dy = inGlobal.dy;
    }

    public final void repaint() {
        this.repaint((vRect)null);
    }

    public final void repaint(vRect localRect) {
        vWindow window = this;
        if (localRect != null) {
            this.m_masterLocal.set(localRect);
            this.m_masterLocal.x += window.getOuterX() + window.getInnerX();
            this.m_masterLocal.y += window.getOuterY() + window.getInnerY();
        } else {
            this.m_masterLocal.set(this.m_windowRect);
        }
        while (window.m_parent != null) {
            this.m_masterLocal.x += window.m_parent.getOuterX() + window.m_parent.getInnerX();
            this.m_masterLocal.y += window.m_parent.getOuterY() + window.m_parent.getInnerY();
            window = window.m_parent;
        }
        if (window.m_bIsOpen) {
            this.m_app.repaintWindow(window, this.m_masterLocal);
        }
    }

    private void invalidate(vRect localRect) {
        vWindow window = this;
        if (localRect != null) {
            this.m_masterLocal.set(localRect);
            this.m_masterLocal.x += window.getOuterX() + window.getInnerX();
            this.m_masterLocal.y += window.getOuterY() + window.getInnerY();
        } else {
            this.m_masterLocal.set(this.m_windowRect);
        }
        while (window.m_parent != null) {
            this.m_masterLocal.x += window.m_parent.getOuterX() + window.m_parent.getInnerX();
            this.m_masterLocal.y += window.m_parent.getOuterY() + window.m_parent.getInnerY();
            window = window.m_parent;
        }
        if (window.m_bIsOpen) {
            this.m_app.invalidateWindow(window, this.m_masterLocal);
        }
    }

    public final void repaint(vUIElement element) {
        if (element == this) {
            System.out.println("VASSERT failed ::element != this");
        }
        if (element == this) {
            System.out.println("repaint :: DON'T PASS A WINDOW TO ITSELF AS AN ELEMENT! --> " + this);
        }
        this.repaint(element.m_windowRect);
    }

    public final void readParams(DataInputStream dis) throws IOException {
        this.m_iType = dis.readShort();
        this.m_iPadding = dis.readShort();
        this.m_bSizeToChildren = dis.readBoolean();
    }

    protected void readElement(DataInputStream dis) throws IOException {
        this.readParams(dis);
        short iNextID = dis.readShort();
        while (iNextID != -1) {
            vUIElement e = this.m_app.createObject(iNextID);
            e.read(dis);
            if (e.m_iClassID == -1) {
                System.out.println("VASSERT failed ::e.getClassID() != m_app.vClassID_Unknown");
            }
            this.addToBack(e);
            iNextID = dis.readShort();
        }
    }

    protected void initElement() throws IOException {
        if (this.m_clientRect.dx <= 0 || this.m_clientRect.dy <= 0) {
            int iWidth = this.m_windowRect.dx;
            int iHeight = this.m_windowRect.dy;
            if (this.m_windowRect.dx <= 0) {
                iWidth = this.m_parent != null && this.m_parent.getInnerWidth() > 0 ? (iWidth += this.m_parent.getInnerWidth()) : (iWidth += this.m_app.getScreenWidth());
            }
            if (this.m_windowRect.dy <= 0) {
                iHeight = this.m_parent != null && this.m_parent.getInnerHeight() > 0 ? (iHeight += this.m_parent.getInnerHeight()) : (iHeight += this.m_app.getScreenHeight());
            }
            this.setOuterDimensions(iWidth, iHeight);
        } else {
            this.setInnerDimensions(this.m_clientRect.dx, this.m_clientRect.dy);
        }
        vUIElement iter = this.m_listHead;
        while (iter != null) {
            if (iter.m_bAutoInit) {
                iter.init();
                iter.calculateAlignment();
            }
            iter = iter.m_next;
        }
        if (this.m_bSizeToChildren) {
            this.sizeToChildren();
        }
    }

    protected void freeElement() throws IOException {
        vUIElement iter = this.m_listHead;
        while (iter != null) {
            iter.free();
            iter = iter.m_next;
        }
    }

    private void paintChildren(vGraphics graphics) {
        if (this.m_iListLength <= 0) {
            System.out.println("VASSERT failed ::m_iListLength > 0");
        }
        int absX = graphics.m_iTranslateX;
        int absY = graphics.m_iTranslateY;
        vUIElement iter = this.m_listTail;
        while (iter != null) {
            if (iter.m_bVisible && iter.m_bInitialized) {
                this.m_globalClip.x = absX + iter.getOuterX();
                this.m_globalClip.y = absY + iter.getOuterY();
                this.m_globalClip.dx = iter.getOuterWidth();
                this.m_globalClip.dy = iter.getOuterHeight();
                graphics.pushClipRect();
                if (graphics.clipRect(this.m_globalClip)) {
                    iter.paint(graphics);
                }
                graphics.popClipRect();
            }
            iter = iter.m_previous;
        }
    }
}

