/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class vUIElement {
    public int m_iClassID;
    public int m_iUserID;
    protected vBaseCanvas m_app;
    public vUIElement m_previous;
    public vUIElement m_next;
    protected vWindow m_parent;
    protected vRect m_clientRect = new vRect();
    public vRect m_windowRect = new vRect();
    protected int m_iMarginX;
    protected int m_iMarginY;
    public int m_iFillColor;
    public int m_iFrameColor;
    public int m_iElementCRC32;
    protected int m_iStyleFlags;
    protected int m_iAlignOffX;
    protected int m_iAlignOffY;
    public int m_iZOrder;
    public boolean m_bVisible;
    public boolean m_bAutoInit;
    public boolean m_bInitialized;
    protected int m_iAlignH;
    protected int m_iAlignV;
    protected int m_iAnchorH;
    protected int m_iAnchorV;

    public vUIElement(vBaseCanvas canvas) {
        this.m_app = canvas;
        this.m_iClassID = -1;
        this.m_iUserID = -1;
        this.m_bAutoInit = true;
        this.m_bVisible = true;
        this.m_clientRect.setEmpty();
        this.m_windowRect.setEmpty();
    }

    public final void read(DataInputStream dis) throws IOException {
        this.m_iElementCRC32 = dis.readInt();
        this.m_windowRect.x = dis.readShort();
        this.m_windowRect.y = dis.readShort();
        this.m_windowRect.dx = dis.readShort();
        this.m_windowRect.dy = dis.readShort();
        this.m_clientRect.dx = dis.readShort();
        this.m_clientRect.dy = dis.readShort();
        this.m_iMarginX = dis.readShort();
        this.m_iMarginY = dis.readShort();
        if (this.m_iMarginX < 0) {
            System.out.println("VASSERT failed ::m_iMarginX >= 0");
        }
        if (this.m_iMarginY < 0) {
            System.out.println("VASSERT failed ::m_iMarginY >= 0");
        }
        this.m_iStyleFlags = dis.readInt();
        this.m_iFillColor = dis.readInt();
        this.m_iFrameColor = dis.readInt();
        this.m_iZOrder = dis.readInt();
        this.m_bVisible = dis.readBoolean();
        this.m_iAlignH = dis.readShort();
        this.m_iAlignV = dis.readShort();
        this.m_iAnchorH = dis.readShort();
        this.m_iAnchorV = dis.readShort();
        this.m_iAlignOffX = dis.readShort();
        this.m_iAlignOffY = dis.readShort();
        this.m_bAutoInit = dis.readBoolean();
        this.readElement(dis);
    }

    public void paint(vGraphics graphics) {
        if ((this.m_iStyleFlags & 1) != 0) {
            graphics.fillRect(this.m_windowRect, this.m_iFillColor);
        }
        if ((this.m_iStyleFlags & 2) != 0) {
            graphics.drawRect(this.m_windowRect, this.m_iFrameColor);
        }
    }

    public final void init() throws IOException {
        this.initElement();
        this.m_bInitialized = true;
    }

    public final void free() throws IOException {
        this.freeElement();
        this.m_bInitialized = false;
    }

    public void setOuterDimensions(int iX, int iY) {
        if (iX < 0) {
            System.out.println("VASSERT failed ::iX >= 0");
        }
        if (iY < 0) {
            System.out.println("VASSERT failed ::iY >= 0");
        }
        this.m_windowRect.dx = iX;
        this.m_windowRect.dy = iY;
        if ((this.m_iStyleFlags & 2) != 0) {
            if (iX < 2 + (this.m_iMarginX << 1)) {
                System.out.println("VASSERT failed ::iX >= 2+(m_iMarginX<<1)");
            }
            if (iY < 2 + (this.m_iMarginY << 1)) {
                System.out.println("VASSERT failed ::iY >= 2+(m_iMarginY<<1)");
            }
            this.m_clientRect.x = 1 + this.m_iMarginX;
            this.m_clientRect.y = 1 + this.m_iMarginY;
            this.m_clientRect.dx = this.m_windowRect.dx - (this.m_iMarginX << 1) - 2;
            this.m_clientRect.dy = this.m_windowRect.dy - (this.m_iMarginY << 1) - 2;
        } else {
            if (iX < this.m_iMarginX << 1) {
                System.out.println("VASSERT failed ::iX >= (m_iMarginX<<1)");
            }
            if (iY < this.m_iMarginY << 1) {
                System.out.println("VASSERT failed ::iY >= (m_iMarginY<<1)");
            }
            this.m_clientRect.x = this.m_iMarginX;
            this.m_clientRect.y = this.m_iMarginY;
            this.m_clientRect.dx = this.m_windowRect.dx - (this.m_iMarginX << 1);
            this.m_clientRect.dy = this.m_windowRect.dy - (this.m_iMarginY << 1);
        }
        this.calculateAlignment();
    }

    public void setInnerDimensions(int iX, int iY) {
        if (iX < 0) {
            System.out.println("VASSERT failed ::iX >= 0");
        }
        if (iY < 0) {
            System.out.println("VASSERT failed ::iY >= 0");
        }
        this.m_clientRect.dx = iX;
        this.m_clientRect.dy = iY;
        if ((this.m_iStyleFlags & 2) != 0) {
            this.m_clientRect.x = 1 + this.m_iMarginX;
            this.m_clientRect.y = 1 + this.m_iMarginY;
            this.m_windowRect.dx = this.m_clientRect.dx + (this.m_iMarginX << 1) + 2;
            this.m_windowRect.dy = this.m_clientRect.dy + (this.m_iMarginY << 1) + 2;
        } else {
            this.m_clientRect.x = this.m_iMarginX;
            this.m_clientRect.y = this.m_iMarginY;
            this.m_windowRect.dx = this.m_clientRect.dx + (this.m_iMarginX << 1);
            this.m_windowRect.dy = this.m_clientRect.dy + (this.m_iMarginY << 1);
        }
        this.calculateAlignment();
    }

    public final void setAlignmentOffset(int iX, int iY) {
        this.m_iAlignOffX = iX;
        this.m_iAlignOffY = iY;
        this.calculateAlignment();
    }

    public final void setAlignment(int iAlignH, int iAlignV) {
        this.m_iAlignH = iAlignH;
        this.m_iAlignV = iAlignV;
        this.calculateAlignment();
    }

    public final void setStyleFlags(int iStyleFlags) {
        this.m_iStyleFlags = iStyleFlags;
        if (this.m_bInitialized) {
            this.setInnerDimensions(this.m_clientRect.dx, this.m_clientRect.dy);
        }
    }

    public final int getAbsolutePositionX() {
        int iX = this.m_windowRect.x;
        vWindow parent = this.m_parent;
        while (parent != null) {
            iX += parent.m_windowRect.x + parent.m_clientRect.x;
            parent = parent.m_parent;
        }
        return iX;
    }

    public final int getAbsolutePositionY() {
        int iY = this.m_windowRect.y;
        vWindow parent = this.m_parent;
        while (parent != null) {
            iY += parent.m_windowRect.y + parent.m_clientRect.y;
            parent = parent.m_parent;
        }
        return iY;
    }

    public final void calculateAlignment() {
        int iAnchor;
        if (this.m_iAlignH != 0) {
            iAnchor = 0;
            switch (this.m_iAnchorH) {
                case 0: {
                    switch (this.m_iAlignH) {
                        case 2: 
                        case 5: {
                            iAnchor = this.m_windowRect.dx >> 1;
                            break;
                        }
                        case 3: 
                        case 4: {
                            iAnchor = this.m_windowRect.dx;
                        }
                    }
                    break;
                }
                case 2: {
                    iAnchor = this.m_windowRect.dx >> 1;
                    break;
                }
                case 3: {
                    iAnchor = this.m_windowRect.dx;
                }
            }
            this.m_windowRect.x = -iAnchor + this.m_iAlignOffX;
            switch (this.m_iAlignH) {
                case 2: {
                    if (this.m_parent != null) {
                        this.m_windowRect.x += this.m_parent.getInnerWidth() >> 1;
                        break;
                    }
                    this.m_windowRect.x += this.m_app.getScreenWidth() >> 1;
                    break;
                }
                case 3: {
                    if (this.m_parent != null) {
                        this.m_windowRect.x += this.m_parent.getInnerWidth();
                        break;
                    }
                    this.m_windowRect.x += this.m_app.getScreenWidth();
                    break;
                }
                case 4: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.x += this.m_previous.getOuterX();
                    break;
                }
                case 5: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.x += this.m_previous.getOuterX() + (this.m_previous.getOuterWidth() >> 1);
                    break;
                }
                case 6: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.x += this.m_previous.getOuterX() + this.m_previous.getOuterWidth();
                }
            }
        }
        if (this.m_iAlignV != 0) {
            iAnchor = 0;
            switch (this.m_iAnchorV) {
                case 0: {
                    switch (this.m_iAlignV) {
                        case 2: 
                        case 5: {
                            iAnchor = this.m_windowRect.dy >> 1;
                            break;
                        }
                        case 3: 
                        case 4: {
                            iAnchor = this.m_windowRect.dy;
                        }
                    }
                    break;
                }
                case 2: {
                    iAnchor = this.m_windowRect.dy >> 1;
                    break;
                }
                case 3: {
                    iAnchor = this.m_windowRect.dy;
                }
            }
            this.m_windowRect.y = -iAnchor + this.m_iAlignOffY;
            switch (this.m_iAlignV) {
                case 2: {
                    if (this.m_parent != null) {
                        this.m_windowRect.y += this.m_parent.getInnerHeight() >> 1;
                        break;
                    }
                    this.m_windowRect.y += this.m_app.getScreenHeight() >> 1;
                    break;
                }
                case 3: {
                    if (this.m_parent != null) {
                        this.m_windowRect.y += this.m_parent.getInnerHeight();
                        break;
                    }
                    this.m_windowRect.y += this.m_app.getScreenHeight();
                    break;
                }
                case 4: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.y += this.m_previous.getOuterY();
                    break;
                }
                case 5: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.y += this.m_previous.getOuterY() + (this.m_previous.getOuterHeight() >> 1);
                    break;
                }
                case 6: {
                    if (this.m_previous == null) break;
                    this.m_windowRect.y += this.m_previous.getOuterY() + this.m_previous.getOuterHeight();
                }
            }
        }
        if (this.m_parent != null) {
            this.m_parent.adjustSpacing();
        }
    }

    public void repaint() {
        if (this.m_parent != null) {
            this.m_parent.repaint(this);
            return;
        }
        ((vWindow)this).repaint();
    }

    protected void readElement(DataInputStream dis) throws IOException {
    }

    protected void initElement() throws IOException {
    }

    protected void freeElement() throws IOException {
    }

    public final int getOuterX() {
        return this.m_windowRect.x;
    }

    public final int getOuterY() {
        return this.m_windowRect.y;
    }

    public final int getOuterWidth() {
        return this.m_windowRect.dx;
    }

    public final int getOuterHeight() {
        return this.m_windowRect.dy;
    }

    public final int getInnerX() {
        return this.m_clientRect.x;
    }

    public final int getInnerY() {
        return this.m_clientRect.y;
    }

    public final int getInnerWidth() {
        return this.m_clientRect.dx;
    }

    public final int getInnerHeight() {
        return this.m_clientRect.dy;
    }

    public final void move(int iX, int iY) {
        this.m_windowRect.x += iX;
        this.m_windowRect.y += iY;
    }

    public final void setPosition(int iX, int iY) {
        this.m_windowRect.x = iX;
        this.m_windowRect.y = iY;
    }
}

