/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class vLabel
extends vUIElement {
    private int m_iFgNativeColor;
    private int m_iLineNativeColor;
    private int m_iTextStyle;
    vBitmapFont m_font_fg;
    vBitmapFont m_font_bg;
    public String m_szText;
    private int m_iJustify;
    private int m_iImageWidth;
    private int m_iImageHeight;
    private int m_iStringID;
    private boolean m_bAutoSize;

    public vLabel(vBaseCanvas canvas) {
        super(canvas);
        this.m_iStringID = -1;
        this.m_bAutoSize = true;
        this.m_iClassID = 1;
    }

    public vLabel(vBaseCanvas canvas, int[] info) {
        super(canvas);
        this.m_iFgNativeColor = info[0];
        this.m_iLineNativeColor = info[1];
        this.m_iTextStyle = info[2];
        this.m_iJustify = info[3];
        this.m_iStringID = info[4];
        this.m_bAutoSize = info[6] != 0;
        this.m_szText = null;
        this.setBitmapFont();
        this.m_iClassID = 1;
    }

    public final void setText(String szText, boolean bResize) throws IOException {
        if (szText == null) {
            return;
        }
        if (szText != this.m_szText) {
            this.m_szText = new String(szText);
            int i = szText.indexOf("%version");
            if (i >= 0) {
                this.m_szText = szText.substring(0, i) + this.m_app.m_midlet.getAppProperty("MIDlet-Version") + szText.substring(i + 8);
            }
            this.m_szText.length();
            this.m_iStringID = -1;
        }
        if (bResize && this.m_app.m_font != null) {
            this.m_iImageWidth = this.m_app.m_font.measureString(szText) + 2;
            if (this.m_iJustify == 1) {
                ++this.m_iImageWidth;
            }
            this.m_iImageHeight = this.m_app.m_font.getHeight() + 2 + 1;
            this.setInnerDimensions(this.m_iImageWidth, this.m_iImageHeight);
        }
    }

    public final void setText(int iStringID, boolean bResize) throws IOException {
        this.m_iStringID = iStringID;
        if (iStringID == -1) {
            this.setText("", bResize);
            return;
        }
        String s = vBaseCanvas.getString(iStringID);
        this.setText(s, bResize);
    }

    public final void setFgColor(int fgNativeColor) {
        this.m_iFgNativeColor = fgNativeColor;
        this.setBitmapFont();
    }

    public final void paint(vGraphics graphics) {
        int iStringWidth;
        super.paint(graphics);
        graphics.translate(this.m_windowRect.x, this.m_windowRect.y);
        graphics.translate(this.m_clientRect.x, this.m_clientRect.y);
        String szText = this.m_szText;
        if (szText == null && this.m_iStringID >= 0) {
            szText = vBaseCanvas.getString(this.m_iStringID);
            szText.length();
            iStringWidth = this.m_app.m_font.measureString(szText);
        } else {
            iStringWidth = this.m_iImageWidth - 2;
        }
        if (szText != null) {
            int baseX = 1;
            switch (this.m_iJustify) {
                case 1: {
                    baseX = this.m_iImageWidth - iStringWidth + 1 >> 1;
                    break;
                }
                case 2: {
                    baseX = this.m_iImageWidth - iStringWidth;
                }
            }
            if (this.m_iTextStyle == 1) {
                graphics.drawBitmapStyleTextShadow(szText, this.m_font_fg, this.m_font_bg, baseX, 1);
            } else if (this.m_iTextStyle == 2) {
                graphics.drawBitmapStyleTextOutline(szText, this.m_font_fg, this.m_font_bg, baseX, 1);
            } else {
                graphics.drawBitmapStyleText(szText, this.m_font_fg, baseX, 1);
            }
        }
        graphics.translate(-this.m_clientRect.x, -this.m_clientRect.y);
        graphics.translate(-this.m_windowRect.x, -this.m_windowRect.y);
    }

    protected final void readElement(DataInputStream dis) throws IOException {
        this.m_iFgNativeColor = dis.readInt();
        this.m_iLineNativeColor = dis.readInt();
        this.m_iTextStyle = dis.readInt();
        this.m_iJustify = dis.readShort();
        this.m_iStringID = dis.readShort();
        dis.readShort();
        this.m_bAutoSize = dis.readBoolean();
    }

    private void setBitmapFont() {
        this.m_font_fg = this.m_iFgNativeColor == 65280 ? this.m_app.m_font_green : (this.m_iFgNativeColor == 0xFF0000 ? this.m_app.m_font_red : (this.m_iFgNativeColor == 0 ? this.m_app.m_font_black : this.m_app.m_font_white));
        if (this.m_iTextStyle != 0) {
            if (this.m_iLineNativeColor == 65280) {
                this.m_font_bg = this.m_app.m_font_green;
                return;
            }
            if (this.m_iLineNativeColor == 0xFF0000) {
                this.m_font_bg = this.m_app.m_font_red;
                return;
            }
            if (this.m_iLineNativeColor == 0) {
                this.m_font_bg = this.m_app.m_font_black;
                return;
            }
            this.m_font_bg = this.m_app.m_font_white;
        }
    }

    protected final void initElement() throws IOException {
        this.setBitmapFont();
        if (this.m_iStringID >= 0) {
            this.setText(this.m_iStringID, this.m_bAutoSize);
            return;
        }
        this.setText(this.m_szText, this.m_bAutoSize);
    }

    protected final void freeElement() {
    }
}

