/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class vBaseCanvas
extends FullCanvas
implements Runnable,
PlayerListener {
    public static vBaseCanvas s_instance;
    private final Display m_display;
    public final vBaseMIDlet m_midlet;
    private vGraphics m_vGraphics;
    public vBitmapFont m_font;
    public vBitmapFont m_font_white;
    public vBitmapFont m_font_green;
    public vBitmapFont m_font_red;
    public vBitmapFont m_font_black;
    private static Object s_paintLock;
    private boolean m_bPaused = false;
    private boolean m_bRunLoopDelay = false;
    private boolean m_bQuitting = false;
    private int[] m_aiKeyEvents = new int[32];
    private int m_iKeyEventStart = 0;
    private int m_iKeyEventCount = 0;
    private static int[] m_iSharedLabelConstructionInfo;
    private static int m_iAppStartTime;
    boolean gs_bSoundEnabled = true;
    private boolean m_bHandleSuspend;
    private boolean m_bHandleResume;
    private vLabel m_OKLabel;
    private vLabel m_BackLabel;
    private vWindow m_keyLabels;
    private boolean m_bKeyLabelsOverlay = false;
    private Graphics m_lastG = null;
    public int m_iLoadStatus = 100;
    private vRect m_loadScreenTempRect = new vRect();
    private vLabel m_loadingLabel;
    protected static int LOADCOLOR_SCREEN_BG;
    protected static int LOADCOLOR_BAR_BG;
    protected static int LOADCOLOR_BAR_FILL;
    protected static int LOADCOLOR_BAR_HILITE;
    protected static int LOADCOLOR_BAR_BORDER;
    private static byte[] m_abyStringData;
    private vWindow m_safeWindow;
    public vWindow m_windowListHead;
    public vWindow m_windowListTail;
    private boolean m_bSafeIterationForward;
    private boolean m_bRepaint = false;
    private boolean m_bVisualDebug = false;
    private boolean m_bFlashToggle = false;
    private vRect m_tempScreenRect = new vRect();
    private vRect m_tempLocalRect = new vRect();
    private vRect m_tempGlobalRect = new vRect();
    private vRect m_tempGlobalRect2 = new vRect();
    private Random m_sysRandGen = new Random();
    protected int m_mti;
    protected int[] m_iMag01 = new int[2];
    protected int[] m_iMT = new int[624];
    private static Hashtable m_imageTable;
    private static Hashtable m_spriteDataTable;
    private static Hashtable m_nokiaPixelsTable;
    public static byte[] m_readBuffer;
    private static int m_iLastResFile;
    private static int m_iLastPackedResourceReadSize;
    private static int m_iPNGCount;
    private byte[][] m_sounds = new byte[32][];
    public int m_iSoundState = 0;
    public int m_iCurrentSoundID = -1;
    private String[] m_mmapiFormat = new String[32];
    private int m_iLoopCount = 0;
    private int m_iLastSoundID = -1;
    private int m_iCurrentLoop = 0;
    private Player m_soundPlayer;

    public vBaseCanvas(vBaseMIDlet midlet, Display display, String sDictionary) {
        System.out.println("vBaseCanvas::ctor()");
        s_instance = this;
        this.m_display = display;
        this.m_midlet = midlet;
        this.initPRNG();
        this.gs_bSoundEnabled = true;
        m_iAppStartTime = vBaseCanvas.getSysTime();
        this.setPRNGSeed(m_iAppStartTime);
        this.setSysSeed(m_iAppStartTime);
        try {
            if (sDictionary != "") {
                vBaseCanvas.loadDictionary(sDictionary);
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public final void hideNotify() {
        this.pause();
    }

    public final void showNotify() {
        this.unpause();
    }

    public final void pause() {
        try {
            this.handleSuspend();
            return;
        }
        catch (OutOfMemoryError e) {
            System.out.println("Error during run\n" + e.getMessage());
            e.printStackTrace();
            this.m_midlet.m_iCriticalError = 2;
            this.m_midlet.exitRequested();
            return;
        }
        catch (Throwable t) {
            System.out.println("Error during run\n" + t.getMessage());
            t.printStackTrace();
            this.m_midlet.m_iCriticalError = 1;
            this.m_midlet.exitRequested();
            return;
        }
    }

    private void handleSuspend() throws IOException {
        this.m_bHandleSuspend = false;
        if (!this.m_bPaused) {
            this.m_bPaused = true;
            this.pauseSound();
            vWindow window = this.m_windowListTail;
            while (window != null) {
                window.onWindowEvent$f13b8cb(3);
                window = vBaseCanvas.getHigherWindow(window);
            }
            this.onSuspend();
        }
    }

    public final void unpause() {
        try {
            this.handleResume();
            return;
        }
        catch (OutOfMemoryError e) {
            System.out.println("Error during run\n" + e.getMessage());
            e.printStackTrace();
            this.m_midlet.m_iCriticalError = 2;
            this.m_midlet.exitRequested();
            return;
        }
        catch (Throwable t) {
            System.out.println("Error during run\n" + t.getMessage());
            t.printStackTrace();
            this.m_midlet.m_iCriticalError = 1;
            this.m_midlet.exitRequested();
            return;
        }
    }

    private void handleResume() throws IOException {
        this.m_bHandleResume = false;
        if (this.m_bPaused) {
            this.m_bPaused = false;
            if (this.m_windowListHead != null) {
                this.repaintWindow(null, null);
            }
            this.resumeSound();
            vWindow window = this.m_windowListTail;
            while (window != null) {
                window.onWindowEvent$f13b8cb(4);
                window = vBaseCanvas.getHigherWindow(window);
            }
            this.onResume();
        }
    }

    public final void displayErrorAlert(AlertType type, String title, String msg, int iTimeout) {
        Alert alert = new Alert(title);
        alert.setTimeout(iTimeout);
        alert.setString(msg);
        alert.setType(type);
        this.m_display.setCurrent((Displayable)alert);
        vBaseCanvas.threadSleep(iTimeout);
    }

    public final int getScreenWidth() {
        return this.getWidth();
    }

    public final int getScreenHeight() {
        if (this.m_keyLabels != null && !this.m_bKeyLabelsOverlay) {
            return this.getHeight() - this.m_keyLabels.getOuterHeight();
        }
        return this.getHeight();
    }

    private static int getSysTime() {
        return (int)System.currentTimeMillis();
    }

    public static final int getAppTime() {
        return vBaseCanvas.getSysTime() - m_iAppStartTime;
    }

    public vUIElement createObject(int iType) {
        return null;
    }

    protected void onService(int iServiceType) throws IOException {
    }

    protected void onStart() throws IOException {
    }

    protected void onStop() throws IOException {
    }

    protected void onSuspend() throws IOException {
    }

    protected void onResume() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPrivateStop() throws IOException {
        Object object = s_paintLock;
        synchronized (object) {
            this.onStop();
            s_paintLock.notify();
            return;
        }
    }

    public final void startMainLoop() {
        new Thread(this).start();
    }

    public final void quitMainLoop() {
        this.m_bQuitting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        while (true) {
            if (this.m_bQuitting) {
                this.m_midlet.exitRequested();
                return;
            }
            if (!(this.m_bHandleResume || this.m_bHandleSuspend || !this.m_bPaused && this.isShown())) {
                vBaseCanvas.threadSleep(10);
                continue;
            }
            Object object = s_paintLock;
            synchronized (object) {
                try {
                    if (this.m_bHandleSuspend) {
                        this.handleSuspend();
                        continue;
                    }
                    if (this.m_bHandleResume) {
                        this.handleResume();
                    }
                    this.onService(2);
                    this.publishKeyEvents();
                    int iAppTime = vBaseCanvas.getAppTime();
                    this.m_bSafeIterationForward = true;
                    vWindow window = this.getSafeBackWindow();
                    while (window != null) {
                        window.onIdle(iAppTime);
                        window = this.getSafeHigherWindow();
                    }
                    this.endSafeIteration();
                    if (this.m_bRepaint) {
                        this.m_bRepaint = false;
                        this.repaint();
                        s_paintLock.notify();
                        s_paintLock.wait();
                    }
                    if (this.m_bRunLoopDelay) {
                        vBaseCanvas.threadSleep(30);
                    }
                    Thread.yield();
                }
                catch (OutOfMemoryError e) {
                    System.out.println("Error during run\n" + e.getMessage());
                    e.printStackTrace();
                    this.m_midlet.m_iCriticalError = 2;
                    this.m_midlet.exitRequested();
                }
                catch (Throwable t) {
                    System.out.println("Error during run\n" + t.getMessage());
                    t.printStackTrace();
                    this.m_midlet.m_iCriticalError = 1;
                    this.m_midlet.exitRequested();
                }
            }
        }
    }

    public final void createKeyLabels(int iTextColor, int iBackColor, int iLeftOffset, int iRightOffset, boolean bOverlay) throws IOException {
        this.m_bKeyLabelsOverlay = bOverlay;
        this.m_keyLabels = new vWindow(this, 0);
        if (!this.m_bKeyLabelsOverlay) {
            this.m_keyLabels.setStyleFlags(1);
            this.m_keyLabels.m_iFillColor = iBackColor;
        }
        this.m_keyLabels.init();
        this.m_OKLabel = new vLabel(this);
        this.m_OKLabel.setAlignment(1, 2);
        this.m_OKLabel.setAlignmentOffset(iLeftOffset, 0);
        this.m_OKLabel.setText("", true);
        this.m_OKLabel.setFgColor(iTextColor);
        this.m_OKLabel.init();
        this.m_keyLabels.addToFront(this.m_OKLabel);
        this.m_BackLabel = new vLabel(this);
        this.m_BackLabel.setAlignment(3, 2);
        this.m_BackLabel.setAlignmentOffset(iRightOffset, 0);
        this.m_BackLabel.setText("", true);
        this.m_BackLabel.setFgColor(iTextColor);
        this.m_BackLabel.init();
        this.m_keyLabels.addToFront(this.m_BackLabel);
        this.m_keyLabels.setOuterDimensions(this.getWidth(), this.m_OKLabel.getOuterHeight());
        this.m_keyLabels.setPosition(0, this.getHeight() - this.m_keyLabels.getOuterHeight());
    }

    public final void setKeyLabels(int iOK, int iBack) {
        if (this.m_bKeyLabelsOverlay) {
            this.repaintWindow(null, null);
        }
        try {
            this.m_OKLabel.setText(iOK, true);
            this.m_BackLabel.setText(iBack, true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyEvent(int iType) {
        int[] nArray = this.m_aiKeyEvents;
        synchronized (this.m_aiKeyEvents) {
            if (this.m_iKeyEventCount < 32) {
                int n = this.m_iKeyEventStart + this.m_iKeyEventCount;
                if (n >= 32) {
                    n -= 32;
                }
                this.m_aiKeyEvents[n] = iType;
                ++this.m_iKeyEventCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearKeyEvents() {
        int[] nArray = this.m_aiKeyEvents;
        synchronized (this.m_aiKeyEvents) {
            this.m_iKeyEventStart = 0;
            this.m_iKeyEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKeyEvent() {
        int[] nArray = this.m_aiKeyEvents;
        synchronized (this.m_aiKeyEvents) {
            int iType = 0;
            if (this.m_iKeyEventCount > 0) {
                iType = this.m_aiKeyEvents[this.m_iKeyEventStart];
                --this.m_iKeyEventCount;
                ++this.m_iKeyEventStart;
                if (this.m_iKeyEventStart == 32) {
                    this.m_iKeyEventStart = 0;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return iType;
        }
    }

    private void publishKeyEvents() throws IOException {
        int iType = this.getKeyEvent();
        while (iType != 0) {
            this.handleKey(iType);
            iType = this.getKeyEvent();
        }
    }

    protected final void keyPressed(int keyCode) {
        if (this.m_bPaused) {
            return;
        }
        int iKey = this.getTranslatedKey(keyCode);
        if (iKey != 0) {
            this.addKeyEvent(iKey);
        }
    }

    protected final void keyReleased(int keyCode) {
        if (this.m_bPaused) {
            return;
        }
        int iKey = this.getTranslatedKey(keyCode);
        if (iKey != 0) {
            this.addKeyEvent(iKey | 0x40000000);
        }
    }

    private final int getTranslatedKey(int keyCode) {
        int iVKey = 0;
        int gameAction = this.getGameAction(keyCode);
        switch (gameAction) {
            case 1: {
                iVKey = 131072;
                break;
            }
            case 6: {
                iVKey = 262144;
                break;
            }
            case 2: {
                iVKey = 32768;
                break;
            }
            case 5: {
                iVKey = 65536;
                break;
            }
            case 8: {
                iVKey = 524288;
            }
        }
        switch (keyCode) {
            case 49: {
                iVKey = 0x100002;
                break;
            }
            case 50: {
                iVKey = 131076;
                break;
            }
            case 51: {
                iVKey = 0x200008;
                break;
            }
            case 52: {
                iVKey = 32784;
                break;
            }
            case 53: {
                iVKey = 524320;
                break;
            }
            case 54: {
                iVKey = 65600;
                break;
            }
            case 55: {
                iVKey = 0x400080;
                break;
            }
            case 56: {
                iVKey = 262400;
                break;
            }
            case 57: {
                iVKey = 0x800200;
                break;
            }
            case 48: {
                iVKey = 0x4000001;
                break;
            }
            case 42: {
                iVKey = 0x1000400;
                break;
            }
            case 35: {
                iVKey = 0x2000800;
                break;
            }
            case -6: {
                iVKey = 0x8001000;
                break;
            }
            case -8: {
                iVKey = 0x10000000;
                break;
            }
            case -7: {
                iVKey = 0x10002000;
                break;
            }
            case -5: {
                iVKey = 0x8000000;
            }
        }
        if (iVKey == 524288) {
            iVKey = 0x8000000;
        }
        return iVKey;
    }

    private boolean handleKey(int keyCode) throws IOException {
        boolean bHandled = false;
        boolean bRelease = (keyCode & 0x40000000) != 0;
        keyCode &= 0xBFFFFFFF;
        this.m_bSafeIterationForward = false;
        vWindow window = this.getSafeFrontWindow();
        while (window != null && !(bHandled = bRelease ? window.onKeyReleased(keyCode & Short.MAX_VALUE, keyCode & Short.MIN_VALUE) : window.onKeyPressed(keyCode & Short.MAX_VALUE, keyCode & Short.MIN_VALUE))) {
            window = this.getSafeLowerWindow();
        }
        this.endSafeIteration();
        this.onService(bRelease ? 0 : 1);
        return bHandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g) {
        try {
            Object object = s_paintLock;
            synchronized (object) {
                if (this.m_lastG != g || this.getHeight() != this.m_vGraphics.m_iActualHeight) {
                    this.m_vGraphics = null;
                    this.m_lastG = g;
                    this.m_vGraphics = new vGraphics(g, this.getWidth(), this.getHeight());
                }
                this.m_vGraphics.setClipRect(null);
                if (this.m_iLoadStatus < 100) {
                    this.paintLoadScreen(this.m_vGraphics);
                } else {
                    this.m_vGraphics.setClipRect(0, 0, this.getWidth(), this.getScreenHeight());
                    this.paintWindows(this.m_vGraphics);
                    if (this.m_keyLabels != null) {
                        int iOriginalTranX = this.m_vGraphics.m_iTranslateX;
                        int iOriginalTranY = this.m_vGraphics.m_iTranslateY;
                        this.m_vGraphics.pushClipRect();
                        this.m_vGraphics.setTranslate(0, 0);
                        this.m_keyLabels.setPosition(0, this.getHeight() - this.m_keyLabels.getOuterHeight());
                        this.m_vGraphics.setClipRect(0, this.getHeight() - this.m_keyLabels.getOuterHeight(), this.getWidth(), this.m_keyLabels.getOuterHeight());
                        this.m_keyLabels.paint(this.m_vGraphics);
                        this.m_vGraphics.setTranslate(iOriginalTranX, iOriginalTranY);
                        this.m_vGraphics.popClipRect();
                    }
                    if (this.m_bFlashToggle) {
                        this.m_bFlashToggle = false;
                        this.m_vGraphics.fillRect(this.m_vGraphics.m_dirtyRect, 0xFF00FF);
                        this.dirtyWindows(null, this.m_vGraphics.m_dirtyRect, false);
                    } else if (this.m_bVisualDebug) {
                        this.m_bFlashToggle = true;
                        vBaseCanvas.threadSleep(8);
                    }
                }
                this.m_vGraphics.clearDirtyRect();
                s_paintLock.notify();
            }
            return;
        }
        catch (Exception e) {
            System.out.println("*** Error during paint ***\n" + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public final void setLoadStatusText(String iString) {
        try {
            if (this.m_loadingLabel == null) {
                int[] nArray = vBaseCanvas.getSharedLabelConstructionInfo();
                int[] labelInfo = nArray;
                nArray[0] = 0xFFFFFF;
                labelInfo[1] = 0;
                labelInfo[2] = 0;
                labelInfo[3] = 1;
                labelInfo[4] = -1;
                labelInfo[5] = 0;
                labelInfo[6] = 1;
                this.m_loadingLabel = new vLabel(this, labelInfo);
                this.m_loadingLabel.init();
            }
            this.m_loadingLabel.setText(iString, true);
            this.m_loadingLabel.setPosition(this.getScreenWidth() - this.m_loadingLabel.getOuterWidth() >> 1, (this.getScreenHeight() >> 1) + 12);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void updateLoadStatus(int iComplete) {
        this.m_iLoadStatus = iComplete;
        if (this.m_iLoadStatus >= 100) {
            this.m_loadingLabel = null;
        }
        this.m_bRepaint = true;
    }

    private void paintLoadScreen(vGraphics g) {
        g.fillRect(null, LOADCOLOR_SCREEN_BG);
        if (this.m_loadingLabel != null) {
            this.m_loadingLabel.paint(g);
        }
        this.m_loadScreenTempRect.set(this.getScreenWidth() - 102 >> 1, (this.getScreenHeight() - 12 >> 1) - 1, 102, 12);
        g.drawRect(this.m_loadScreenTempRect, LOADCOLOR_BAR_BORDER);
        ++this.m_loadScreenTempRect.x;
        ++this.m_loadScreenTempRect.y;
        this.m_loadScreenTempRect.dy -= 2;
        this.m_loadScreenTempRect.dx = this.m_iLoadStatus;
        if (this.m_loadScreenTempRect.dx > 0) {
            g.fillRect(this.m_loadScreenTempRect, LOADCOLOR_BAR_FILL);
            g.drawRect(this.m_loadScreenTempRect, LOADCOLOR_BAR_HILITE);
        }
        this.m_loadScreenTempRect.x += this.m_loadScreenTempRect.dx;
        this.m_loadScreenTempRect.dx = 100 - this.m_loadScreenTempRect.dx;
        if (this.m_loadScreenTempRect.dx > 0) {
            g.fillRect(this.m_loadScreenTempRect, LOADCOLOR_BAR_BG);
        }
    }

    public static final String getString(int iStringID) {
        int iBase = iStringID << 1;
        int offset1 = m_abyStringData[iBase + 0] << 8 & 0xFF00 | m_abyStringData[iBase + 1] & 0xFF;
        return new String(m_abyStringData, offset1, (m_abyStringData[iBase + 2] << 8 & 0xFF00 | m_abyStringData[iBase + 3] & 0xFF) - offset1);
    }

    public final synchronized void openWindow(vWindow window) {
        vWindow oldFront;
        vWindow onTopOf = oldFront = this.m_windowListHead;
        window.m_next = null;
        window.m_previous = null;
        if (onTopOf != null) {
            while (onTopOf != null && onTopOf.m_iZOrder > window.m_iZOrder) {
                onTopOf = vBaseCanvas.getLowerWindow(onTopOf);
            }
            if (onTopOf != null) {
                if (this.m_windowListHead == onTopOf) {
                    this.m_windowListHead = window;
                    this.m_windowListHead.m_previous = null;
                } else {
                    onTopOf.m_previous.m_next = window;
                }
                window.m_previous = onTopOf.m_previous;
                window.m_next = onTopOf;
                onTopOf.m_previous = window;
            } else {
                this.m_windowListTail.m_next = window;
                window.m_previous = this.m_windowListTail;
                this.m_windowListTail = window;
            }
        } else {
            this.m_windowListHead = window;
            this.m_windowListTail = window;
        }
        window.m_bIsOpen = true;
        window.m_wndMgrDirtyRect.dx = 0;
        window.m_wndMgrLocalWindowRect.set(0, 0, window.getOuterWidth(), window.getOuterHeight());
        this.invalidateWindow(window, null);
        try {
            if (oldFront != null && oldFront != this.m_windowListHead) {
                oldFront.onWindowEvent$f13b8cb(1);
            }
            if (window == this.m_windowListHead) {
                window.onWindowEvent$f13b8cb(0);
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("ERROR :: it's illegal to throw an exception for an active or deactive event.");
            return;
        }
    }

    public final void closeWindow(vWindow window) {
        vWindow oldFront = this.m_windowListHead;
        window.localToGlobal(this.m_tempGlobalRect, window.m_wndMgrLocalWindowRect);
        window.m_bIsOpen = false;
        if (this.m_windowListHead == window) {
            this.m_windowListHead = (vWindow)window.m_next;
            if (this.m_windowListHead != null) {
                this.m_windowListHead.m_previous = null;
            }
        } else {
            window.m_previous.m_next = window.m_next;
        }
        if (this.m_windowListTail == window) {
            this.m_windowListTail = (vWindow)window.m_previous;
            if (this.m_windowListTail != null) {
                this.m_windowListTail.m_next = null;
            }
        } else {
            window.m_next.m_previous = window.m_previous;
        }
        window.m_previous = null;
        window.m_next = null;
        if (this.m_windowListHead != null && this.m_windowListHead.m_previous != null) {
            System.out.println("VASSERT failed ::m_windowListHead.getPrevious() == null");
        }
        if (this.m_windowListTail != null && this.m_windowListTail.m_next != null) {
            System.out.println("VASSERT failed ::m_windowListTail.getNext() == null");
        }
        this.invalidateWindow(null, this.m_tempGlobalRect);
        vWindow newFront = this.m_windowListHead;
        if (newFront != null && newFront != oldFront) {
            try {
                newFront.onWindowEvent$f13b8cb(0);
            }
            catch (IOException iOException) {
                System.out.println("ERROR :: it's illegal to throw an exception on an active event.");
            }
        }
        if (this.m_safeWindow != null && this.m_safeWindow == window) {
            if (this.m_bSafeIterationForward) {
                this.m_safeWindow = vBaseCanvas.getHigherWindow(window);
                return;
            }
            this.m_safeWindow = vBaseCanvas.getLowerWindow(window);
        }
    }

    public final void windowResized(vWindow window) {
        window.localToGlobal(this.m_tempGlobalRect, window.m_wndMgrLocalWindowRect);
        if (this.m_tempGlobalRect.x != window.getOuterX() || this.m_tempGlobalRect.y != window.getOuterY() || this.m_tempGlobalRect.dx != window.getOuterWidth() || this.m_tempGlobalRect.dy != window.getOuterHeight()) {
            this.invalidateWindow(null, this.m_tempGlobalRect);
            this.m_tempScreenRect.set(0, 0, this.getScreenWidth(), this.getScreenHeight());
            this.m_tempGlobalRect2.set(window.getOuterX(), window.getOuterY(), window.getOuterWidth(), window.getOuterHeight());
            this.m_tempGlobalRect2.intersect(this.m_tempScreenRect);
            window.globalToLocal(window.m_wndMgrLocalWindowRect, this.m_tempGlobalRect2);
            this.repaintWindow(window, null);
        }
    }

    private void dirtyWindows(vWindow window, vRect localRect, boolean bInvalidate) {
        vWindow w;
        if (window != null) {
            if (!vBaseCanvas.isWindowOpen(window)) {
                System.out.println("VASSERT failed ::isWindowOpen( window )");
            }
            if (localRect != null) {
                this.m_tempLocalRect.set(localRect);
                if (!this.m_tempLocalRect.intersect(window.m_wndMgrLocalWindowRect)) {
                    return;
                }
                window.localToGlobal(this.m_tempGlobalRect, this.m_tempLocalRect);
            } else {
                window.localToGlobal(this.m_tempGlobalRect, window.m_wndMgrLocalWindowRect);
            }
        } else if (localRect != null) {
            this.m_tempGlobalRect.set(localRect);
        } else {
            this.m_tempGlobalRect.set(0, 0, this.getScreenWidth(), this.getScreenHeight());
        }
        if (bInvalidate) {
            w = this.m_windowListTail;
            while (w != null) {
                w.globalToLocal(this.m_tempLocalRect, this.m_tempGlobalRect);
                if (this.m_tempLocalRect.intersect(w.m_wndMgrLocalWindowRect)) {
                    try {
                        w.onWindowEvent$f13b8cb(2);
                    }
                    catch (IOException iOException) {
                        System.out.println("ERROR :: it's illegal to throw an exception on an invalidate event.");
                    }
                }
                w = vBaseCanvas.getHigherWindow(w);
            }
        }
        w = this.m_windowListTail;
        while (w != null) {
            w.globalToLocal(this.m_tempLocalRect, this.m_tempGlobalRect);
            if (this.m_tempLocalRect.intersect(w.m_wndMgrLocalWindowRect)) {
                if (w.m_wndMgrDirtyRect.dx == 0) {
                    w.m_wndMgrDirtyRect.set(this.m_tempLocalRect);
                } else {
                    w.m_wndMgrDirtyRect.unionRect(this.m_tempLocalRect);
                }
                w.localToGlobal(this.m_tempGlobalRect2, w.m_wndMgrDirtyRect);
                this.m_tempGlobalRect.unionRect(this.m_tempGlobalRect2);
            }
            w = vBaseCanvas.getHigherWindow(w);
        }
        this.m_bRepaint = true;
    }

    private void paintWindows(vGraphics g) {
        int iOriginalTranX = g.m_iTranslateX;
        int iOriginalTranY = g.m_iTranslateY;
        g.pushClipRect();
        g.setTranslate(0, 0);
        vWindow window = this.m_windowListTail;
        while (window != null) {
            if (window.m_wndMgrDirtyRect.dx > 0) {
                window.localToGlobal(this.m_tempGlobalRect, window.m_wndMgrDirtyRect);
                g.setClippedClipRect(this.m_tempGlobalRect);
                window.m_wndMgrDirtyRect.dx = 0;
                window.paint(g);
            }
            window = vBaseCanvas.getHigherWindow(window);
        }
        g.setTranslate(iOriginalTranX, iOriginalTranY);
        g.popClipRect();
    }

    private void endSafeIteration() {
        this.m_safeWindow = null;
    }

    private vWindow getSafeFrontWindow() {
        this.m_safeWindow = this.m_windowListHead;
        return this.m_safeWindow;
    }

    private vWindow getSafeBackWindow() {
        this.m_safeWindow = this.m_windowListTail;
        return this.m_safeWindow;
    }

    private vWindow getSafeHigherWindow() {
        if (this.m_safeWindow != null) {
            this.m_safeWindow = vBaseCanvas.getHigherWindow(this.m_safeWindow);
        }
        return this.m_safeWindow;
    }

    private vWindow getSafeLowerWindow() {
        if (this.m_safeWindow != null) {
            this.m_safeWindow = vBaseCanvas.getLowerWindow(this.m_safeWindow);
        }
        return this.m_safeWindow;
    }

    private static vWindow getHigherWindow(vWindow window) {
        return (vWindow)window.m_previous;
    }

    private static vWindow getLowerWindow(vWindow window) {
        return (vWindow)window.m_next;
    }

    private static boolean isWindowOpen(vWindow window) {
        return window.m_bIsOpen;
    }

    public final void invalidateWindow(vWindow window, vRect rect) {
        this.dirtyWindows(window, rect, true);
    }

    public final void repaintWindow(vWindow window, vRect rect) {
        this.dirtyWindows(window, rect, false);
    }

    public final vWindow findWindowByUserID(int eUserID) {
        vWindow window = this.m_windowListHead;
        while (window != null) {
            if (window.m_iUserID == eUserID) {
                return window;
            }
            window = vBaseCanvas.getLowerWindow(window);
        }
        return null;
    }

    private void initPRNG() {
        this.m_mti = 625;
        this.m_iMag01[0] = 0;
        this.m_iMag01[1] = -1727483681;
    }

    private void setPRNGSeed(int iSeed) {
        this.m_iMT[0] = iSeed;
        this.m_mti = 1;
        while (this.m_mti < 624) {
            this.m_iMT[this.m_mti] = 1812433253 * (this.m_iMT[this.m_mti - 1] ^ this.m_iMT[this.m_mti - 1] >> 30) + this.m_mti;
            ++this.m_mti;
        }
    }

    private int getRandom() {
        int y;
        if (this.m_mti >= 624) {
            int kk;
            if (this.m_mti == 625) {
                System.out.println("VASSERT_MSG failed ::m_mti != N + 1 | vPRNG::getRandom -- you have not seeded the PRNG.");
            }
            for (kk = 0; kk < 227; ++kk) {
                y = this.m_iMT[kk] & Integer.MIN_VALUE | this.m_iMT[kk + 1] & Integer.MAX_VALUE;
                this.m_iMT[kk] = this.m_iMT[kk + 397] ^ y >> 1 ^ this.m_iMag01[y & 1];
            }
            while (kk < 623) {
                y = this.m_iMT[kk] & Integer.MIN_VALUE | this.m_iMT[kk + 1] & Integer.MAX_VALUE;
                this.m_iMT[kk] = this.m_iMT[kk + -227] ^ y >> 1 ^ this.m_iMag01[y & 1];
                ++kk;
            }
            y = this.m_iMT[623] & Integer.MIN_VALUE | this.m_iMT[0] & Integer.MAX_VALUE;
            this.m_iMT[623] = this.m_iMT[396] ^ y >> 1 ^ this.m_iMag01[y & 1];
            this.m_mti = 0;
        }
        y = this.m_iMT[this.m_mti++];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >> 18;
        return y;
    }

    public final int getRandom(int iMax) {
        if (iMax <= 0) {
            System.out.println("VASSERT failed ::iMax > 0");
        }
        return this.getRandom() % iMax;
    }

    private void setSysSeed(int iSeed) {
        this.m_sysRandGen.setSeed(iSeed);
    }

    protected void onReadGameData(DataInputStream ds) throws IOException {
    }

    protected void onWriteGameData(DataOutputStream ds) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public static boolean loadData(String sDataFile, boolean bActuallyLoad) {
        void var2_2;
        block15: {
            RecordStore rs;
            DataInputStream ds;
            ByteArrayInputStream bs;
            block14: {
                boolean bSuccess = false;
                bs = null;
                ds = null;
                rs = null;
                rs = RecordStore.openRecordStore((String)sDataFile, (boolean)false);
                if (rs == null) break block14;
                byte[] record = rs.getRecord(1);
                if (bActuallyLoad) {
                    bs = new ByteArrayInputStream(record);
                    ds = new DataInputStream(bs);
                    s_instance.onReadGameData(ds);
                    bSuccess = true;
                    break block14;
                }
                bSuccess = record != null;
            }
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {}
            vBaseCanvas.closeInputStream(ds);
            vBaseCanvas.closeInputStream(bs);
            break block15;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.closeRecordStore();
                        }
                    }
                    catch (RecordStoreException recordStoreException) {}
                    vBaseCanvas.closeInputStream(ds);
                    vBaseCanvas.closeInputStream(bs);
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (RecordStoreException recordStoreException) {}
                vBaseCanvas.closeInputStream(ds);
                vBaseCanvas.closeInputStream(bs);
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean saveData(String sDataFile, boolean bCreateNew) {
        block20: {
            bSuccess = false;
            rs = null;
            bs = null;
            ds = null;
            rs = RecordStore.openRecordStore((String)sDataFile, (boolean)bCreateNew);
            bs = new ByteArrayOutputStream();
            ds = new DataOutputStream(bs);
            vBaseCanvas.s_instance.onWriteGameData(ds);
            aBytes = bs.toByteArray();
            System.out.println("output record size == " + aBytes.length);
            try {
                rs.setRecord(1, aBytes, 0, aBytes.length);
                bSuccess = true;
            }
            catch (InvalidRecordIDException v0) {
                rs.addRecord(aBytes, 0, aBytes.length);
                bSuccess = true;
            }
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (RecordStoreException v1) {}
            vBaseCanvas.closeOutputStream(ds);
            vBaseCanvas.closeOutputStream(bs);
            break block20;
            catch (RecordStoreException v2) {
                ** try [egrp 3[TRYBLOCK] [4 : 134->135)] { 
lbl30:
                // 1 sources

                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (RecordStoreException v3) {}
                vBaseCanvas.closeOutputStream(ds);
                vBaseCanvas.closeOutputStream(bs);
            }
            catch (IOException v4) {
                ** try [egrp 5[TRYBLOCK] [5 : 160->161)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var8_7) {
                        try {
                            if (rs != null) {
                                rs.closeRecordStore();
                            }
                        }
                        catch (RecordStoreException v5) {}
                        vBaseCanvas.closeOutputStream(ds);
                        vBaseCanvas.closeOutputStream(bs);
                        throw var8_7;
                    }
                }
lbl49:
                // 1 sources

                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (RecordStoreException v6) {}
                vBaseCanvas.closeOutputStream(ds);
                vBaseCanvas.closeOutputStream(bs);
            }
        }
        return (boolean)var2_2;
    }

    public static void deleteData(String sDataFile) {
        try {
            RecordStore.deleteRecordStore((String)sDataFile);
            return;
        }
        catch (Exception e) {
            System.out.println("deleteData(" + sDataFile + ") -- exception: " + e.toString());
            return;
        }
    }

    private static int getLastPackedResourceReadSize() {
        return m_iLastPackedResourceReadSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static vSpriteData loadPackedSpriteData(int iFile, int iIndex) throws IOException {
        DataInputStream ds = null;
        vSpriteData spriteData = null;
        try {
            ds = vBaseCanvas.loadPackedResource(iFile, iIndex);
            spriteData = new vSpriteData(ds);
        }
        finally {
            vBaseCanvas.closeInputStream(ds);
        }
        return spriteData;
    }

    public final vSpriteData loadSpriteData(int iDataFile, int iDataIndex) throws IOException {
        Integer key = new Integer((iDataFile << 8) + iDataIndex + 1);
        vSpriteData spriteData = (vSpriteData)m_spriteDataTable.get(key);
        if (spriteData == null && (spriteData = vBaseCanvas.loadPackedSpriteData(iDataFile, iDataIndex)) != null) {
            m_spriteDataTable.put(key, spriteData);
        }
        return spriteData;
    }

    public final vSprite loadSprite(int iFile, int iIndex, int iPalFile, int iPalIndex, int iDataFile, int iDataIndex) throws IOException {
        Image image = iPalFile >= 0 && iPalIndex >= 0 ? vBaseCanvas.loadPalImage(iFile, iIndex, iPalFile, iPalIndex) : vBaseCanvas.loadImage(iFile, iIndex);
        if (image != null) {
            if (iDataFile >= 0) {
                vSpriteData data = this.loadSpriteData(iDataFile, iDataIndex);
                if (data != null) {
                    return new vSprite(image, data);
                }
            } else {
                return new vSprite(image, null);
            }
        }
        return null;
    }

    public static Image loadImage(int iFile, int iIndex) throws IOException {
        Integer key = new Integer((iFile << 8) + iIndex + 1);
        Image image = (Image)m_imageTable.get(key);
        if (image == null && (image = vBaseCanvas.loadPackedImage(iFile, iIndex)) != null) {
            m_imageTable.put(key, image);
        }
        return image;
    }

    private static Image loadPalImage(int iFile, int iIndex, int iPalFile, int iPalIndex) throws IOException {
        Integer key = new Integer((iPalFile << 24) + (iPalIndex << 16) + (iFile << 8) + iIndex + 1);
        Image image = (Image)m_imageTable.get(key);
        if (image == null && (image = vBaseCanvas.loadPackedPalImage(iFile, iIndex, iPalFile, iPalIndex)) != null) {
            m_imageTable.put(key, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadPackedResourceAsArray(int iFile, int iIndex) throws IOException {
        DataInputStream ds = null;
        byte[] byteArray = null;
        try {
            ds = vBaseCanvas.loadPackedResource(iFile, iIndex);
            int iSize = vBaseCanvas.getLastPackedResourceReadSize();
            if (iSize <= 0) {
                System.out.println("VASSERT failed ::iSize > 0");
            }
            byteArray = new byte[iSize];
            ds.read(byteArray);
        }
        finally {
            vBaseCanvas.closeInputStream(ds);
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataInputStream loadPackedResource(int iFile, int iIndex) throws IOException {
        InputStream is = null;
        DataInputStream ds = null;
        ByteArrayInputStream bs = null;
        try {
            int iNumFiles;
            int iOffset;
            block11: {
                if (iFile == m_iLastResFile) break block11;
                String sFile = vBaseCanvas.getString(iFile);
                try {
                    is = sFile.getClass().getResourceAsStream(sFile);
                    int iBytes = 0;
                    iOffset = 0;
                    while ((iBytes = is.read(m_readBuffer, iOffset, m_readBuffer.length - iOffset)) != -1) {
                        if (iBytes == 0) {
                            throw new IOException("File read exceeding buffer size");
                        }
                        iOffset += iBytes;
                    }
                }
                catch (Throwable throwable) {
                    vBaseCanvas.closeInputStream(is);
                    throw throwable;
                }
                vBaseCanvas.closeInputStream(is);
                m_iLastResFile = iFile;
            }
            if (iIndex >= (iNumFiles = (ds = new DataInputStream(bs = new ByteArrayInputStream(m_readBuffer))).readInt())) {
                System.out.println("loadPackedResource( " + iFile + " , " + iIndex + " ) -> " + vBaseCanvas.getString(iFile) + " == NumFiles( " + iNumFiles + " );");
                throw new IOException("PackRat: Index > NumFiles");
            }
            int iFileSize = ds.readInt();
            iOffset = 0;
            int iNextOffset = 0;
            for (int i = 0; i < iNumFiles; ++i) {
                int iDummy = ds.readInt();
                if (i == iIndex) {
                    iOffset = iDummy;
                    continue;
                }
                if (i != iIndex + 1) continue;
                iNextOffset = iDummy;
            }
            if (iNextOffset == 0) {
                iNextOffset = iFileSize;
            }
            m_iLastPackedResourceReadSize = iNextOffset - iOffset;
            int iSkip = iOffset - (8 + 4 * iNumFiles);
            if (iSkip > 0) {
                ds.skipBytes(iSkip);
            }
        }
        catch (Throwable throwable) {
            vBaseCanvas.closeInputStream(bs);
            throw throwable;
        }
        vBaseCanvas.closeInputStream(bs);
        return ds;
    }

    public final vSprite loadSpritePixels(int iFile, int iIndex, int iPalFile, int iPalIndex, int iDataFile, int iDataIndex) throws IOException {
        short[] pixels = vBaseCanvas.loadPalPixels(iFile, iIndex, iPalFile, iPalIndex);
        if (pixels != null) {
            if (iDataFile >= 0) {
                vSpriteData data = this.loadSpriteData(iDataFile, iDataIndex);
                if (data != null) {
                    return new vSprite(pixels, data);
                }
            } else {
                return new vSprite(pixels, null);
            }
        }
        return null;
    }

    public static short[] loadPalPixels(int iFile, int iIndex, int iPalFile, int iPalIndex) throws IOException {
        Integer key = new Integer((iPalFile << 24) + (iPalIndex << 16) + (iFile << 8) + iIndex + 1);
        short[] data = (short[])m_nokiaPixelsTable.get(key);
        if (data == null && (data = vBaseCanvas.loadPackedPalPixels(iFile, iIndex, iPalFile, iPalIndex)) != null) {
            m_nokiaPixelsTable.put(key, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short[] loadPackedPalPixels(int iImageFile, int iImageIndex, int iPalFile, int iPalIndex) throws IOException {
        int iCount;
        DataInputStream ds = null;
        short[] aPalette = null;
        try {
            ds = vBaseCanvas.loadPackedResource(iPalFile, iPalIndex);
            iCount = ds.readShort();
            aPalette = new short[iCount];
            for (int i = 0; i < iCount; ++i) {
                aPalette[i] = ds.readShort();
            }
        }
        catch (Throwable throwable) {
            vBaseCanvas.closeInputStream(ds);
            throw throwable;
        }
        vBaseCanvas.closeInputStream(ds);
        Object bs = null;
        short[] aPixels = null;
        try {
            ds = vBaseCanvas.loadPackedResource(iImageFile, iImageIndex);
            short iWidth = ds.readShort();
            short iHeight = ds.readShort();
            iCount = iWidth * iHeight;
            short[] sArray = new short[2 + iCount];
            aPixels = sArray;
            sArray[aPixels.length - 2] = iWidth;
            aPixels[aPixels.length - 1] = iHeight;
            for (int i = 0; i < iCount; ++i) {
                short color = ds.readByte();
                if (color < 0) {
                    color = (short)(color + 256);
                }
                aPixels[i] = aPalette[color];
            }
        }
        finally {
            vBaseCanvas.closeInputStream(ds);
        }
        return aPixels;
    }

    private static final Image loadPackedImage(int iFile, int iIndex) throws IOException {
        byte[] data = null;
        try {
            data = vBaseCanvas.loadPackedResourceAsArray(iFile, iIndex);
            ++m_iPNGCount;
            return Image.createImage((byte[])data, (int)0, (int)data.length);
        }
        catch (Exception e) {
            if (data != null) {
                throw new IOException("iFile/iIndex= " + iFile + "/" + iIndex + " data_len=" + data.length + " e=" + e.toString());
            }
            throw new IOException("iFile/iIndex= " + iFile + "/" + iIndex + " e=" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image loadPackedPalImage(int iImageFile, int iImageIndex, int iPalFile, int iPalIndex) throws IOException {
        DataInputStream imageDS = null;
        DataInputStream paletteDS = null;
        Image i = null;
        try {
            imageDS = vBaseCanvas.loadPackedResource(iImageFile, iImageIndex);
            paletteDS = vBaseCanvas.loadPackedResource(iPalFile, iPalIndex);
            int paletteSize = vBaseCanvas.getLastPackedResourceReadSize();
            i = vBaseCanvas.createImage$578e0373(imageDS, paletteDS, paletteSize);
        }
        catch (Throwable throwable) {
            vBaseCanvas.closeInputStream(imageDS);
            vBaseCanvas.closeInputStream(paletteDS);
            throw throwable;
        }
        vBaseCanvas.closeInputStream(imageDS);
        vBaseCanvas.closeInputStream(paletteDS);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image createImage$578e0373(DataInputStream dsImage, DataInputStream dsPalette, int paletteSize) throws IOException {
        ByteArrayOutputStream bs = null;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] aBytes = null;
        try {
            int iType;
            bs = new ByteArrayOutputStream();
            byte[] abyHeader = new byte[33];
            dsImage.read(abyHeader);
            bs.write(abyHeader);
            byte[] abyPalette = new byte[paletteSize];
            dsPalette.read(abyPalette);
            bs.write(abyPalette);
            do {
                int iLen = dsImage.readInt();
                iType = dsImage.readInt();
                bos = new ByteArrayOutputStream(iLen + 12);
                dos = new DataOutputStream(bos);
                dos.writeInt(iLen);
                dos.writeInt(iType);
                if (iLen > 0) {
                    byte[] aBytes2 = new byte[iLen];
                    dsImage.read(aBytes2);
                    bos.write(aBytes2);
                }
                dos.writeInt(dsImage.readInt());
                if (iType == 1347179589) continue;
                bs.write(bos.toByteArray());
            } while (iType != 1229278788);
            aBytes = bs.toByteArray();
        }
        catch (Throwable throwable) {
            vBaseCanvas.closeOutputStream(dos);
            vBaseCanvas.closeOutputStream(bos);
            vBaseCanvas.closeOutputStream(bs);
            throw throwable;
        }
        vBaseCanvas.closeOutputStream(dos);
        vBaseCanvas.closeOutputStream(bos);
        vBaseCanvas.closeOutputStream(bs);
        System.out.println("loading PNG image " + ++m_iPNGCount);
        return Image.createImage((byte[])aBytes, (int)0, (int)aBytes.length);
    }

    public static final void closeInputStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void closeOutputStream(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDictionary(String sDictFile) throws IOException {
        DataInputStream dis = null;
        InputStream is = null;
        try {
            is = s_instance.getClass().getResourceAsStream(sDictFile);
            dis = new DataInputStream(is);
            m_abyStringData = new byte[dis.readInt() - 4];
            dis.readFully(m_abyStringData);
        }
        catch (Throwable throwable) {
            vBaseCanvas.closeInputStream(dis);
            vBaseCanvas.closeInputStream(is);
            throw throwable;
        }
        vBaseCanvas.closeInputStream(dis);
        vBaseCanvas.closeInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final vWindow loadUIFile(int iFile, int iIndex) throws IOException {
        vWindow window = null;
        DataInputStream ds = null;
        try {
            ds = vBaseCanvas.loadPackedResource(iFile, iIndex);
            window = (vWindow)this.createObject(ds.readShort());
            if (window != null) {
                window.read(ds);
            }
        }
        finally {
            vBaseCanvas.closeInputStream(ds);
        }
        return window;
    }

    public final void playerUpdate(Player player, String event, Object eventData) {
        if (event == "endOfMedia") {
            if (this.m_iLoopCount == 0) {
                this.m_iSoundState = 0;
                return;
            }
            if (this.m_iLoopCount > 0) {
                --this.m_iLoopCount;
            }
        }
    }

    public final void loadSound(int iFile, int iIndex, int iSound, Object format) throws IOException {
        if (iSound < 0 || iSound >= 32 || this.m_sounds[iSound] != null) {
            return;
        }
        this.m_sounds[iSound] = vBaseCanvas.loadPackedResourceAsArray(iFile, iIndex);
        this.m_mmapiFormat[iSound] = (String)format;
    }

    public final boolean isSoundLoaded(int iSound) {
        return this.m_sounds[iSound] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prefetch(int iSound) {
        if (this.m_iCurrentSoundID != iSound && this.m_iSoundState == 0) {
            try {
                if (this.m_soundPlayer != null) {
                    this.m_soundPlayer.close();
                    this.m_soundPlayer = null;
                }
            }
            catch (Exception e) {
                System.out.println("Error closing sound\n" + e.getMessage());
                e.printStackTrace();
            }
            ByteArrayInputStream bs = null;
            try {
                bs = new ByteArrayInputStream(this.m_sounds[iSound]);
                this.m_soundPlayer = Manager.createPlayer((InputStream)bs, (String)this.m_mmapiFormat[iSound]);
                this.m_soundPlayer.addPlayerListener((PlayerListener)this);
                this.m_soundPlayer.realize();
                this.m_iCurrentSoundID = iSound;
            }
            catch (Exception e) {
                block8: {
                    try {
                        System.out.println("Error creating sound\n" + e.getMessage());
                        e.printStackTrace();
                        this.m_iCurrentSoundID = -1;
                        this.m_iSoundState = 0;
                        if (this.m_soundPlayer == null) break block8;
                        this.m_soundPlayer.close();
                        this.m_soundPlayer = null;
                    }
                    catch (Throwable throwable) {
                        vBaseCanvas.closeInputStream(bs);
                        throw throwable;
                    }
                }
                vBaseCanvas.closeInputStream(bs);
                return;
            }
            vBaseCanvas.closeInputStream(bs);
            return;
        }
    }

    public final void playSound(int iSound, int iLoop) {
        if (!this.gs_bSoundEnabled || iSound == -1) {
            return;
        }
        if (this.m_sounds[iSound] == null) {
            return;
        }
        if (this.m_iCurrentSoundID != iSound) {
            this.m_iCurrentSoundID = -1;
            this.m_iSoundState = 0;
            this.prefetch(iSound);
            this.m_iCurrentLoop = iLoop;
        } else {
            try {
                try {
                    this.m_soundPlayer.stop();
                }
                catch (Exception e) {
                    System.out.println("Error stopping sound\n" + e.getMessage());
                    e.printStackTrace();
                }
                this.m_soundPlayer.setMediaTime(1L);
            }
            catch (Exception e) {
                System.out.println("Error resetting time\n" + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            this.m_iLoopCount = iLoop;
            if (iLoop != -1) {
                ++iLoop;
            }
            this.m_soundPlayer.setLoopCount(iLoop);
            this.m_soundPlayer.start();
            this.m_iSoundState = 1;
            return;
        }
        catch (Exception e) {
            System.out.println("Error playing sound\n" + e.getMessage());
            e.printStackTrace();
            this.m_iCurrentSoundID = -1;
            this.m_iSoundState = 0;
            if (this.m_soundPlayer != null) {
                this.m_soundPlayer.close();
                this.m_soundPlayer = null;
            }
            return;
        }
    }

    private void pauseSound() {
        this.m_iLastSoundID = this.m_iSoundState == 1 ? this.m_iCurrentSoundID : -1;
        this.stopAllSounds();
    }

    public void resumeSound() {
        if (this.m_iLastSoundID != -1 && this.m_iLoopCount < 0) {
            this.playSound(this.m_iLastSoundID, this.m_iCurrentLoop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopAllSounds() {
        try {
            if (this.m_soundPlayer != null) {
                this.m_soundPlayer.close();
            }
            return;
        }
        catch (Exception e) {
            System.out.println("Error stopping sound\n" + e.getMessage());
            e.printStackTrace();
            return;
        }
        finally {
            this.m_iCurrentSoundID = -1;
            this.m_iSoundState = 0;
            this.m_soundPlayer = null;
        }
    }

    public final void unloadSoundResources() {
        this.stopAllSounds();
        for (int i = 0; i < 32; ++i) {
            this.m_sounds[i] = null;
        }
    }

    public final void enableSound(boolean b) {
        if (!b) {
            this.stopAllSounds();
        }
        this.gs_bSoundEnabled = b;
    }

    public static final int toInt(int x) {
        if (x >= 0) {
            return x >> 16;
        }
        return (x >> 16) + 1;
    }

    public static final short toShort(int x) {
        return (short)vBaseCanvas.toInt(x);
    }

    public static final int intToFP(int x) {
        return x << 16;
    }

    public static final int mul(int x, int y) {
        long z = (long)x * (long)y;
        return (int)(z >> 16);
    }

    public static final int div(int x, int y) {
        if (y == 0) {
            System.out.println("VASSERT failed ::y != 0");
        }
        long z = (long)x << 16;
        return (int)(z / (long)y);
    }

    public static final int length3(int x, int y, int z) {
        long n = (long)x * (long)x + (long)y * (long)y + (long)z * (long)z >> 16;
        long s = n + 65536L >> 1;
        n <<= 16;
        for (int i = 0; i < 8; ++i) {
            s = s + n / s >> 1;
        }
        return (int)s;
    }

    public static final int normalize3(int x, int y, int z, int[] out) {
        if (x == 0 && y == 0 && z == 0) {
            out[0] = 0;
            out[1] = 0;
            out[2] = 0;
            return 0;
        }
        int signx = x < 0 ? -1 : 1;
        int signy = y < 0 ? -1 : 1;
        int signz = z < 0 ? -1 : 1;
        x *= signx;
        y *= signy;
        z *= signz;
        int iMagShift = 0;
        while (x > 131072 || y > 131072 || z > 131072) {
            x >>= 1;
            y >>= 1;
            z >>= 1;
            ++iMagShift;
        }
        while (x < 65536 && y < 65536 && z < 65536) {
            x <<= 1;
            y <<= 1;
            z <<= 1;
            --iMagShift;
        }
        int fpMag = vBaseCanvas.length3(x *= signx, y *= signy, z *= signz);
        x = vBaseCanvas.div(x, fpMag);
        y = vBaseCanvas.div(y, fpMag);
        z = vBaseCanvas.div(z, fpMag);
        out[0] = x;
        out[1] = y;
        out[2] = z;
        if (iMagShift < 0) {
            return fpMag >> -iMagShift;
        }
        return fpMag << iMagShift;
    }

    private static void threadSleep(int iTime) {
        try {
            Thread.currentThread();
            Thread.sleep(iTime);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static int[] getSharedLabelConstructionInfo() {
        return m_iSharedLabelConstructionInfo;
    }

    public static int clamp(int val, int lo, int hi) {
        if (val <= lo) {
            return lo;
        }
        if (val >= hi) {
            return hi;
        }
        return val;
    }

    public static short flip_word(short x) {
        int hi = (x & 0xFF) << 8;
        int lo = (x & 0xFF00) >> 8;
        return (short)(hi | lo);
    }

    static {
        s_paintLock = new Object();
        m_iSharedLabelConstructionInfo = new int[7];
        LOADCOLOR_SCREEN_BG = 0;
        LOADCOLOR_BAR_BG = 0x808080;
        LOADCOLOR_BAR_FILL = 0xFF0000;
        LOADCOLOR_BAR_HILITE = 0x3F0000;
        LOADCOLOR_BAR_BORDER = 0xFFFF00;
        m_imageTable = new Hashtable();
        m_spriteDataTable = new Hashtable();
        m_nokiaPixelsTable = new Hashtable();
        m_readBuffer = new byte[58300];
        m_iLastResFile = -1;
        m_iLastPackedResourceReadSize = 0;
        m_iPNGCount = 0;
    }
}

