/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public final class MapWindow
extends vWindow {
    private TC2App m_tc2;
    private Game m_game;
    private int m_iStartTime;
    private int m_iLastUpdateTime;
    private int m_iKeyDownTime;
    private int m_fpRemainingDist;
    private int m_iCurrentLocation;
    private int m_iSelection;
    private int m_iPinCount;
    private int m_iKeyFlags;
    private vRect m_mapRect = new vRect();
    private vRect m_mapRange = new vRect();
    private int m_iCurrentMapX;
    private int m_iCurrentMapY;
    private int m_iArrowU_X;
    private int m_iArrowU_Y;
    private int m_iArrowD_X;
    private int m_iArrowD_Y;
    private Image m_mapImage;
    private Image m_arrowU;
    private Image m_arrowD;
    private vSprite m_pMapPinSprite;
    private MapPin[] m_pMapPins;
    private boolean m_bUpArrowVisible;
    private boolean m_bDownArrowVisible;

    public MapWindow(Game game, TC2App tc2) {
        super(tc2, 0);
        this.m_tc2 = tc2;
        this.m_game = game;
        this.m_iSelection = -1;
        this.m_iCurrentLocation = -1;
        this.m_bUpArrowVisible = true;
        this.m_bDownArrowVisible = true;
        this.m_iUserID = 1002;
        this.m_tc2.setKeyLabels(-1, -1);
    }

    public final boolean onKeyPressed(int usKey, int eAction) throws IOException {
        TC2App tc2 = this.m_tc2;
        switch (eAction) {
            case 0x10000000: {
                this.m_game.pause(true);
                if (this.m_tc2.findWindowByUserID(1003) != null) break;
                this.m_tc2.openWindow(1003, false, 0);
                break;
            }
            case 32768: {
                this.m_iKeyFlags &= 0xFFFFFFF7;
                this.m_iKeyFlags |= 4;
                this.m_iKeyDownTime = vBaseCanvas.getAppTime();
                break;
            }
            case 65536: {
                this.m_iKeyFlags &= 0xFFFFFFFB;
                this.m_iKeyFlags |= 8;
                this.m_iKeyDownTime = vBaseCanvas.getAppTime();
                break;
            }
            case 131072: {
                this.m_iKeyFlags &= 0xFFFFFFFD;
                this.m_iKeyFlags |= 1;
                this.m_iKeyDownTime = vBaseCanvas.getAppTime();
                break;
            }
            case 262144: {
                this.m_iKeyFlags &= 0xFFFFFFFE;
                this.m_iKeyFlags |= 2;
                this.m_iKeyDownTime = vBaseCanvas.getAppTime();
                break;
            }
            case 524288: 
            case 0x8000000: {
                if (this.m_iSelection == -1) break;
                this.m_game.requestDeferredLoadLevel(this.m_pMapPins[this.m_iSelection].iLevel, 0);
                this.m_game.mapWindowClosing();
                tc2.closeWindow(this);
                vWindow pGameWindow = tc2.findWindowByUserID(1001);
                if (pGameWindow != null) break;
                tc2.openWindow(1001, true, 1);
            }
        }
        return true;
    }

    public final boolean onKeyReleased(int usKey, int eAction) throws IOException {
        switch (eAction) {
            case 32768: {
                this.m_iKeyFlags &= 0xFFFFFFFB;
                break;
            }
            case 65536: {
                this.m_iKeyFlags &= 0xFFFFFFF7;
                break;
            }
            case 131072: {
                this.m_iKeyFlags &= 0xFFFFFFFE;
                break;
            }
            case 262144: {
                this.m_iKeyFlags &= 0xFFFFFFFD;
            }
        }
        return true;
    }

    public final void paint(vGraphics pGraphics) {
        pGraphics.pushClipRect();
        if (pGraphics.clipRect(this.m_mapRect)) {
            pGraphics.fillRect(this.m_mapRect, 0);
            pGraphics.drawImage(this.m_mapImage, this.m_iCurrentMapX, this.m_iCurrentMapY);
            for (int i = 0; i < this.m_iPinCount; ++i) {
                if (!this.m_pMapPins[i].bVisible) continue;
                int iFrame = this.m_pMapPins[i].iFrame;
                this.m_pMapPinSprite.paint(pGraphics, this.m_iCurrentMapX + this.m_pMapPins[i].iX, this.m_iCurrentMapY + this.m_pMapPins[i].iY, iFrame);
            }
            if (this.m_iSelection != -1) {
                this.m_pMapPinSprite.paint(pGraphics, this.m_iCurrentMapX + this.m_pMapPins[this.m_iSelection].iX, this.m_iCurrentMapY + this.m_pMapPins[this.m_iSelection].iY, 3);
            }
            this.m_pMapPinSprite.paint(pGraphics, this.m_iCurrentMapX + this.m_tc2.m_iMapCursorX, this.m_iCurrentMapY + this.m_tc2.m_iMapCursorY, 4);
            if (this.m_bUpArrowVisible) {
                pGraphics.drawImage(this.m_arrowU, this.m_iArrowU_X, this.m_iArrowU_Y);
            }
            if (this.m_bDownArrowVisible) {
                pGraphics.drawImage(this.m_arrowD, this.m_iArrowD_X, this.m_iArrowD_Y);
            }
        }
        pGraphics.popClipRect();
        super.paint(pGraphics);
    }

    public final void onIdle(int iTime) throws IOException {
        if (this.m_iKeyFlags != 0) {
            int iDeltaTime = iTime - this.m_iLastUpdateTime;
            int iKeyDownTime = iTime - this.m_iKeyDownTime;
            if (iDeltaTime > 0) {
                int fpMoveDist = iKeyDownTime > 1000 ? 6554 * iDeltaTime + this.m_fpRemainingDist : 2185 * iDeltaTime + this.m_fpRemainingDist;
                short iDelta = vBaseCanvas.toShort(fpMoveDist);
                int fpDeltaDist = vBaseCanvas.intToFP(iDelta);
                if (iDelta > 0) {
                    short iDeltaX = (this.m_iKeyFlags & 4) != 0 ? -iDelta : ((this.m_iKeyFlags & 8) != 0 ? iDelta : (short)0);
                    short iDeltaY = (this.m_iKeyFlags & 1) != 0 ? -iDelta : ((this.m_iKeyFlags & 2) != 0 ? iDelta : (short)0);
                    this.m_tc2.m_iMapCursorX += iDeltaX;
                    this.m_tc2.m_iMapCursorY += iDeltaY;
                    int iMinCursorX = Math.min(-this.m_mapRange.x, 0);
                    int iMaxCursorX = Math.max(this.m_mapRect.dx - this.m_mapRange.dx, this.m_mapImage.getWidth()) - 1;
                    if (this.m_tc2.m_iMapCursorX < iMinCursorX) {
                        this.m_tc2.m_iMapCursorX = iMinCursorX;
                    } else if (this.m_tc2.m_iMapCursorX > iMaxCursorX) {
                        this.m_tc2.m_iMapCursorX = iMaxCursorX;
                    }
                    int iMinCursorY = Math.min(-this.m_mapRange.y, 0);
                    int iMaxCursorY = Math.max(this.m_mapRect.dy - this.m_mapRange.dy, this.m_mapImage.getHeight()) - 1;
                    if (this.m_tc2.m_iMapCursorY < iMinCursorY) {
                        this.m_tc2.m_iMapCursorY = iMinCursorY;
                    } else if (this.m_tc2.m_iMapCursorY > iMaxCursorY) {
                        this.m_tc2.m_iMapCursorY = iMaxCursorY;
                    }
                    this.m_bUpArrowVisible = true;
                    this.m_bDownArrowVisible = true;
                    if (this.m_iCurrentMapX < -this.m_tc2.m_iMapCursorX + this.m_mapRect.x) {
                        this.m_iCurrentMapX = -this.m_tc2.m_iMapCursorX + this.m_mapRect.x;
                    } else if (this.m_iCurrentMapX > -this.m_tc2.m_iMapCursorX + this.m_mapRect.x + this.m_mapRect.dx) {
                        this.m_iCurrentMapX = -this.m_tc2.m_iMapCursorX + this.m_mapRect.x + this.m_mapRect.dx;
                    }
                    if (this.m_iCurrentMapY < -this.m_tc2.m_iMapCursorY + this.m_mapRect.y) {
                        this.m_iCurrentMapY = -this.m_tc2.m_iMapCursorY + this.m_mapRect.y;
                    } else if (this.m_iCurrentMapY > -this.m_tc2.m_iMapCursorY + this.m_mapRect.y + this.m_mapRect.dy) {
                        this.m_iCurrentMapY = -this.m_tc2.m_iMapCursorY + this.m_mapRect.y + this.m_mapRect.dy;
                    }
                    if (this.m_iCurrentMapY >= this.m_mapRect.y) {
                        this.m_bUpArrowVisible = false;
                    }
                    if (this.m_iCurrentMapY <= this.m_mapRange.y + 1) {
                        this.m_bDownArrowVisible = false;
                    }
                    this.updateSelection();
                    this.repaint(this.m_mapRect);
                }
                this.m_fpRemainingDist = fpMoveDist - fpDeltaDist;
            }
        }
        this.m_iLastUpdateTime = iTime;
    }

    protected final void initElement() throws IOException {
        super.initElement();
    }

    public final int load(int iStage) throws IOException {
        switch (iStage) {
            case 0: {
                this.m_game.removeEntities();
                DataInputStream dis = this.m_game.getFile(186, 1);
                this.m_iPinCount = dis.readShort();
                if (this.m_iPinCount <= 0) {
                    System.out.println("VASSERT failed ::m_iPinCount > 0");
                }
                this.m_pMapPins = new MapPin[this.m_iPinCount];
                if (this.m_pMapPins == null) {
                    System.out.println("VASSERT failed ::m_pMapPins != null");
                }
                dis.readShort();
                dis.readShort();
                for (int i = 0; i < this.m_iPinCount; ++i) {
                    this.m_pMapPins[i] = new MapPin(this);
                    this.m_pMapPins[i].iNameID = dis.readShort();
                    this.m_pMapPins[i].iLevel = dis.readShort();
                    this.m_pMapPins[i].fpX = dis.readInt();
                    this.m_pMapPins[i].fpY = dis.readInt();
                    this.m_pMapPins[i].iDependencyTable = dis.readShort();
                    this.m_pMapPins[i].iFrame = dis.readByte();
                }
                return 20;
            }
            case 1: {
                this.m_mapImage = vBaseCanvas.loadImage(180, 20);
                this.m_arrowU = vBaseCanvas.loadImage(180, 7);
                this.m_arrowD = vBaseCanvas.loadImage(180, 8);
                this.m_pMapPinSprite = this.m_tc2.loadSprite(180, 21, -1, -1, 180, 22);
                return 30;
            }
            case 2: {
                vWindow pWindow = (vWindow)this.getChildCRC32(-243627045);
                if (pWindow == null) {
                    System.out.println("VASSERT failed ::pWindow != null");
                }
                pWindow.setOuterDimensions(this.getInnerWidth(), pWindow.getOuterHeight());
                for (int i = 0; i < this.m_iPinCount; ++i) {
                    this.m_pMapPins[i].iX = this.m_pMapPins[i].fpX * this.m_mapImage.getWidth() >> 16;
                    this.m_pMapPins[i].iY = this.m_pMapPins[i].fpY * this.m_mapImage.getHeight() >> 16;
                    this.m_pMapPins[i].bVisible = this.m_pMapPins[i].iDependencyTable == -1 ? true : this.m_game.getDependencyTable((byte)this.m_pMapPins[i].iDependencyTable);
                    if (this.m_pMapPins[i].iLevel != this.m_game.m_iCurrentLevel) continue;
                    this.m_iCurrentLocation = i;
                }
                return 40;
            }
            case 3: {
                for (int j = 0; j < 3; ++j) {
                    int iPin = this.m_game.getRandomMissionPin(j);
                    if (iPin == -1) continue;
                    int iMissionType = this.m_game.getRandomMissionType(j);
                    this.m_pMapPins[iPin].iNameID = this.m_game.getRandomMissionName(iMissionType);
                    this.m_pMapPins[iPin].iLevel = ~j;
                }
                return 50;
            }
            case 4: {
                vUIElement pHeader = this.getChildCRC32(351066823);
                if (pHeader == null) {
                    System.out.println("VASSERT failed ::pHeader != null");
                }
                this.m_mapRect.set(0, pHeader.getOuterHeight(), this.getInnerWidth(), this.getInnerHeight() - pHeader.getOuterHeight());
                if (this.m_mapRect.dx > this.m_mapImage.getWidth()) {
                    this.m_mapRange.dx = this.m_mapRange.x = this.m_mapRect.x + (this.m_mapRect.dx - this.m_mapImage.getWidth() >> 1);
                } else {
                    this.m_mapRange.x = this.m_mapRect.x + this.m_mapRect.dx - this.m_mapImage.getWidth();
                    this.m_mapRange.dx = this.m_mapRect.x;
                }
                if (this.m_mapRect.dy > this.m_mapImage.getHeight()) {
                    this.m_mapRange.dy = this.m_mapRange.y = this.m_mapRect.y + (this.m_mapRect.dy - this.m_mapImage.getHeight() >> 1);
                } else {
                    this.m_mapRange.y = this.m_mapRect.y + this.m_mapRect.dy - this.m_mapImage.getHeight();
                    this.m_mapRange.dy = this.m_mapRect.y;
                }
                return 70;
            }
            case 5: {
                if (this.m_tc2.m_iMapCursorX == Integer.MAX_VALUE) {
                    if (this.m_iCurrentLocation == -1) {
                        this.m_tc2.m_iMapCursorX = this.m_mapImage.getWidth() >> 1;
                        this.m_tc2.m_iMapCursorY = this.m_mapImage.getHeight() >> 1;
                    } else {
                        this.m_tc2.m_iMapCursorX = this.m_pMapPins[this.m_iCurrentLocation].iX;
                        this.m_tc2.m_iMapCursorY = this.m_pMapPins[this.m_iCurrentLocation].iY;
                    }
                }
                return 80;
            }
            case 6: {
                this.m_iCurrentMapX = -this.m_tc2.m_iMapCursorX + this.m_mapRect.x + (this.m_mapRect.dx >> 1);
                this.m_iCurrentMapY = -this.m_tc2.m_iMapCursorY + this.m_mapRect.y + (this.m_mapRect.dy >> 1);
                if (this.m_iCurrentMapX < this.m_mapRange.x) {
                    this.m_iCurrentMapX = this.m_mapRange.x;
                } else if (this.m_iCurrentMapX > this.m_mapRange.dx) {
                    this.m_iCurrentMapX = this.m_mapRange.dx;
                }
                if (this.m_iCurrentMapY < this.m_mapRange.y) {
                    this.m_iCurrentMapY = this.m_mapRange.y;
                } else if (this.m_iCurrentMapY > this.m_mapRange.dy) {
                    this.m_iCurrentMapY = this.m_mapRange.dy;
                }
                return 90;
            }
            case 7: {
                this.m_iArrowU_X = (this.m_mapRect.dx >> 1) - (this.m_arrowU.getWidth() >> 2);
                this.m_iArrowU_Y = this.m_mapRect.y;
                this.m_iArrowD_X = this.m_iArrowU_X;
                this.m_iArrowD_Y = this.m_mapRect.y + this.m_mapRect.dy - this.m_arrowD.getHeight();
                this.updateSelection();
                this.m_iLastUpdateTime = this.m_iStartTime = vBaseCanvas.getAppTime();
                this.m_fpRemainingDist = 0;
                if (this.m_game.m_bPaused && this.m_tc2.findWindowByUserID(1003) == null) {
                    this.m_tc2.openWindow(1003, false, 0);
                }
                this.m_tc2.setKeyLabels(147, 145);
                return 100;
            }
        }
        return 100;
    }

    protected final void freeElement() throws IOException {
        this.m_mapImage = null;
        this.m_arrowU = null;
        this.m_arrowD = null;
        super.freeElement();
    }

    private void updateSelection() throws IOException {
        vTextControl pText;
        int iSelection = -1;
        vRect pinRect = new vRect();
        for (int i = 0; i < this.m_iPinCount; ++i) {
            if (!this.m_pMapPins[i].bVisible) continue;
            this.m_pMapPinSprite.getRect(pinRect, this.m_pMapPins[i].iX, this.m_pMapPins[i].iY);
            if (!pinRect.contains(this.m_tc2.m_iMapCursorX, this.m_tc2.m_iMapCursorY)) continue;
            iSelection = i;
            break;
        }
        if (this.m_iSelection == iSelection) {
            return;
        }
        this.m_iSelection = iSelection;
        vWindow pWindow = (vWindow)this.getChildCRC32(-243627045);
        if (pWindow == null) {
            System.out.println("VASSERT failed ::pWindow != null");
        }
        if ((pText = (vTextControl)this.getChildCRC32(-1569513538)) == null) {
            System.out.println("VASSERT failed ::pText != null");
        }
        if (iSelection != -1) {
            int iNameID = this.m_pMapPins[iSelection].iNameID;
            pWindow = (vWindow)this.getChildCRC32(-243627045);
            if (pWindow == null) {
                System.out.println("VASSERT failed ::pWindow != null");
            }
            pWindow.setOuterDimensions(this.getOuterWidth(), this.getOuterHeight());
            if (iNameID != -1) {
                pText.setText(this.m_game.getGlobalPropertyString(iNameID));
            } else {
                pText.setText("WTF?");
            }
            pText.setInnerDimensions(0, 0);
            pText.init();
            pWindow.sizeToChildren();
            pWindow.setOuterDimensions(this.getOuterWidth(), pWindow.getOuterHeight() + 3);
            pText.m_bVisible = true;
            pWindow.m_bVisible = true;
        } else {
            pText.m_bVisible = false;
            pWindow.m_bVisible = false;
        }
        pText.repaint();
        this.repaint(this.m_mapRect);
    }

    public final class MapPin {
        int fpX;
        int fpY;
        int iNameID;
        int iDependencyTable;
        int iLevel;
        int iX;
        int iY;
        int iFrame;
        boolean bVisible;

        public MapPin(MapWindow this$0) {
        }
    }
}

