/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public final class GameWindow
extends vWindow {
    vRect m_missionSuccessRect = new vRect();
    protected TC2App m_tc2;
    private Game m_game;
    private vSprite m_interfaceSprite;
    private vBitmapFont m_font;
    private int[] m_PointText_time = new int[6];
    private int[] m_PointText_type = new int[6];
    private int[] m_PointText_value = new int[6];
    private int[][] m_enemyArrows = new int[8][2];
    private int m_iEnemyArrowCount;
    private int m_iConversationStartTime;
    private int m_iAssetsLoaded = 0;
    private vRect m_repaintRect = new vRect();
    private vRect m_r = new vRect();
    private vRect m_reloadBar = new vRect();
    private vRect m_fill = new vRect();
    private vRect m_arrestBar = new vRect();
    private String m_szBuffer = new String();

    public GameWindow(Game game, TC2App tc2) {
        super(tc2, 0);
        this.m_tc2 = tc2;
        this.m_game = game;
        this.m_iUserID = 1001;
        this.m_game.m_bLevelLoadedInitialized = false;
        this.m_tc2.setKeyLabels(-1, -1);
    }

    public final void initElement() throws IOException {
        super.initElement();
        this.m_interfaceSprite = this.m_tc2.loadSprite(180, 10, -1, -1, 180, 11);
        this.m_tc2.loadSound(192, 1, 1, "audio/x-wav");
        this.m_tc2.prefetch(1);
        this.m_iConversationStartTime = vBaseCanvas.getAppTime();
        this.m_font = this.m_tc2.m_font_white;
    }

    public final void destructor() throws IOException {
        this.m_tc2.unloadSoundResources();
        this.m_game.unloadTempResources();
        super.destructor();
    }

    public final int load(int iStage) throws IOException {
        int iAssets;
        this.m_iAssetsLoaded = iAssets = this.m_game.loadTempResources(iStage);
        if (iAssets == 100) {
            vRect viewport = new vRect(0, 0, this.getInnerWidth(), this.getInnerHeight());
            this.m_game.setViewport(viewport);
            if (this.m_game.m_bPaused) {
                if (this.m_game.m_pSnippet != null) {
                    this.showConversationWindow(this.m_game.m_pSnippet);
                }
                if (this.m_tc2.findWindowByUserID(1003) == null) {
                    this.m_tc2.openWindow(1003, false, 0);
                }
            }
            this.m_iEnemyArrowCount = 0;
            this.m_game.closeInventory();
        }
        return iAssets;
    }

    public final void onIdle(int iTime) throws IOException {
        vWindow pWindow;
        int iDeferedIndex = this.m_tc2.m_iDeferedSlotIndex;
        if (this.m_tc2.m_iDeferedSlotIndex != 3) {
            this.m_tc2.m_iDeferedSlotIndex = 3;
            if (this.m_tc2.m_sDeferedSlotName == null) {
                System.out.println("GameWindow::onIdle -- loadSlot " + iDeferedIndex);
                this.m_game.loadSlot(iDeferedIndex, false);
                if (iDeferedIndex == -1) {
                    this.m_game.deleteSavedDataForSlot(-1);
                }
            } else {
                System.out.println("GameWindow::onIdle -- newGame " + iDeferedIndex);
                this.m_game.newGame(iDeferedIndex, this.m_tc2.m_sDeferedSlotName);
            }
        }
        this.m_repaintRect.dx = 0;
        this.m_game.onIdle(iTime, this.m_repaintRect);
        if (this.m_game.m_bExit) {
            return;
        }
        if (this.m_repaintRect.dx > 0) {
            this.repaint(this.m_repaintRect);
        }
        if (this.m_game.m_iCurrentInventorySelection != -1) {
            this.m_repaintRect.set(0, 0, this.m_interfaceSprite.getWidth() + 72, this.getInnerHeight());
            this.repaint(this.m_repaintRect);
        }
        if (this.m_game.m_bResetPointText) {
            for (int i = 0; i < 6; ++i) {
                this.m_PointText_type[i] = 0;
                this.m_PointText_value[i] = 0;
                this.m_PointText_time[i] = 0;
            }
            this.m_game.m_bResetPointText = false;
        }
        if ((pWindow = (vWindow)this.getChildCRC32(1327597844)) == null) {
            System.out.println("VASSERT failed ::pWindow != null");
        }
        if (this.m_game.getCurrentNotificationID() != -1 && this.m_game.m_iDisplayNotificationTime == -1) {
            this.m_game.m_iDisplayNotificationTime = iTime;
            pWindow.setOuterDimensions(this.getOuterWidth(), this.getOuterHeight());
            vLabel pLabel = (vLabel)this.getChildCRC32(-1510518473);
            if (pLabel == null) {
                System.out.println("VASSERT failed ::pLabel != null");
            }
            pLabel.setText(this.m_game.getCurrentNotificationID(), true);
            pWindow.sizeToChildren();
            pWindow.setOuterDimensions(this.getOuterWidth(), pWindow.getOuterHeight());
            int iY = pLabel.getAbsolutePositionY();
            pLabel.setPosition(0, iY);
            this.m_game.m_iScrollingState = pLabel.getOuterWidth() > this.getOuterWidth() ? 0 : 2;
            pWindow.m_bVisible = true;
            pWindow.repaint();
        } else if (this.m_game.m_iDisplayNotificationTime != -1 && (iTime - this.m_game.m_iDisplayNotificationTime < 2000 || this.m_game.m_iScrollingState != 2)) {
            int iNotifyTime = iTime - this.m_game.m_iDisplayNotificationTime;
            vLabel pLabel = (vLabel)this.getChildCRC32(-1510518473);
            if (pLabel == null) {
                System.out.println("VASSERT failed ::pLabel != null");
            }
            if (this.m_game.m_iScrollingState != 2) {
                int iX = pLabel.getAbsolutePositionX();
                int iY = pLabel.getAbsolutePositionY();
                if (this.m_game.m_iScrollingState == 0) {
                    pLabel.setPosition(0, iY);
                    if (iNotifyTime >= 1000) {
                        this.m_game.m_iDisplayNotificationTime = iTime;
                        this.m_game.m_iScrollingState = 1;
                    }
                } else if (this.m_game.m_iScrollingState == 1) {
                    if (iNotifyTime >= 40) {
                        pLabel.setPosition(--iX, iY);
                        this.m_game.m_iDisplayNotificationTime = iTime;
                    }
                    if (iX + pLabel.getOuterWidth() < this.getOuterWidth()) {
                        this.m_game.m_iScrollingState = 2;
                        this.m_game.m_iDisplayNotificationTime = iTime;
                    }
                }
            }
            pWindow.repaint();
        } else if (this.m_game.m_iDisplayNotificationTime != -1 && iTime - this.m_game.m_iDisplayNotificationTime >= 2000) {
            this.m_game.incrementNotificationID();
            this.m_game.m_iDisplayNotificationTime = -1;
            if (this.m_game.getCurrentNotificationID() == -1) {
                pWindow.m_bVisible = false;
            }
        }
        if (this.m_game.m_bHideNotificationWindow) {
            pWindow.m_bVisible = false;
            this.m_game.m_bHideNotificationWindow = false;
        }
    }

    public final void paint(vGraphics pGraphics) {
        pGraphics.translate(this.getOuterX(), this.getOuterY());
        pGraphics.translate(this.getInnerX(), this.getInnerY());
        try {
            this.m_game.paint(pGraphics);
        }
        catch (IOException iOException) {
            IOException e = iOException;
            iOException.printStackTrace();
        }
        int iArrowX = 0;
        int iArrowY = 0;
        int iScreenWidth = this.getInnerWidth();
        int iScreenHeight = this.getInnerHeight();
        for (int i = 0; i < this.m_iEnemyArrowCount; ++i) {
            if (this.m_enemyArrows[i][0] != 0 || this.m_enemyArrows[i][1] != 0) {
                iArrowX = Math.max(this.m_enemyArrows[i][0], 0);
                iArrowX = Math.min(iArrowX, iScreenWidth);
                iArrowY = Math.max(this.m_enemyArrows[i][1], 0);
                iArrowY = Math.min(iArrowY, iScreenHeight);
                if (this.m_enemyArrows[i][0] < 0) {
                    this.m_interfaceSprite.paint(pGraphics, iArrowX, iArrowY, 21);
                } else if (this.m_enemyArrows[i][0] > iScreenWidth) {
                    this.m_interfaceSprite.paint(pGraphics, iArrowX, iArrowY, 20);
                } else if (this.m_enemyArrows[i][1] < 0) {
                    this.m_interfaceSprite.paint(pGraphics, iArrowX, iArrowY, 18);
                } else if (this.m_enemyArrows[i][1] > iScreenHeight) {
                    this.m_interfaceSprite.paint(pGraphics, iArrowX, iArrowY, 19);
                }
            }
            this.m_enemyArrows[i][1] = 0;
            this.m_enemyArrows[i][0] = 0;
        }
        this.m_iEnemyArrowCount = 0;
        Entity pPlayer = this.m_game.m_pPlayerEntity;
        if (pPlayer != null) {
            boolean bStealthMode;
            vBitmapFont bitFont;
            int iObjectCompleteUntil;
            int iTime;
            int iCharState;
            int iArmorHP;
            int iIconWidth = this.m_interfaceSprite.getWidth(14);
            int iIconHeight = this.m_interfaceSprite.getHeight(14);
            int iHealth = pPlayer.getProperty(3);
            int iHealthMax = pPlayer.getProperty(4);
            int iX = this.getOuterWidth() - iIconWidth - 2;
            int iY = this.getOuterHeight() - iIconHeight - 2;
            this.m_interfaceSprite.paint(pGraphics, iX, iY, 14);
            if (iHealth > 0) {
                if (iHealth == iHealthMax) {
                    this.m_interfaceSprite.paint(pGraphics, iX, iY, 15);
                } else {
                    Object pSpriteData = null;
                    this.m_r.x = iX;
                    this.m_r.y = iY;
                    this.m_r.dx = this.m_interfaceSprite.getWidth(15);
                    this.m_r.dy = this.m_interfaceSprite.getHeight(15);
                    int iHealthHeight = iHealth * this.m_r.dy / iHealthMax;
                    this.m_r.y += this.m_r.dy - iHealthHeight;
                    this.m_r.dy = iHealthHeight;
                    pGraphics.pushClipRect();
                    if (pGraphics.clipRect(this.m_r)) {
                        this.m_interfaceSprite.paint(pGraphics, iX, iY, 15);
                    }
                    pGraphics.popClipRect();
                }
            }
            if ((iArmorHP = pPlayer.getProperty(63)) > 0) {
                int iArmorMaxHP = pPlayer.getProperty(64);
                if (iArmorHP == iArmorMaxHP) {
                    this.m_interfaceSprite.paint(pGraphics, iX, iY, 16);
                } else {
                    this.m_r.x = iX;
                    this.m_r.y = iY;
                    this.m_r.dx = this.m_interfaceSprite.getWidth(16);
                    this.m_r.dy = this.m_interfaceSprite.getHeight(16);
                    int iArmorHeight = iArmorHP * this.m_r.dy / iArmorMaxHP;
                    this.m_r.y += this.m_r.dy - iArmorHeight;
                    this.m_r.dy = iArmorHeight;
                    pGraphics.pushClipRect();
                    if (pGraphics.clipRect(this.m_r)) {
                        this.m_interfaceSprite.paint(pGraphics, iX, iY, 16);
                    }
                    pGraphics.popClipRect();
                }
                this.m_interfaceSprite.paint(pGraphics, iX, iY, 17);
            }
            this.paintPoints(pGraphics, iY);
            this.paintWeapons(pGraphics);
            int iWeapon = pPlayer.getProperty(6);
            if (iWeapon == 11 && (iCharState = pPlayer.getProperty(8)) == 3) {
                int iTime2 = this.m_game.m_iGameTime;
                int iStateTime = iTime2 - pPlayer.getProperty(9);
                String szText = vBaseCanvas.getString(36);
                int iTextHeight = this.m_font.getHeight();
                int iTextWidth = this.m_font.measureString(szText);
                int iBarWidth = iTextWidth + 6;
                this.m_arrestBar.set(this.getInnerWidth() - iBarWidth >> 1, this.getInnerHeight() - 56, iBarWidth, 14);
                pGraphics.drawRect(this.m_arrestBar, 16758818);
                ++this.m_arrestBar.x;
                ++this.m_arrestBar.y;
                this.m_arrestBar.dx -= 2;
                this.m_arrestBar.dy -= 2;
                int iArrestWidth = iStateTime * (iBarWidth - 2) / 3000;
                int iRemainingWidth = iBarWidth - 2 - iArrestWidth;
                this.m_fill.set(this.m_arrestBar);
                this.m_fill.dx = iArrestWidth;
                pGraphics.fillRect(this.m_fill, 13500424);
                this.m_fill.x += iArrestWidth;
                this.m_fill.dx = iRemainingWidth;
                pGraphics.fillRect(this.m_fill, 0);
                pGraphics.drawBitmapStyleText(szText, this.m_tc2.m_font_white, this.m_arrestBar.x + (this.m_arrestBar.dx - iTextWidth >> 1), this.m_arrestBar.y + (this.m_arrestBar.dy - iTextHeight >> 1));
            }
            if ((iTime = this.m_game.m_iGameTime) < (iObjectCompleteUntil = this.m_game.m_iDisplayObjectiveCompleteUntil)) {
                String szText = vBaseCanvas.getString(45);
                int iTextHeight = this.m_font.getHeight();
                int iTextWidth = this.m_font.measureString(szText);
                iX = this.getInnerWidth() - iTextWidth >> 1;
                iY = this.getInnerHeight() - iTextHeight * 5 >> 1;
                pGraphics.drawBitmapStyleText(szText, this.m_tc2.m_font_green, iX, iY);
            }
            int iSuccessUntil = this.m_game.m_iDisplayMissionSuccessUntil;
            int iFailureUntil = this.m_game.m_iDisplayMissionFailureUntil;
            if (iTime < iSuccessUntil || iTime < iFailureUntil) {
                String szText;
                if (iTime < iSuccessUntil) {
                    szText = vBaseCanvas.getString(46);
                    bitFont = this.m_tc2.m_font_green;
                } else {
                    szText = vBaseCanvas.getString(47);
                    bitFont = this.m_tc2.m_font_red;
                }
                int iTextHeight = this.m_font.getHeight();
                int iTextWidth = this.m_font.measureString(szText);
                this.m_missionSuccessRect.dx = iTextWidth + 8;
                this.m_missionSuccessRect.dy = iTime < iSuccessUntil ? iTextHeight * 5 + 8 : iTextHeight + 8;
                iX = this.getInnerWidth() - iTextWidth >> 1;
                iY = this.getInnerHeight() - iTextHeight * 5 >> 1;
                this.m_missionSuccessRect.x = iX - 4;
                this.m_missionSuccessRect.y = iY - 4;
                pGraphics.fillRect(this.m_missionSuccessRect, 0);
                pGraphics.drawBitmapStyleText(szText, bitFont, iX, iY);
                iY += iTextHeight;
                if (iTime < iSuccessUntil) {
                    int iKilled = this.m_game.getGlobalPropertyInt(22);
                    int iArrested = this.m_game.getGlobalPropertyInt(23);
                    int iEscaped = this.m_game.getGlobalPropertyInt(24);
                    this.m_szBuffer = vBaseCanvas.getString(48) + " " + iKilled;
                    iTextWidth = this.m_font.measureString(this.m_szBuffer);
                    iX = this.getInnerWidth() - iTextWidth >> 1;
                    pGraphics.drawBitmapStyleText(this.m_szBuffer, bitFont, iX, iY += iTextHeight);
                    this.m_szBuffer = vBaseCanvas.getString(49) + " " + iArrested;
                    iTextWidth = this.m_font.measureString(this.m_szBuffer);
                    iX = this.getInnerWidth() - iTextWidth >> 1;
                    pGraphics.drawBitmapStyleText(this.m_szBuffer, bitFont, iX, iY += iTextHeight);
                    this.m_szBuffer = vBaseCanvas.getString(50) + " " + iEscaped;
                    iTextWidth = this.m_font.measureString(this.m_szBuffer);
                    iX = this.getInnerWidth() - iTextWidth >> 1;
                    pGraphics.drawBitmapStyleText(this.m_szBuffer, bitFont, iX, iY += iTextHeight);
                }
            }
            boolean bStrafeMode = pPlayer.getProperty(16) != 0;
            boolean bl = bStealthMode = pPlayer.getProperty(70) != 0;
            if (bStrafeMode || bStealthMode) {
                String szText = vBaseCanvas.getString(bStrafeMode ? 34 : 35);
                bitFont = bStrafeMode ? this.m_tc2.m_font_red : this.m_tc2.m_font_green;
                int iTextHeight = this.m_font.getHeight();
                int iTextWidth = this.m_font.measureString(szText);
                pGraphics.drawBitmapStyleText(szText, bitFont, this.getInnerWidth() - iTextWidth >> 1, this.getInnerHeight() - iTextHeight * 3);
            }
        }
        pGraphics.translate(-this.getInnerX(), -this.getInnerY());
        pGraphics.translate(-this.getOuterX(), -this.getOuterY());
        super.paint(pGraphics);
    }

    public final boolean onKeyPressed(int usKey, int eAction) throws IOException {
        if (vBaseCanvas.getAppTime() - this.m_iConversationStartTime < 500) {
            return true;
        }
        if (eAction == 0x10000000 && !this.m_game.inventoryIsOpen()) {
            this.setPause();
        }
        if (this == this.m_tc2.m_windowListHead) {
            vWindow pConvWindow = (vWindow)this.getChildCRC32(963736325);
            if (pConvWindow == null) {
                System.out.println("VASSERT failed ::pConvWindow != null");
            }
            if (usKey == 4096 && !pConvWindow.m_bVisible) {
                return true;
            }
            if (pConvWindow.m_bVisible) {
                if (eAction == 131072) {
                    vTextControl pConvText = (vTextControl)pConvWindow.getChildCRC32(-585047408);
                    if (pConvText == null) {
                        System.out.println("VASSERT failed ::pConvText != null");
                    }
                    pConvText.prevPage();
                } else if (eAction == 262144) {
                    vTextControl pConvText = (vTextControl)pConvWindow.getChildCRC32(-585047408);
                    if (pConvText == null) {
                        System.out.println("VASSERT failed ::pConvText != null");
                    }
                    pConvText.nextPage();
                }
            }
        }
        this.m_game.onKeyPressed$255f299(eAction);
        return true;
    }

    public final boolean onKeyReleased(int usKey, int eAction) throws IOException {
        if (this == this.m_tc2.m_windowListHead) {
            vWindow pConvWindow = (vWindow)this.getChildCRC32(963736325);
            if (pConvWindow == null) {
                System.out.println("VASSERT failed ::pConvWindow != null");
            }
            if (usKey == 4096 && !pConvWindow.m_bVisible) {
                return true;
            }
        }
        this.m_game.onKeyReleased$255f299(eAction);
        return true;
    }

    public final boolean onWindowEvent$f13b8cb(int eEvent) throws IOException {
        switch (eEvent) {
            case 0: {
                break;
            }
            case 1: {
                this.m_game.pause(true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.m_iAssetsLoaded != 100 || this.m_game.m_iLevelLoaded == -1) break;
                this.m_game.closeInventory();
                this.setPause();
                break;
            }
            case 4: {
                if (this.m_iAssetsLoaded != 100 || this.m_game.m_iLevelLoaded == -1 || this != this.m_tc2.m_windowListHead || this.m_game.m_pSnippet != null) break;
                this.m_game.m_pPlayerEntity.setProperty(15, 0);
                this.m_game.m_bLookAhead = false;
            }
        }
        return true;
    }

    public final void showConversationWindow(ConversationSnippet snippet) throws IOException {
        int iFriendlyNameIndex;
        int iSpeakerCRC32;
        Definition pDefinition;
        vLabel pSpeaker;
        this.m_tc2.setKeyLabels(147, 145);
        this.m_iConversationStartTime = vBaseCanvas.getAppTime();
        this.m_tc2.clearKeyEvents();
        vWindow pConvWindow = (vWindow)this.getChildCRC32(963736325);
        if (pConvWindow == null) {
            System.out.println("VASSERT failed ::pConvWindow != null");
        }
        pConvWindow.setOuterDimensions(this.getInnerWidth(), this.getInnerHeight());
        vWindow pResponseShelf = (vWindow)pConvWindow.getChildCRC32(573643703);
        if (pResponseShelf == null) {
            System.out.println("VASSERT failed ::pResponseShelf != null");
        }
        if ((pSpeaker = (vLabel)pConvWindow.getChildCRC32(1226127143)) == null) {
            System.out.println("VASSERT failed ::pSpeaker != null");
        }
        if ((pDefinition = this.m_game.getDefinition(iSpeakerCRC32 = snippet.m_iSpeakerTypeCRC32)) == null) {
            pDefinition = this.m_game.m_pSnippetEntity.m_definition;
        }
        if ((iFriendlyNameIndex = pDefinition.m_iFriendlyNameIndex) != -1) {
            String szFriendlyName = this.m_game.getGlobalPropertyString(iFriendlyNameIndex);
            pSpeaker.setText(szFriendlyName, true);
        } else {
            pSpeaker.setText("<NoFriendlyName>", true);
        }
        int[] nArray = new int[7];
        int[] aiInfo = nArray;
        nArray[0] = 0xFFFFFF;
        aiInfo[1] = 0;
        aiInfo[2] = 0;
        aiInfo[3] = 1;
        aiInfo[4] = -1;
        aiInfo[5] = 0;
        aiInfo[6] = 1;
        pResponseShelf.destroyChildren();
        for (int i = 0; i < snippet.getResponseCount(); ++i) {
            byte condition = snippet.getResponse((int)i).m_iCondition;
            if (condition != -1 && !this.m_game.getDependencyTable(condition)) continue;
            vLabel pResponse = new vLabel(this.m_tc2, aiInfo);
            pResponse.setStyleFlags(2);
            pResponse.m_iElementCRC32 = i;
            pResponse.setText(snippet.getResponse(i).getString(), true);
            pResponseShelf.addToBack(pResponse);
            pResponse.init();
        }
        this.updateConversationSelection();
        pResponseShelf.sizeToChildren();
        vTextControl pConvText = (vTextControl)pConvWindow.getChildCRC32(-585047408);
        if (pConvText == null) {
            System.out.println("VASSERT failed ::pConvText != null");
        }
        int iMaxHeight = this.getOuterHeight() - pSpeaker.getOuterHeight() - pResponseShelf.getOuterHeight() - 4;
        pConvText.setInnerDimensions(0, iMaxHeight);
        pConvText.setText(snippet.getString());
        pConvText.init();
        pConvWindow.sizeToChildren();
        pConvWindow.setOuterDimensions(this.getInnerWidth(), pConvWindow.getOuterHeight());
        pConvWindow.m_bVisible = true;
        pConvWindow.repaint();
    }

    public final void hideConversationWindow() throws IOException {
        vUIElement pElem;
        vTextControl pConvText;
        this.m_tc2.setKeyLabels(-1, 145);
        vWindow pConvWindow = (vWindow)this.getChildCRC32(963736325);
        if (pConvWindow == null) {
            System.out.println("VASSERT failed ::pConvWindow != null");
        }
        if ((pConvText = (vTextControl)pConvWindow.getChildCRC32(-585047408)) == null) {
            System.out.println("VASSERT failed ::pConvText != null");
        }
        pConvText.free();
        vWindow pResponseShelf = (vWindow)pConvWindow.getChildCRC32(573643703);
        if (pResponseShelf == null) {
            System.out.println("VASSERT failed ::pResponseShelf != null");
        }
        while ((pElem = pResponseShelf.getChild(0)) != null) {
            pResponseShelf.remove(pElem);
            pElem.free();
        }
        pConvWindow.m_bVisible = false;
        pConvWindow.repaint();
    }

    public final void updateConversationSelection() {
        vWindow pResponseShelf;
        vWindow pConvWindow = (vWindow)this.getChildCRC32(963736325);
        if (pConvWindow == null) {
            System.out.println("VASSERT failed ::pConvWindow != null");
        }
        if ((pResponseShelf = (vWindow)pConvWindow.getChildCRC32(573643703)) == null) {
            System.out.println("VASSERT failed ::pResponseShelf != null");
        }
        byte iSelection = this.m_game.m_iSnippetSelection;
        for (int i = 0; i < pResponseShelf.m_iListLength; ++i) {
            vLabel pResponse = (vLabel)pResponseShelf.getChild(i);
            if (pResponse == null) {
                System.out.println("VASSERT failed ::pResponse != null");
            }
            pResponse.m_iFrameColor = pResponse.m_iElementCRC32 == iSelection ? 0xFFFFFF : 0;
        }
    }

    public final void setPause() throws IOException {
        this.m_game.pause(true);
        if (this.m_tc2.findWindowByUserID(1003) == null) {
            this.m_tc2.openWindow(1003, false, 0);
        }
    }

    public final void showPoints(int iType, int iNumPoints, int iTime) {
        int iPointText = 0;
        int iOldest = 0;
        int iOldestTime = Integer.MAX_VALUE;
        int iTimeDec = 0;
        int iHeight = 0;
        for (iPointText = 0; iPointText < 6 && this.m_PointText_type[iPointText] != 0; ++iPointText) {
            if (this.m_PointText_time[iPointText] >= iOldestTime) continue;
            iOldestTime = this.m_PointText_time[iPointText];
            iOldest = iPointText;
        }
        iHeight = this.m_tc2.m_font.getHeight();
        this.m_font.measureString("T");
        iTimeDec = vBaseCanvas.div(vBaseCanvas.intToFP(iHeight), 655) >> 16;
        int i = 0;
        while (i < 6) {
            int n = i++;
            this.m_PointText_time[n] = this.m_PointText_time[n] - iTimeDec;
        }
        if (iPointText >= 6) {
            iPointText = iOldest;
        }
        this.m_PointText_type[iPointText] = iType;
        this.m_PointText_value[iPointText] = iNumPoints;
        this.m_PointText_time[iPointText] = iTime;
    }

    public final void addEnemyArrow(int iX, int iY) {
        if (this.m_iEnemyArrowCount < 8) {
            this.m_enemyArrows[this.m_iEnemyArrowCount][0] = iX;
            this.m_enemyArrows[this.m_iEnemyArrowCount][1] = iY;
            ++this.m_iEnemyArrowCount;
        }
    }

    private void paintWeapons(vGraphics pGraphics) {
        Entity pPlayer = this.m_game.m_pPlayerEntity;
        if (this.m_game.m_iCurrentInventorySelection == -1) {
            int iWeapon = pPlayer.getProperty(6);
            this.m_interfaceSprite.setFrame(iWeapon);
            int iY = this.getInnerHeight() - Math.max(this.m_interfaceSprite.getHeight(), (3 * this.m_interfaceSprite.getHeight() >> 2) + 9);
            this.paintWeapon(pGraphics, iWeapon, 0, iY, false);
            return;
        }
        int iWeaponList = this.m_game.m_iCurrentInventoryList;
        int iY = this.getInnerHeight();
        for (int i = 0; i < 12; ++i) {
            int iWeapon = this.m_game.m_iCurrentInventorySelection - i;
            if (iWeapon < 0) {
                iWeapon += 12;
            }
            if ((iWeaponList & 1 << iWeapon) == 0) continue;
            this.paintWeapon(pGraphics, iWeapon, 0, iY -= Math.max(this.m_interfaceSprite.getHeight(), (3 * this.m_interfaceSprite.getHeight() >> 2) + 9), true);
            if (iY >= this.m_interfaceSprite.getHeight()) continue;
            return;
        }
    }

    private void paintWeapon(vGraphics pGraphics, int iWeapon, int iX, int iY, boolean bBackground) {
        Entity pPlayer = this.m_game.m_pPlayerEntity;
        this.m_interfaceSprite.setFrame(iWeapon);
        this.m_interfaceSprite.setPosition(iX, iY);
        this.m_r.set(this.m_interfaceSprite.m_frameRect);
        this.m_r.dx = Math.max(this.m_r.dx, 48);
        this.m_r.dy = Math.max(this.m_r.dy, (3 * this.m_r.dy >> 2) + 9);
        if (bBackground) {
            if (iWeapon != this.m_game.m_iCurrentInventorySelection) {
                pGraphics.fillRect(this.m_r, 0);
            } else {
                pGraphics.fillRect(this.m_r, 3357005);
                pGraphics.drawRect(this.m_r, 16758562);
            }
        }
        this.m_interfaceSprite.paint(pGraphics);
        int iMin = 0;
        int iMax = 0;
        if (Game.projectile_getAttackType(iWeapon) == 1) {
            int iAmmoCount = pPlayer.getProperty(26 + iWeapon);
            int iClipCount = pPlayer.getProperty(38 + iWeapon);
            if (iAmmoCount != -1 || iClipCount > 0) {
                if (iClipCount == 0 && iAmmoCount != 0) {
                    iMax = this.m_game.projectile_getReloadTime(iWeapon);
                    int iTime = this.m_game.m_iGameTime;
                    int iNextTime = pPlayer.getProperty(50 + iWeapon);
                    iMin = iTime < iNextTime ? iNextTime - iTime : iMax;
                } else {
                    iMin = 1;
                    iMax = 1;
                }
            } else {
                iMin = 0;
                iMax = 1;
            }
            if (iMin != -1) {
                this.m_szBuffer = iAmmoCount != -2 ? Integer.toString(iClipCount) + "/" + iAmmoCount : Integer.toString(iClipCount) + "/-";
                int iTextHeight = this.m_font.getHeight();
                int iTextWidth = this.m_font.measureString(this.m_szBuffer);
                this.m_reloadBar.set(this.m_r.x + (this.m_r.dx - 44 >> 1), this.m_r.y + this.m_r.dy - 9 - 1, 44, 9);
                if (iMin < iMax) {
                    pGraphics.fillOutlinedRect(this.m_reloadBar, 0, 0x680000);
                    if (iMin > 0) {
                        int iReloadWidth = iMin * 44 / iMax;
                        this.m_fill.set(this.m_reloadBar);
                        this.m_fill.x += iReloadWidth;
                        this.m_fill.dx -= iReloadWidth;
                        ++this.m_fill.x;
                        ++this.m_fill.y;
                        this.m_fill.dx -= 2;
                        this.m_fill.dy -= 2;
                        pGraphics.fillRect(this.m_fill, 0xFE0000);
                    }
                } else {
                    pGraphics.fillOutlinedRect(this.m_reloadBar, 0, 2919680);
                }
                pGraphics.drawBitmapStyleText(this.m_szBuffer, this.m_tc2.m_font_white, this.m_reloadBar.x + (this.m_reloadBar.dx - iTextWidth >> 1), this.m_reloadBar.y + (this.m_reloadBar.dy - iTextHeight >> 1) - 1);
            }
        }
    }

    private void paintPoints(vGraphics pGraphics, int iStartY) {
        int iTime = this.m_game.m_iGameTime;
        int iPointText = 0;
        int iElapsed = 0;
        int iStringID = 0;
        int iX = 0;
        int iY = 0;
        vBitmapFont bitFont = this.m_tc2.m_font_white;
        int iOffset = 0;
        int iTextWidth = 0;
        for (iPointText = 0; iPointText < 6; ++iPointText) {
            if (this.m_PointText_type[iPointText] == 0) continue;
            iElapsed = iTime - this.m_PointText_time[iPointText];
            if (iElapsed >= 3000) {
                this.m_PointText_type[iPointText] = 0;
                continue;
            }
            iOffset = vBaseCanvas.mul(iElapsed << 16, 655) >> 16;
            switch (this.m_PointText_type[iPointText]) {
                case 1: {
                    bitFont = this.m_tc2.m_font_red;
                    iStringID = 14;
                    break;
                }
                case 2: {
                    bitFont = this.m_tc2.m_font_green;
                    iStringID = 13;
                    break;
                }
                case 3: {
                    bitFont = this.m_tc2.m_font_white;
                    iStringID = 15;
                }
            }
            this.m_szBuffer = "+" + this.m_PointText_value[iPointText] + " " + this.m_game.getGlobalPropertyString(iStringID);
            iTextWidth = this.m_font.measureString(this.m_szBuffer) + 1;
            iX = this.getOuterWidth() - iTextWidth - 2;
            iY = iStartY - 0 - iOffset;
            pGraphics.drawBitmapStyleText(this.m_szBuffer, bitFont, iX, iY);
        }
    }
}

