/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Engine {
    protected vBaseCanvas m_tc2;
    private PropertyTable m_globalProperties = new PropertyTable();
    private PropertyTable m_levelProperties = new PropertyTable();
    public ConversationSnippet m_pSnippet;
    public byte m_iSnippetSelection;
    public Entity m_pSnippetEntity;
    private vLinkedList m_definitionList = new vLinkedList();
    private vLinkedList m_renderList = new vLinkedList();
    private vLinkedList m_renderAsFloorList = new vLinkedList();
    private vVector3 m_camera = new vVector3();
    public vRect m_viewport = new vRect();
    private vRect m_scissors = new vRect();
    private vRect m_transparentRect = new vRect();
    private vRect m_sectorRect = new vRect();
    private vRect m_globalRect = new vRect();
    private vRect m_entityRect = new vRect();
    private vRect m_collideRect = new vRect();
    private vRect m_r = new vRect();
    private int m_iTileClipMinX;
    private int m_iTileClipMaxX;
    private int m_iTileClipMinY;
    private int m_iTileClipMaxY;
    private short[] m_pDependencyTable;
    private byte[] m_pDependencyIndices;
    private int m_iDependencyTableSize;
    private int m_iDependencyTableBytes;
    private int m_iDependencyIndicesSize;
    private int m_iUniqueBaseIndex;
    public int m_iNumTilesVisX;
    public int m_iNumTilesVisY;
    private int m_fpNumTilesVisX;
    private int m_fpNumTilesVisY;
    private int m_iTallestObjectInTiles;
    private int m_iFirstTileVisX;
    private int m_iFirstTileVisY;
    public int m_iLevelWidth;
    public int m_iLevelHeight;
    private byte[] m_pTileInfo;
    private byte[] m_pTiles;
    private boolean[] m_abValidTiles;
    public int m_iGameTime;
    private int m_iLastProcessTime;
    public int m_iTilePixelX;
    public int m_iTilePixelY;
    private int m_iSkew;
    public boolean m_bPaused;
    private Image[] m_terrainImages;
    private KDTree2D m_kdTree = new KDTree2D();
    public vLinkedList m_sectors = new vLinkedList();
    private Sector[] m_pSectors;
    private Sector m_masterSector = new Sector();
    public Entity m_pPortalFocus;
    private boolean m_bUpdatePortals;
    public int m_iWorldToScreenX;
    public int m_iWorldToScreenY;
    public int m_iTileToScreenX;
    public int m_iTileToScreenY;

    public final DataInputStream getFile(int iFile, int iIndex) throws IOException {
        byte[] bytes = vBaseCanvas.loadPackedResourceAsArray(iFile, iIndex);
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bs);
        return dis;
    }

    public final void beginConversationSnippet(Entity pEntity, byte convID, int iDefaultSelection, int iTime) throws IOException {
        ConversationSnippet snippet;
        Definition definition;
        if (this.m_pSnippet != null) {
            System.out.println("VASSERT failed ::m_pSnippet == null");
        }
        if (this.m_pSnippetEntity != null) {
            System.out.println("VASSERT failed ::m_pSnippetEntity == null");
        }
        if ((definition = pEntity.m_definition).isSnippetCollection(convID)) {
            ConversationSnippetCollection col = definition.getSnippetCollection(convID);
            if (col.getSnippetCount() <= 0) {
                System.out.println("VASSERT failed ::col.getSnippetCount() > 0");
            }
            convID = col.getSnippetID(this.m_tc2.getRandom(col.getSnippetCount()));
        }
        this.m_pSnippet = snippet = definition.getSnippet(convID);
        this.m_iSnippetSelection = (byte)iDefaultSelection;
        byte condition = this.m_pSnippet.getResponse((int)this.m_iSnippetSelection).m_iCondition;
        if (condition != -1 && !this.getDependencyTable(condition)) {
            this.m_iSnippetSelection = this.getNextConversationResponse(this.m_pSnippet, this.m_iSnippetSelection);
        }
        this.m_pSnippetEntity = pEntity;
        if (iDefaultSelection < 0 || iDefaultSelection >= this.m_pSnippet.getResponseCount()) {
            System.out.println("VASSERT failed ::iDefaultSelection >= 0 && iDefaultSelection < m_pSnippet.getResponseCount()");
        }
        this.onConversationSnippetEvent$3af13cf9(snippet, (byte)1);
        this.pause(true);
    }

    public final boolean getDependencyTable(byte iDependencyTableID) {
        if (iDependencyTableID < 0) {
            System.out.println("VASSERT failed ::iDependencyTableID >= 0");
        }
        if (iDependencyTableID >= this.m_iDependencyTableSize) {
            System.out.println("VASSERT failed ::iDependencyTableID < m_iDependencyTableSize");
        }
        short iTableIndex = this.m_pDependencyTable[iDependencyTableID];
        int iNumIndicies = this.m_pDependencyTable[iTableIndex + 0];
        short uiBits = this.m_pDependencyTable[iTableIndex + 1];
        if ((uiBits & 0x8000) == 0) {
            for (int i = 0; i < iNumIndicies; ++i) {
                short iIndex = this.m_pDependencyTable[iTableIndex + i + 2];
                boolean bLogicalResult = this.getDependencyIndex(iIndex);
                if (!((uiBits & 1 << i) == 0 ? !bLogicalResult : bLogicalResult)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < iNumIndicies; ++i) {
            short iIndex = this.m_pDependencyTable[iTableIndex + i + 2];
            boolean bLogicalResult = this.getDependencyIndex(iIndex);
            if (!((uiBits & 1 << i) == 0 ? bLogicalResult : !bLogicalResult)) continue;
            return true;
        }
        return false;
    }

    public final boolean getDependencyIndex(int iDpndIndex) {
        int iBit;
        int iByte;
        if (iDpndIndex < 0) {
            System.out.println("VASSERT failed ::iDpndIndex >= 0");
        }
        if (iDpndIndex >= this.m_iDependencyIndicesSize) {
            System.out.println("VASSERT failed ::iDpndIndex < m_iDependencyIndicesSize");
        }
        return (this.m_pDependencyIndices[iByte = iDpndIndex >> 3] >> (iBit = iDpndIndex & 7) & 1) != 0;
    }

    public final void setDependencyIndex(int iDpndIndex, boolean bValue) throws IOException {
        int iBit;
        int iByte;
        boolean bOldValue;
        if (iDpndIndex < 0) {
            System.out.println("VASSERT failed ::iDpndIndex >= 0");
        }
        if (iDpndIndex >= this.m_iDependencyIndicesSize) {
            System.out.println("VASSERT failed ::iDpndIndex < m_iDependencyIndicesSize");
        }
        boolean bl = bOldValue = (this.m_pDependencyIndices[iByte = iDpndIndex >> 3] & 1 << (iBit = iDpndIndex & 7)) != 0;
        if (bValue) {
            int n = iByte;
            this.m_pDependencyIndices[n] = (byte)(this.m_pDependencyIndices[n] | 1 << iBit);
        } else {
            int n = iByte;
            this.m_pDependencyIndices[n] = (byte)(this.m_pDependencyIndices[n] & ~(1 << iBit));
        }
        this.onDependencyUpdate(iDpndIndex, bValue, bOldValue);
    }

    public final String getGlobalPropertyString(int uiStringIndex) {
        return this.m_globalProperties.getString(uiStringIndex);
    }

    public final int getGlobalPropertyInt(int uiCRC32) {
        return this.m_globalProperties.getInt(uiCRC32);
    }

    public final void setGlobalPropertyInt(int uiCRC32, int iValue) {
        this.m_globalProperties.setInt(uiCRC32, iValue);
    }

    public final int getLevelPropertyInt(int uiCRC32) {
        return this.m_levelProperties.getInt(uiCRC32);
    }

    public final Definition getDefinition(int iDefinitionCRC32) {
        vNode pNode = this.m_definitionList.m_pFirst;
        while (pNode != null) {
            Definition pDefinition = (Definition)pNode;
            if (pDefinition.m_iDefinitionCRC32 == iDefinitionCRC32) {
                return pDefinition;
            }
            pNode = pNode.m_pNext;
        }
        return null;
    }

    public static void acquireEntity(Entity pEntity) {
        pEntity.addRef();
    }

    public final boolean releaseEntity(Entity pEntity) throws IOException {
        return Engine.releaseEntity(pEntity, false);
    }

    public final Entity spawnEntity(DataInputStream dis, int iTime) throws IOException {
        int iDefinitionCRC32 = dis.readInt();
        Definition pDefinition = this.getDefinition(iDefinitionCRC32);
        if (pDefinition == null) {
            DataInputStream defStream = this.getDefinitionStream(iDefinitionCRC32);
            Definition pNewDefinition = new Definition();
            pNewDefinition.init(defStream);
            this.m_definitionList.insertLast(pNewDefinition);
            pDefinition = pNewDefinition;
        }
        Entity pEntity = new Entity(this.m_tc2, this, pDefinition, this.m_iUniqueBaseIndex++);
        pEntity.init(dis, iTime);
        if ((pEntity.m_iFlags & 4) != 0) {
            pEntity.onEvent(null, (byte)0, 0);
        }
        Engine.acquireEntity(pEntity);
        pEntity.m_iTileX = (byte)(pEntity.m_iTileX - 1);
        pEntity.updateCache();
        return pEntity;
    }

    public final Entity getEntityByUniqueIndex(int iUniqueIndex) {
        vNode pS = this.m_sectors.m_pFirst;
        while (pS != null) {
            Sector pSector = (Sector)pS;
            vNode pNode = pSector.m_entities.m_pFirst;
            while (pNode != null) {
                Entity pEntity = (Entity)pNode;
                if (pEntity.m_iUniqueIndex == iUniqueIndex) {
                    return pEntity;
                }
                pNode = pNode.m_pNext;
            }
            pS = pS.m_pNext;
        }
        return null;
    }

    public final Entity getEntityByName(int uiNameCRC32) {
        vNode pS = this.m_sectors.m_pFirst;
        while (pS != null) {
            Sector pSector = (Sector)pS;
            vNode pNode = pSector.m_entities.m_pFirst;
            while (pNode != null) {
                Entity pEntity = (Entity)pNode;
                if (pEntity.m_iCRC32 == uiNameCRC32) {
                    return pEntity;
                }
                pNode = pNode.m_pNext;
            }
            pS = pS.m_pNext;
        }
        return null;
    }

    public final Entity getEntityByDefinition(int iDefinitionCRC32, Entity pFrom) {
        vNode pNode;
        vNode pS;
        if (pFrom == null) {
            pS = this.m_sectors.m_pFirst;
            pNode = null;
        } else {
            pS = pFrom.m_pSector;
            pNode = pFrom.m_pNext;
            if (pNode == null) {
                pS = pS.m_pNext;
            }
        }
        while (pS != null) {
            vNode pSector = pS;
            if (pNode == null) {
                pNode = pSector.m_entities.m_pFirst;
            }
            while (pNode != null) {
                Entity pEntity = (Entity)pNode;
                if (pEntity.m_definition.m_iDefinitionCRC32 == iDefinitionCRC32) {
                    return pEntity;
                }
                pNode = pNode.m_pNext;
            }
            pS = pS.m_pNext;
        }
        return null;
    }

    public final Entity getEntityAtLocation(int iTileX, int iTileY, Entity pFrom) {
        vNode pNode;
        Sector pSector;
        if (pFrom == null) {
            pSector = this.getSector(iTileX, iTileY);
            if (pSector == null) {
                System.out.println("WARNING . getEntityAtLocation -- " + iTileX + " x " + iTileY + " isn't within a sector.");
                return null;
            }
            pNode = pSector.m_entities.m_pFirst;
        } else {
            pSector = null;
            pNode = pFrom.m_pNext;
        }
        while (pNode != null) {
            Entity pEntity = (Entity)pNode;
            if (pEntity.m_iTileX == iTileX && pEntity.m_iTileY == iTileY) {
                return pEntity;
            }
            pNode = pNode.m_pNext;
        }
        return null;
    }

    public final Entity getEntityIntersectingLocation(int iTileX, int iTileY, Entity pFrom) {
        vNode pNode;
        Sector pSector;
        if (pFrom == null) {
            pSector = this.getSector(iTileX, iTileY);
            if (pSector == null) {
                System.out.println("WARNING . getEntityIntersectingLocation -- " + iTileX + " x " + iTileY + " isn't within a sector.");
                return null;
            }
            pNode = pSector.m_entities.m_pFirst;
        } else {
            pSector = null;
            pNode = pFrom.m_pNext;
        }
        while (pNode != null) {
            Entity pEntity = (Entity)pNode;
            if (pEntity.m_iTileX <= iTileX && pEntity.m_iTileX + pEntity.m_iWidth > iTileX && pEntity.m_iTileY >= iTileY && pEntity.m_iTileY - pEntity.m_iHeight < iTileY) {
                return pEntity;
            }
            pNode = pNode.m_pNext;
        }
        return null;
    }

    public final Entity getEntityByArea(vRect rect, boolean bFullyContained, Entity pFrom) {
        vNode pNode;
        vNode pS;
        if (pFrom == null) {
            pS = this.m_sectors.m_pFirst;
            pNode = null;
        } else {
            pS = pFrom.m_pSector;
            pNode = pFrom.m_pNext;
            if (pNode == null) {
                pS = pS.m_pNext;
            }
        }
        while (pS != null) {
            vNode pSector = pS;
            if (pNode == null) {
                pNode = pSector.m_entities.m_pFirst;
            }
            while (pNode != null) {
                Entity pEntity = (Entity)pNode;
                pEntity.getRect(this.m_collideRect);
                if (bFullyContained ? rect.intersects(this.m_collideRect) : rect.contains(this.m_collideRect)) {
                    return pEntity;
                }
                pNode = pNode.m_pNext;
            }
            pS = pS.m_pNext;
        }
        return null;
    }

    public final byte getTile(int iTileX, int iTileY) {
        if (iTileX < 0 || iTileX >= this.m_iLevelWidth) {
            System.out.println("VASSERT failed ::iTileX >= 0 && iTileX < m_iLevelWidth");
        }
        if (iTileY < 0 || iTileY >= this.m_iLevelHeight) {
            System.out.println("VASSERT failed ::iTileY >= 0 && iTileY < m_iLevelHeight");
        }
        if (this.m_pTileInfo == null) {
            System.out.println("VASSERT failed ::m_pTileInfo != null");
        }
        return this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX];
    }

    public final byte getTileInfo(int iTileX, int iTileY) {
        if (this.m_pTileInfo == null) {
            System.out.println("VASSERT failed ::m_pTileInfo != null");
        }
        byte tile = this.getTile(iTileX, iTileY);
        return this.m_pTileInfo[(byte)(tile & 0x1F)];
    }

    public final void markTilesAsOccupied(Entity pEntity, boolean bOccupied) {
        this.markTilesAsOccupied(pEntity, pEntity.m_iTileX, pEntity.m_iTileY, bOccupied);
    }

    public final void markTilesAsOccupied(Entity pEntity, int iTileX, int iTileY, boolean bOccupied) {
        int iHeight;
        int iWidth;
        if (iTileX < 0 || iTileX >= this.m_iLevelWidth) {
            System.out.println("VASSERT failed ::iTileX >= 0 && iTileX < m_iLevelWidth");
        }
        if (iTileY < 0 || iTileY >= this.m_iLevelHeight) {
            System.out.println("VASSERT failed ::iTileY >= 0 && iTileY < m_iLevelHeight");
        }
        if ((iWidth = pEntity.m_iWidth) + (iHeight = pEntity.m_iHeight) == 1) {
            this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] = (byte)(this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] & 0xDF | (bOccupied ? 32 : 0));
            return;
        }
        if (iTileX + iWidth > this.m_iLevelWidth) {
            System.out.println("VASSERT failed ::iTileX + iWidth <= m_iLevelWidth");
        }
        if (iTileY - iHeight + 1 < 0) {
            System.out.println("VASSERT failed ::iTileY - iHeight + 1 >= 0");
        }
        int index = iTileY * this.m_iLevelWidth + iTileX;
        int y = iHeight;
        while (y-- != 0) {
            for (int x = 0; x < iWidth; ++x) {
                this.m_pTiles[index + x] = (byte)(this.m_pTiles[index + x] & 0xDF | (bOccupied ? 32 : 0));
            }
            index -= this.m_iLevelWidth;
        }
    }

    public final void markTilesAsOccupied(int iTileX, int iTileY, boolean bOccupied) {
        if (iTileX < 0 || iTileX >= this.m_iLevelWidth) {
            System.out.println("VASSERT failed ::iTileX >= 0 && iTileX < m_iLevelWidth");
        }
        if (iTileY < 0 || iTileY >= this.m_iLevelHeight) {
            System.out.println("VASSERT failed ::iTileY >= 0 && iTileY < m_iLevelHeight");
        }
        this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] = (byte)(this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] & 0xDF | (bOccupied ? 32 : 0));
    }

    public final void markTilesAsValid(int iTileX, int iTileY, boolean bValid) {
        if (iTileX < 0 || iTileX >= this.m_iLevelWidth) {
            System.out.println("VASSERT failed ::iTileX >= 0 && iTileX < m_iLevelWidth");
        }
        if (iTileY < 0 || iTileY >= this.m_iLevelHeight) {
            System.out.println("VASSERT failed ::iTileY >= 0 && iTileY < m_iLevelHeight");
        }
        this.m_abValidTiles[iTileY * this.m_iLevelWidth + iTileX] = bValid;
    }

    public final boolean areTilesOccupied(int iTileX, int iTileY) {
        if (iTileX < 0 || iTileY < 0) {
            return true;
        }
        if (iTileX >= this.m_iLevelWidth || iTileY >= this.m_iLevelHeight) {
            return true;
        }
        return (this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] & 0x20) != 0;
    }

    public final boolean areTilesOccupied(Entity pEntity) {
        return this.areTilesOccupied(pEntity, pEntity.m_iTileX, pEntity.m_iTileY);
    }

    public final boolean areTilesOccupied(Entity pEntity, int iTileX, int iTileY) {
        int iWidth = pEntity.m_iWidth;
        int iHeight = pEntity.m_iHeight;
        if (iTileX < 0 || iTileY - iHeight + 1 < 0) {
            return true;
        }
        if (iTileX + iWidth > this.m_iLevelWidth || iTileY >= this.m_iLevelHeight) {
            return true;
        }
        if (iWidth + iHeight == 1) {
            return (this.m_pTiles[iTileY * this.m_iLevelWidth + iTileX] & 0x20) != 0;
        }
        int index = iTileY * this.m_iLevelWidth + iTileX;
        int y = iHeight;
        while (y-- != 0) {
            for (int x = 0; x < iWidth; ++x) {
                if ((this.m_pTiles[index + x] & 0x20) == 0) continue;
                return true;
            }
            index -= this.m_iLevelWidth;
        }
        return false;
    }

    public final void checkForEntityCollision(Entity pEntity, int iTime) throws IOException {
        Sector pSector = pEntity.m_pSector;
        if (pSector == null) {
            System.out.println("VASSERT failed ::pSector != null");
        }
        pEntity.getRect(this.m_entityRect);
        vNode pNode = pSector.m_entities.m_pFirst;
        while (pNode != null) {
            Entity pCollideWith = (Entity)pNode;
            if (pCollideWith != pEntity && (pCollideWith.m_iFlags & 2) != 0) {
                pCollideWith.getRect(this.m_collideRect);
                if (this.m_entityRect.intersects(this.m_collideRect)) {
                    pCollideWith.onEvent(pEntity, (byte)4, iTime);
                }
            }
            pNode = pNode.m_pNext;
        }
    }

    public static void sendEventToEntity(Entity pSender, Entity pReceiver, byte eEvent, int iTime) throws IOException {
        pReceiver.onEvent(pSender, eEvent, iTime);
    }

    public void pause(boolean bPaused) throws IOException {
        if (this.m_bPaused != bPaused) {
            if (!bPaused && this.m_pSnippet != null) {
                System.out.println("Can't unpause the game while a conversation snippet is active...");
                bPaused = false;
            }
            this.m_bPaused = bPaused;
        }
    }

    public final void moveCameraToWorldPosition(int fpWorldX, int fpWorldY) {
        int fpPixelsWide = vBaseCanvas.intToFP(this.m_iTilePixelX);
        int fpPixelsTall = vBaseCanvas.intToFP(this.m_iTilePixelY);
        int fpMinX = 0 - vBaseCanvas.div(this.m_iLevelHeight * this.m_iSkew, this.m_iTilePixelX - this.m_iSkew);
        int fpMaxX = vBaseCanvas.intToFP(this.m_iLevelWidth - 1) - this.m_fpNumTilesVisX - fpMinX;
        int fpMinY = 0 - vBaseCanvas.intToFP(this.m_iTallestObjectInTiles);
        int fpMaxY = vBaseCanvas.intToFP(this.m_iLevelHeight - 1) - this.m_fpNumTilesVisY;
        int fpX = fpWorldX - (this.m_fpNumTilesVisX >> 1);
        int fpY = fpWorldY - (this.m_fpNumTilesVisY >> 1);
        if (fpMinY > fpMaxY) {
            int fpAverage;
            fpMinY = fpAverage = fpMinY + fpMaxY >> 1;
            fpMaxY = fpAverage;
        }
        fpX = vBaseCanvas.clamp(fpX, fpMinX, fpMaxX);
        fpY = vBaseCanvas.clamp(fpY, fpMinY, fpMaxY);
        int fpSkew = vBaseCanvas.intToFP(this.m_iSkew);
        this.m_camera.x = vBaseCanvas.mul(fpPixelsWide, fpX) - vBaseCanvas.mul(fpX + fpY, fpSkew);
        this.m_camera.y = vBaseCanvas.mul(fpPixelsTall, fpY);
        this.m_iFirstTileVisX = this.m_iLevelWidth > this.m_iNumTilesVisX ? vBaseCanvas.clamp(vBaseCanvas.toInt(fpX), 0, this.m_iLevelWidth - this.m_iNumTilesVisX) : 0;
        if (this.m_iLevelHeight > this.m_iNumTilesVisY) {
            this.m_iFirstTileVisY = vBaseCanvas.clamp(vBaseCanvas.toInt(fpY), 0, this.m_iLevelHeight - this.m_iNumTilesVisY);
            return;
        }
        this.m_iFirstTileVisY = 0;
    }

    public final void worldToScreen(vVector3 worldPos) {
        int fpPixelsWide = vBaseCanvas.intToFP(this.m_iTilePixelX);
        int fpPixelsTall = vBaseCanvas.intToFP(this.m_iTilePixelY);
        int fpSkew = vBaseCanvas.intToFP(this.m_iSkew);
        int fpScreenX = vBaseCanvas.mul(worldPos.x, fpPixelsWide) - vBaseCanvas.mul(worldPos.x + worldPos.y, fpSkew);
        int fpScreenY = vBaseCanvas.mul(worldPos.y, fpPixelsTall);
        this.m_iWorldToScreenX = vBaseCanvas.toInt(fpScreenX);
        this.m_iWorldToScreenY = vBaseCanvas.toInt(fpScreenY);
    }

    private void tileToScreen(int iTileX, int iTileY) {
        this.m_iTileToScreenX = iTileX * this.m_iTilePixelX - (iTileX + iTileY) * this.m_iSkew;
        this.m_iTileToScreenY = iTileY * this.m_iTilePixelY;
    }

    public final void setTransparentRect(vRect rect) {
        this.m_transparentRect.set(rect);
    }

    public final void setViewport(vRect viewport) {
        this.m_viewport.set(viewport);
        this.m_iTilePixelX = this.m_terrainImages[0].getWidth();
        this.m_iTilePixelY = this.m_terrainImages[0].getHeight();
        this.m_fpNumTilesVisX = vBaseCanvas.div(this.m_viewport.dx, this.m_iTilePixelX - this.m_iSkew);
        this.m_fpNumTilesVisY = vBaseCanvas.div(this.m_viewport.dy, this.m_iTilePixelY);
        this.m_fpNumTilesVisX += this.m_fpNumTilesVisY * this.m_iSkew / (this.m_iTilePixelX - this.m_iSkew);
        this.m_iNumTilesVisX = (this.m_fpNumTilesVisX >> 16) + 2;
        this.m_iNumTilesVisY = (this.m_fpNumTilesVisY >> 16) + 3;
    }

    public final Sector getSector(int x, int y) {
        int userData = this.m_kdTree.find(x, y);
        if (userData > 0) {
            Sector pSector = this.m_pSectors[userData];
            if (pSector.m_area.contains(x, y)) {
                return pSector;
            }
        }
        return null;
    }

    public final Sector addToMasterSector(Entity pEntity) {
        this.m_masterSector.add(pEntity);
        return this.m_masterSector;
    }

    public final void setPortalFocus(Entity pFocus) {
        this.m_pPortalFocus = pFocus;
        this.m_bUpdatePortals = true;
    }

    public final void openPortal(Sector pSector) {
        pSector.open();
        this.m_bUpdatePortals = true;
    }

    public final void closePortal(Sector pSector) {
        pSector.close();
        this.m_bUpdatePortals = true;
    }

    public final void updatePortals(Entity pFocus) {
        vNode pNode = this.m_sectors.m_pFirst;
        while (pNode != null) {
            Sector pSector = (Sector)pNode;
            pSector.m_iFlags &= 0xFFFFFFFA;
            pNode = pNode.m_pNext;
        }
        Sector pMaster = pFocus.m_pSector;
        pMaster.m_iFlags |= 4;
        this.activateSector(pMaster);
        vNode pNode2 = this.m_sectors.m_pFirst;
        while (pNode2 != null) {
            Sector pSector = (Sector)pNode2;
            if ((pSector.m_iFlags & 8) != 0) {
                pSector.m_iFlags |= 1;
            }
            pNode2 = pNode2.m_pNext;
        }
    }

    public void callFunctionByIndex(byte iFuncIndex, Entity a, int b, int c, Object d) throws IOException {
        System.out.println("VASSERT failed ::false");
    }

    public void callTriggerByIndex(byte iTriggerIndex, Entity a, int b, int c) throws IOException {
        System.out.println("VASSERT failed ::false");
    }

    public boolean doesBlockSector(byte tileType) {
        return false;
    }

    protected Engine() {
    }

    protected final void init(vBaseCanvas tc2, DataInputStream dependencyStream, DataInputStream globalPropertiesStream, int iTallestObject, int iSkew) throws IOException {
        this.m_transparentRect.set(-1, -1, 0, 0);
        this.m_viewport.set(0, 0, 1, 1);
        this.m_tc2 = tc2;
        this.m_iTallestObjectInTiles = iTallestObject;
        this.m_iTilePixelX = -1;
        this.m_iTilePixelY = -1;
        this.m_iFirstTileVisX = 0;
        this.m_iFirstTileVisY = 0;
        this.m_iSkew = iSkew;
        int iMagicID = dependencyStream.readUnsignedShort();
        int iVersion = dependencyStream.readUnsignedShort();
        if (iMagicID != 41573) {
            System.out.println("VASSERT failed ::iMagicID == kDependency_MagicID");
        }
        if (iVersion != 1) {
            System.out.println("VASSERT failed ::iVersion == kDependency_Version");
        }
        this.m_iDependencyIndicesSize = dependencyStream.readUnsignedShort();
        this.m_pDependencyIndices = new byte[this.m_iDependencyIndicesSize + 7 >> 3];
        this.m_iDependencyTableBytes = this.m_iDependencyTableSize = dependencyStream.readUnsignedShort();
        this.m_pDependencyTable = new short[this.m_iDependencyTableBytes];
        int iIndex = this.m_iDependencyTableSize;
        for (int i = 0; i < this.m_iDependencyTableSize; ++i) {
            int iTableEntrySize = dependencyStream.readUnsignedByte();
            this.m_iDependencyTableBytes += iTableEntrySize + 2;
            int iTableBits = dependencyStream.readUnsignedShort();
            int iCurArrayLength = this.m_pDependencyTable.length;
            if (iCurArrayLength < this.m_iDependencyTableBytes) {
                iCurArrayLength *= this.m_iDependencyTableBytes / iCurArrayLength + 1;
                short[] aiTemp = new short[iCurArrayLength];
                System.arraycopy(this.m_pDependencyTable, 0, aiTemp, 0, this.m_pDependencyTable.length);
                this.m_pDependencyTable = aiTemp;
            }
            this.m_pDependencyTable[i] = (short)iIndex;
            this.m_pDependencyTable[iIndex + 0] = (short)iTableEntrySize;
            this.m_pDependencyTable[iIndex + 1] = (short)iTableBits;
            for (int j = 0; j < iTableEntrySize; ++j) {
                this.m_pDependencyTable[iIndex + 2 + j] = (short)dependencyStream.readUnsignedShort();
            }
            iIndex += iTableEntrySize + 2;
        }
        short[] aiTemp = new short[this.m_iDependencyTableBytes];
        System.arraycopy(this.m_pDependencyTable, 0, aiTemp, 0, aiTemp.length);
        this.m_pDependencyTable = aiTemp;
        this.m_globalProperties.init(globalPropertiesStream);
    }

    public void shutdown() throws IOException {
        this.shutdownLevel();
        this.m_globalProperties.shutdown();
        this.m_pDependencyTable = null;
        this.m_pDependencyIndices = null;
    }

    public final void process(int iWindowTime, int fpTimeMultiplier) throws IOException {
        if (!this.m_bPaused) {
            Entity pEntity;
            Sector pSector;
            int iDeltaTime = Math.min(iWindowTime - this.m_iLastProcessTime, 150);
            this.m_iLastProcessTime = iWindowTime;
            this.m_iGameTime += vBaseCanvas.mul(iDeltaTime, fpTimeMultiplier);
            int fpElapsedTime = vBaseCanvas.mul(vBaseCanvas.intToFP(iDeltaTime), 66);
            if (this.m_bUpdatePortals) {
                this.m_bUpdatePortals = false;
                this.updatePortals(this.m_pPortalFocus);
            }
            vNode pS = this.m_sectors.m_pFirst;
            while (pS != null) {
                pSector = (Sector)pS;
                if ((pSector.m_iFlags & 1) != 0) {
                    vNode pNode = pSector.m_entities.m_pFirst;
                    while (pNode != null) {
                        pEntity = (Entity)pNode;
                        vNode next = pNode.m_pNext;
                        byte iProcess = pEntity.m_definition.m_iOnProcess;
                        if (iProcess != -1) {
                            this.callFunctionByIndex(iProcess, pEntity, this.m_iGameTime, fpElapsedTime, null);
                        }
                        pNode = next;
                    }
                }
                pS = pS.m_pNext;
            }
            pS = this.m_sectors.m_pFirst;
            while (pS != null) {
                pSector = (Sector)pS;
                if ((pSector.m_iFlags & 1) != 0) {
                    vNode pNode = pSector.m_entities.m_pFirst;
                    while (pNode != null) {
                        vNode pNext = pNode.m_pNext;
                        pEntity = (Entity)pNode;
                        if ((pEntity.m_iFlags & 8) != 0) {
                            Engine.releaseEntity(pEntity, true);
                        }
                        pNode = pNext;
                    }
                }
                pS = pS.m_pNext;
            }
        }
    }

    protected final void render(vGraphics pGraphics) throws IOException {
        pGraphics.pushClipRect();
        if (pGraphics.clipRect(this.m_viewport)) {
            pGraphics.fillRect(null, 0x404040);
            pGraphics.getClipRect(this.m_scissors);
            if (this.m_scissors.isEqual(this.m_viewport)) {
                this.m_iTileClipMinX = 0;
                this.m_iTileClipMaxX = this.m_iNumTilesVisX;
                this.m_iTileClipMinY = 0;
                this.m_iTileClipMaxY = this.m_iNumTilesVisY;
            } else {
                this.m_iTileClipMinX = this.m_scissors.x / (this.m_iTilePixelX - this.m_iSkew);
                this.m_iTileClipMaxX = (this.m_scissors.x + this.m_scissors.dx + (this.m_iTilePixelX - this.m_iSkew << 1) - 1) / (this.m_iTilePixelX - this.m_iSkew);
                this.m_iTileClipMinY = this.m_scissors.y / this.m_iTilePixelY;
                this.m_iTileClipMaxY = (this.m_scissors.y + this.m_scissors.dy + (this.m_iTilePixelY << 1) - 1) / this.m_iTilePixelY;
                if (this.m_iTileClipMinX >= this.m_iTileClipMaxX || this.m_iTileClipMinY >= this.m_iTileClipMaxY) {
                    pGraphics.popClipRect();
                    return;
                }
                this.m_iTileClipMaxX += (this.m_iTileClipMaxY - this.m_iTileClipMinY) * this.m_iSkew / (this.m_iTilePixelX - this.m_iSkew);
            }
            this.m_iTileClipMaxX = Math.min(this.m_iTileClipMaxX, this.m_iLevelWidth - this.m_iFirstTileVisX);
            this.m_iTileClipMaxY = Math.min(this.m_iTileClipMaxY, this.m_iLevelHeight - this.m_iFirstTileVisY);
            short iCameraX = vBaseCanvas.toShort(this.m_camera.x);
            short iCameraY = vBaseCanvas.toShort(this.m_camera.y);
            pGraphics.translate(-iCameraX, -iCameraY);
            int iTilesIndex = this.m_iFirstTileVisY * this.m_iLevelWidth + this.m_iFirstTileVisX;
            this.tileToScreen(this.m_iFirstTileVisX, this.m_iFirstTileVisY);
            int pixelX = this.m_iTileToScreenX;
            int pixelY = this.m_iTileToScreenY;
            int iSkewedXStep = this.m_iTilePixelX - this.m_iSkew;
            for (int y = this.m_iTileClipMinY; y < this.m_iTileClipMaxY; ++y) {
                int iLocalPixelX = pixelX;
                for (int x = this.m_iTileClipMinX; x < this.m_iTileClipMaxX; ++x) {
                    byte type;
                    byte t = this.m_pTiles[iTilesIndex + x];
                    if ((t & 0x40) != 0 && this.m_terrainImages[type = (byte)(t & 0x1F)] != null) {
                        int iLocalPixelY = pixelY - this.m_terrainImages[type].getHeight();
                        if (this.m_abValidTiles[iTilesIndex + x]) {
                            pGraphics.drawImage(this.m_terrainImages[16], iLocalPixelX, iLocalPixelY);
                        } else {
                            pGraphics.drawImage(this.m_terrainImages[type], iLocalPixelX, iLocalPixelY);
                        }
                    }
                    iLocalPixelX += iSkewedXStep;
                }
                iTilesIndex += this.m_iLevelWidth;
                pixelY += this.m_iTilePixelY;
                pixelX -= this.m_iSkew;
            }
            int iGlobalTileMinX = this.m_iTileClipMinX + this.m_iFirstTileVisX;
            int iGlobalTileMaxX = Math.min(this.m_iTileClipMaxX + this.m_iFirstTileVisX, this.m_iLevelWidth);
            int iGlobalTileMinY = this.m_iTileClipMinY + this.m_iFirstTileVisY;
            int iGlobalTileMaxY = Math.min(this.m_iTileClipMaxY + this.m_iFirstTileVisY, this.m_iLevelHeight);
            this.m_globalRect.set(iGlobalTileMinX, iGlobalTileMinY, iGlobalTileMaxX - iGlobalTileMinX, iGlobalTileMaxY - iGlobalTileMinY);
            vNode pS = this.m_sectors.m_pFirst;
            while (pS != null) {
                Sector pSector = (Sector)pS;
                pSector.m_iFlags &= 0xFFFFFFEF;
                if ((pSector.m_iFlags & 1) != 0) {
                    vRect r = pSector.m_area;
                    this.m_sectorRect.x = r.x - 3;
                    this.m_sectorRect.dx = r.dx + 6;
                    this.m_sectorRect.y = r.y - this.m_iTallestObjectInTiles - 3;
                    this.m_sectorRect.dy = r.dy + this.m_iTallestObjectInTiles + 6;
                    if (this.m_globalRect.intersects(this.m_sectorRect)) {
                        pSector.m_iFlags |= 0x10;
                        vNode pNode = pSector.m_entities.m_pFirst;
                        while (pNode != null) {
                            vNode pNext = pNode.m_pNext;
                            Entity pEntity = (Entity)pNode;
                            if ((pEntity.m_iFlags & 1) != 0) {
                                if (pEntity.m_definition.m_iOnRender == -1) {
                                    System.out.println("VASSERT failed ::pEntity.getDefinition().m_iOnRender != kInvalidFunctionIndex");
                                }
                                byte iEntityMinX = pEntity.m_iTileX;
                                int iEntityMaxX = iEntityMinX + pEntity.m_iWidth;
                                int iEntityMinY = pEntity.m_iTileY - pEntity.getBoundBoxHeightInTiles();
                                byte iEntityMaxY = pEntity.m_iTileY;
                                if (iEntityMaxX > iGlobalTileMinX && iEntityMinX < iGlobalTileMaxX && iEntityMaxY >= iGlobalTileMinY && iEntityMinY < iGlobalTileMaxY) {
                                    pSector.remove(pEntity);
                                    if ((pEntity.m_iFlags & 0x100) == 0) {
                                        this.m_renderList.insertLast(pNode);
                                    } else {
                                        this.m_renderAsFloorList.insertLast(pNode);
                                    }
                                }
                            }
                            pNode = pNext;
                        }
                    }
                }
                pS = pS.m_pNext;
            }
            if (!this.m_renderAsFloorList.isEmpty()) {
                Engine.sortEntityList(this.m_renderAsFloorList);
                do {
                    vNode pNode = this.m_renderAsFloorList.removeLast();
                    Entity pEntity = (Entity)pNode;
                    pEntity.m_pSector.add(pEntity);
                    byte iRender = pEntity.m_definition.m_iOnRender;
                    if (iRender == -1) continue;
                    this.callFunctionByIndex(iRender, pEntity, 0, this.m_iGameTime, pGraphics);
                } while (!this.m_renderAsFloorList.isEmpty());
            }
            Engine.sortEntityList(this.m_renderList);
            iTilesIndex = this.m_iFirstTileVisY * this.m_iLevelWidth + this.m_iFirstTileVisX;
            Entity pEntity = (Entity)this.m_renderList.m_pLast;
            iGlobalTileMaxY = Math.min(iGlobalTileMaxY + this.m_iTallestObjectInTiles, this.m_iLevelHeight);
            this.tileToScreen(this.m_iFirstTileVisX, this.m_iFirstTileVisY);
            pixelX = this.m_iTileToScreenX;
            pixelY = this.m_iTileToScreenY;
            for (int y = iGlobalTileMinY; y < iGlobalTileMaxY; ++y) {
                while (pEntity != null && (pEntity.m_iTileY < y || pEntity.m_iTileX + pEntity.m_iWidth < iGlobalTileMinX)) {
                    byte iRender = pEntity.m_definition.m_iOnRender;
                    if (iRender != -1) {
                        this.callFunctionByIndex(iRender, pEntity, 0, this.m_iGameTime, pGraphics);
                    }
                    pEntity = (Entity)pEntity.m_pPrevious;
                }
                int iLocalPixelX = pixelX;
                for (int x = iGlobalTileMinX; x < iGlobalTileMaxX; ++x) {
                    byte type;
                    int iLocalX = x - iGlobalTileMinX;
                    byte t = this.m_pTiles[iTilesIndex + iLocalX];
                    if (!((t & 0x40) != 0 || this.m_terrainImages[type = (byte)(t & 0x1F)] == null || (this.m_pTiles[iTilesIndex + iLocalX] & 0x80) != 0 && this.m_transparentRect.contains(x, y))) {
                        int iLocalPixelY = pixelY - this.m_terrainImages[type].getHeight();
                        pGraphics.drawImage(this.m_terrainImages[type], iLocalPixelX, iLocalPixelY);
                    }
                    while (pEntity != null && pEntity.m_iTileY == y && pEntity.m_iTileX == x) {
                        byte iRender = pEntity.m_definition.m_iOnRender;
                        if (iRender != -1) {
                            this.callFunctionByIndex(iRender, pEntity, 0, this.m_iGameTime, pGraphics);
                        }
                        pEntity = (Entity)pEntity.m_pPrevious;
                    }
                    iLocalPixelX += iSkewedXStep;
                }
                iTilesIndex += this.m_iLevelWidth;
                pixelY += this.m_iTilePixelY;
                pixelX -= this.m_iSkew;
            }
            while (pEntity != null) {
                byte iRender = pEntity.m_definition.m_iOnRender;
                if (iRender != -1) {
                    this.callFunctionByIndex(iRender, pEntity, 0, this.m_iGameTime, pGraphics);
                }
                pEntity = (Entity)pEntity.m_pPrevious;
            }
            while (!this.m_renderList.isEmpty()) {
                vNode pNode = this.m_renderList.removeFirst();
                pEntity = (Entity)pNode;
                pEntity.m_pSector.add(pEntity);
            }
            pGraphics.translate(iCameraX, iCameraY);
        }
        pGraphics.popClipRect();
    }

    protected final void initGlobalPropertyTable(DataInputStream globalPropertiesStream) throws IOException {
        this.m_globalProperties.shutdown();
        this.m_globalProperties.init(globalPropertiesStream);
    }

    protected final void initDependencyIndices() {
        int iBytes = this.m_iDependencyIndicesSize + 7 >> 3;
        for (int i = 0; i < iBytes; ++i) {
            this.m_pDependencyIndices[i] = 0;
        }
    }

    protected final void save(DataOutputStream dos, boolean bSaveLevel) throws IOException {
        Sector pSector;
        dos.writeShort(44536);
        dos.writeShort(8);
        this.m_globalProperties.save(dos);
        dos.write(this.m_pDependencyIndices, 0, this.m_iDependencyIndicesSize + 7 >> 3);
        if (!bSaveLevel) {
            return;
        }
        this.m_levelProperties.save(dos);
        dos.writeInt(this.m_camera.x);
        dos.writeInt(this.m_camera.y);
        dos.writeInt(this.m_iFirstTileVisX);
        dos.writeInt(this.m_iFirstTileVisY);
        dos.writeShort(this.m_transparentRect.x);
        dos.writeShort(this.m_transparentRect.y);
        dos.writeShort(this.m_transparentRect.dx);
        dos.writeShort(this.m_transparentRect.dy);
        dos.writeInt(this.m_iGameTime);
        dos.writeBoolean(this.m_bPaused);
        dos.writeInt(this.m_iUniqueBaseIndex);
        int iNumInstances = 0;
        vNode pS = this.m_sectors.m_pFirst;
        while (pS != null) {
            pSector = (Sector)pS;
            iNumInstances += pSector.m_entities.m_iSize;
            pS = pS.m_pNext;
        }
        dos.writeInt(iNumInstances);
        pS = this.m_sectors.m_pFirst;
        while (pS != null) {
            pSector = (Sector)pS;
            vNode pNode = pSector.m_entities.m_pFirst;
            while (pNode != null) {
                Entity pEntity = (Entity)pNode;
                pEntity.save(dos);
                pNode = pNode.m_pNext;
            }
            pS = pS.m_pNext;
        }
        int iPrevious = 0;
        while (true) {
            Entity pEntity = null;
            int iLowestIndex = Integer.MAX_VALUE;
            vNode pS2 = this.m_sectors.m_pFirst;
            while (pS2 != null) {
                Sector pSector2 = (Sector)pS2;
                vNode pNode = pSector2.m_entities.m_pFirst;
                while (pNode != null) {
                    Entity pCompare = (Entity)pNode;
                    if (pCompare.m_iUniqueIndex < iLowestIndex && pCompare.m_iUniqueIndex > iPrevious) {
                        pEntity = pCompare;
                        iLowestIndex = pCompare.m_iUniqueIndex;
                    }
                    pNode = pNode.m_pNext;
                }
                pS2 = pS2.m_pNext;
            }
            if (pEntity == null) break;
            pEntity.postSave(dos);
            iPrevious = iLowestIndex;
        }
        if (this.m_pSnippetEntity != null) {
            Definition def = this.m_pSnippetEntity.m_definition;
            int iSnippetIndex = -1;
            for (int k = 0; k < def.m_iSnippetListSize; ++k) {
                if (def.getSnippet(k) != this.m_pSnippet) continue;
                iSnippetIndex = k;
                break;
            }
            dos.writeInt(this.m_pSnippetEntity.m_iUniqueIndex);
            dos.writeInt(iSnippetIndex);
            dos.writeInt(this.m_iSnippetSelection);
            return;
        }
        dos.writeInt(-1);
    }

    protected final void open(DataInputStream dis, boolean bOpenLevel) throws IOException {
        int iMagicID = dis.readUnsignedShort();
        int iVersion = dis.readUnsignedShort();
        if (iMagicID != 44536) {
            System.out.println("VASSERT failed ::iMagicID == kMagicID");
        }
        if (iVersion != 8) {
            System.out.println("VASSERT failed ::iVersion == kVersion");
        }
        this.m_globalProperties.open(dis);
        dis.read(this.m_pDependencyIndices, 0, this.m_iDependencyIndicesSize + 7 >> 3);
        if (!bOpenLevel) {
            return;
        }
        this.m_levelProperties.open(dis);
        this.m_camera.x = dis.readInt();
        this.m_camera.y = dis.readInt();
        this.m_iFirstTileVisX = dis.readInt();
        this.m_iFirstTileVisY = dis.readInt();
        this.m_transparentRect.x = dis.readShort();
        this.m_transparentRect.y = dis.readShort();
        this.m_transparentRect.dx = dis.readShort();
        this.m_transparentRect.dy = dis.readShort();
        this.m_iGameTime = dis.readInt();
        this.m_bPaused = dis.readBoolean();
        this.m_iUniqueBaseIndex = dis.readInt();
        int iNumInstances = dis.readInt();
        Sector temp = new Sector();
        for (int i = 0; i < iNumInstances; ++i) {
            int iUniqueIndex = dis.readInt();
            int iDefinitionCRC32 = dis.readInt();
            Definition pDefinition = this.getDefinition(iDefinitionCRC32);
            if (pDefinition == null) {
                DataInputStream defStream = this.getDefinitionStream(iDefinitionCRC32);
                Definition pNewDefinition = new Definition();
                pNewDefinition.init(defStream);
                this.m_definitionList.insertLast(pNewDefinition);
                pDefinition = pNewDefinition;
            }
            Entity pEntity = new Entity(this.m_tc2, this, pDefinition, iUniqueIndex);
            pEntity.open(dis);
            if ((pEntity.m_iFlags & 4) != 0) {
                pEntity.onEvent(null, (byte)0, 0);
            }
            Engine.acquireEntity(pEntity);
            temp.add(pEntity);
        }
        this.buildSectorsAndPortals(temp.m_entities);
        while (!temp.m_entities.isEmpty()) {
            Entity pEntity = (Entity)temp.m_entities.removeFirst();
            pEntity.m_iTileX = (byte)(pEntity.m_iTileX - 1);
            pEntity.updateCache();
        }
        int iPrevious = 0;
        while (true) {
            Entity pEntity = null;
            int iLowestIndex = Integer.MAX_VALUE;
            vNode pS = this.m_sectors.m_pFirst;
            while (pS != null) {
                Sector pSector = (Sector)pS;
                vNode pNode = pSector.m_entities.m_pFirst;
                while (pNode != null) {
                    Entity pCompare = (Entity)pNode;
                    if (pCompare.m_iUniqueIndex < iLowestIndex && pCompare.m_iUniqueIndex > iPrevious) {
                        pEntity = pCompare;
                        iLowestIndex = pCompare.m_iUniqueIndex;
                    }
                    pNode = pNode.m_pNext;
                }
                pS = pS.m_pNext;
            }
            if (pEntity == null) break;
            pEntity.postOpen(dis, this.m_iGameTime);
            iPrevious = iLowestIndex;
        }
        int iSnippetEntityUniqueIndex = dis.readInt();
        if (iSnippetEntityUniqueIndex != -1) {
            int iSnippetIndex = dis.readInt();
            int iSelection = dis.readInt();
            Entity pConversationEntity = this.getEntityByUniqueIndex(iSnippetEntityUniqueIndex);
            byte convID = (byte)iSnippetIndex;
            this.beginConversationSnippet(pConversationEntity, convID, iSelection, this.m_iGameTime);
        }
        this.m_iLastProcessTime = vBaseCanvas.getAppTime();
    }

    protected final void removeEntities() {
        this.m_pSnippet = null;
        this.m_pSnippetEntity = null;
        this.m_pPortalFocus = null;
    }

    protected final void initLevel(DataInputStream dis, boolean bInstantiateNewInstances) throws IOException {
        int iEncoding;
        int i;
        this.m_pSnippet = null;
        this.m_iSnippetSelection = (byte)-1;
        this.m_pSnippetEntity = null;
        this.m_iGameTime = 0;
        this.m_iLastProcessTime = 0;
        this.m_pPortalFocus = null;
        this.m_bUpdatePortals = false;
        int iMagicID = dis.readUnsignedShort();
        int iVersion = dis.readUnsignedShort();
        if (iMagicID != 43514) {
            System.out.println("VASSERT failed ::iMagicID == kLevelFormat_MagicID");
        }
        if (iVersion != 9) {
            System.out.println("VASSERT failed ::iVersion == kLevelFormat_Version");
        }
        this.m_iLevelWidth = dis.readInt();
        this.m_iLevelHeight = dis.readInt();
        int iNumAssets = dis.readUnsignedShort();
        for (i = 0; i < iNumAssets; ++i) {
            dis.readInt();
        }
        this.m_levelProperties.init(dis);
        if (this.m_pTileInfo != null) {
            System.out.println("VASSERT failed ::m_pTileInfo == null");
        }
        int iNumTileInfo = dis.readUnsignedShort();
        this.m_pTileInfo = new byte[iNumTileInfo];
        if (this.m_pTileInfo == null) {
            System.out.println("VASSERT failed ::m_pTileInfo != null");
        }
        for (i = 0; i < iNumTileInfo; ++i) {
            this.m_pTileInfo[i] = (byte)dis.readUnsignedByte();
        }
        if (this.m_pTiles != null) {
            System.out.println("VASSERT failed ::m_pTiles == null");
        }
        this.m_pTiles = new byte[this.m_iLevelWidth * this.m_iLevelHeight];
        if (this.m_pTiles == null) {
            System.out.println("VASSERT failed ::m_pTiles != null");
        }
        this.m_abValidTiles = new boolean[this.m_iLevelWidth * this.m_iLevelHeight];
        if (this.m_abValidTiles == null) {
            System.out.println("VASSERT failed ::m_abValidTiles != null");
        }
        int[][] kOffsets = new int[][]{{1, 0}, {0, -1}, {0, 1}, {-1, 0}};
        while ((iEncoding = dis.readUnsignedShort()) != 0) {
            int iTileType = iEncoding >> 0 & 0x1F;
            int iDirection = iEncoding >> 5 & 3;
            int iLength = iEncoding >> 7 & 0x1FF;
            int iX = dis.readUnsignedByte();
            int iY = dis.readUnsignedByte();
            for (int n = 0; n < iLength; ++n) {
                this.m_pTiles[iY * this.m_iLevelWidth + iX] = this.m_pTileInfo[iTileType];
                this.m_abValidTiles[iY * this.m_iLevelWidth + iX] = false;
                iX += kOffsets[iDirection][0];
                iY += kOffsets[iDirection][1];
            }
        }
        int iNumRows = dis.readUnsignedByte();
        for (int y = 0; y < iNumRows; ++y) {
            int iY = dis.readUnsignedByte();
            int iNumColumns = dis.readUnsignedByte();
            int iTileBaseIndex = iY * this.m_iLevelWidth;
            for (int x = 0; x < iNumColumns; ++x) {
                int iX = dis.readUnsignedByte();
                int iTileType = dis.readUnsignedByte();
                this.m_pTiles[iTileBaseIndex + iX] = this.m_pTileInfo[iTileType];
            }
        }
        int iNumDefinitions = dis.readUnsignedShort();
        System.out.println("def count = " + iNumDefinitions);
        for (i = 0; i < iNumDefinitions; ++i) {
            int iDefinitionCRC32 = dis.readInt();
            if (this.getDefinition(iDefinitionCRC32) != null) continue;
            DataInputStream defStream = this.getDefinitionStream(iDefinitionCRC32);
            Definition pDefinition = new Definition();
            pDefinition.init(defStream);
            this.m_definitionList.insertLast(pDefinition);
        }
        if (!bInstantiateNewInstances) {
            return;
        }
        int iNumEntities = dis.readUnsignedShort();
        this.m_iUniqueBaseIndex = 1;
        Sector temp = new Sector();
        if (!this.m_masterSector.m_entities.isEmpty()) {
            System.out.println("VASSERT failed ::m_masterSector.m_entities.isEmpty()");
        }
        for (i = 0; i < iNumEntities; ++i) {
            int iDefinitionCRC32 = dis.readInt();
            Definition pDefinition = this.getDefinition(iDefinitionCRC32);
            if (pDefinition == null) {
                System.out.println("VASSERT failed ::pDefinition != null");
            }
            Entity pEntity = new Entity(this.m_tc2, this, pDefinition, this.m_iUniqueBaseIndex++);
            pEntity.init(dis, 0);
            if ((pEntity.m_iFlags & 4) != 0) {
                pEntity.onEvent(null, (byte)0, 0);
            }
            Engine.acquireEntity(pEntity);
            temp.add(pEntity);
        }
        this.buildSectorsAndPortals(temp.m_entities);
        while (!temp.m_entities.isEmpty()) {
            vNode pNode = temp.m_entities.removeFirst();
            Entity pEntity = (Entity)pNode;
            pEntity.m_iTileX = (byte)(pEntity.m_iTileX - 1);
            pEntity.updateCache();
            if (pEntity.m_pSector != null) continue;
            System.out.println("VASSERT failed ::pEntity.getSector() != null");
        }
    }

    protected final void shutdownLevel() throws IOException {
        if (this.m_pSnippet != null) {
            this.onConversationSnippetEvent$3af13cf9(this.m_pSnippet, (byte)2);
        }
        vNode pS = this.m_sectors.m_pFirst;
        while (pS != null) {
            Sector pSector = (Sector)pS;
            vNode pNode = pSector.m_entities.m_pFirst;
            while (pNode != null) {
                vNode pNext = pNode.m_pNext;
                Entity pEntity = (Entity)pNode;
                Engine.releaseEntity(pEntity, true);
                pNode = pNext;
            }
            pS = pS.m_pNext;
        }
        this.m_masterSector.m_entities.clear();
        if (!this.m_sectors.isEmpty()) {
            this.m_sectors.remove(this.m_masterSector);
            this.m_sectors.clear();
        }
        this.m_pSectors = null;
        this.m_kdTree.clear();
        vNode pNode = this.m_definitionList.m_pFirst;
        while (pNode != null) {
            vNode pNext = pNode.m_pNext;
            Definition pDefinition = (Definition)pNode;
            pDefinition.shutdown();
            this.m_definitionList.remove(pNode);
            pNode = pNext;
        }
        this.m_pTiles = null;
        this.m_abValidTiles = null;
        this.m_pTileInfo = null;
        this.m_levelProperties.shutdown();
        this.removeEntities();
    }

    protected final void setEnvironment(Image[] terrainImages) {
        this.m_terrainImages = terrainImages;
        if (this.m_terrainImages != null && (this.m_terrainImages[0].getWidth() != this.m_iTilePixelX || this.m_terrainImages[0].getHeight() != this.m_iTilePixelY)) {
            this.setViewport(this.m_viewport);
        }
    }

    protected final boolean onConversationSnippetAction(byte eAction) throws IOException {
        if (this.m_pSnippet == null) {
            return false;
        }
        byte eEvent = 0;
        switch (eAction) {
            case 0: {
                eEvent = 4;
                this.m_iSnippetSelection = this.getNextConversationResponse(this.m_pSnippet, this.m_iSnippetSelection);
                break;
            }
            case 1: {
                eEvent = 3;
                this.m_iSnippetSelection = this.getPrevConversationResponse(this.m_pSnippet, this.m_iSnippetSelection);
                break;
            }
            case 2: {
                eEvent = 5;
            }
        }
        if (eEvent != 0) {
            this.onConversationSnippetEvent$3af13cf9(this.m_pSnippet, eEvent);
            if (eEvent == 5) {
                int iTime = this.m_iGameTime;
                ConversationResponse response = this.m_pSnippet.getResponse(this.m_iSnippetSelection);
                Entity pEntity = this.m_pSnippetEntity;
                this.onConversationSnippetEvent$3af13cf9(this.m_pSnippet, (byte)2);
                this.m_pSnippet = null;
                this.m_pSnippetEntity = null;
                byte iTriggerIndex = response.m_iTriggerIndex;
                if (iTriggerIndex != -1) {
                    this.callTriggerByIndex(iTriggerIndex, pEntity, response.m_iTriggerParam, iTime);
                }
                byte nextID = response.m_iNextSnippet;
                pEntity.setConversationID(nextID);
                if (!response.m_bEndConversation) {
                    if (nextID == -1) {
                        System.out.println("VASSERT failed ::nextID != kInvalidConversationID");
                    }
                    this.beginConversationSnippet(pEntity, nextID, 0, iTime);
                } else {
                    this.pause(false);
                }
            }
            return true;
        }
        return false;
    }

    protected void onDependencyUpdate(int iDependecyIndex, boolean bValue, boolean bOldValue) throws IOException {
    }

    protected void onConversationSnippetEvent$3af13cf9(ConversationSnippet pSnippet, byte eEvent) throws IOException {
    }

    protected DataInputStream getDefinitionStream(int iDefinitionCRC32) throws IOException {
        return null;
    }

    private static boolean releaseEntity(Entity pEntity, boolean bSystemRelease) throws IOException {
        if (bSystemRelease) {
            Sector pSector = pEntity.m_pSector;
            if (pSector != null) {
                pSector.remove(pEntity);
                pEntity.m_pSector = null;
            }
            pEntity.releaseUserEntities();
        }
        if (pEntity.m_iRefCount == 1) {
            pEntity.shutdown();
        }
        return pEntity.release();
    }

    private static void sortEntityList(vLinkedList list) {
        for (int uiSize = 1; uiSize < list.m_iSize; uiSize <<= 1) {
            vNode p = list.m_pFirst;
            list.m_pFirst = null;
            list.m_pLast = null;
            while (p != null) {
                int pSize;
                vNode q = p;
                int qSize = uiSize;
                for (pSize = 0; pSize < uiSize && q != null; ++pSize) {
                    q = q.m_pNext;
                }
                while (pSize != 0 || qSize != 0 && q != null) {
                    vNode e;
                    if (pSize == 0) {
                        e = q;
                        q = q.m_pNext;
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        e = p;
                        p = p.m_pNext;
                        --pSize;
                    } else {
                        Entity pEntity_P = (Entity)p;
                        Entity pEntity_Q = (Entity)q;
                        if (pEntity_P.m_fpSortValue > pEntity_Q.m_fpSortValue) {
                            e = p;
                            p = p.m_pNext;
                            --pSize;
                        } else {
                            e = q;
                            q = q.m_pNext;
                            --qSize;
                        }
                    }
                    if (list.m_pLast != null) {
                        e.m_pPrevious = list.m_pLast;
                        list.m_pLast.m_pNext = e;
                    } else {
                        list.m_pFirst = e;
                    }
                    list.m_pLast = e;
                }
                p = q;
            }
            list.m_pFirst.m_pPrevious = null;
            list.m_pLast.m_pNext = null;
        }
    }

    private static void sortSectorByID(vLinkedList list) {
        for (int uiSize = 1; uiSize < list.m_iSize; uiSize <<= 1) {
            vNode p = list.m_pFirst;
            list.m_pFirst = null;
            list.m_pLast = null;
            while (p != null) {
                int pSize;
                vNode q = p;
                int qSize = uiSize;
                for (pSize = 0; pSize < uiSize && q != null; ++pSize) {
                    q = q.m_pNext;
                }
                while (pSize != 0 || qSize != 0 && q != null) {
                    vNode e;
                    if (pSize == 0) {
                        e = q;
                        q = q.m_pNext;
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        e = p;
                        p = p.m_pNext;
                        --pSize;
                    } else {
                        Sector pSector_P = (Sector)p;
                        Sector pSector_Q = (Sector)q;
                        if (pSector_P.m_iID <= pSector_Q.m_iID) {
                            e = p;
                            p = p.m_pNext;
                            --pSize;
                        } else {
                            e = q;
                            q = q.m_pNext;
                            --qSize;
                        }
                    }
                    if (list.m_pLast != null) {
                        e.m_pPrevious = list.m_pLast;
                        list.m_pLast.m_pNext = e;
                    } else {
                        list.m_pFirst = e;
                    }
                    list.m_pLast = e;
                }
                p = q;
            }
            list.m_pFirst.m_pPrevious = null;
            list.m_pLast.m_pNext = null;
        }
    }

    private byte getNextConversationResponse(ConversationSnippet pSnippet, byte currentID) {
        for (byte nextID = currentID; nextID < pSnippet.getResponseCount() - 1; nextID = (byte)(nextID + 1)) {
            byte condition = pSnippet.getResponse((int)nextID).m_iCondition;
            if (condition != -1 && !this.getDependencyTable(condition)) continue;
            return nextID;
        }
        return currentID;
    }

    private byte getPrevConversationResponse(ConversationSnippet pSnippet, byte currentID) {
        for (byte prevID = currentID; prevID > 0; prevID = (byte)(prevID - 1)) {
            byte condition = pSnippet.getResponse((int)prevID).m_iCondition;
            if (condition != -1 && !this.getDependencyTable(condition)) continue;
            return prevID;
        }
        return currentID;
    }

    private void activateSector(Sector pSector) {
        if ((pSector.m_iFlags & 1) == 0) {
            pSector.m_iFlags |= 1;
            if ((pSector.m_iFlags & 2) != 0) {
                for (int i = 0; i < pSector.m_iNumNeighbors; ++i) {
                    Sector pNeighbor = this.m_pSectors[pSector.m_iNeighbors[i]];
                    if ((pNeighbor.m_iFlags & 4) != 0) continue;
                    pNeighbor.m_iFlags |= 4;
                    this.activateSector(pNeighbor);
                }
            }
        }
    }

    private void buildSectorsAndPortals(vLinkedList entities) {
        this.buildPortals(entities);
        this.buildSectors();
        this.m_kdTree.build(this.m_sectors);
        Engine.sortSectorByID(this.m_sectors);
        this.m_sectors.insertFirst(this.m_masterSector);
        this.m_pSectors = new Sector[this.m_sectors.m_iSize];
        if (this.m_pSectors == null) {
            System.out.println("VASSERT failed ::m_pSectors != null");
        }
        int i = 0;
        vNode pNode = this.m_sectors.m_pFirst;
        while (pNode != null) {
            Sector pSector = (Sector)pNode;
            this.m_pSectors[i++] = pSector;
            pNode = pNode.m_pNext;
        }
        this.linkSectors();
    }

    private void buildPortals(vLinkedList entities) {
        vNode pNode = entities.m_pFirst;
        while (pNode != null) {
            Entity pEntity = (Entity)pNode;
            if ((pEntity.m_iFlags & 0x200) != 0) {
                Sector pSector = new Sector();
                this.m_sectors.insertLast(pSector);
                pSector.m_iFlags = 8;
                pSector.m_iNumNeighbors = 0;
                pSector.m_iID = this.m_sectors.m_iSize;
                pSector.m_area.set(pEntity.m_iTileX, pEntity.m_iTileY - pEntity.m_iHeight + 1, pEntity.m_iWidth, pEntity.m_iHeight);
            }
            pNode = pNode.m_pNext;
        }
    }

    private void buildSectors() {
        while (true) {
            boolean bStillExpanding;
            int iTileX = 0;
            int iTileY = 0;
            boolean bNewSector = false;
            block7: for (int x = 0; x < this.m_iLevelWidth; ++x) {
                for (int y = 0; y < this.m_iLevelHeight; ++y) {
                    if (this.doesBlockSector(this.getTileInfo(x, y)) || this.getTempSector(x, y) != null) continue;
                    bNewSector = true;
                    iTileX = x;
                    iTileY = y;
                    continue block7;
                }
            }
            if (!bNewSector) {
                return;
            }
            Sector pSector = new Sector();
            this.m_sectors.insertLast(pSector);
            pSector.m_iFlags = 2;
            pSector.m_iNumNeighbors = 0;
            pSector.m_iID = this.m_sectors.m_iSize;
            pSector.m_area.set(iTileX, iTileY, 1, 1);
            do {
                bStillExpanding = false;
                for (int i = 0; i < 4; ++i) {
                    this.m_r.set(pSector.m_area);
                    switch (i) {
                        case 0: {
                            ++this.m_r.dx;
                            break;
                        }
                        case 1: {
                            --this.m_r.y;
                            ++this.m_r.dy;
                            break;
                        }
                        case 2: {
                            ++this.m_r.dy;
                            break;
                        }
                        case 3: {
                            --this.m_r.x;
                            ++this.m_r.dx;
                        }
                    }
                    boolean bValid = true;
                    block11: for (int a = 0; a < this.m_r.dx; ++a) {
                        for (int b = 0; b < this.m_r.dy; ++b) {
                            if (this.m_r.x >= 0 && this.m_r.y >= 0 && this.m_r.x + a < this.m_iLevelWidth && this.m_r.y + b < this.m_iLevelHeight) {
                                if (!this.doesBlockSector(this.getTileInfo(this.m_r.x + a, this.m_r.y + b))) continue;
                                bValid = false;
                                continue block11;
                            }
                            bValid = false;
                            continue block11;
                        }
                    }
                    if (bValid) {
                        Sector pCoexists = null;
                        while ((pCoexists = this.getTempSector(this.m_r, pCoexists)) != null) {
                            if (pCoexists == pSector) continue;
                            bValid = false;
                            break;
                        }
                    }
                    if (!bValid) continue;
                    bStillExpanding = true;
                    pSector.m_area.set(this.m_r);
                }
            } while (bStillExpanding);
        }
    }

    private void linkSectors() {
        vNode pA = this.m_sectors.m_pFirst;
        while (pA != null) {
            Sector pSectorA = (Sector)pA;
            vNode pB = this.m_sectors.m_pFirst;
            while (pB != null) {
                Sector pSectorB = (Sector)pB;
                vRect a = pSectorA.m_area;
                vRect b = pSectorB.m_area;
                boolean bAreNeighbors = false;
                if (a.x == b.x + b.dx || a.x + a.dx == b.x) {
                    if (a.y >= b.y && a.y < b.y + b.dy) {
                        bAreNeighbors = true;
                    } else if (b.y >= a.y && b.y < a.y + a.dy) {
                        bAreNeighbors = true;
                    }
                }
                if (a.y == b.y + b.dy || a.y + a.dy == b.y) {
                    if (a.x >= b.x && a.x < b.x + b.dx) {
                        bAreNeighbors = true;
                    } else if (b.x >= a.x && b.x < a.x + a.dx) {
                        bAreNeighbors = true;
                    }
                }
                if (bAreNeighbors) {
                    boolean bAlreadyNeighbor = false;
                    for (int i = 0; i < pSectorA.m_iNumNeighbors; ++i) {
                        if (pSectorA.m_iNeighbors[i] != pSectorB.m_iID) continue;
                        bAlreadyNeighbor = true;
                        break;
                    }
                    if (!bAlreadyNeighbor) {
                        if (pSectorA.m_iNumNeighbors >= 16) {
                            System.out.println("VASSERT failed ::pSectorA.m_iNumNeighbors < Sector.kMaxPortalsPerSector");
                        }
                        pSectorA.m_iNeighbors[pSectorA.m_iNumNeighbors++] = pSectorB.m_iID;
                    }
                }
                pB = pB.m_pNext;
            }
            pA = pA.m_pNext;
        }
    }

    private Sector getTempSector(int x, int y) {
        vNode pNode = this.m_sectors.m_pFirst;
        while (pNode != null) {
            Sector pSector = (Sector)pNode;
            if (pSector.m_area.contains(x, y)) {
                return pSector;
            }
            pNode = pNode.m_pNext;
        }
        return null;
    }

    private Sector getTempSector(vRect area, Sector pSector) {
        vNode pNode = pSector == null ? this.m_sectors.m_pFirst : pSector.m_pNext;
        while (pNode != null) {
            pSector = (Sector)pNode;
            if (pSector.m_area.intersects(area)) {
                return pSector;
            }
            pNode = pNode.m_pNext;
        }
        return null;
    }
}

